/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.transport.http.ChunkedInputStream;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.OCSPTrustManager;
import org.openspcoop2.utils.transport.http.SSLHostNameVerifierDisabled;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.utils.transport.http.WrappedLogTlsSocketStrategy;

class HttpCoreConnection
extends HttpLibraryConnection {
    HttpCoreConnection() {
    }

    private HttpHost setupProxy(HttpClientBuilder builder, Map<String, List<String>> addHeaders, HttpRequest request) {
        if (request.getProxyType() == null || request.getProxyHostname() == null) {
            builder.useSystemProperties();
            if (request.isDebug()) {
                request.logInfo("Impostazione connessione alla URL [" + request.getUrl() + "] - Utilizzo propriet\u00e0 di sistema (JAVA_OPTS) per proxy se configurate");
            }
            return null;
        }
        request.logInfo("Impostazione connessione alla URL [" + request.getUrl() + "] (via proxy " + request.getProxyHostname() + ":" + request.getProxyPort() + ") (username[" + request.getProxyUsername() + "] password[" + request.getProxyPassword() + "])...");
        HttpHost proxy = new HttpHost(request.getProxyHostname(), request.getProxyPort());
        builder.setProxy(proxy);
        if (request.getProxyUsername() != null && request.getProxyPassword() != null) {
            String authentication = request.getProxyUsername() + ":" + request.getProxyPassword();
            authentication = "Basic " + Base64Utilities.encodeAsString(authentication.getBytes());
            addHeaders.put("Proxy-Authorization", List.of(authentication));
        }
        return proxy;
    }

    private void enableRedirect(HttpClientBuilder builder, HttpRequest request) {
        if (Boolean.TRUE.equals(request.getFollowRedirects())) {
            if (request.isDebug()) {
                request.logInfo("Redirect strategy abilitato");
            }
            DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
            builder.setRedirectStrategy((RedirectStrategy)redirectStrategy);
        } else {
            if (request.isDebug()) {
                request.logInfo("Redirect strategy disabilitato");
            }
            builder.disableRedirectHandling();
        }
    }

    private PoolingHttpClientConnectionManager setupConnectionManager(HttpClientBuilder builder, HttpRequest request, SSLContext sslContext) {
        PoolingHttpClientConnectionManager connManager = null;
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        if (request.isDebug()) {
            request.logInfo("Impostazione connection config CT[" + request.getConnectTimeout() + "]");
        }
        connectionConfigBuilder.setConnectTimeout((long)request.getConnectTimeout(), TimeUnit.MILLISECONDS);
        ConnectionConfig connectionConfig = connectionConfigBuilder.build();
        if (sslContext != null) {
            Object hostnameVerifier;
            Object object = hostnameVerifier = request.isHostnameVerifier() ? new DefaultHostnameVerifier() : new SSLHostNameVerifierDisabled(LoggerWrapperFactory.getLogger(HttpCoreConnection.class));
            if (request.isDebug() && request.isHostnameVerifier()) {
                request.logInfo("HostName verifier abilitato");
            } else {
                request.logInfo("HostName verifier disabilitato");
            }
            Object tlsSocketStrategy = new DefaultClientTlsStrategy(sslContext, (HostnameVerifier)hostnameVerifier);
            if (request.isDebug()) {
                String clientCertificateConfigurated = request.getKeyStorePath();
                tlsSocketStrategy = new WrappedLogTlsSocketStrategy((TlsSocketStrategy)tlsSocketStrategy, request.getLog(), "", clientCertificateConfigurated);
            }
            connManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)tlsSocketStrategy).setDefaultConnectionConfig(connectionConfig).build();
            builder.setConnectionManager((HttpClientConnectionManager)connManager);
        } else {
            if (request.isDebug() && request.getUrl() != null && request.getUrl().toLowerCase().startsWith("https://")) {
                String clientCertificateConfigurated = SSLUtilities.getJvmHttpsClientCertificateConfigurated();
                request.logInfo("Utilizzo propriet\u00e0 di sistema (JAVA_OPTS) per SSL - Client certificate: " + clientCertificateConfigurated);
            }
            connManager = PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties().setDefaultConnectionConfig(connectionConfig).build();
            builder.setConnectionManager((HttpClientConnectionManager)connManager);
        }
        connManager.setMaxTotal(1);
        connManager.setDefaultMaxPerRoute(1);
        return connManager;
    }

    private void addHeader(HttpUriRequestBase httpRequest, Map<String, List<String>> overrideHeaders, HttpRequest request) {
        for (Map.Entry<String, List<String>> entry : overrideHeaders.entrySet()) {
            for (String value : entry.getValue()) {
                if (request.isDebug()) {
                    request.logInfo("Aggiungo header (override) [" + entry.getKey() + "]=[" + value + "]");
                }
                httpRequest.addHeader(entry.getKey(), (Object)value);
            }
        }
        for (Map.Entry<String, List<String>> entry : request.getHeadersValues().entrySet()) {
            if (overrideHeaders.containsKey(entry.getKey())) continue;
            for (String value : entry.getValue()) {
                if (request.isDebug()) {
                    request.logInfo("Aggiungo header [" + entry.getKey() + "]=[" + value + "]");
                }
                httpRequest.addHeader(entry.getKey(), (Object)value);
            }
        }
        this.addHeaderContentType(httpRequest, request);
        this.addHeaderAuthorizationBasic(httpRequest, request);
        this.addHeaderAuthorizationBearer(httpRequest, request);
        this.addHeaderAuthorizationApiKey(httpRequest, request);
    }

    private void addHeaderContentType(HttpUriRequestBase httpRequest, HttpRequest request) {
        if (request.getContentType() != null) {
            if (request.isDebug()) {
                request.logInfo("Impostazione Content-Type [" + request.getContentType() + "]");
            }
            httpRequest.setHeader("Content-Type", (Object)request.getContentType());
        }
    }

    private void addHeaderAuthorizationBasic(HttpUriRequestBase httpRequest, HttpRequest request) {
        if (request.getUsername() != null && request.getPassword() != null) {
            String authentication = request.getUsername() + ":" + request.getPassword();
            authentication = "Basic " + Base64Utilities.encodeAsString(authentication.getBytes());
            if (request.isDebug()) {
                request.logInfo("Impostazione autenticazione (username:" + request.getUsername() + " password:" + request.getPassword() + ") [" + authentication + "]");
            }
            httpRequest.setHeader("Authorization", (Object)authentication);
        }
    }

    private void addHeaderAuthorizationBearer(HttpUriRequestBase httpRequest, HttpRequest request) {
        if (request.getBearerToken() != null) {
            String authorizationHeader = "Bearer " + request.getBearerToken();
            if (request.isDebug()) {
                request.logInfo("Impostazione autenticazione bearer [" + authorizationHeader + "]");
            }
            httpRequest.setHeader("Authorization", (Object)authorizationHeader);
        }
    }

    private void addHeaderAuthorizationApiKey(HttpUriRequestBase httpRequest, HttpRequest request) {
        String apiKey = request.getApiKey();
        if (apiKey != null && StringUtils.isNotEmpty((CharSequence)apiKey)) {
            String apiKeyHeader = request.getApiKeyHeader();
            if (apiKeyHeader == null || StringUtils.isEmpty((CharSequence)apiKeyHeader)) {
                apiKeyHeader = "X-API-KEY";
            }
            httpRequest.setHeader(apiKeyHeader, (Object)apiKey);
            if (request.isDebug()) {
                request.logInfo("Impostazione autenticazione api key [" + apiKeyHeader + "]=[" + apiKey + "]");
            }
            this.addHeaderAuthorizationAppId(httpRequest, request);
        }
    }

    private void addHeaderAuthorizationAppId(HttpUriRequestBase httpRequest, HttpRequest request) {
        String appId = request.getAppId();
        if (appId != null && StringUtils.isNotEmpty((CharSequence)appId)) {
            String appIdHeader = request.getAppIdHeader();
            if (appIdHeader == null || StringUtils.isEmpty((CharSequence)appIdHeader)) {
                appIdHeader = "X-APP-ID";
            }
            httpRequest.setHeader(appIdHeader, (Object)appId);
            if (request.isDebug()) {
                request.logInfo("Impostazione autenticazione api key (app id) [" + appIdHeader + "]=[" + appId + "]");
            }
        }
    }

    private void setupTimeouts(RequestConfig.Builder builder, HttpRequest request) {
        if (request.isDebug()) {
            request.logInfo("Impostazione request config timeout: connectionRequest[" + request.getConnectTimeout() + "] response[" + request.getReadTimeout() + "]");
        }
        builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)request.getConnectTimeout())).setResponseTimeout(Timeout.ofMilliseconds((long)request.getReadTimeout()));
    }

    private void setupMaxRedirect(RequestConfig.Builder builder, HttpRequest request) {
        if (request.isDebug()) {
            request.logInfo("Impostazione redirect max hop [" + request.getMaxHopRedirects() + "]");
        }
        builder.setMaxRedirects(request.getMaxHopRedirects().intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public HttpResponse send(HttpRequest request, SSLContext sslContext, OCSPTrustManager ocspTrustManager) throws UtilsException, IOException {
        HttpResponse response;
        ClassicHttpResponse httpResp;
        CloseableHttpClient client;
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager;
        block18: {
            if (request.getMethod() == null) {
                throw new UtilsException("HttpMethod required");
            }
            poolingHttpClientConnectionManager = null;
            HttpClientBuilder builder = HttpClients.custom();
            builder.setConnectionManagerShared(false);
            HashMap<String, List<String>> overrideHeaders = new HashMap<String, List<String>>();
            this.enableRedirect(builder, request);
            HttpHost proxy = this.setupProxy(builder, overrideHeaders, request);
            poolingHttpClientConnectionManager = this.setupConnectionManager(builder, request, sslContext);
            HttpUriRequestBase httpRequest = new HttpUriRequestBase(request.getMethod().name(), URI.create(request.getUrl()));
            this.addHeader(httpRequest, overrideHeaders, request);
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            this.setupMaxRedirect(configBuilder, request);
            this.setupTimeouts(configBuilder, request);
            builder.evictExpiredConnections();
            builder.evictIdleConnections(TimeValue.ofSeconds((long)1L));
            builder.disableAutomaticRetries();
            httpRequest.setConfig(configBuilder.build());
            InputStream contentStream = null;
            if (request.getContent() != null && request.getContent().length > 0) {
                contentStream = new ByteArrayInputStream(request.getContent());
            } else if (request.getContentStream() != null) {
                contentStream = request.getContentStream();
            }
            if (contentStream != null) {
                Integer contentLength = request.getContent().length;
                if (request.getThrottlingSendByte() != null && request.getThrottlingSendMs() != null) {
                    contentStream = new ChunkedInputStream(contentStream, request.getThrottlingSendByte(), request.getThrottlingSendMs());
                    contentLength = -1;
                }
                if (request.isForceTransferEncodingChunked()) {
                    contentLength = -1;
                }
                InputStreamEntity entity = new InputStreamEntity(contentStream, (long)contentLength.intValue(), ContentType.parse((CharSequence)request.getContentType()));
                httpRequest.setEntity((HttpEntity)entity);
            }
            client = null;
            httpResp = null;
            client = builder.build();
            if (request.isDebug()) {
                request.logDebug("Connessione in corso ...");
            }
            httpResp = client.executeOpen(proxy, (ClassicHttpRequest)httpRequest, (HttpContext)HttpClientContext.create());
            response = new HttpResponse();
            response.setResultHTTPOperation(httpResp.getCode());
            if (!request.isCheckConnection()) break block18;
            HttpResponse httpResponse = this.checkConnection(request);
            this.safeClose(httpResp);
            this.safeDisconnect(client);
            this.safeDisconnect(poolingHttpClientConnectionManager);
            return httpResponse;
        }
        HttpResponse httpResponse = this.processResponse(httpResp, response, ocspTrustManager);
        this.safeClose(httpResp);
        this.safeDisconnect(client);
        this.safeDisconnect(poolingHttpClientConnectionManager);
        return httpResponse;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        this.safeClose(httpResp);
                        this.safeDisconnect(client);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new UtilsException(e);
                    }
                }
                catch (Throwable throwable2) {
                    this.safeDisconnect(poolingHttpClientConnectionManager);
                    throw throwable2;
                }
            }
        }
    }

    private HttpResponse checkConnection(HttpRequest request) {
        if (request.isDebug()) {
            request.logDebug("Connessione effettuata con successo");
        }
        return null;
    }

    private void safeClose(ClassicHttpResponse httpResp) {
        try {
            if (httpResp != null) {
                httpResp.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeDisconnect(CloseableHttpClient client) {
        try {
            if (client != null) {
                client.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeDisconnect(PoolingHttpClientConnectionManager cManager) {
        try {
            if (cManager != null) {
                cManager.close(CloseMode.IMMEDIATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private HttpResponse processResponse(ClassicHttpResponse httpResp, HttpResponse response, OCSPTrustManager ocspTrustManager) throws IOException {
        Header[] responseHeaders;
        for (Header h : responseHeaders = httpResp.getHeaders()) {
            if ("Content-Type".equalsIgnoreCase(h.getName()) && response.getContentType() == null) {
                response.setContentType(h.getValue());
            }
            response.addHeader(h.getName(), List.of(h.getValue()));
        }
        HttpEntity entity = httpResp.getEntity();
        if (entity != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)out);
            out.flush();
            out.close();
            response.setContent(out.toByteArray());
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        String returnCode = String.valueOf(httpResp.getVersion()) + " " + httpResp.getCode();
        if (httpResp.getReasonPhrase() != null && StringUtils.isNotEmpty((CharSequence)httpResp.getReasonPhrase())) {
            returnCode = returnCode + " " + httpResp.getReasonPhrase();
        }
        response.addHeader("ReturnCode", List.of(returnCode));
        if (ocspTrustManager != null) {
            response.setServerCertificate(ocspTrustManager.getPeerCertificates());
        }
        return response;
    }
}

