/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLSavingTrustManager
implements X509TrustManager {
    private X509TrustManager tm;
    private X509Certificate[] chain;
    private boolean processClient;

    public X509Certificate[] getPeerCertificates() {
        return this.chain;
    }

    public SSLSavingTrustManager(X509TrustManager tm) {
        this(tm, false);
    }

    public SSLSavingTrustManager(X509TrustManager tm, boolean processClient) {
        this.tm = tm;
        this.processClient = processClient;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        if (this.processClient) {
            return this.tm.getAcceptedIssuers();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (!this.processClient) {
            throw new UnsupportedOperationException();
        }
        this.tm.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.chain = chain;
        this.tm.checkServerTrusted(chain, authType);
    }

    public static TrustManager[] wrap(TrustManager[] tmArray) {
        if (tmArray != null && tmArray.length > 0) {
            for (int i = 0; i < tmArray.length; ++i) {
                TrustManager tm = tmArray[i];
                if (tm == null || !(tm instanceof X509TrustManager)) continue;
                TrustManager[] cloned = new TrustManager[tmArray.length];
                for (int j = 0; j < tmArray.length; ++j) {
                    cloned[j] = j == i ? new SSLSavingTrustManager((X509TrustManager)tm, true) : tmArray[j];
                }
                return cloned;
            }
        }
        return tmArray;
    }

    public static SSLSavingTrustManager read(TrustManager[] tmArray) {
        if (tmArray != null && tmArray.length > 0) {
            for (int i = 0; i < tmArray.length; ++i) {
                TrustManager tm = tmArray[i];
                if (tm == null || !(tm instanceof SSLSavingTrustManager)) continue;
                return (SSLSavingTrustManager)tm;
            }
        }
        return null;
    }
}

