/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http.credential;

import jakarta.servlet.http.HttpServletRequest;
import org.openspcoop2.utils.transport.http.HttpServletCredential;
import org.openspcoop2.utils.transport.http.credential.IPrincipalReader;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderException;
import org.slf4j.Logger;

public class IdentityPrincipalReader
implements IPrincipalReader {
    private transient Logger log = null;
    private static final long serialVersionUID = 1L;

    public IdentityPrincipalReader(Logger log) {
        this.log = log;
        this.log.debug("IdentityPrincipalReader inizializzato.");
    }

    @Override
    public void init(Object ... parametri) throws PrincipalReaderException {
    }

    @Override
    public String getPrincipal(HttpServletRequest request) throws PrincipalReaderException {
        this.log.debug("Estrazione principal in corso...");
        try {
            HttpServletCredential identity = new HttpServletCredential(request, this.log);
            String username = identity.getPrincipal();
            this.log.debug("Username trovato nel principal [identity.getPrincipal()]: [{}]", (Object)username);
            this.log.debug("Username trovato nel principal [identity.getUsername()]: [{}]", (Object)identity.getUsername());
            return username;
        }
        catch (Exception e) {
            this.log.error("Errore durante la lettura del principal: " + e.getMessage(), (Throwable)e);
            throw new PrincipalReaderException(e);
        }
    }
}

