/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpFilterChain;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.bouncycastle.util.encoders.Base64;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.test.HttpServerTest;

public class HttpProxyTest
implements Closeable {
    private final HttpServerTest backend;
    private final HttpServer server;
    private final String username;
    private final String password;

    public HttpProxyTest(HttpServerTest backend) throws IOException {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofSeconds((long)15L)).setTcpNoDelay(true).setSoReuseAddress(true).build();
        this.username = new Random().ints(10L, 97, 122).mapToObj(v -> String.valueOf((char)v)).collect(Collectors.joining());
        this.password = new Random().ints(10L, 97, 122).mapToObj(v -> String.valueOf((char)v)).collect(Collectors.joining());
        this.server = ServerBootstrap.bootstrap().setListenerPort(-1).setSslContext(null).setSocketConfig(socketConfig).setExceptionListener(new ExceptionListener(this){

            public void onError(HttpConnection arg0, Exception arg1) {
            }

            public void onError(Exception arg0) {
            }
        }).addFilterFirst("auth", this::handleAuth).register("localhost", "*", this::handle).create();
        this.backend = backend;
        this.server.start();
    }

    @Override
    public void close() {
        this.server.stop();
        this.server.close(CloseMode.GRACEFUL);
        this.server.initiateShutdown();
        try {
            this.server.awaitTermination(TimeValue.MAX_VALUE);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void handleAuth(ClassicHttpRequest req, HttpFilterChain.ResponseTrigger trigger, HttpContext ctx, HttpFilterChain chain) throws HttpException, IOException {
        Header auth = req.getHeader("Proxy-Authorization");
        String rawCredential = auth.getValue().replace("Basic ", "");
        String[] credential = new String(Base64.decode((String)rawCredential)).split(":");
        String usernameReq = credential[0];
        String passwordReq = credential[1];
        if (usernameReq.equals(this.getUsername()) && passwordReq.equals(this.getPassword())) {
            chain.proceed(req, trigger, ctx);
        } else {
            trigger.sendInformation((ClassicHttpResponse)new BasicClassicHttpResponse(401));
        }
    }

    public void handle(ClassicHttpRequest req, ClassicHttpResponse res, HttpContext ctx) throws IOException {
        try {
            this.executeProxy(req, res);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringEntity out = new StringEntity(e.getMessage());
            res.setEntity((HttpEntity)out);
            res.setCode(400);
            res.close();
        }
    }

    private void executeProxy(ClassicHttpRequest req, ClassicHttpResponse res) throws UtilsException, IOException {
        String url = this.backend.getUrl() + "/proxy";
        HttpRequest proxiedRequest = new HttpRequest();
        for (Header header : req.getHeaders()) {
            if (header.getName().startsWith("Proxy")) continue;
            proxiedRequest.addHeader(header.getName(), header.getValue());
        }
        proxiedRequest.addHeader("Proxied", "true");
        proxiedRequest.setUrl(url);
        proxiedRequest.setMethod(HttpRequestMethod.valueOf(req.getMethod()));
        HttpResponse proxiedResponse = HttpUtilities.httpInvoke(proxiedRequest);
        ByteArrayEntity out = new ByteArrayEntity(proxiedResponse.getContent(), ContentType.parse((CharSequence)proxiedResponse.getContentType()));
        for (Map.Entry<String, List<String>> entry : proxiedResponse.getHeadersValues().entrySet()) {
            if (!entry.getKey().equals("Content-Type")) continue;
            res.setHeader(entry.getKey(), (Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        res.setEntity((HttpEntity)out);
        res.setCode(proxiedResponse.getResultHTTPOperation());
        res.close();
    }
}

