/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml.test;

import java.util.ArrayList;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.xml.AbstractXPathExpressionEngine;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.w3c.dom.Element;

public class TestBugEntityReferences {
    public static void main(String[] args) throws Exception {
        TestBugEntityReferences.test();
    }

    public static void test() throws Exception {
        String template = "REFERENCE";
        String valoreReferenceConTemplate = "Valore con reference: " + template + " .\nTerminata altra informazione\n\nFine";
        String attributoReferenceConTemplate = "Attributo con reference: " + template + " .";
        String xml_riga1 = "<ns:elemento>" + valoreReferenceConTemplate + "</ns:elemento>";
        String xml_riga2 = "<ns:attributo attr1=\"val1\" attrRef=\"" + attributoReferenceConTemplate + "\">" + valoreReferenceConTemplate + "</ns:attributo>";
        String xml = "<ns:prova xmlns:ns=\"http://prova\"><ns:contenutoInterno>\n" + xml_riga1 + "\n" + xml_riga2 + "\n</ns:contenutoInterno></ns:prova>";
        String xmlMultiLine = "<ns:prova xmlns:ns=\"http://prova\"><ns:contenutoInterno>\n" + xml_riga1 + "\n" + xml_riga1 + "\n" + xml_riga1 + "\n</ns:contenutoInterno></ns:prova>";
        ArrayList<String> listTest = new ArrayList<String>();
        listTest.add("&");
        listTest.add("<");
        listTest.add(">");
        listTest.add("\"");
        listTest.add("'");
        listTest.add("&<>\"'");
        ArrayList<String> listReferences = new ArrayList<String>();
        listReferences.add("(&amp; , &#38; , &#x26;)");
        listReferences.add("(&lt; , &#60; , &#x3C;)");
        listReferences.add("(&gt; , &#62; , &#x3E;)");
        listReferences.add("(&quot; , &#34; , &#x22;)");
        listReferences.add("(&apos; , &#39; , &#x27;)");
        listReferences.add("(&amp; , &lt; , &gt; , &quot; , &apos;)");
        ArrayList<String> listReferencesAttese = new ArrayList<String>();
        listReferencesAttese.add("(&amp; , &amp; , &amp;)");
        listReferencesAttese.add("(&lt; , &lt; , &lt;)");
        listReferencesAttese.add("(&gt; , &gt; , &gt;)");
        listReferencesAttese.add("(\" , \" , \")");
        listReferencesAttese.add("(' , ' , ')");
        listReferencesAttese.add("(&amp; , &lt; , &gt; , \" , ')");
        for (int i = 0; i < listTest.size(); ++i) {
            String test = (String)listTest.get(i);
            String reference = (String)listReferences.get(i);
            String referenceAttesa = (String)listReferencesAttese.get(i);
            System.out.println("\n\n======== [" + test + "] ========");
            String pattern = "/ns:prova/*";
            String xmlConReference = xml.replace(template, reference);
            String xml_riga1_conReference_attesa = xml_riga1.replace(template, referenceAttesa);
            String xml_riga2_conReference_attesa = xml_riga2.replace(template, referenceAttesa);
            TestBugEntityReferences.verify(xmlConReference, pattern, xml_riga1_conReference_attesa, xml_riga2_conReference_attesa);
            pattern = "//ns:attributo/@attrRef";
            String attributo_conReference_attesa = attributoReferenceConTemplate.replace(template, referenceAttesa);
            TestBugEntityReferences.verify(xmlConReference, pattern, attributo_conReference_attesa);
            pattern = "//ns:elemento/text()";
            String valore_conReference_attesa_risolta = valoreReferenceConTemplate.replace(template, referenceAttesa);
            TestBugEntityReferences.verify(xmlConReference, pattern, valore_conReference_attesa_risolta);
            System.out.println("-- MultiLine");
            pattern = "//ns:elemento/text()";
            String xmlMultiLineConReference = xmlMultiLine.replace(template, reference);
            TestBugEntityReferences.verify(xmlMultiLineConReference, pattern, "[0]=" + valore_conReference_attesa_risolta + ", [1]=" + valore_conReference_attesa_risolta + ", [2]=" + valore_conReference_attesa_risolta);
            pattern = "//ns:contenutoInterno/*";
            xmlMultiLineConReference = xmlMultiLine.replace(template, reference);
            TestBugEntityReferences.verify(xmlMultiLineConReference, pattern, xml_riga1_conReference_attesa + xml_riga1_conReference_attesa + xml_riga1_conReference_attesa);
        }
    }

    private static void verify(String xml, String pattern, String ... verifica) throws Exception {
        Element element = XMLUtils.getInstance().newElement(xml.getBytes());
        XPathExpressionEngine xPathEngine = new XPathExpressionEngine();
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace(element);
        String xmlValue = AbstractXPathExpressionEngine.extractAndConvertResultAsString(element, dnc, (AbstractXPathExpressionEngine)xPathEngine, pattern, LoggerWrapperFactory.getLogger(TestBugEntityReferences.class));
        for (int i = 0; i < verifica.length; ++i) {
            String verificaS = verifica[i];
            if (xmlValue.contains(verificaS)) continue;
            throw new Exception("Pattern '" + pattern + "' failed: stringa '" + verificaS + "' attesa non riscontrata nel valore estratto [" + xmlValue + "]\n\nXml: " + xml);
        }
        System.out.println("Pattern '" + pattern + "' ok");
    }
}

