/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml2json;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class AbstractMappedConverter {
    protected boolean camelCase = false;
    protected boolean camelCase_firstLower = false;
    protected SortedMap<String> renameFields = new SortedMap();
    protected List<String> arrays = new ArrayList<String>();
    protected SortedMap<String[]> reorderChildren = new SortedMap();
    protected boolean forceReorder = false;
    protected boolean prettyPrint = false;

    public void activeCamelCase(boolean firstLowerCase) {
        this.camelCase = true;
        this.camelCase_firstLower = firstLowerCase;
    }

    public void addRenameField(String path, String newName) throws UtilsException {
        this.renameFields.add(path, newName);
    }

    public void readRenameFieldConfigFromFile(String path) throws UtilsException {
        this.readRenameFieldConfigFromFile(new File(path));
    }

    public void readRenameFieldConfigFromFile(File path) throws UtilsException {
        if (!path.exists()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] not exists");
        }
        if (!path.canRead()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] cannot read");
        }
        byte[] r = null;
        try {
            r = FileSystemUtilities.readBytesFromFile(path);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        this.readRenameFieldConfigFromFile(r);
    }

    public void readRenameFieldConfigFromFile(byte[] resource) throws UtilsException {
        this.readFileConfig(resource, this.renameFields);
    }

    public void addArrayMapping(String path) throws UtilsException {
        this.arrays.add(path);
    }

    public void readArrayMappingFromFile(String path) throws UtilsException {
        this.readArrayMappingFromFile(new File(path));
    }

    public void readArrayMappingFromFile(File path) throws UtilsException {
        if (!path.exists()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] not exists");
        }
        if (!path.canRead()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] cannot read");
        }
        byte[] r = null;
        try {
            r = FileSystemUtilities.readBytesFromFile(path);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        this.readArrayMappingFromFile(r);
    }

    public void readArrayMappingFromFile(byte[] resource) throws UtilsException {
        this.readFileConfig(resource, this.arrays);
    }

    public void addReorderChildren(String path, List<String> children) throws UtilsException {
        if (children == null || children.size() <= 0) {
            throw new UtilsException("Children undefined");
        }
        this.addReorderChildren(path, children.toArray(new String[1]));
    }

    public void addReorderChildren(String path, String children) throws UtilsException {
        List<String> l = this.toList(children);
        if (l.isEmpty()) {
            throw new UtilsException("Children not found");
        }
        this.addReorderChildren(path, l);
    }

    public void addReorderChildren(String path, String ... children) throws UtilsException {
        if (children == null || children.length <= 0) {
            throw new UtilsException("Children undefined");
        }
        this.reorderChildren.add(path, children);
    }

    public void readReorderChildrenConfigFromFile(String path) throws UtilsException {
        this.readReorderChildrenConfigFromFile(new File(path));
    }

    public void readReorderChildrenConfigFromFile(File path) throws UtilsException {
        if (!path.exists()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] not exists");
        }
        if (!path.canRead()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] cannot read");
        }
        byte[] r = null;
        try {
            r = FileSystemUtilities.readBytesFromFile(path);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        this.readReorderChildrenConfigFromFile(r);
    }

    public void readReorderChildrenConfigFromFile(byte[] resource) throws UtilsException {
        this.readFileConfig_mapStringArray(resource, this.reorderChildren);
    }

    public void setForceReorder(boolean forceReorder) {
        this.forceReorder = forceReorder;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    protected static String getParentPath(String name) throws UtilsException {
        if (name.contains(".")) {
            if (name.startsWith(".") || name.endsWith(".")) {
                throw new UtilsException("Uncorrect format path [" + name + "]");
            }
            int l = name.lastIndexOf(".");
            String parentPath = name.substring(0, l);
            return parentPath;
        }
        return null;
    }

    protected static String getLastNamePath(String name) throws UtilsException {
        if (name.contains(".")) {
            if (name.startsWith(".") || name.endsWith(".")) {
                throw new UtilsException("Uncorrect format path [" + name + "]");
            }
            int l = name.lastIndexOf(".");
            String last = name.substring(l + 1, name.length());
            return last;
        }
        return name;
    }

    protected List<String> correctPath(String tipologia, List<String> params) throws UtilsException {
        ArrayList<String> newListArray = new ArrayList<String>();
        ArrayList<String> removePath = new ArrayList<String>();
        if (!params.isEmpty()) {
            for (String path : params) {
                String[] tmp = path.split("\\.");
                StringBuilder sbNewPath = new StringBuilder();
                for (int limit = 1; limit <= tmp.length; ++limit) {
                    StringBuilder sbPathCheck = new StringBuilder();
                    for (int i = 0; i < limit; ++i) {
                        if (i > 0) {
                            sbPathCheck.append(".");
                        }
                        sbPathCheck.append(tmp[i]);
                    }
                    String patchCheck = sbPathCheck.toString();
                    if (sbNewPath.length() > 0) {
                        sbNewPath.append(".");
                    }
                    String nome = tmp[limit - 1];
                    if (this.renameFields.containsKey(patchCheck)) {
                        nome = this.renameFields.get(patchCheck);
                    }
                    sbNewPath.append(nome);
                }
                String newPath = sbNewPath.toString();
                newListArray.add(newPath);
                if (!"reorder".equals(tipologia)) continue;
                removePath.add(path);
            }
        }
        if ("reorder".equals(tipologia) && !newListArray.isEmpty()) {
            for (int i = 0; i < newListArray.size(); ++i) {
                String newPath = (String)newListArray.get(i);
                String path = (String)removePath.get(i);
                String[] v = this.reorderChildren.remove(path);
                String[] newV = new String[v.length];
                for (int j = 0; j < v.length; ++j) {
                    String old = v[j];
                    String key = "".equals(path) ? old : path + "." + old;
                    String newK = old;
                    if (this.renameFields.containsKey(key)) {
                        newK = this.renameFields.get(key);
                    }
                    newV[j] = newK;
                }
                this.reorderChildren.add(newPath, newV);
            }
        }
        return newListArray;
    }

    protected void readFileConfig(byte[] file, List<String> list) throws UtilsException {
        this._readFileConfig(file, false, list, null, null);
    }

    protected void readFileConfig_mapStringArray(byte[] file, SortedMap<String[]> mapStringArray) throws UtilsException {
        this._readFileConfig(file, true, null, mapStringArray, null);
    }

    protected void readFileConfig(byte[] file, SortedMap<String> mapString) throws UtilsException {
        this._readFileConfig(file, true, null, null, mapString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _readFileConfig(byte[] file, boolean isProperty, List<String> listString, SortedMap<String[]> mapStringArray, SortedMap<String> mapString) throws UtilsException {
        try (Scanner scanner = new Scanner(new String(file));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line == null || line.trim().equals("") || line.trim().startsWith("#")) continue;
                if (isProperty) {
                    if (!line.contains("=")) {
                        throw new UtilsException("In ogni riga deve essere indicata una coppia (nome=valore); non \u00e8 stato riscontrato il carattere separatore '=' nella riga '" + line + "'");
                    }
                    int indexOf = line.indexOf("=");
                    String key = null;
                    String value = null;
                    if (indexOf == 0) {
                        key = "";
                        value = line.substring(indexOf + 1, line.length());
                    } else if (indexOf == line.length() - 1) {
                        key = line.substring(0, indexOf);
                        value = "";
                    } else {
                        key = line.substring(0, indexOf);
                        value = line.substring(indexOf + 1, line.length());
                    }
                    if (value.contains("#")) {
                        int indexOfCommento = value.indexOf("#");
                        value = value.substring(0, indexOfCommento);
                    }
                    if (mapStringArray != null) {
                        List<String> l = this.toList(value);
                        if (l.isEmpty()) {
                            throw new UtilsException("element for key '" + key + "' not found");
                        }
                        mapStringArray.add(key, l.toArray(new String[1]));
                        continue;
                    }
                    mapString.add(key, value);
                    continue;
                }
                listString.add(line);
            }
        }
    }

    protected List<String> toList(String param) {
        ArrayList<String> l = new ArrayList<String>();
        if (param != null && param.contains(",")) {
            String[] tmp = param.split(",");
            if (tmp != null && tmp.length > 0) {
                for (String c : tmp) {
                    if (c == null || StringUtils.isEmpty((CharSequence)c.trim())) continue;
                    l.add(c.trim());
                }
            }
        } else if (param != null && !StringUtils.isEmpty((CharSequence)param.trim())) {
            l.add(param.trim());
        }
        return l;
    }
}

