/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml2json;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.xml.DOMSourceFix;
import org.openspcoop2.utils.xml2json.IXml2Json;
import org.w3c.dom.Node;

public abstract class AbstractXml2Json
implements IXml2Json {
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    protected abstract XMLOutputFactory getOutputFactory();

    @Override
    public String xml2json(String xmlString) throws UtilsException {
        XMLEventReader reader = null;
        try {
            reader = this.inputFactory.createXMLEventReader(new StringReader(xmlString));
            StringWriter stringWriter = new StringWriter();
            this.xml2json(reader, stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String xml2json(Node node) throws UtilsException {
        XMLEventReader reader = null;
        try {
            reader = this.inputFactory.createXMLEventReader(new DOMSourceFix(node));
            StringWriter stringWriter = new StringWriter();
            this.xml2json(reader, stringWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void xml2json(XMLEventReader reader, Writer writer) throws Exception {
        XMLEventWriter eventWriter = null;
        try {
            eventWriter = this.getOutputFactory().createXMLEventWriter(writer);
            eventWriter.add(reader);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        finally {
            if (eventWriter != null) {
                try {
                    eventWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

