/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.xml2json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.json.AbstractUtils;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.utils.xml2json.AbstractMappedConverter;
import org.openspcoop2.utils.xml2json.IJson2Xml;
import org.openspcoop2.utils.xml2json.Xml2JsonFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Json2XmlMappedConverter
extends AbstractMappedConverter {
    private String rootElement_localName = "Root";
    private String rootElement_namespace = null;
    private List<String> attributes = new ArrayList<String>();

    public Json2XmlMappedConverter() {
        this.forceReorder = true;
    }

    public void setRootElement(String rootElement) {
        this.rootElement_localName = rootElement;
    }

    public void setRootElement(String rootElement, String namespace) {
        this.rootElement_localName = rootElement;
        this.rootElement_namespace = namespace;
    }

    public void addAttributeMapping(String path) throws UtilsException {
        this.attributes.add(path);
    }

    public void readAttributeMappingFromFile(String path) throws UtilsException {
        this.readAttributeMappingFromFile(new File(path));
    }

    public void readAttributeMappingFromFile(File path) throws UtilsException {
        if (!path.exists()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] not exists");
        }
        if (!path.canRead()) {
            throw new UtilsException("File [" + path.getAbsolutePath() + "] cannot read");
        }
        byte[] r = null;
        try {
            r = FileSystemUtilities.readBytesFromFile(path);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        this.readAttributeMappingFromFile(r);
    }

    public void readAttributeMappingFromFile(byte[] resource) throws UtilsException {
        this.readFileConfig(resource, this.attributes);
    }

    public String convert(String json) throws UtilsException {
        JSONUtils utils = JSONUtils.getInstance(false);
        JsonNode node = utils.getAsNode(json);
        return this.convert(node);
    }

    public String convert(JsonNode node) throws UtilsException {
        JSONUtils utils = JSONUtils.getInstance(false);
        List<String> attributes_renamed = this.attributes;
        List<String> arrays_renamed = this.arrays;
        List<String> reorderChildren_renamed = this.reorderChildren.keys();
        if (!this.renameFields.isEmpty()) {
            Iterator<Object> keys = this.renameFields.keys();
            Collections.sort(keys, Comparator.reverseOrder());
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                Object newName = (String)this.renameFields.get(path);
                boolean forceReorder = false;
                if (this.attributes.contains(path)) {
                    this.attributes.remove(path);
                    newName = "@" + (String)newName;
                } else {
                    forceReorder = this.forceReorder;
                }
                utils.renameFieldByPath(node, path, (String)newName, forceReorder, false);
            }
            if (!attributes_renamed.isEmpty()) {
                attributes_renamed = this.correctPath("attributes", attributes_renamed);
            }
            if (!arrays_renamed.isEmpty()) {
                arrays_renamed = this.correctPath("arrays", arrays_renamed);
            }
            if (!reorderChildren_renamed.isEmpty()) {
                reorderChildren_renamed = this.correctPath("reorder", reorderChildren_renamed);
            }
        }
        if (!attributes_renamed.isEmpty()) {
            for (String path : attributes_renamed) {
                String parentPath = Json2XmlMappedConverter.getParentPath(path);
                String attrName = Json2XmlMappedConverter.getLastNamePath(path);
                if (this.camelCase) {
                    attrName = AbstractUtils.camelCase(attrName, this.camelCase_firstLower);
                }
                utils.renameFieldByPath(node, path, "@" + attrName, false);
            }
        }
        if (!arrays_renamed.isEmpty()) {
            for (String path : arrays_renamed) {
                utils.convertFieldToArrayByPath(node, path, this.forceReorder, false);
            }
        }
        if (!reorderChildren_renamed.isEmpty()) {
            for (String path : reorderChildren_renamed) {
                String[] children = (String[])this.reorderChildren.get(path);
                utils.reorderFieldChildrenByPath(node, path, false, children);
            }
        }
        if (this.camelCase) {
            boolean forceReorder = true;
            utils.renameFieldInCamelCase(node, this.camelCase_firstLower, forceReorder);
        }
        JsonNode rootNode = node;
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.rootElement_localName != null) {
            rootNode = utils.newObjectNode();
            if (this.rootElement_namespace != null) {
                ((ObjectNode)rootNode).set("NS." + this.rootElement_localName, node);
                map.put(this.rootElement_namespace, "NS");
            } else {
                ((ObjectNode)rootNode).set(this.rootElement_localName, node);
            }
        }
        String json = utils.toString(rootNode);
        IJson2Xml json2xml = Xml2JsonFactory.getJson2XmlMapped(map);
        String xml = json2xml.json2xml(json);
        if (this.prettyPrint) {
            try {
                Document n = XMLUtils.getInstance().newDocument(xml.getBytes());
                return PrettyPrintXMLUtils.prettyPrintWithTrAX((Node)n, true);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return xml;
    }
}

