/*
 * Decompiled with CFR 0.152.
 */
package org.tp23.antinstaller.selfextract;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.tp23.antinstaller.InstallException;
import org.tp23.antinstaller.renderer.swing.plaf.LookAndFeelFactory;
import org.tp23.antinstaller.runtime.ExecInstall;
import org.tp23.antinstaller.runtime.exe.FilterChain;
import org.tp23.antinstaller.runtime.exe.FilterFactory;
import org.tp23.antinstaller.selfextract.ProgressIndicator;

public class SelfExtractor {
    public static final String CONFIG_RESOURCE = "/org/tp23/antinstaller/runtime/exe/selfextractor.fconfig";
    private File extractDir;
    private File archiveFile;
    private boolean overwrite = true;
    private static int DEFAULT_BUFFER_SIZE = 1024;
    private int BUFFER_SIZE = DEFAULT_BUFFER_SIZE;
    private static boolean graphicsEnv = false;
    private static String lookAndFeel = null;

    public static File getEnclosingJar(Object reference) {
        String thisClass = "/" + reference.getClass().getName().replace('.', '/') + ".class";
        URL jarUrl = reference.getClass().getResource(thisClass);
        String stringForm = jarUrl.toString();
        File file = null;
        int endIdx = stringForm.indexOf("!/");
        if (endIdx != -1) {
            String unescaped = null;
            String fileNamePart = stringForm.substring("jar:file:".length(), endIdx);
            file = new File(fileNamePart);
            if (!file.exists()) {
                unescaped = SelfExtractor.unescape(fileNamePart);
                file = new File(unescaped);
            }
            return file;
        }
        throw new RuntimeException("Failed expanding Jar.");
    }

    public SelfExtractor() {
    }

    public void init() {
        System.out.println("Loading self extractor...");
        this.archiveFile = SelfExtractor.getEnclosingJar(this);
        this.makeTempDir();
        try {
            JarFile thisJar = new JarFile(this.archiveFile);
            lookAndFeel = thisJar.getManifest().getMainAttributes().getValue("Look-And-Feel");
            lookAndFeel = LookAndFeelFactory.getLafFromToken(lookAndFeel);
            if (lookAndFeel != null) {
                UIManager.setLookAndFeel(lookAndFeel);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected File makeTempDir() {
        String tempDir = System.getProperty("java.io.tmpdir");
        this.extractDir = new File(tempDir, "antinstall");
        int idx = 0;
        while (this.extractDir.exists()) {
            this.extractDir = new File(tempDir, "antinstall" + idx++);
        }
        this.extractDir.mkdirs();
        this.extractDir.deleteOnExit();
        return this.extractDir;
    }

    public SelfExtractor(int newBufferSize) {
        this.BUFFER_SIZE = newBufferSize;
        this.archiveFile = SelfExtractor.getEnclosingJar(this);
    }

    public void setExtractDir(File newExtractDir) {
        this.extractDir = newExtractDir;
    }

    public void setArchiveFile(File newArchiveFile) {
        this.archiveFile = newArchiveFile;
    }

    public File getExtractDir() {
        return this.extractDir;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public File getArchiveFile() {
        return this.archiveFile;
    }

    public ArrayList getList(boolean vebose) throws FileNotFoundException, IOException {
        JarInputStream zis = new JarInputStream(new FileInputStream(this.archiveFile));
        JarEntry entry = null;
        ArrayList<String> result = new ArrayList<String>();
        while ((entry = zis.getNextJarEntry()) != null) {
            if (vebose) {
                System.out.println(entry.getName());
            }
            result.add(entry.getName());
        }
        return result;
    }

    public int getFileCount() throws FileNotFoundException, IOException {
        JarInputStream zis = new JarInputStream(new FileInputStream(this.archiveFile));
        int count = 0;
        while (zis.getNextJarEntry() != null) {
            ++count;
        }
        return count;
    }

    public ArrayList extract(boolean vebose, boolean isX) throws FileNotFoundException, IOException {
        int fileCount = this.getFileCount();
        ProgressIndicator indicator = null;
        if (isX) {
            try {
                indicator = new ProgressIndicator(fileCount);
                indicator.show();
            }
            catch (Exception exc) {
                graphicsEnv = false;
                isX = false;
            }
        }
        JarInputStream zis = new JarInputStream(new FileInputStream(this.archiveFile));
        JarEntry entry = null;
        ArrayList<File> result = new ArrayList<File>();
        while ((entry = zis.getNextJarEntry()) != null) {
            if (vebose) {
                System.out.println("Extracting:" + entry.getName());
            }
            result.add(this.extract(zis, entry));
            if (!isX) continue;
            indicator.tick();
        }
        if (isX) {
            indicator.hide();
        }
        zis.close();
        return result;
    }

    private File extract(JarInputStream zis, JarEntry entry) throws FileNotFoundException, IOException {
        this.createPath(entry.getName());
        File fileToUse = new File(this.extractDir, entry.getName());
        if (fileToUse.exists()) {
            if (!this.overwrite) {
                return fileToUse;
            }
        } else {
            fileToUse.createNewFile();
        }
        if (fileToUse.isDirectory()) {
            return fileToUse;
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(fileToUse), this.BUFFER_SIZE);
        byte[] bytes = new byte[this.BUFFER_SIZE];
        int len = 0;
        while ((len = zis.read(bytes)) >= 0) {
            bos.write(bytes, 0, len);
        }
        bos.close();
        zis.closeEntry();
        return fileToUse;
    }

    private void createPath(String entryName) throws IOException {
        String firstPath;
        File dir;
        int slashIdx = entryName.lastIndexOf(47);
        if (slashIdx >= 0 && !(dir = new File(this.extractDir, firstPath = entryName.substring(0, slashIdx))).exists()) {
            dir.mkdirs();
        }
    }

    public static void main(String[] args) {
        SelfExtractor.testX();
        SelfExtractor extractor = null;
        try {
            boolean verbose = false;
            extractor = new SelfExtractor();
            extractor.init();
            extractor.extract(verbose, graphicsEnv);
        }
        catch (Exception e) {
            e.printStackTrace();
            String tempDir = "unknown";
            if (extractor != null) {
                tempDir = extractor.getExtractDir().getAbsolutePath();
            }
            String warning = "Could not extract Jar file to directory:" + tempDir;
            SelfExtractor.printXorTextWarning(warning);
        }
        try {
            FilterChain chain = FilterFactory.factory(CONFIG_RESOURCE);
            ExecInstall installExec = new ExecInstall(chain);
            installExec.parseArgs(args, false);
            installExec.setInstallRoot(extractor.getExtractDir());
            installExec.setTempRoot(extractor.getExtractDir());
            installExec.exec();
        }
        catch (InstallException e1) {
            System.out.println("Cant load filter chain:/org/tp23/antinstaller/runtime/exe/selfextractor.fconfig");
            e1.printStackTrace();
        }
    }

    protected static void testX() {
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                boolean headless = GraphicsEnvironment.isHeadless();
                if (headless) {
                    graphicsEnv = false;
                    return;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            graphicsEnv = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean isGraphicsEnv() {
        return graphicsEnv;
    }

    protected static void printXorTextWarning(String warning) {
        if (graphicsEnv) {
            try {
                JOptionPane.showMessageDialog(null, warning);
            }
            catch (HeadlessException headlessExc) {
                graphicsEnv = false;
                System.out.println(warning);
            }
        } else {
            System.out.println(warning);
        }
    }

    public static int deleteRecursive(File directory) {
        int count = 0;
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
            ++count;
        }
        File[] dirs = directory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        for (int i = 0; i < dirs.length; ++i) {
            count += SelfExtractor.deleteRecursive(dirs[i]);
        }
        directory.delete();
        return count;
    }

    private static String unescape(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block6;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException siob) {
                        String end = s.substring(i);
                        sb.append(end);
                        if (end.length() != 2) continue block6;
                        ++i;
                        continue block6;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

