/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.lib.audit.appender;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.MessageSecurityFlow;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.CostantiProprieta;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.pdd.core.byok.DriverBYOKUtilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.openspcoop2.utils.serialization.Filter;
import org.openspcoop2.utils.serialization.FilteredObject;
import org.openspcoop2.utils.serialization.IDBuilder;
import org.openspcoop2.utils.serialization.JsonJacksonSerializer;
import org.openspcoop2.utils.serialization.SerializationConfig;
import org.openspcoop2.web.lib.audit.AuditException;
import org.openspcoop2.web.lib.audit.appender.AuditDisabilitatoException;
import org.openspcoop2.web.lib.audit.appender.IAuditAppender;
import org.openspcoop2.web.lib.audit.appender.IDOperazione;
import org.openspcoop2.web.lib.audit.dao.Appender;
import org.openspcoop2.web.lib.audit.dao.Configurazione;
import org.openspcoop2.web.lib.audit.dao.Filtro;
import org.openspcoop2.web.lib.audit.log.Binary;
import org.openspcoop2.web.lib.audit.log.Operation;
import org.openspcoop2.web.lib.audit.log.constants.Stato;
import org.openspcoop2.web.lib.audit.log.constants.Tipologia;

public class AuditAppender {
    private static final String AUDIT_DISABILITATO = "Audit engine disabilitato";
    private static final String APPENDER_NON_FORNITI = "Appender non forniti";
    private static Configurazione configurazioneAuditing;
    private static IDBuilder idBuilder;
    private static HashMap<String, IAuditAppender> appenders;

    public void initializeAudit(Configurazione configurazioneAuditing, IDBuilder idBuilder) throws AuditException {
        AuditAppender.initializeAuditEngine(configurazioneAuditing, idBuilder);
    }

    private static synchronized void initializeAuditEngine(Configurazione configurazioneAuditing, IDBuilder idBuilder) throws AuditException {
        try {
            appenders.clear();
            AuditAppender.configurazioneAuditing = configurazioneAuditing;
            AuditAppender.idBuilder = idBuilder;
            for (int i = 0; i < AuditAppender.configurazioneAuditing.sizeAppender(); ++i) {
                Appender appenderConf = AuditAppender.configurazioneAuditing.getAppender(i);
                Class<?> c = Class.forName(appenderConf.getClassName());
                IAuditAppender appender = (IAuditAppender)ClassLoaderUtilities.newInstance(c);
                Properties propertiesAppender = new Properties();
                for (int j = 0; j < appenderConf.sizeProperties(); ++j) {
                    propertiesAppender.put(appenderConf.getProperty(j).getName(), appenderConf.getProperty(j).getValue());
                }
                appender.initAppender(appenderConf.getNome(), propertiesAppender);
                appenders.put(appenderConf.getNome(), appender);
            }
        }
        catch (Exception e) {
            throw new AuditException("InizializzazioneFallita: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigurazioneAuditing(Configurazione configurazioneAuditing) throws AuditException {
        try {
            Configurazione configurazione = AuditAppender.configurazioneAuditing;
            synchronized (configurazione) {
                AuditAppender.configurazioneAuditing = configurazioneAuditing;
                appenders.clear();
                for (int i = 0; i < AuditAppender.configurazioneAuditing.sizeAppender(); ++i) {
                    Appender appenderConf = AuditAppender.configurazioneAuditing.getAppender(i);
                    Class<?> c = Class.forName(appenderConf.getClassName());
                    IAuditAppender appender = (IAuditAppender)ClassLoaderUtilities.newInstance(c);
                    Properties propertiesAppender = new Properties();
                    for (int j = 0; j < appenderConf.sizeProperties(); ++j) {
                        propertiesAppender.put(appenderConf.getProperty(j).getName(), appenderConf.getProperty(j).getValue());
                    }
                    appender.initAppender(appenderConf.getNome(), propertiesAppender);
                    appenders.put(appenderConf.getNome(), appender);
                }
            }
        }
        catch (Exception e) {
            throw new AuditException("AggiornamentoFallito: " + e.getMessage(), e);
        }
    }

    public IDOperazione registraOperazioneInFaseDiElaborazione(Tipologia tipoOperazione, Object object, String user, String interfaceMsg, boolean registrazioneBinari, DriverBYOKUtilities byok) throws AuditException, AuditDisabilitatoException {
        if (!configurazioneAuditing.isAuditEngineEnabled()) {
            throw new AuditDisabilitatoException(AUDIT_DISABILITATO);
        }
        try {
            Operation operation = new Operation();
            operation.setTipologia(tipoOperazione);
            operation.setUtente(user);
            operation.setStato(Stato.REQUESTING);
            operation.setTimeRequest(DateManager.getDate());
            operation.setTimeExecute(DateManager.getDate());
            operation.setInterfaceMsg(interfaceMsg);
            if (object == null) {
                throw new AuditException("Object riguardante l'operazione non definito");
            }
            operation.setTipoOggetto(idBuilder.getSimpleName(object));
            operation.setObjectId(idBuilder.toID(object));
            operation.setObjectOldId(idBuilder.toOldID(object));
            operation.setObjectClass(object.getClass().getName());
            Filter listFilter = new Filter();
            String objectDetails = this.filtraOperazione(operation, object, listFilter, registrazioneBinari, byok);
            if (objectDetails != null) {
                operation.setObjectDetails(objectDetails);
                for (int i = 0; i < listFilter.sizeFilteredObjects(); ++i) {
                    FilteredObject filteredObject = listFilter.getFilteredObject(i);
                    Binary binary = new Binary();
                    binary.setBinaryId(filteredObject.getId());
                    binary.setChecksum(filteredObject.getChecksum());
                    operation.addBinary(binary);
                }
            }
            IDOperazione idOperazione = new IDOperazione();
            if (appenders != null && appenders.keySet() != null) {
                for (String appenderName : appenders.keySet()) {
                    IAuditAppender appender = appenders.get(appenderName);
                    Object idOperazioneAppender = appender.registraOperazioneInFaseDiElaborazione(operation);
                    idOperazione.addIdOperazione(appenderName, idOperazioneAppender);
                }
                return idOperazione;
            }
            throw new AuditException(APPENDER_NON_FORNITI);
        }
        catch (AuditDisabilitatoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuditException("registraOperazioneInFaseDiElaborazione error: " + e.getMessage(), e);
        }
    }

    public void registraOperazioneAccesso(Tipologia tipoOperazione, String user, String interfaceMsg, boolean registrazioneBinari, DriverBYOKUtilities byok) throws AuditException, AuditDisabilitatoException {
        block6: {
            if (!configurazioneAuditing.isAuditEngineEnabled()) {
                throw new AuditDisabilitatoException(AUDIT_DISABILITATO);
            }
            try {
                Operation operation = new Operation();
                operation.setTipologia(tipoOperazione);
                operation.setUtente(user);
                operation.setStato(Stato.COMPLETED);
                operation.setTimeRequest(DateManager.getDate());
                operation.setTimeExecute(DateManager.getDate());
                operation.setInterfaceMsg(interfaceMsg);
                this.filtraOperazione(operation, registrazioneBinari, byok);
                IDOperazione idOperazione = new IDOperazione();
                if (appenders != null && appenders.keySet() != null) {
                    for (String appenderName : appenders.keySet()) {
                        IAuditAppender appender = appenders.get(appenderName);
                        Object idOperazioneAppender = appender.registraOperazioneInFaseDiElaborazione(operation);
                        idOperazione.addIdOperazione(appenderName, idOperazioneAppender);
                    }
                    break block6;
                }
                throw new AuditException(APPENDER_NON_FORNITI);
            }
            catch (AuditDisabilitatoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AuditException("registraOperazioneInFaseDiElaborazione error: " + e.getMessage(), e);
            }
        }
    }

    public void registraOperazioneCompletataConSuccesso(IDOperazione idOperazione, String interfaceMsg) throws AuditException, AuditDisabilitatoException {
        block8: {
            if (!configurazioneAuditing.isAuditEngineEnabled()) {
                throw new AuditDisabilitatoException(AUDIT_DISABILITATO);
            }
            try {
                if (idOperazione == null) {
                    throw new AuditException("Identificativo dell'operazione per cui cambiare stato non fornito");
                }
                if (appenders != null && appenders.keySet() != null) {
                    for (String appenderName : appenders.keySet()) {
                        IAuditAppender appender = appenders.get(appenderName);
                        Object id = idOperazione.getIdOperazione(appenderName);
                        if (id == null) {
                            throw new AuditException("Identificativo dell'operazione per l'appender[" + appenderName + "] non fornito");
                        }
                        if (id instanceof Operation) {
                            Operation op = (Operation)id;
                            op.setInterfaceMsg(interfaceMsg);
                        }
                        appender.registraOperazioneCompletataConSuccesso(id);
                    }
                    break block8;
                }
                throw new AuditException(APPENDER_NON_FORNITI);
            }
            catch (Exception e) {
                throw new AuditException("registraOperazioneCompletataConSuccesso error: " + e.getMessage(), e);
            }
        }
    }

    public void registraOperazioneTerminataConErrore(IDOperazione idOperazione, String motivoErrore, String interfaceMsg) throws AuditException, AuditDisabilitatoException {
        block8: {
            if (!configurazioneAuditing.isAuditEngineEnabled()) {
                throw new AuditDisabilitatoException(AUDIT_DISABILITATO);
            }
            try {
                if (idOperazione == null) {
                    throw new AuditException("Identificativo dell'operazione per cui cambiare stato non fornito");
                }
                if (appenders != null && appenders.keySet() != null) {
                    for (String appenderName : appenders.keySet()) {
                        IAuditAppender appender = appenders.get(appenderName);
                        Object id = idOperazione.getIdOperazione(appenderName);
                        if (id == null) {
                            throw new AuditException("Identificativo dell'operazione per l'appender[" + appenderName + "] non fornito");
                        }
                        if (id instanceof Operation) {
                            Operation op = (Operation)id;
                            op.setInterfaceMsg(interfaceMsg);
                        }
                        appender.registraOperazioneTerminataConErrore(id, motivoErrore);
                    }
                    break block8;
                }
                throw new AuditException(APPENDER_NON_FORNITI);
            }
            catch (Exception e) {
                throw new AuditException("registraOperazioneCompletataConSuccesso error: " + e.getMessage(), e);
            }
        }
    }

    private String serializeJsonObject(Object o, Filter listFilter, boolean registrazioneBinari) throws AuditException {
        try {
            if (!registrazioneBinari) {
                listFilter.addFilterByValue(byte[].class);
            }
            SerializationConfig config = new SerializationConfig();
            config.setFilter(listFilter);
            config.setIdBuilder(idBuilder);
            config.setPrettyPrint(true);
            JsonJacksonSerializer serializer = new JsonJacksonSerializer(config);
            return serializer.getObject(o);
        }
        catch (Exception e) {
            throw new AuditException("serializeJsonObject error: " + e.getMessage(), e);
        }
    }

    private void filtraOperazione(Operation operation, boolean registrazioneBinari, DriverBYOKUtilities byok) throws AuditException, AuditDisabilitatoException {
        this.filtraOperazione(operation, null, null, registrazioneBinari, byok);
    }

    private String filtraOperazione(Operation operation, Object object, Filter listFilter, boolean registrazioneBinari, DriverBYOKUtilities byok) throws AuditException, AuditDisabilitatoException {
        try {
            ArrayList<Filtro> filtri = configurazioneAuditing.getFiltri();
            boolean auditEnabledDefault = configurazioneAuditing.isAuditEnabled();
            boolean dumpEnabledDefault = configurazioneAuditing.isDumpEnabled();
            String objectDetails = null;
            for (int i = 0; i < filtri.size(); ++i) {
                Filtro filtro = filtri.get(i);
                if (filtro.getUsername() == null && filtro.getTipoOperazione() == null && filtro.getTipoOggettoInModifica() == null && filtro.getStatoOperazione() == null && filtro.getDump() == null) {
                    throw new AuditException("Filtro(" + i + "1) non valido: nessun meccanismo di filtro definito");
                }
                if (filtro.getUsername() != null && !filtro.getUsername().equals(operation.getUtente()) || filtro.getTipoOperazione() != null && !filtro.getTipoOperazione().equals(operation.getTipologia()) || filtro.getTipoOggettoInModifica() != null && !filtro.getTipoOggettoInModifica().equals(operation.getTipoOggetto()) || filtro.getStatoOperazione() != null && !filtro.getStatoOperazione().equals(operation.getStato())) continue;
                if (filtro.getDump() != null) {
                    if (object == null) continue;
                    if (objectDetails == null) {
                        objectDetails = this.serialize(object, listFilter, registrazioneBinari, byok);
                    }
                    if (!filtro.isDumpExprRegular() ? !objectDetails.contains(filtro.getDump()) : RegularExpressionEngine.getStringMatchPattern((String)objectDetails, (String)filtro.getDump()) == null) continue;
                }
                if (!filtro.isAuditEnabled()) {
                    throw new AuditDisabilitatoException("Audit disabilitato, criterio adottato in base al filtro numero " + (i + 1));
                }
                if (filtro.isDumpEnabled()) {
                    if (object != null && objectDetails == null) {
                        objectDetails = this.serialize(object, listFilter, registrazioneBinari, byok);
                    }
                } else if (objectDetails != null) {
                    objectDetails = null;
                }
                return objectDetails;
            }
            if (!auditEnabledDefault) {
                throw new AuditDisabilitatoException("Audit disabilitato nella configurazione generale (Non vi sono filtri che creano eccezioni)");
            }
            if (dumpEnabledDefault) {
                if (object != null && objectDetails == null) {
                    objectDetails = this.serialize(object, listFilter, registrazioneBinari, byok);
                }
            } else if (objectDetails != null) {
                objectDetails = null;
            }
            return objectDetails;
        }
        catch (AuditDisabilitatoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuditException("filtraOperazione error: " + e.getMessage(), e);
        }
    }

    private Object byok(DriverBYOKUtilities byok, Object object) throws UtilsException {
        if (object instanceof org.openspcoop2.core.config.Soggetto) {
            org.openspcoop2.core.config.Soggetto sCloned = (org.openspcoop2.core.config.Soggetto)((org.openspcoop2.core.config.Soggetto)object).clone();
            if (sCloned.getConnettore() != null && !sCloned.getConnettore().isEmpty()) {
                for (org.openspcoop2.core.config.Connettore connettore : sCloned.getConnettore()) {
                    this.byokConnettore(byok, connettore);
                }
            }
            return sCloned;
        }
        if (object instanceof Soggetto) {
            Soggetto sCloned = (Soggetto)((Soggetto)object).clone();
            if (sCloned.getConnettore() != null) {
                this.byokConnettore(byok, sCloned.getConnettore());
            }
            return sCloned;
        }
        if (object instanceof ServizioApplicativo) {
            ServizioApplicativo sCloned = (ServizioApplicativo)((ServizioApplicativo)object).clone();
            return this.byok(byok, sCloned);
        }
        if (object instanceof PortaDelegata) {
            PortaDelegata pdCloned = (PortaDelegata)((PortaDelegata)object).clone();
            return this.byok(byok, pdCloned);
        }
        if (object instanceof PortaApplicativa) {
            PortaApplicativa paCloned = (PortaApplicativa)((PortaApplicativa)object).clone();
            return this.byok(byok, paCloned);
        }
        if (object instanceof GenericProperties) {
            GenericProperties gpCloned = (GenericProperties)((GenericProperties)object).clone();
            return this.byok(byok, gpCloned);
        }
        if (object instanceof AccordoServizioParteSpecifica) {
            AccordoServizioParteSpecifica aspsCloned = (AccordoServizioParteSpecifica)((AccordoServizioParteSpecifica)object).clone();
            return this.byok(byok, aspsCloned);
        }
        return object;
    }

    private Object byok(DriverBYOKUtilities byok, ServizioApplicativo sCloned) throws UtilsException {
        if (sCloned.getInvocazioneServizio() != null && sCloned.getInvocazioneServizio().getConnettore() != null) {
            this.byokConnettore(byok, sCloned.getInvocazioneServizio().getConnettore());
        }
        if (sCloned.getInvocazioneServizio() != null && sCloned.getInvocazioneServizio().getAutenticazione() != null && InvocazioneServizioTipoAutenticazione.BASIC.equals((Object)sCloned.getInvocazioneServizio().getAutenticazione()) && sCloned.getInvocazioneServizio().getCredenziali() != null) {
            this.byokCredenzialiConnettore(byok, sCloned.getInvocazioneServizio().getCredenziali());
        }
        if (sCloned.getRispostaAsincrona() != null && sCloned.getRispostaAsincrona().getConnettore() != null) {
            this.byokConnettore(byok, sCloned.getRispostaAsincrona().getConnettore());
        }
        if (sCloned.getRispostaAsincrona() != null && sCloned.getRispostaAsincrona().getAutenticazione() != null && InvocazioneServizioTipoAutenticazione.BASIC.equals((Object)sCloned.getRispostaAsincrona().getAutenticazione()) && sCloned.getRispostaAsincrona().getCredenziali() != null) {
            this.byokCredenzialiConnettore(byok, sCloned.getRispostaAsincrona().getCredenziali());
        }
        if (sCloned.sizeProtocolPropertyList() > 0) {
            for (org.openspcoop2.core.config.ProtocolProperty p : sCloned.getProtocolProperty()) {
                if (!this.isConfidentialProtocolProperties(p.getName())) continue;
                p.setValue(byok.wrap(p.getValue()));
            }
        }
        return sCloned;
    }

    private void byokCredenzialiConnettore(DriverBYOKUtilities byok, InvocazioneCredenziali credenziale) throws UtilsException {
        if (credenziale.getPassword() != null) {
            credenziale.setPassword(byok.wrap(credenziale.getPassword()));
        }
    }

    private void byokConnettore(DriverBYOKUtilities byok, org.openspcoop2.core.config.Connettore connettore) throws UtilsException {
        if (connettore.sizePropertyList() > 0) {
            for (org.openspcoop2.core.config.Property p : connettore.getPropertyList()) {
                if (!this.isConfidentialConnettore(p.getNome())) continue;
                p.setValore(byok.wrap(p.getValore()));
            }
        }
    }

    private void byokConnettore(DriverBYOKUtilities byok, Connettore connettore) throws UtilsException {
        if (connettore.sizePropertyList() > 0) {
            for (Property p : connettore.getPropertyList()) {
                if (!this.isConfidentialConnettore(p.getNome())) continue;
                p.setValore(byok.wrap(p.getValore()));
            }
        }
    }

    private boolean isConfidentialConnettore(String nomeProprieta) {
        for (String nomeProprietaConfidential : CostantiConnettori.getConfidentials()) {
            if (!nomeProprieta.equals(nomeProprietaConfidential)) continue;
            return true;
        }
        return false;
    }

    private Object byok(DriverBYOKUtilities byok, PortaDelegata pdCloned) throws UtilsException {
        if (pdCloned.getMessageSecurity() != null) {
            if (pdCloned.getMessageSecurity().getRequestFlow() != null) {
                this.byok(byok, pdCloned.getMessageSecurity().getRequestFlow());
            }
            if (pdCloned.getMessageSecurity().getResponseFlow() != null) {
                this.byok(byok, pdCloned.getMessageSecurity().getResponseFlow());
            }
        }
        return pdCloned;
    }

    private Object byok(DriverBYOKUtilities byok, PortaApplicativa paCloned) throws UtilsException {
        if (paCloned.getMessageSecurity() != null) {
            if (paCloned.getMessageSecurity().getRequestFlow() != null) {
                this.byok(byok, paCloned.getMessageSecurity().getRequestFlow());
            }
            if (paCloned.getMessageSecurity().getResponseFlow() != null) {
                this.byok(byok, paCloned.getMessageSecurity().getResponseFlow());
            }
        }
        return paCloned;
    }

    private void byok(DriverBYOKUtilities byok, MessageSecurityFlow flow) throws UtilsException {
        if (flow.sizeParameterList() > 0) {
            for (MessageSecurityFlowParameter p : flow.getParameterList()) {
                if (!this.isConfidentialSecurity(p.getNome())) continue;
                p.setValore(byok.wrap(p.getValore()));
            }
        }
    }

    private boolean isConfidentialSecurity(String nomeProprieta) {
        List messageSecurityIds = CostantiProprieta.getMessageSecurityIds();
        if (messageSecurityIds != null && !messageSecurityIds.isEmpty()) {
            for (String id : messageSecurityIds) {
                List l = CostantiProprieta.getMessageSecurityProperties((String)id);
                for (String nomeProprietaCheck : l) {
                    if (!nomeProprietaCheck.equals(nomeProprieta)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private Object byok(DriverBYOKUtilities byok, GenericProperties gp) throws UtilsException {
        if (gp.sizePropertyList() > 0) {
            for (org.openspcoop2.core.config.Property p : gp.getPropertyList()) {
                if (!this.isConfidentialToken(gp.getTipo(), p.getNome())) continue;
                p.setValore(byok.wrap(p.getValore()));
            }
        }
        return gp;
    }

    private boolean isConfidentialToken(String tipo, String nomeProprieta) {
        List l = null;
        if ("validationToken".equals(tipo)) {
            l = CostantiProprieta.getTokenValidationProperties();
        } else if ("retrieveToken".equals(tipo)) {
            l = CostantiProprieta.getTokenRetrieveProperties();
        } else if ("attributeAuthority".equals(tipo)) {
            l = CostantiProprieta.getAttributeAuthorityProperties();
        }
        if (l != null) {
            for (String nomeProprietaCheck : l) {
                if (!nomeProprietaCheck.equals(nomeProprieta)) continue;
                return true;
            }
        }
        return false;
    }

    private Object byok(DriverBYOKUtilities byok, AccordoServizioParteSpecifica asps) throws UtilsException {
        if (asps.sizeProtocolPropertyList() > 0) {
            for (ProtocolProperty p : asps.getProtocolProperty()) {
                if (!this.isConfidentialProtocolProperties(p.getName())) continue;
                p.setValue(byok.wrap(p.getValue()));
            }
        }
        if (asps.sizeFruitoreList() > 0) {
            for (Fruitore fruitore : asps.getFruitoreList()) {
                this.byok(byok, fruitore);
            }
        }
        if (asps.getConfigurazioneServizio() != null && asps.getConfigurazioneServizio().getConnettore() != null) {
            this.byokConnettore(byok, asps.getConfigurazioneServizio().getConnettore());
        }
        return asps;
    }

    private Object byok(DriverBYOKUtilities byok, Fruitore fruitore) throws UtilsException {
        if (fruitore.sizeProtocolPropertyList() > 0) {
            for (ProtocolProperty p : fruitore.getProtocolProperty()) {
                if (!this.isConfidentialProtocolProperties(p.getName())) continue;
                p.setValue(byok.wrap(p.getValue()));
            }
        }
        if (fruitore.getConnettore() != null) {
            this.byokConnettore(byok, fruitore.getConnettore());
        }
        return fruitore;
    }

    private boolean isConfidentialProtocolProperties(String nomeProprieta) {
        return "modipaKeystorePassword".equals(nomeProprieta) || "modipaKeyPassword".equals(nomeProprieta) || "modipaTruststorePassword".equals(nomeProprieta) || "modipaSslTruststorePassword".equals(nomeProprieta);
    }

    private String serialize(Object object, Filter listFilter, boolean registrazioneBinari, DriverBYOKUtilities byok) throws AuditException {
        DriverBYOKUtilities byokUtilizzato = byok;
        try {
            if (byok == null || byok.getDriverBYOK(true, false) == null) {
                byokUtilizzato = this.newObfuscatedBYOKUtilities();
            }
        }
        catch (Exception e) {
            throw new AuditException(e.getMessage(), e);
        }
        try {
            object = this.byok(byokUtilizzato, object);
        }
        catch (Exception e) {
            throw new AuditException(e.getMessage(), e);
        }
        if ("JSON".equals(configurazioneAuditing.getDumpFormat())) {
            return this.serializeJsonObject(object, listFilter, registrazioneBinari);
        }
        throw new AuditException("Tipo di formattazione non conosciuta: " + configurazioneAuditing.getDumpFormat());
    }

    private ObfuscatedBYOKUtilities newObfuscatedBYOKUtilities() throws AuditException {
        try {
            return new ObfuscatedBYOKUtilities();
        }
        catch (Exception e) {
            throw new AuditException(e.getMessage(), e);
        }
    }

    static {
        appenders = new HashMap();
    }

    private static class ObfuscatedBYOKUtilities
    extends DriverBYOKUtilities {
        private static final String OBFUSCATED_VALUE = "***";

        public ObfuscatedBYOKUtilities() {
            super(null);
        }

        public String wrap(String value) throws UtilsException {
            if (value == null || value.isEmpty()) {
                return value;
            }
            return OBFUSCATED_VALUE;
        }

        public byte[] wrap(byte[] value) throws UtilsException {
            if (value == null || value.length == 0) {
                return value;
            }
            return OBFUSCATED_VALUE.getBytes();
        }
    }
}

