/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message;

import com.sun.xml.messaging.saaj.soap.SOAPDocumentImpl;
import jakarta.mail.internet.ContentType;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.message.AttachmentsProcessingMode;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory_impl;
import org.openspcoop2.message.OpenSPCoop2MessageParseResult;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.config.FaultBuilderConfig;
import org.openspcoop2.message.constants.Costanti;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.io.notifier.NotifierInputStream;
import org.openspcoop2.utils.io.notifier.NotifierInputStreamParams;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.mime.MultipartUtils;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.rest.problem.JsonSerializer;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807Builder;
import org.openspcoop2.utils.rest.problem.XmlSerializer;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.transport.TransportResponseContext;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class OpenSPCoop2MessageFactory {
    public static String messageFactoryImpl = OpenSPCoop2MessageFactory_impl.class.getName();
    protected static OpenSPCoop2MessageFactory openspcoopMessageFactory = null;
    protected static SOAPFactory soapFactory11 = null;
    protected static SOAPFactory soapFactory12 = null;
    protected static MessageFactory soapMessageFactory = null;
    private static OpenSPCoop2Message _instanceForUtilities = null;
    private static HashMap<String, OpenSPCoop2Message> internalInstanceForSOAPUtilities = new HashMap();

    public static void setMessageFactoryImpl(String messageFactoryImpl) {
        if (messageFactoryImpl != null) {
            OpenSPCoop2MessageFactory.messageFactoryImpl = messageFactoryImpl;
        }
    }

    public static OpenSPCoop2MessageFactory getDefaultMessageFactory() {
        if (openspcoopMessageFactory == null) {
            try {
                OpenSPCoop2MessageFactory.initDefaultMessageFactory();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return openspcoopMessageFactory;
    }

    public static void initDefaultMessageFactory() throws MessageException {
        OpenSPCoop2MessageFactory.initDefaultMessageFactory(false);
    }

    public static synchronized void initDefaultMessageFactory(boolean force) throws MessageException {
        try {
            if (openspcoopMessageFactory == null || force) {
                openspcoopMessageFactory = (OpenSPCoop2MessageFactory)Loader.getInstance().newInstance(messageFactoryImpl);
                SOAPDocumentImpl.setCustomDocumentBuilderFactory((String)openspcoopMessageFactory.getDocumentBuilderFactoryClass());
                SOAPDocumentImpl.setCustomSAXParserFactory((String)openspcoopMessageFactory.getSAXParserFactoryClass());
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    public SOAPFactory getSoapFactory11() {
        if (soapFactory11 == null) {
            this.initSoapFactory();
        }
        return soapFactory11;
    }

    public SOAPFactory getSoapFactory12() {
        if (soapFactory12 == null) {
            this.initSoapFactory();
        }
        return soapFactory12;
    }

    public static synchronized void initSoapFactory11(SOAPFactory soapFactory) {
        if (soapFactory11 == null) {
            soapFactory11 = soapFactory;
        }
    }

    public static synchronized void initSoapFactory12(SOAPFactory soapFactory) {
        if (soapFactory12 == null) {
            soapFactory12 = soapFactory;
        }
    }

    protected abstract void initSoapFactory();

    public MessageFactory getSoapMessageFactory() throws SOAPException {
        if (soapMessageFactory == null) {
            this.initSoapMessageFactory();
        }
        return soapMessageFactory;
    }

    public static synchronized void initSoapMessageFactory(MessageFactory soapMessageFactory) {
        if (OpenSPCoop2MessageFactory.soapMessageFactory == null) {
            OpenSPCoop2MessageFactory.soapMessageFactory = soapMessageFactory;
        }
    }

    protected abstract void initSoapMessageFactory() throws SOAPException;

    public abstract SOAPConnectionFactory getSOAPConnectionFactory() throws SOAPException;

    private static synchronized void initInstanceForUtilities(OpenSPCoop2MessageFactory messageFactory) {
        if (_instanceForUtilities == null) {
            _instanceForUtilities = messageFactory.createEmptyMessage(MessageType.SOAP_11, MessageRole.NONE);
        }
    }

    private static OpenSPCoop2Message getInstanceForUtilities(OpenSPCoop2MessageFactory messageFactory) {
        if (_instanceForUtilities == null) {
            OpenSPCoop2MessageFactory.initInstanceForUtilities(messageFactory);
        }
        return _instanceForUtilities;
    }

    public static String getAsString(OpenSPCoop2MessageFactory messageFactory, Node ele, boolean consume) {
        return OpenSPCoop2MessageFactory.getInstanceForUtilities(messageFactory).getAsString(ele, consume);
    }

    public static byte[] getAsByte(OpenSPCoop2MessageFactory messageFactory, Node ele, boolean consume) {
        return OpenSPCoop2MessageFactory.getInstanceForUtilities(messageFactory).getAsByte(ele, consume);
    }

    private static synchronized void initInstanceForSOAPUtilities(OpenSPCoop2MessageFactory messageFactory, MessageType messageType) {
        if (!internalInstanceForSOAPUtilities.containsKey(messageType.name())) {
            OpenSPCoop2Message msg = messageFactory.createEmptyMessage(messageType, MessageRole.NONE);
            internalInstanceForSOAPUtilities.put(messageType.name(), msg);
        }
    }

    private static OpenSPCoop2Message getInstanceForSOAPUtilities(OpenSPCoop2MessageFactory messageFactory, MessageType messageType) {
        if (!internalInstanceForSOAPUtilities.containsKey(messageType.name())) {
            OpenSPCoop2MessageFactory.initInstanceForSOAPUtilities(messageFactory, messageType);
        }
        return internalInstanceForSOAPUtilities.get(messageType.name());
    }

    public static SOAPElement createSOAPElement(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, byte[] element) throws MessageException, MessageNotSupportedException {
        OpenSPCoop2Message message = OpenSPCoop2MessageFactory.getInstanceForSOAPUtilities(messageFactory, messageType);
        OpenSPCoop2SoapMessage soapMsg = message.castAsSoap();
        return soapMsg.createSOAPElement(element);
    }

    public static Element getFirstChildElement(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, SOAPElement element) throws MessageException, MessageNotSupportedException {
        return OpenSPCoop2MessageFactory.getInstanceForSOAPUtilities(messageFactory, messageType).castAsSoap().getFirstChildElement(element);
    }

    public abstract String getDocumentBuilderFactoryClass();

    public abstract String getSAXParserFactoryClass();

    public abstract Element convertoForXPathSearch(Element var1);

    public abstract void normalizeDocument(Document var1);

    protected abstract OpenSPCoop2Message _createMessage(MessageType var1, SOAPMessage var2) throws MessageException;

    protected abstract OpenSPCoop2Message _createEmptyMessage(MessageType var1) throws MessageException;

    protected abstract OpenSPCoop2Message _createMessage(MessageType var1, TransportRequestContext var2, InputStream var3, AttachmentsProcessingMode var4, long var5, OpenSPCoop2MessageSoapStreamReader var7) throws MessageException;

    protected abstract OpenSPCoop2Message _createMessage(MessageType var1, TransportResponseContext var2, InputStream var3, AttachmentsProcessingMode var4, long var5, OpenSPCoop2MessageSoapStreamReader var7) throws MessageException;

    protected abstract OpenSPCoop2Message _createMessage(MessageType var1, String var2, InputStream var3, AttachmentsProcessingMode var4, long var5, OpenSPCoop2MessageSoapStreamReader var7) throws MessageException;

    public MessageType getMessageType(SOAPMessage soapMessage) throws MessageException {
        try {
            Object o = soapMessage.getProperty("OP2_MESSAGE_TYPE");
            if (o instanceof MessageType) {
                return (MessageType)o;
            }
            return null;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    private OpenSPCoop2Message internalCreateMessage(MessageType messageType, MessageRole role, SOAPMessage msg) throws MessageException {
        if (!MessageType.SOAP_11.equals(messageType) && !MessageType.SOAP_12.equals(messageType)) {
            throw new MessageException("Message Type [" + String.valueOf(messageType) + "] unsupported");
        }
        if (role.equals(MessageRole.FAULT) && Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
        }
        OpenSPCoop2Message msgNew = this._createMessage(messageType, msg);
        msgNew.castAsSoap();
        msgNew.setMessageType(messageType);
        msgNew.setMessageRole(role);
        return msgNew;
    }

    private OpenSPCoop2Message internalCreateEmptyMessage(MessageType messageType, MessageRole role) throws MessageException {
        if (role.equals(MessageRole.FAULT) && Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
        }
        OpenSPCoop2Message msgNew = this._createEmptyMessage(messageType);
        MessageUtilities.checkType(messageType, msgNew);
        msgNew.setMessageType(messageType);
        msgNew.setMessageRole(role);
        return msgNew;
    }

    private OpenSPCoop2MessageParseResult internalCreateMessage(MessageType messageType, MessageRole messageRole, Object context, Object msgParam, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, long overhead, OpenSPCoop2MessageSoapStreamReader soapStreamReader) {
        if (messageRole.equals(MessageRole.FAULT) && Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
        }
        OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
        try {
            InputStream is = null;
            if (msgParam != null) {
                if (msgParam instanceof byte[]) {
                    is = new ByteArrayInputStream((byte[])msgParam);
                } else if (msgParam instanceof InputStream) {
                    is = (InputStream)msgParam;
                } else {
                    throw new MessageException("Tipo di messaggio non supportato: " + msgParam.getClass().getName());
                }
            }
            InputStream nis = null;
            String contentType = null;
            TransportRequestContext transportRequestContext = null;
            TransportResponseContext transportResponseContext = null;
            String codiceTrasportoRisposta = null;
            if (context instanceof TransportRequestContext) {
                transportRequestContext = (TransportRequestContext)context;
                contentType = transportRequestContext.getHeaderFirstValue("Content-Type");
            } else if (context instanceof TransportResponseContext) {
                transportResponseContext = (TransportResponseContext)context;
                contentType = transportResponseContext.getHeaderFirstValue("Content-Type");
                codiceTrasportoRisposta = transportResponseContext.getCodiceTrasporto();
            } else if (context instanceof String) {
                contentType = (String)context;
            } else if (context == null) {
                if (!MessageType.BINARY.equals(messageType)) {
                    throw new MessageException("Unsupported Empty Context for message '" + String.valueOf(messageType) + "' (No Content Type?)");
                }
            } else {
                throw new MessageException("Unsupported Context [" + context.getClass().getName() + "]");
            }
            nis = notifierInputStreamParams != null && is != null ? new NotifierInputStream(is, contentType, notifierInputStreamParams) : is;
            OpenSPCoop2Message op2Msg = null;
            if (transportRequestContext != null) {
                op2Msg = this._createMessage(messageType, transportRequestContext, nis, attachmentsProcessingMode, overhead, soapStreamReader);
                if (MessageType.SOAP_11.equals(messageType) || MessageType.SOAP_12.equals(messageType)) {
                    ContentType ct;
                    String soapAction = null;
                    if (MessageType.SOAP_11.equals(messageType)) {
                        soapAction = transportRequestContext.getHeaderFirstValue("SOAPAction");
                    } else if (contentType != null && (ct = new ContentType(contentType)).getParameterList() != null && ct.getParameterList().size() > 0) {
                        Enumeration names = ct.getParameterList().getNames();
                        while (names.hasMoreElements()) {
                            String name = (String)names.nextElement();
                            if (!"action".equals(name)) continue;
                            soapAction = ct.getParameterList().get(name);
                        }
                    }
                    OpenSPCoop2SoapMessage soapMessage = op2Msg.castAsSoap();
                    if (soapAction != null) {
                        soapMessage.setSoapAction(soapAction);
                    }
                }
            } else {
                op2Msg = transportResponseContext != null ? this._createMessage(messageType, transportResponseContext, nis, attachmentsProcessingMode, overhead, soapStreamReader) : this._createMessage(messageType, contentType, nis, attachmentsProcessingMode, overhead, soapStreamReader);
            }
            if (op2Msg == null) {
                throw new MessageException("Create message failed");
            }
            if (notifierInputStreamParams != null && nis != null) {
                op2Msg.setNotifierInputStream((NotifierInputStream)nis);
            }
            if (context instanceof TransportRequestContext) {
                op2Msg.setTransportRequestContext(transportRequestContext);
            } else if (context instanceof TransportResponseContext) {
                op2Msg.setTransportResponseContext(transportResponseContext);
                if (codiceTrasportoRisposta != null) {
                    op2Msg.setForcedResponseCode(codiceTrasportoRisposta);
                }
            }
            op2Msg.setMessageRole(messageRole);
            op2Msg.setMessageType(messageType);
            if ((MessageType.SOAP_11.equals(messageType) || MessageType.SOAP_12.equals(messageType)) && !(op2Msg instanceof AbstractOpenSPCoop2Message_soap_impl)) {
                op2Msg.castAsSoap().getSOAPHeader();
            }
            result.setMessage(op2Msg);
        }
        catch (Throwable t) {
            try {
                result.setParseException(ParseExceptionUtils.buildParseException(t, messageRole));
            }
            catch (Throwable e) {
                System.err.println("Message reading error: " + t.getMessage());
                t.printStackTrace(System.err);
                throw new UtilsRuntimeException(t.getMessage(), t);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenSPCoop2MessageParseResult internalEnvelopingMessage(MessageType messageType, MessageRole messageRole, String contentTypeForEnvelope, String soapAction, Object context, Object msgParam, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        try {
            String contentType;
            byte[] byteMsg = null;
            if (msgParam instanceof byte[]) {
                byteMsg = (byte[])msgParam;
            } else if (msgParam instanceof InputStream) {
                byteMsg = Utilities.getAsByteArray((InputStream)((InputStream)msgParam));
            } else {
                throw new MessageException("Tipo di messaggio non supportato: " + msgParam.getClass().getName());
            }
            if (byteMsg == null || byteMsg.length == 0) {
                throw new MessageException("Nessun contenuto fornito da inserire all'interno del SoapBody");
            }
            if (MessageType.SOAP_11.equals(messageType)) {
                if (contentTypeForEnvelope == null) {
                    contentTypeForEnvelope = "text/xml";
                }
            } else if (MessageType.SOAP_12.equals(messageType)) {
                if (contentTypeForEnvelope == null) {
                    contentTypeForEnvelope = "application/soap+xml";
                }
            } else {
                throw new MessageException("Unsupported Type [" + String.valueOf(messageType) + "]");
            }
            int offset = 0;
            InputStream messageInput = null;
            if (MultipartUtils.messageWithAttachment((byte[])byteMsg)) {
                int puliziaSpaziBianchiConXML;
                contentTypeForEnvelope = ContentTypeUtilities.buildMultipartRelatedContentType((byte[])byteMsg, (String)contentTypeForEnvelope);
                String boundary = MultipartUtils.findBoundary((byte[])byteMsg);
                String msg = new String(byteMsg);
                int firstBound = msg.indexOf(boundary);
                int secondBound = msg.indexOf(boundary, firstBound + boundary.length());
                if (firstBound == -1 || secondBound == -1) {
                    throw new MessageException("multipart/related non correttamente formato (bound not found)");
                }
                String bodyOriginal = msg.substring(firstBound + boundary.length(), secondBound);
                int indexCarriage = bodyOriginal.indexOf("\r\n\r\n");
                if (indexCarriage == -1) {
                    throw new MessageException("multipart/related non correttamente formato (\\r\\n\\r\\n not found)");
                }
                String contenutoBody = bodyOriginal.substring(indexCarriage + "\r\n\r\n".length());
                for (puliziaSpaziBianchiConXML = 0; puliziaSpaziBianchiConXML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchiConXML) == ' '; ++puliziaSpaziBianchiConXML) {
                }
                String bodyPulito = contenutoBody.substring(puliziaSpaziBianchiConXML);
                if (bodyPulito.startsWith("<?xml")) {
                    if (eraserXmlTag) {
                        for (puliziaSpaziBianchiConXML = 0; puliziaSpaziBianchiConXML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchiConXML) != '>'; ++puliziaSpaziBianchiConXML) {
                        }
                        bodyPulito = bodyPulito.substring(puliziaSpaziBianchiConXML + 1);
                    } else {
                        throw new MessageException("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                    }
                }
                String contenutoBodyImbustato = null;
                contenutoBodyImbustato = MessageType.SOAP_11.equals(messageType) ? "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + bodyPulito + "</SOAP-ENV:Body></SOAP-ENV:Envelope>\r\n" : "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"><SOAP-ENV:Body>" + bodyPulito + "</SOAP-ENV:Body></SOAP-ENV:Envelope>\r\n";
                String bodyOriginalImbustato = bodyOriginal.replace(contenutoBody, contenutoBodyImbustato);
                msg = msg.replace(bodyOriginal, bodyOriginalImbustato);
                byteMsg = msg.getBytes();
                messageInput = new ByteArrayInputStream(byteMsg, offset, byteMsg.length);
            } else {
                int i;
                for (i = 0; i < byteMsg.length && (char)byteMsg[i] == ' '; ++i) {
                }
                offset = OpenSPCoop2MessageFactory.readOffsetXmlInstruction(byteMsg, i, eraserXmlTag, offset, false);
                ByteArrayInputStream messageInputXml = new ByteArrayInputStream(byteMsg, offset, byteMsg.length);
                ByteArrayInputStream binSoapOpen = null;
                binSoapOpen = MessageType.SOAP_11.equals(messageType) ? new ByteArrayInputStream("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>".getBytes()) : new ByteArrayInputStream("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\"><SOAP-ENV:Body>".getBytes());
                ByteArrayInputStream binSoapClose = new ByteArrayInputStream("</SOAP-ENV:Body></SOAP-ENV:Envelope>".getBytes());
                SequenceInputStream startInput = new SequenceInputStream(binSoapOpen, messageInputXml);
                messageInput = new SequenceInputStream(startInput, binSoapClose);
            }
            OpenSPCoop2MessageSoapStreamReader soapReader = null;
            if (useSoapMessageReader && (contentType = contentTypeForEnvelope) != null) {
                soapReader = new OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), contentType, messageInput, soapMessageReaderBufferThresholdKb);
                try {
                    soapReader.read();
                }
                finally {
                    messageInput = soapReader.getBufferedInputStream();
                }
            }
            OpenSPCoop2MessageParseResult result = null;
            if (context == null) {
                result = this.internalCreateMessage(messageType, messageRole, contentTypeForEnvelope, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, soapReader);
            } else if (context instanceof TransportRequestContext) {
                TransportRequestContext trc = (TransportRequestContext)context;
                TransportUtils.removeObject((Map)trc.getHeaders(), (String)"Content-Type");
                TransportUtils.addHeader((Map)trc.getHeaders(), (String)"Content-Type", (String)contentTypeForEnvelope);
                result = this.internalCreateMessage(messageType, messageRole, trc, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, soapReader);
            } else if (context instanceof TransportResponseContext) {
                TransportResponseContext trc = (TransportResponseContext)context;
                TransportUtils.removeObject((Map)trc.getHeaders(), (String)"Content-Type");
                TransportUtils.addHeader((Map)trc.getHeaders(), (String)"Content-Type", (String)contentTypeForEnvelope);
                result = this.internalCreateMessage(messageType, messageRole, trc, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, soapReader);
            } else {
                throw new MessageException("Unsupported Context [" + context.getClass().getName() + "]");
            }
            if (result.getMessage() != null) {
                OpenSPCoop2SoapMessage soapMessage = null;
                try {
                    soapMessage = result.getMessage().castAsSoap();
                    soapMessage.getSOAPHeader();
                }
                catch (Throwable soapException) {
                    result.setMessage(null);
                    result.setParseException(ParseExceptionUtils.buildParseException(soapException, messageRole));
                }
                if (soapMessage != null) {
                    soapMessage.setSoapAction(soapAction);
                }
            }
            return result;
        }
        catch (Throwable t) {
            OpenSPCoop2MessageParseResult result = new OpenSPCoop2MessageParseResult();
            result.setParseException(ParseExceptionUtils.buildParseException(t, messageRole));
            return result;
        }
    }

    private static int readOffsetXmlInstruction(byte[] byteMsg, int startFrom, boolean eraserXmlTag, int offsetParam, boolean cleanEmptyChar) throws Exception {
        int i;
        int offset = offsetParam;
        if (cleanEmptyChar) {
            for (i = startFrom; i < byteMsg.length && (char)byteMsg[i] != '<'; ++i) {
            }
        }
        Object xml = "";
        if (byteMsg.length > i + 5) {
            xml = "" + (char)byteMsg[i] + (char)byteMsg[i + 1] + (char)byteMsg[i + 2] + (char)byteMsg[i + 3] + (char)byteMsg[i + 4];
            if (((String)xml).equals("<?xml")) {
                if (eraserXmlTag) {
                    while (i < byteMsg.length && (char)byteMsg[i] != '>') {
                        ++i;
                    }
                } else {
                    throw new MessageException("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                }
                offset = i + 1;
                return OpenSPCoop2MessageFactory.readOffsetXmlInstruction(byteMsg, i + 1, eraserXmlTag, offset, true);
            }
            return offset;
        }
        return offset;
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createMessage(messageType, requestContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, MessageRole.REQUEST, requestContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, null);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, OpenSPCoop2MessageSoapStreamReader soapStreamReader) {
        return this.createMessage(messageType, requestContext, messageInput, notifierInputStreamParams, soapStreamReader, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, OpenSPCoop2MessageSoapStreamReader soapStreamReader, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, MessageRole.REQUEST, requestContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, soapStreamReader);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, byte[] messageInput) {
        return this.createMessage(messageType, requestContext, messageInput, null, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, byte[] messageInput, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.createMessage(messageType, requestContext, messageInput, null, attachmentsProcessingMode);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createMessage(messageType, requestContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportRequestContext requestContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, MessageRole.REQUEST, requestContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, null);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createMessage(messageType, responseContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, MessageRole.RESPONSE, responseContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, null);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, OpenSPCoop2MessageSoapStreamReader soapStreamReader) {
        return this.createMessage(messageType, responseContext, messageInput, notifierInputStreamParams, soapStreamReader, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, OpenSPCoop2MessageSoapStreamReader soapStreamReader, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, MessageRole.RESPONSE, responseContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, soapStreamReader);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, byte[] messageInput) {
        return this.createMessage(messageType, responseContext, messageInput, null, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, byte[] messageInput, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.createMessage(messageType, responseContext, messageInput, null, attachmentsProcessingMode);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createMessage(messageType, responseContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, TransportResponseContext responseContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, MessageRole.RESPONSE, responseContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, null);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createMessage(messageType, messageRole, contentType, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, messageRole, contentType, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, null);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, OpenSPCoop2MessageSoapStreamReader soapStreamReader) {
        return this.createMessage(messageType, messageRole, contentType, messageInput, notifierInputStreamParams, soapStreamReader, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, OpenSPCoop2MessageSoapStreamReader soapStreamReader, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, messageRole, contentType, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, soapStreamReader);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, byte[] messageInput) {
        return this.createMessage(messageType, messageRole, contentType, messageInput, null, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, byte[] messageInput, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.createMessage(messageType, messageRole, contentType, messageInput, null, attachmentsProcessingMode);
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createMessage(messageType, messageRole, contentType, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode());
    }

    public OpenSPCoop2MessageParseResult createMessage(MessageType messageType, MessageRole messageRole, String contentType, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode) {
        return this.internalCreateMessage(messageType, messageRole, contentType, messageInput, notifierInputStreamParams, attachmentsProcessingMode, 0L, null);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportRequestContext requestContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.envelopingMessage(messageType, contentTypeForEnvelope, soapAction, requestContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportRequestContext requestContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.internalEnvelopingMessage(messageType, MessageRole.REQUEST, contentTypeForEnvelope, soapAction, requestContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportRequestContext requestContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.envelopingMessage(messageType, contentTypeForEnvelope, soapAction, requestContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportRequestContext requestContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.internalEnvelopingMessage(messageType, MessageRole.REQUEST, contentTypeForEnvelope, soapAction, requestContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportResponseContext responseContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.envelopingMessage(messageType, contentTypeForEnvelope, soapAction, responseContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportResponseContext responseContext, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.internalEnvelopingMessage(messageType, MessageRole.RESPONSE, contentTypeForEnvelope, soapAction, responseContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportResponseContext responseContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.envelopingMessage(messageType, contentTypeForEnvelope, soapAction, responseContext, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, String contentTypeForEnvelope, String soapAction, TransportResponseContext responseContext, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.internalEnvelopingMessage(messageType, MessageRole.RESPONSE, contentTypeForEnvelope, soapAction, responseContext, messageInput, notifierInputStreamParams, attachmentsProcessingMode, eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, MessageRole messageRole, String contentTypeForEnvelope, String soapAction, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.envelopingMessage(messageType, messageRole, contentTypeForEnvelope, soapAction, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, MessageRole messageRole, String contentTypeForEnvelope, String soapAction, InputStream messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.internalEnvelopingMessage(messageType, messageRole, contentTypeForEnvelope, soapAction, null, messageInput, notifierInputStreamParams, attachmentsProcessingMode, eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, MessageRole messageRole, String contentTypeForEnvelope, String soapAction, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.envelopingMessage(messageType, messageRole, contentTypeForEnvelope, soapAction, messageInput, notifierInputStreamParams, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2MessageParseResult envelopingMessage(MessageType messageType, MessageRole messageRole, String contentTypeForEnvelope, String soapAction, byte[] messageInput, NotifierInputStreamParams notifierInputStreamParams, AttachmentsProcessingMode attachmentsProcessingMode, boolean eraserXmlTag, boolean useSoapMessageReader, int soapMessageReaderBufferThresholdKb) {
        return this.internalEnvelopingMessage(messageType, messageRole, contentTypeForEnvelope, soapAction, null, messageInput, notifierInputStreamParams, attachmentsProcessingMode, eraserXmlTag, useSoapMessageReader, soapMessageReaderBufferThresholdKb);
    }

    public OpenSPCoop2Message createMessage(MessageType messageType, MessageRole role, SOAPMessage msg) throws MessageException {
        return this.internalCreateMessage(messageType, role, msg);
    }

    public OpenSPCoop2Message createEmptyMessage(MessageType messageType, MessageRole role) {
        return this.createEmptyMessage(messageType, role, null);
    }

    public OpenSPCoop2Message createEmptyMessage(MessageType messageType, MessageRole role, NotifierInputStreamParams notifierInputStreamParams) {
        try {
            OpenSPCoop2Message msgEmpty = this.internalCreateEmptyMessage(messageType, role);
            if (MessageType.SOAP_11.equals(messageType) || MessageType.SOAP_12.equals(messageType)) {
                msgEmpty.setContentType(MessageUtilities.getDefaultContentType(messageType));
            }
            return msgEmpty;
        }
        catch (Throwable e) {
            System.err.println("Exception non gestibile durante la creazione di un messaggio vuoto. " + String.valueOf(e));
            e.printStackTrace(System.err);
            return null;
        }
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, FaultBuilderConfig faultBuilderConfig) {
        return this.createFaultMessage(messageType, useProblemRFC7807, faultBuilderConfig, "InternalError", null);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807) {
        return this.createFaultMessage(messageType, useProblemRFC7807, "InternalError", null);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, FaultBuilderConfig faultBuilderConfig, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createFaultMessage(messageType, useProblemRFC7807, faultBuilderConfig, "InternalError", notifierInputStreamParams);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createFaultMessage(messageType, useProblemRFC7807, "InternalError", notifierInputStreamParams);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, FaultBuilderConfig faultBuilderConfig, Throwable t) {
        return this.createFaultMessage(messageType, useProblemRFC7807, faultBuilderConfig, t, null);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, Throwable t) {
        return this.createFaultMessage(messageType, useProblemRFC7807, t, null);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, FaultBuilderConfig faultBuilderConfig, Throwable t, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createFaultMessage(messageType, useProblemRFC7807, faultBuilderConfig, t != null ? t.getMessage() : "Internal Error", notifierInputStreamParams);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, Throwable t, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createFaultMessage(messageType, useProblemRFC7807, t.getMessage(), notifierInputStreamParams);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, FaultBuilderConfig faultBuilderConfig, String errore) {
        return this.createFaultMessage(messageType, useProblemRFC7807, faultBuilderConfig, errore, null);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, String errore) {
        return this.createFaultMessage(messageType, useProblemRFC7807, errore, null);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, String errore, NotifierInputStreamParams notifierInputStreamParams) {
        return this.createFaultMessage(messageType, useProblemRFC7807, null, errore, notifierInputStreamParams);
    }

    public OpenSPCoop2Message createFaultMessage(MessageType messageType, boolean useProblemRFC7807, FaultBuilderConfig faultBuilderConfig, String erroreParam, NotifierInputStreamParams notifierInputStreamParams) {
        if (Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
        }
        if (faultBuilderConfig == null) {
            faultBuilderConfig = new FaultBuilderConfig();
        }
        if (faultBuilderConfig.getHttpReturnCode() == null) {
            faultBuilderConfig.setHttpReturnCode(503);
        }
        if (faultBuilderConfig.getGovwayReturnCode() == null) {
            faultBuilderConfig.setGovwayReturnCode(faultBuilderConfig.getHttpReturnCode());
        }
        String errore = erroreParam;
        if (faultBuilderConfig.getDetails() != null) {
            errore = faultBuilderConfig.getDetails();
        }
        if (messageType == null) {
            messageType = MessageType.BINARY;
        }
        try {
            Object fault = null;
            String contentType = MessageUtilities.getDefaultContentType(messageType);
            if (MessageType.SOAP_11.equals(messageType)) {
                prefixSoap = "SOAP-ENV";
                if (faultBuilderConfig.getPrefixSoap() != null) {
                    prefixSoap = faultBuilderConfig.getPrefixSoap();
                }
                fault = "<" + prefixSoap + ":Envelope xmlns:" + prefixSoap + "=\"http://schemas.xmlsoap.org/soap/envelope/\"><" + prefixSoap + ":Header/><" + prefixSoap + ":Body><" + prefixSoap + ":Fault>";
                fault = faultBuilderConfig.getErrorCode() != null ? (prefixSoap.equals(faultBuilderConfig.getErrorCode().getPrefix()) ? (String)fault + "<faultcode>" + faultBuilderConfig.getErrorCode().getPrefix() + ":" + faultBuilderConfig.getErrorCode().getLocalPart() + "</faultcode>" : (String)fault + "<faultcode xmlns:" + faultBuilderConfig.getErrorCode().getPrefix() + "=\"" + faultBuilderConfig.getErrorCode().getNamespaceURI() + "\">" + faultBuilderConfig.getErrorCode().getPrefix() + ":" + faultBuilderConfig.getErrorCode().getLocalPart() + "</faultcode>") : (String)fault + "<faultcode>" + prefixSoap + ":Server</faultcode>";
                fault = (String)fault + "<faultstring>" + errore + "</faultstring>";
                fault = faultBuilderConfig.getActor() != null ? (String)fault + "<faultactor>" + faultBuilderConfig.getActor() + "</faultactor>" : (String)fault + "<faultactor>http://govway.org/fault</faultactor>";
                fault = (String)fault + "</" + prefixSoap + ":Fault></" + prefixSoap + ":Body></" + prefixSoap + ":Envelope>";
            } else if (MessageType.SOAP_12.equals(messageType)) {
                prefixSoap = "env";
                if (faultBuilderConfig.getPrefixSoap() != null) {
                    prefixSoap = faultBuilderConfig.getPrefixSoap();
                }
                String code12 = "Receiver";
                if (faultBuilderConfig.getGovwayReturnCode() != null && faultBuilderConfig.getGovwayReturnCode() <= 499) {
                    code12 = "Sender";
                }
                fault = "<" + prefixSoap + ":Envelope xmlns:" + prefixSoap + "=\"http://www.w3.org/2003/05/soap-envelope\"><" + prefixSoap + ":Header/><" + prefixSoap + ":Body><" + prefixSoap + ":Fault><" + prefixSoap + ":Code><" + prefixSoap + ":Value>" + prefixSoap + ":" + code12 + "</" + prefixSoap + ":Value>";
                if (faultBuilderConfig.getErrorCode() != null) {
                    fault = (String)fault + "<" + prefixSoap + ":Subcode><" + prefixSoap + ":Value xmlns:" + faultBuilderConfig.getErrorCode().getPrefix() + "=\"" + faultBuilderConfig.getErrorCode().getNamespaceURI() + "\">" + faultBuilderConfig.getErrorCode().getPrefix() + ":" + faultBuilderConfig.getErrorCode().getLocalPart() + "</" + prefixSoap + ":Value></" + prefixSoap + ":Subcode>";
                }
                fault = (String)fault + "</" + prefixSoap + ":Code><" + prefixSoap + ":Reason><" + prefixSoap + ":Text xml:lang=\"en-US\">" + errore + "</" + prefixSoap + ":Text></" + prefixSoap + ":Reason>";
                fault = faultBuilderConfig.getActor() != null ? (String)fault + "<" + prefixSoap + ":Role>" + faultBuilderConfig.getActor() + "</" + prefixSoap + ":Role>" : (String)fault + "<" + prefixSoap + ":Role>http://govway.org/fault</" + prefixSoap + ":Role>";
                fault = (String)fault + "</" + prefixSoap + ":Fault></" + prefixSoap + ":Body></" + prefixSoap + ":Envelope>";
            } else if (MessageType.XML.equals(messageType)) {
                if (useProblemRFC7807) {
                    builder = null;
                    builder = faultBuilderConfig.isRfc7807Type() ? (faultBuilderConfig.getRfc7807WebSite() != null ? new ProblemRFC7807Builder(faultBuilderConfig.getRfc7807WebSite()) : new ProblemRFC7807Builder(true)) : new ProblemRFC7807Builder(false);
                    problemRFC7807 = builder.buildProblem(faultBuilderConfig.getGovwayReturnCode().intValue());
                    if (faultBuilderConfig.getRfc7807Title() != null) {
                        problemRFC7807.setTitle(faultBuilderConfig.getRfc7807Title());
                    }
                    if (errore != null && !"InternalError".equals(errore)) {
                        problemRFC7807.setDetail(errore);
                    }
                    XmlSerializer xmlSerializer = new XmlSerializer();
                    fault = xmlSerializer.toString(problemRFC7807);
                    contentType = "application/problem+xml";
                } else {
                    fault = "<op2:Fault xmlns:op2=\"" + (faultBuilderConfig.getActor() != null ? faultBuilderConfig.getActor() : "http://govway.org/fault") + "\"><op2:Message>" + errore + "</op2:Message></op2:Fault>";
                }
            } else if (MessageType.JSON.equals(messageType)) {
                if (useProblemRFC7807) {
                    builder = null;
                    builder = faultBuilderConfig.isRfc7807Type() ? (faultBuilderConfig.getRfc7807WebSite() != null ? new ProblemRFC7807Builder(faultBuilderConfig.getRfc7807WebSite()) : new ProblemRFC7807Builder(true)) : new ProblemRFC7807Builder(false);
                    problemRFC7807 = builder.buildProblem(faultBuilderConfig.getGovwayReturnCode().intValue());
                    if (faultBuilderConfig.getRfc7807Title() != null) {
                        problemRFC7807.setTitle(faultBuilderConfig.getRfc7807Title());
                    }
                    if (errore != null && !"InternalError".equals(errore)) {
                        problemRFC7807.setDetail(errore);
                    }
                    jsonSerializer = new JsonSerializer();
                    fault = jsonSerializer.toString(problemRFC7807);
                    contentType = "application/problem+json";
                } else {
                    fault = "{ \"fault\" : { \"message\" : \"" + errore + "\" , \"namespace\" : \"" + (faultBuilderConfig.getActor() != null ? faultBuilderConfig.getActor() : "http://govway.org/fault") + "\" } }";
                }
            } else if (useProblemRFC7807) {
                builder = null;
                builder = faultBuilderConfig.isRfc7807Type() ? (faultBuilderConfig.getRfc7807WebSite() != null ? new ProblemRFC7807Builder(faultBuilderConfig.getRfc7807WebSite()) : new ProblemRFC7807Builder(true)) : new ProblemRFC7807Builder(false);
                problemRFC7807 = builder.buildProblem(faultBuilderConfig.getGovwayReturnCode().intValue());
                if (faultBuilderConfig.getRfc7807Title() != null) {
                    problemRFC7807.setTitle(faultBuilderConfig.getRfc7807Title());
                }
                if (errore != null && !"InternalError".equals(errore)) {
                    problemRFC7807.setDetail(errore);
                }
                if (faultBuilderConfig.getRfc7807GovWayTypeHeaderErrorTypeName() != null && faultBuilderConfig.getRfc7807GovWayTypeHeaderErrorTypeValue() != null) {
                    problemRFC7807.getCustom().put(faultBuilderConfig.getRfc7807GovWayTypeHeaderErrorTypeName(), faultBuilderConfig.getRfc7807GovWayTypeHeaderErrorTypeValue());
                }
                jsonSerializer = new JsonSerializer();
                fault = jsonSerializer.toString(problemRFC7807);
                contentType = "application/problem+json";
            } else {
                fault = "{ \"fault\" : { \"message\" : \"" + errore + "\" , \"namespace\" : \"" + (faultBuilderConfig.getActor() != null ? faultBuilderConfig.getActor() : "http://govway.org/fault") + "\" } }";
                contentType = MessageUtilities.getDefaultContentType(MessageType.JSON);
            }
            byte[] xmlByte = ((String)fault).getBytes();
            OpenSPCoop2MessageParseResult result = this.createMessage(messageType, MessageRole.FAULT, contentType, xmlByte, notifierInputStreamParams);
            if (result.getParseException() != null) {
                throw result.getParseException().getSourceException();
            }
            OpenSPCoop2Message msg = result.getMessage();
            msg.addContextProperty(Costanti.ERRORE_GOVWAY, useProblemRFC7807 ? "rfc7807" : "govway");
            if (faultBuilderConfig.getErrorCode() != null) {
                if (faultBuilderConfig.getErrorCode().getPrefix() != null) {
                    msg.addContextProperty(Costanti.ERRORE_GOVWAY_PREFIX_CODE, faultBuilderConfig.getErrorCode().getPrefix());
                }
                if (faultBuilderConfig.getErrorCode().getLocalPart() != null) {
                    msg.addContextProperty(Costanti.ERRORE_GOVWAY_CODE, faultBuilderConfig.getErrorCode().getLocalPart());
                }
                msg.addContextProperty(Costanti.ERRORE_GOVWAY_DETAILS, errore);
            }
            if (faultBuilderConfig.getHeaderErrorTypeName() != null && faultBuilderConfig.getHeaderErrorTypeValue() != null) {
                msg.forceTransportHeader(faultBuilderConfig.getHeaderErrorTypeName(), faultBuilderConfig.getHeaderErrorTypeValue());
            }
            msg.setForcedResponseCode("" + faultBuilderConfig.getHttpReturnCode());
            return msg;
        }
        catch (Throwable e) {
            System.err.println("Exception non gestibile durante la creazione di un Fault. " + String.valueOf(e));
            e.printStackTrace(System.err);
            return null;
        }
    }

    public static boolean isFaultXmlMessage(Node nodeXml) {
        try {
            return "Fault".equals(nodeXml.getLocalName()) && "http://govway.org/fault".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFaultJsonMessage(String jsonBody, Logger log) {
        try {
            String namespace = JsonPathExpressionEngine.extractAndConvertResultAsString((String)jsonBody, (String)"$.fault.namespace", (Logger)log);
            return namespace != null && "http://govway.org/fault".equals(namespace);
        }
        catch (Exception e) {
            return false;
        }
    }
}

