/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.regexp.RegularExpressionPatternCompileMode;

public abstract class AbstractMediaTypeCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int STATUS_DEFAULT = 0;
    private static final String SEPARATORE = "__@@@__";
    private static final int SEPARATORE_LEN = "__@@@__".length();
    private List<String> map_status_mediaTypes = new ArrayList<String>();
    private List<MessageType> map_messageProcessor = new ArrayList<MessageType>();
    private List<Boolean> map_useRegularExpression = new ArrayList<Boolean>();

    private String buildKey(String mediaType, Integer status) {
        if (status == null) {
            status = 0;
        }
        return status + SEPARATORE + mediaType;
    }

    private String extractMediaTypeFromKey(String key) {
        int charIx = key.indexOf(SEPARATORE);
        return key.substring(charIx + SEPARATORE_LEN);
    }

    private int extractStatusFromKey(String key) {
        int charIx = key.indexOf(SEPARATORE);
        return Integer.parseInt(key.substring(0, charIx));
    }

    public void addDefaultMediaType(MessageType version) throws MessageException {
        this.addDefaultMediaType(null, version);
    }

    public void addUndefinedMediaType(MessageType version) throws MessageException {
        this.addUndefinedMediaType(null, version);
    }

    public void addMediaType(String mediaType, MessageType version, boolean regExpr) throws MessageException {
        this.addMediaType(mediaType, null, version, regExpr);
    }

    private void addDefaultMediaType(Integer status, MessageType version) throws MessageException {
        this.addMediaType("*", status, version, false);
    }

    private void addUndefinedMediaType(Integer status, MessageType version) throws MessageException {
        this.addMediaType("NotDefined", status, version, false);
    }

    private void addMediaType(String mediaType, Integer status, MessageType version, boolean regExpr) throws MessageException {
        if (mediaType == null) {
            throw new MessageException("MediaType not defined");
        }
        if (version == null) {
            throw new MessageException("MessageProcessorVersion not defined");
        }
        String key = this.buildKey(mediaType, status);
        if (this.map_status_mediaTypes.contains(key)) {
            Object stato = "";
            if (status != null && 0 != status) {
                stato = " (http-status:" + status + ")";
            }
            throw new MessageException("MediaType" + (String)stato + " already defined for MessageProcessorVersion " + String.valueOf(this.getMessageProcessorVersion(mediaType, status, false)));
        }
        this.map_status_mediaTypes.add(key);
        this.map_messageProcessor.add(version);
        this.map_useRegularExpression.add(regExpr);
    }

    public List<String> getContentTypes() {
        ArrayList<String> l = new ArrayList<String>();
        for (String key : this.map_status_mediaTypes) {
            String mediaType = this.extractMediaTypeFromKey(key);
            if (l.contains(mediaType)) continue;
            l.add(mediaType);
        }
        return l;
    }

    public void clear() {
        this.map_status_mediaTypes.clear();
        this.map_messageProcessor.clear();
        this.map_useRegularExpression.clear();
    }

    public void addOrReplaceMediaType(String mediaType, MessageType version, boolean regExpr) throws MessageException {
        this.addOrReplaceMediaType(mediaType, null, version, regExpr);
    }

    public void addOrReplaceMediaType(String mediaType, Integer status, MessageType version, boolean regExpr) throws MessageException {
        String key = this.buildKey(mediaType, status);
        if (this.map_status_mediaTypes.contains(key)) {
            this.removeMediaType(mediaType, status);
        }
        this.addMediaType(mediaType, status, version, regExpr);
    }

    public void removeMediaType(String mediaType) throws MessageException {
        this.removeMediaType(mediaType, null);
    }

    public void removeMediaType(String mediaType, Integer status) throws MessageException {
        String key = this.buildKey(mediaType, status);
        int index = -1;
        if (this.map_status_mediaTypes.contains(key)) {
            for (int i = 0; i < this.map_status_mediaTypes.size(); ++i) {
                String keyCheck = this.map_status_mediaTypes.get(i);
                if (!keyCheck.equals(key)) continue;
                index = i;
                break;
            }
        }
        if (index >= 0) {
            this.map_useRegularExpression.remove(index);
            this.map_messageProcessor.remove(index);
            this.map_status_mediaTypes.remove(index);
        }
    }

    public MessageType getMessageProcessor(String mediaType) throws MessageException {
        return this.getMessageProcessor(mediaType, null);
    }

    public MessageType getMessageProcessor(String mediaType, Integer status) throws MessageException {
        return this.getMessageProcessorVersion(mediaType, status, true);
    }

    private MessageType getMessageProcessorVersion(String mediaType, Integer status, boolean checkExpression) throws MessageException {
        String mediaTypeCheck;
        MessageType mt;
        int statusCheck;
        String keyCheck;
        int i;
        if (status == null) {
            status = 0;
        }
        for (i = 0; i < this.map_status_mediaTypes.size(); ++i) {
            keyCheck = this.map_status_mediaTypes.get(i);
            statusCheck = this.extractStatusFromKey(keyCheck);
            if (statusCheck != status || (mt = this._getMessageProcessorVersionEngine(checkExpression, i, mediaType, mediaTypeCheck = this.extractMediaTypeFromKey(keyCheck))) == null) continue;
            return mt;
        }
        if (status != 0) {
            for (i = 0; i < this.map_status_mediaTypes.size(); ++i) {
                keyCheck = this.map_status_mediaTypes.get(i);
                statusCheck = this.extractStatusFromKey(keyCheck);
                if (statusCheck != 0 || (mt = this._getMessageProcessorVersionEngine(checkExpression, i, mediaType, mediaTypeCheck = this.extractMediaTypeFromKey(keyCheck))) == null) continue;
                return mt;
            }
        }
        return null;
    }

    private MessageType _getMessageProcessorVersionEngine(boolean checkExpression, int i, String mediaType, String mediaTypeCheck) throws MessageException {
        block11: {
            if (checkExpression) {
                if (this.map_useRegularExpression.get(i).booleanValue()) {
                    if (mediaType == null) {
                        return null;
                    }
                    String pattern = mediaTypeCheck;
                    try {
                        if (RegularExpressionEngine.isMatch((String)mediaType, (String)pattern, (RegularExpressionPatternCompileMode[])new RegularExpressionPatternCompileMode[]{RegularExpressionPatternCompileMode.CASE_INSENSITIVE})) {
                            return this.map_messageProcessor.get(i);
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        throw new MessageException("Errore durante l'identificazione del content-type [" + mediaType + "] (pattern:" + pattern + "): " + e.getMessage(), e);
                    }
                }
                if ("*".equals(mediaTypeCheck)) {
                    return this.map_messageProcessor.get(i);
                }
                if ("NotDefined".equals(mediaTypeCheck) && (mediaType == null || "".equals(mediaType.trim()))) {
                    return this.map_messageProcessor.get(i);
                }
                if (mediaTypeCheck.equals(mediaType)) {
                    return this.map_messageProcessor.get(i);
                }
            } else if (mediaTypeCheck.equals(mediaType)) {
                return this.map_messageProcessor.get(i);
            }
        }
        return null;
    }
}

