/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.context.utils.serializer;

import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.message.context.ContentLength;
import org.openspcoop2.message.context.ContentTypeParameters;
import org.openspcoop2.message.context.Credentials;
import org.openspcoop2.message.context.ForcedResponse;
import org.openspcoop2.message.context.ForcedResponseMessage;
import org.openspcoop2.message.context.HeaderParameters;
import org.openspcoop2.message.context.MessageContext;
import org.openspcoop2.message.context.SerializedContext;
import org.openspcoop2.message.context.SerializedParameter;
import org.openspcoop2.message.context.Soap;
import org.openspcoop2.message.context.StringParameter;
import org.openspcoop2.message.context.TransportRequestContext;
import org.openspcoop2.message.context.TransportResponseContext;
import org.openspcoop2.message.context.UrlParameters;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, StringParameter stringParameter) throws SerializerException {
        this.objToXml(fileName, StringParameter.class, (Object)stringParameter, false);
    }

    public void write(String fileName, StringParameter stringParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, StringParameter.class, (Object)stringParameter, prettyPrint);
    }

    public void write(File file, StringParameter stringParameter) throws SerializerException {
        this.objToXml(file, StringParameter.class, (Object)stringParameter, false);
    }

    public void write(File file, StringParameter stringParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, StringParameter.class, (Object)stringParameter, prettyPrint);
    }

    public void write(OutputStream out, StringParameter stringParameter) throws SerializerException {
        this.objToXml(out, StringParameter.class, (Object)stringParameter, false);
    }

    public void write(OutputStream out, StringParameter stringParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, StringParameter.class, (Object)stringParameter, prettyPrint);
    }

    public byte[] toByteArray(StringParameter stringParameter) throws SerializerException {
        return this.objToXml(StringParameter.class, stringParameter, false).toByteArray();
    }

    public byte[] toByteArray(StringParameter stringParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StringParameter.class, stringParameter, prettyPrint).toByteArray();
    }

    public String toString(StringParameter stringParameter) throws SerializerException {
        return this.objToXml(StringParameter.class, stringParameter, false).toString();
    }

    public String toString(StringParameter stringParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(StringParameter.class, stringParameter, prettyPrint).toString();
    }

    public void write(String fileName, UrlParameters urlParameters) throws SerializerException {
        this.objToXml(fileName, UrlParameters.class, (Object)urlParameters, false);
    }

    public void write(String fileName, UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, UrlParameters.class, (Object)urlParameters, prettyPrint);
    }

    public void write(File file, UrlParameters urlParameters) throws SerializerException {
        this.objToXml(file, UrlParameters.class, (Object)urlParameters, false);
    }

    public void write(File file, UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, UrlParameters.class, (Object)urlParameters, prettyPrint);
    }

    public void write(OutputStream out, UrlParameters urlParameters) throws SerializerException {
        this.objToXml(out, UrlParameters.class, (Object)urlParameters, false);
    }

    public void write(OutputStream out, UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, UrlParameters.class, (Object)urlParameters, prettyPrint);
    }

    public byte[] toByteArray(UrlParameters urlParameters) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, false).toByteArray();
    }

    public byte[] toByteArray(UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, prettyPrint).toByteArray();
    }

    public String toString(UrlParameters urlParameters) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, false).toString();
    }

    public String toString(UrlParameters urlParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(UrlParameters.class, urlParameters, prettyPrint).toString();
    }

    public void write(String fileName, ContentLength contentLength) throws SerializerException {
        this.objToXml(fileName, ContentLength.class, (Object)contentLength, false);
    }

    public void write(String fileName, ContentLength contentLength, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ContentLength.class, (Object)contentLength, prettyPrint);
    }

    public void write(File file, ContentLength contentLength) throws SerializerException {
        this.objToXml(file, ContentLength.class, (Object)contentLength, false);
    }

    public void write(File file, ContentLength contentLength, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ContentLength.class, (Object)contentLength, prettyPrint);
    }

    public void write(OutputStream out, ContentLength contentLength) throws SerializerException {
        this.objToXml(out, ContentLength.class, (Object)contentLength, false);
    }

    public void write(OutputStream out, ContentLength contentLength, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ContentLength.class, (Object)contentLength, prettyPrint);
    }

    public byte[] toByteArray(ContentLength contentLength) throws SerializerException {
        return this.objToXml(ContentLength.class, contentLength, false).toByteArray();
    }

    public byte[] toByteArray(ContentLength contentLength, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ContentLength.class, contentLength, prettyPrint).toByteArray();
    }

    public String toString(ContentLength contentLength) throws SerializerException {
        return this.objToXml(ContentLength.class, contentLength, false).toString();
    }

    public String toString(ContentLength contentLength, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ContentLength.class, contentLength, prettyPrint).toString();
    }

    public void write(String fileName, TransportRequestContext transportRequestContext) throws SerializerException {
        this.objToXml(fileName, TransportRequestContext.class, (Object)transportRequestContext, false);
    }

    public void write(String fileName, TransportRequestContext transportRequestContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, TransportRequestContext.class, (Object)transportRequestContext, prettyPrint);
    }

    public void write(File file, TransportRequestContext transportRequestContext) throws SerializerException {
        this.objToXml(file, TransportRequestContext.class, (Object)transportRequestContext, false);
    }

    public void write(File file, TransportRequestContext transportRequestContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, TransportRequestContext.class, (Object)transportRequestContext, prettyPrint);
    }

    public void write(OutputStream out, TransportRequestContext transportRequestContext) throws SerializerException {
        this.objToXml(out, TransportRequestContext.class, (Object)transportRequestContext, false);
    }

    public void write(OutputStream out, TransportRequestContext transportRequestContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, TransportRequestContext.class, (Object)transportRequestContext, prettyPrint);
    }

    public byte[] toByteArray(TransportRequestContext transportRequestContext) throws SerializerException {
        return this.objToXml(TransportRequestContext.class, transportRequestContext, false).toByteArray();
    }

    public byte[] toByteArray(TransportRequestContext transportRequestContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(TransportRequestContext.class, transportRequestContext, prettyPrint).toByteArray();
    }

    public String toString(TransportRequestContext transportRequestContext) throws SerializerException {
        return this.objToXml(TransportRequestContext.class, transportRequestContext, false).toString();
    }

    public String toString(TransportRequestContext transportRequestContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(TransportRequestContext.class, transportRequestContext, prettyPrint).toString();
    }

    public void write(String fileName, HeaderParameters headerParameters) throws SerializerException {
        this.objToXml(fileName, HeaderParameters.class, (Object)headerParameters, false);
    }

    public void write(String fileName, HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, HeaderParameters.class, (Object)headerParameters, prettyPrint);
    }

    public void write(File file, HeaderParameters headerParameters) throws SerializerException {
        this.objToXml(file, HeaderParameters.class, (Object)headerParameters, false);
    }

    public void write(File file, HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, HeaderParameters.class, (Object)headerParameters, prettyPrint);
    }

    public void write(OutputStream out, HeaderParameters headerParameters) throws SerializerException {
        this.objToXml(out, HeaderParameters.class, (Object)headerParameters, false);
    }

    public void write(OutputStream out, HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, HeaderParameters.class, (Object)headerParameters, prettyPrint);
    }

    public byte[] toByteArray(HeaderParameters headerParameters) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, false).toByteArray();
    }

    public byte[] toByteArray(HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, prettyPrint).toByteArray();
    }

    public String toString(HeaderParameters headerParameters) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, false).toString();
    }

    public String toString(HeaderParameters headerParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(HeaderParameters.class, headerParameters, prettyPrint).toString();
    }

    public void write(String fileName, Credentials credentials) throws SerializerException {
        this.objToXml(fileName, Credentials.class, (Object)credentials, false);
    }

    public void write(String fileName, Credentials credentials, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Credentials.class, (Object)credentials, prettyPrint);
    }

    public void write(File file, Credentials credentials) throws SerializerException {
        this.objToXml(file, Credentials.class, (Object)credentials, false);
    }

    public void write(File file, Credentials credentials, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Credentials.class, (Object)credentials, prettyPrint);
    }

    public void write(OutputStream out, Credentials credentials) throws SerializerException {
        this.objToXml(out, Credentials.class, (Object)credentials, false);
    }

    public void write(OutputStream out, Credentials credentials, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Credentials.class, (Object)credentials, prettyPrint);
    }

    public byte[] toByteArray(Credentials credentials) throws SerializerException {
        return this.objToXml(Credentials.class, credentials, false).toByteArray();
    }

    public byte[] toByteArray(Credentials credentials, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Credentials.class, credentials, prettyPrint).toByteArray();
    }

    public String toString(Credentials credentials) throws SerializerException {
        return this.objToXml(Credentials.class, credentials, false).toString();
    }

    public String toString(Credentials credentials, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Credentials.class, credentials, prettyPrint).toString();
    }

    public void write(String fileName, SerializedParameter serializedParameter) throws SerializerException {
        this.objToXml(fileName, SerializedParameter.class, (Object)serializedParameter, false);
    }

    public void write(String fileName, SerializedParameter serializedParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SerializedParameter.class, (Object)serializedParameter, prettyPrint);
    }

    public void write(File file, SerializedParameter serializedParameter) throws SerializerException {
        this.objToXml(file, SerializedParameter.class, (Object)serializedParameter, false);
    }

    public void write(File file, SerializedParameter serializedParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SerializedParameter.class, (Object)serializedParameter, prettyPrint);
    }

    public void write(OutputStream out, SerializedParameter serializedParameter) throws SerializerException {
        this.objToXml(out, SerializedParameter.class, (Object)serializedParameter, false);
    }

    public void write(OutputStream out, SerializedParameter serializedParameter, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SerializedParameter.class, (Object)serializedParameter, prettyPrint);
    }

    public byte[] toByteArray(SerializedParameter serializedParameter) throws SerializerException {
        return this.objToXml(SerializedParameter.class, serializedParameter, false).toByteArray();
    }

    public byte[] toByteArray(SerializedParameter serializedParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SerializedParameter.class, serializedParameter, prettyPrint).toByteArray();
    }

    public String toString(SerializedParameter serializedParameter) throws SerializerException {
        return this.objToXml(SerializedParameter.class, serializedParameter, false).toString();
    }

    public String toString(SerializedParameter serializedParameter, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SerializedParameter.class, serializedParameter, prettyPrint).toString();
    }

    public void write(String fileName, SerializedContext serializedContext) throws SerializerException {
        this.objToXml(fileName, SerializedContext.class, (Object)serializedContext, false);
    }

    public void write(String fileName, SerializedContext serializedContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, SerializedContext.class, (Object)serializedContext, prettyPrint);
    }

    public void write(File file, SerializedContext serializedContext) throws SerializerException {
        this.objToXml(file, SerializedContext.class, (Object)serializedContext, false);
    }

    public void write(File file, SerializedContext serializedContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, SerializedContext.class, (Object)serializedContext, prettyPrint);
    }

    public void write(OutputStream out, SerializedContext serializedContext) throws SerializerException {
        this.objToXml(out, SerializedContext.class, (Object)serializedContext, false);
    }

    public void write(OutputStream out, SerializedContext serializedContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, SerializedContext.class, (Object)serializedContext, prettyPrint);
    }

    public byte[] toByteArray(SerializedContext serializedContext) throws SerializerException {
        return this.objToXml(SerializedContext.class, serializedContext, false).toByteArray();
    }

    public byte[] toByteArray(SerializedContext serializedContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SerializedContext.class, serializedContext, prettyPrint).toByteArray();
    }

    public String toString(SerializedContext serializedContext) throws SerializerException {
        return this.objToXml(SerializedContext.class, serializedContext, false).toString();
    }

    public String toString(SerializedContext serializedContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(SerializedContext.class, serializedContext, prettyPrint).toString();
    }

    public void write(String fileName, ForcedResponse forcedResponse) throws SerializerException {
        this.objToXml(fileName, ForcedResponse.class, (Object)forcedResponse, false);
    }

    public void write(String fileName, ForcedResponse forcedResponse, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ForcedResponse.class, (Object)forcedResponse, prettyPrint);
    }

    public void write(File file, ForcedResponse forcedResponse) throws SerializerException {
        this.objToXml(file, ForcedResponse.class, (Object)forcedResponse, false);
    }

    public void write(File file, ForcedResponse forcedResponse, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ForcedResponse.class, (Object)forcedResponse, prettyPrint);
    }

    public void write(OutputStream out, ForcedResponse forcedResponse) throws SerializerException {
        this.objToXml(out, ForcedResponse.class, (Object)forcedResponse, false);
    }

    public void write(OutputStream out, ForcedResponse forcedResponse, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ForcedResponse.class, (Object)forcedResponse, prettyPrint);
    }

    public byte[] toByteArray(ForcedResponse forcedResponse) throws SerializerException {
        return this.objToXml(ForcedResponse.class, forcedResponse, false).toByteArray();
    }

    public byte[] toByteArray(ForcedResponse forcedResponse, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ForcedResponse.class, forcedResponse, prettyPrint).toByteArray();
    }

    public String toString(ForcedResponse forcedResponse) throws SerializerException {
        return this.objToXml(ForcedResponse.class, forcedResponse, false).toString();
    }

    public String toString(ForcedResponse forcedResponse, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ForcedResponse.class, forcedResponse, prettyPrint).toString();
    }

    public void write(String fileName, ForcedResponseMessage forcedResponseMessage) throws SerializerException {
        this.objToXml(fileName, ForcedResponseMessage.class, (Object)forcedResponseMessage, false);
    }

    public void write(String fileName, ForcedResponseMessage forcedResponseMessage, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ForcedResponseMessage.class, (Object)forcedResponseMessage, prettyPrint);
    }

    public void write(File file, ForcedResponseMessage forcedResponseMessage) throws SerializerException {
        this.objToXml(file, ForcedResponseMessage.class, (Object)forcedResponseMessage, false);
    }

    public void write(File file, ForcedResponseMessage forcedResponseMessage, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ForcedResponseMessage.class, (Object)forcedResponseMessage, prettyPrint);
    }

    public void write(OutputStream out, ForcedResponseMessage forcedResponseMessage) throws SerializerException {
        this.objToXml(out, ForcedResponseMessage.class, (Object)forcedResponseMessage, false);
    }

    public void write(OutputStream out, ForcedResponseMessage forcedResponseMessage, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ForcedResponseMessage.class, (Object)forcedResponseMessage, prettyPrint);
    }

    public byte[] toByteArray(ForcedResponseMessage forcedResponseMessage) throws SerializerException {
        return this.objToXml(ForcedResponseMessage.class, forcedResponseMessage, false).toByteArray();
    }

    public byte[] toByteArray(ForcedResponseMessage forcedResponseMessage, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ForcedResponseMessage.class, forcedResponseMessage, prettyPrint).toByteArray();
    }

    public String toString(ForcedResponseMessage forcedResponseMessage) throws SerializerException {
        return this.objToXml(ForcedResponseMessage.class, forcedResponseMessage, false).toString();
    }

    public String toString(ForcedResponseMessage forcedResponseMessage, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ForcedResponseMessage.class, forcedResponseMessage, prettyPrint).toString();
    }

    public void write(String fileName, TransportResponseContext transportResponseContext) throws SerializerException {
        this.objToXml(fileName, TransportResponseContext.class, (Object)transportResponseContext, false);
    }

    public void write(String fileName, TransportResponseContext transportResponseContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, TransportResponseContext.class, (Object)transportResponseContext, prettyPrint);
    }

    public void write(File file, TransportResponseContext transportResponseContext) throws SerializerException {
        this.objToXml(file, TransportResponseContext.class, (Object)transportResponseContext, false);
    }

    public void write(File file, TransportResponseContext transportResponseContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, TransportResponseContext.class, (Object)transportResponseContext, prettyPrint);
    }

    public void write(OutputStream out, TransportResponseContext transportResponseContext) throws SerializerException {
        this.objToXml(out, TransportResponseContext.class, (Object)transportResponseContext, false);
    }

    public void write(OutputStream out, TransportResponseContext transportResponseContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, TransportResponseContext.class, (Object)transportResponseContext, prettyPrint);
    }

    public byte[] toByteArray(TransportResponseContext transportResponseContext) throws SerializerException {
        return this.objToXml(TransportResponseContext.class, transportResponseContext, false).toByteArray();
    }

    public byte[] toByteArray(TransportResponseContext transportResponseContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(TransportResponseContext.class, transportResponseContext, prettyPrint).toByteArray();
    }

    public String toString(TransportResponseContext transportResponseContext) throws SerializerException {
        return this.objToXml(TransportResponseContext.class, transportResponseContext, false).toString();
    }

    public String toString(TransportResponseContext transportResponseContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(TransportResponseContext.class, transportResponseContext, prettyPrint).toString();
    }

    public void write(String fileName, Soap soap) throws SerializerException {
        this.objToXml(fileName, Soap.class, (Object)soap, false);
    }

    public void write(String fileName, Soap soap, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Soap.class, (Object)soap, prettyPrint);
    }

    public void write(File file, Soap soap) throws SerializerException {
        this.objToXml(file, Soap.class, (Object)soap, false);
    }

    public void write(File file, Soap soap, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Soap.class, (Object)soap, prettyPrint);
    }

    public void write(OutputStream out, Soap soap) throws SerializerException {
        this.objToXml(out, Soap.class, (Object)soap, false);
    }

    public void write(OutputStream out, Soap soap, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Soap.class, (Object)soap, prettyPrint);
    }

    public byte[] toByteArray(Soap soap) throws SerializerException {
        return this.objToXml(Soap.class, soap, false).toByteArray();
    }

    public byte[] toByteArray(Soap soap, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Soap.class, soap, prettyPrint).toByteArray();
    }

    public String toString(Soap soap) throws SerializerException {
        return this.objToXml(Soap.class, soap, false).toString();
    }

    public String toString(Soap soap, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Soap.class, soap, prettyPrint).toString();
    }

    public void write(String fileName, MessageContext messageContext) throws SerializerException {
        this.objToXml(fileName, MessageContext.class, (Object)messageContext, false);
    }

    public void write(String fileName, MessageContext messageContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, MessageContext.class, (Object)messageContext, prettyPrint);
    }

    public void write(File file, MessageContext messageContext) throws SerializerException {
        this.objToXml(file, MessageContext.class, (Object)messageContext, false);
    }

    public void write(File file, MessageContext messageContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, MessageContext.class, (Object)messageContext, prettyPrint);
    }

    public void write(OutputStream out, MessageContext messageContext) throws SerializerException {
        this.objToXml(out, MessageContext.class, (Object)messageContext, false);
    }

    public void write(OutputStream out, MessageContext messageContext, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, MessageContext.class, (Object)messageContext, prettyPrint);
    }

    public byte[] toByteArray(MessageContext messageContext) throws SerializerException {
        return this.objToXml(MessageContext.class, messageContext, false).toByteArray();
    }

    public byte[] toByteArray(MessageContext messageContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(MessageContext.class, messageContext, prettyPrint).toByteArray();
    }

    public String toString(MessageContext messageContext) throws SerializerException {
        return this.objToXml(MessageContext.class, messageContext, false).toString();
    }

    public String toString(MessageContext messageContext, boolean prettyPrint) throws SerializerException {
        return this.objToXml(MessageContext.class, messageContext, prettyPrint).toString();
    }

    public void write(String fileName, ContentTypeParameters contentTypeParameters) throws SerializerException {
        this.objToXml(fileName, ContentTypeParameters.class, (Object)contentTypeParameters, false);
    }

    public void write(String fileName, ContentTypeParameters contentTypeParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ContentTypeParameters.class, (Object)contentTypeParameters, prettyPrint);
    }

    public void write(File file, ContentTypeParameters contentTypeParameters) throws SerializerException {
        this.objToXml(file, ContentTypeParameters.class, (Object)contentTypeParameters, false);
    }

    public void write(File file, ContentTypeParameters contentTypeParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ContentTypeParameters.class, (Object)contentTypeParameters, prettyPrint);
    }

    public void write(OutputStream out, ContentTypeParameters contentTypeParameters) throws SerializerException {
        this.objToXml(out, ContentTypeParameters.class, (Object)contentTypeParameters, false);
    }

    public void write(OutputStream out, ContentTypeParameters contentTypeParameters, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ContentTypeParameters.class, (Object)contentTypeParameters, prettyPrint);
    }

    public byte[] toByteArray(ContentTypeParameters contentTypeParameters) throws SerializerException {
        return this.objToXml(ContentTypeParameters.class, contentTypeParameters, false).toByteArray();
    }

    public byte[] toByteArray(ContentTypeParameters contentTypeParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ContentTypeParameters.class, contentTypeParameters, prettyPrint).toByteArray();
    }

    public String toString(ContentTypeParameters contentTypeParameters) throws SerializerException {
        return this.objToXml(ContentTypeParameters.class, contentTypeParameters, false).toString();
    }

    public String toString(ContentTypeParameters contentTypeParameters, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ContentTypeParameters.class, contentTypeParameters, prettyPrint).toString();
    }
}

