/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.exception;

import com.ctc.wstx.exc.WstxException;
import java.net.SocketException;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.exception.ParseException;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.TimeoutIOException;
import org.openspcoop2.utils.Utilities;

public class ParseExceptionUtils {
    public static ParseException buildParseException(Throwable e, MessageRole messageRole) {
        Throwable tmp;
        ParseException pe = new ParseException();
        pe.setSourceException(e, messageRole);
        if (e == null) {
            pe.setParseException(new Exception("Occurs Parsing Error"), messageRole);
            pe.setSourceException(new Exception("Occurs Parsing Error"), messageRole);
            return pe;
        }
        if (TimeoutIOException.isTimeoutIOException((Throwable)e) || Utilities.existsInnerMessageException((Throwable)e, (String)"Read timed out", (boolean)true)) {
            Throwable exceptionMessageTimeout;
            Throwable timeoutException = null;
            timeoutException = e instanceof TimeoutIOException ? e : Utilities.getInnerInstanceException((Throwable)e, TimeoutIOException.class, (boolean)false);
            if (timeoutException == null && Utilities.existsInnerMessageException((Throwable)e, (String)"Read timed out", (boolean)true) && (exceptionMessageTimeout = Utilities.getInnerMessageException((Throwable)e, (String)"Read timed out", (boolean)true)) != null) {
                timeoutException = new TimeoutIOException(exceptionMessageTimeout.getMessage(), exceptionMessageTimeout);
            }
            if (timeoutException != null) {
                pe.setParseException(timeoutException, messageRole);
                pe.setSourceException(timeoutException, messageRole);
                return pe;
            }
        }
        if (LimitExceededIOException.isLimitExceededIOException((Throwable)e) || Utilities.existsInnerMessageException((Throwable)e, (String)"Payload too large", (boolean)true) || Utilities.existsInnerMessageException((Throwable)e, (String)"Content-Length exceeds the allowed limit", (boolean)true)) {
            Throwable exceptionMessageLimitExceeded;
            Throwable limitedException = null;
            limitedException = e instanceof LimitExceededIOException ? e : Utilities.getInnerInstanceException((Throwable)e, LimitExceededIOException.class, (boolean)false);
            if (limitedException == null && Utilities.existsInnerMessageException((Throwable)e, (String)"Payload too large", (boolean)true) && (exceptionMessageLimitExceeded = Utilities.getInnerMessageException((Throwable)e, (String)"Payload too large", (boolean)true)) != null) {
                limitedException = new LimitExceededIOException(exceptionMessageLimitExceeded.getMessage(), exceptionMessageLimitExceeded);
            }
            if (limitedException == null && Utilities.existsInnerMessageException((Throwable)e, (String)"Content-Length exceeds the allowed limit", (boolean)true) && (exceptionMessageLimitExceeded = Utilities.getInnerMessageException((Throwable)e, (String)"Content-Length exceeds the allowed limit", (boolean)true)) != null) {
                limitedException = new LimitExceededIOException(exceptionMessageLimitExceeded.getMessage(), exceptionMessageLimitExceeded);
            }
            if (limitedException != null) {
                pe.setParseException(limitedException, messageRole);
                pe.setSourceException(limitedException, messageRole);
                return pe;
            }
        }
        if ((tmp = ParseExceptionUtils.getParseException(e)) != null) {
            pe.setParseException(tmp, messageRole);
            return pe;
        }
        pe.setParseException(ParseExceptionUtils.getInnerNotEmptyMessageException(e), messageRole);
        return pe;
    }

    public static Throwable getParseException(Throwable e) {
        if (e instanceof SocketException) {
            return null;
        }
        if (Utilities.existsInnerException((Throwable)e, SocketException.class)) {
            return null;
        }
        boolean found = false;
        Throwable tmp = null;
        if (tmp == null) {
            if (e instanceof WstxException) {
                tmp = e;
            } else if (Utilities.existsInnerException((Throwable)e, WstxException.class)) {
                tmp = Utilities.getInnerException((Throwable)e, WstxException.class);
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf((String)"com.ctc.wstx.exc.WstxIOException", (Throwable)e)) {
                tmp = e;
            } else if (Utilities.existsInnerException((Throwable)e, (String)"com.ctc.wstx.exc.WstxIOException")) {
                tmp = Utilities.getInnerException((Throwable)e, (String)"com.ctc.wstx.exc.WstxIOException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf((String)"com.ctc.wstx.exc.WstxParsingException", (Throwable)e)) {
                tmp = e;
            } else if (Utilities.existsInnerException((Throwable)e, (String)"com.ctc.wstx.exc.WstxParsingException")) {
                tmp = Utilities.getInnerException((Throwable)e, (String)"com.ctc.wstx.exc.WstxParsingException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf((String)"com.ctc.wstx.exc.WstxUnexpectedCharException", (Throwable)e)) {
                tmp = e;
            } else if (Utilities.existsInnerException((Throwable)e, (String)"com.ctc.wstx.exc.WstxUnexpectedCharException")) {
                tmp = Utilities.getInnerException((Throwable)e, (String)"com.ctc.wstx.exc.WstxUnexpectedCharException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf((String)"org.xml.sax.SAXParseException", (Throwable)e)) {
                tmp = e;
            } else if (Utilities.existsInnerException((Throwable)e, (String)"org.xml.sax.SAXParseException")) {
                tmp = Utilities.getInnerException((Throwable)e, (String)"org.xml.sax.SAXParseException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp == null) {
            if (Utilities.isExceptionInstanceOf((String)"javax.xml.stream.XMLStreamException", (Throwable)e)) {
                tmp = e;
            } else if (Utilities.existsInnerException((Throwable)e, (String)"javax.xml.stream.XMLStreamException")) {
                tmp = Utilities.getInnerException((Throwable)e, (String)"javax.xml.stream.XMLStreamException");
            }
            if (tmp != null && (tmp.getMessage() == null || "".equals(tmp.getMessage()) || "null".equalsIgnoreCase(tmp.getMessage()))) {
                tmp = null;
                found = true;
            }
        }
        if (tmp != null) {
            return tmp;
        }
        if (found) {
            return ParseExceptionUtils.getInnerNotEmptyMessageException(e);
        }
        return null;
    }

    public static boolean isEmpytMessageException(Throwable e) {
        return e.getMessage() == null || "".equals(e.getMessage()) || "null".equalsIgnoreCase(e.getMessage()) || "com.ctc.wstx.exc.WstxIOException: null".equalsIgnoreCase(e.getMessage());
    }

    public static Throwable getInnerNotEmptyMessageException(Throwable e) {
        if (!ParseExceptionUtils.isEmpytMessageException(e)) {
            return e;
        }
        if (e.getCause() != null) {
            return ParseExceptionUtils.getInnerNotEmptyMessageException(e.getCause());
        }
        return e;
    }
}

