/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.rest;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.rest.AbstractBaseOpenSPCoop2RestMessage;
import org.openspcoop2.utils.CopyStream;
import org.openspcoop2.utils.io.DumpByteArrayOutputStream;
import org.openspcoop2.utils.json.JSONUtils;
import org.openspcoop2.utils.json.JsonPathExpressionEngine;
import org.openspcoop2.utils.json.JsonPathReturnType;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;

public class OpenSPCoop2Message_json_impl
extends AbstractBaseOpenSPCoop2RestMessage<String>
implements OpenSPCoop2RestJsonMessage {
    public OpenSPCoop2Message_json_impl(OpenSPCoop2MessageFactory messageFactory) {
        super(messageFactory);
        this.supportReadOnly = false;
    }

    public OpenSPCoop2Message_json_impl(OpenSPCoop2MessageFactory messageFactory, InputStream is, String contentType) throws MessageException {
        super(messageFactory, is, contentType);
        this.supportReadOnly = false;
    }

    @Override
    protected String buildContent() throws MessageException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            CopyStream.copy((InputStream)this._getInputStream(), (OutputStream)bout);
            bout.flush();
            bout.close();
            String string = bout.toString(this.contentTypeCharsetName);
            return string;
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
        finally {
            try {
                this._getInputStream().close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected String buildContent(DumpByteArrayOutputStream contentBuffer) throws MessageException {
        try {
            return contentBuffer.toString(this.contentTypeCharsetName);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    protected String buildContentAsString() throws MessageException {
        return (String)this.content;
    }

    @Override
    protected byte[] buildContentAsByteArray() throws MessageException {
        try {
            return ((String)this.content).getBytes(this.contentTypeCharsetName);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    protected void serializeContent(OutputStream os, boolean consume) throws MessageException {
        OutputStreamWriter w = null;
        try {
            w = new OutputStreamWriter(os, this.contentTypeCharsetName);
            w.write((String)this.content);
            ((Writer)w).flush();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
        finally {
            try {
                if (w != null) {
                    ((Writer)w).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isProblemDetailsForHttpApis_RFC7807() throws MessageException, MessageNotSupportedException {
        try {
            if (this.contentType == null) {
                return false;
            }
            String baseType = ContentTypeUtilities.readBaseTypeFromContentType((String)this.contentType);
            return "application/problem+json".equalsIgnoreCase(baseType);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void prettyFormatContent() throws MessageException, MessageNotSupportedException {
        try {
            if (this.hasContent()) {
                String content = (String)this.getContent();
                JSONUtils jsonUtils = JSONUtils.getInstance((boolean)true);
                JsonNode node = jsonUtils.getAsNode(content);
                this.updateContent(jsonUtils.toString(node));
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public void addSimpleElement(String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(true, null, name, value, true, false, false);
    }

    @Override
    public void addSimpleElement(String jsonPath, String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(false, jsonPath, name, value, true, false, false);
    }

    @Override
    public void addObjectElement(String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(true, null, name, this.toJSONObject(value), true, false, false);
    }

    @Override
    public void addObjectElement(String jsonPath, String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(false, jsonPath, name, this.toJSONObject(value), true, false, false);
    }

    private JSONObject toJSONObject(Object valueParam) throws MessageException {
        JSONObject value = null;
        if (valueParam instanceof JSONObject) {
            value = (JSONObject)valueParam;
        } else if (valueParam instanceof String) {
            try {
                value = JsonPathExpressionEngine.getJSONObject((String)((String)valueParam));
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        } else if (valueParam instanceof JsonNode) {
            try {
                value = JsonPathExpressionEngine.getJSONObject((JsonNode)((JsonNode)valueParam));
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        } else if (valueParam instanceof InputStream) {
            try {
                value = JsonPathExpressionEngine.getJSONObject((InputStream)((InputStream)valueParam));
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        } else {
            throw new MessageException("Unsupported type '" + valueParam.getClass().getName() + "'");
        }
        return value;
    }

    @Override
    public void addArrayElement(String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(true, null, name, this.toJSONArray(value), true, false, false);
    }

    @Override
    public void addArrayElement(String jsonPath, String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(false, jsonPath, name, this.toJSONArray(value), true, false, false);
    }

    private JSONArray toJSONArray(Object valueParam) throws MessageException {
        JSONArray value = null;
        if (valueParam instanceof JSONArray) {
            value = (JSONArray)valueParam;
        } else if (valueParam instanceof String) {
            try {
                value = JsonPathExpressionEngine.getJSONArray((String)((String)valueParam));
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        } else if (valueParam instanceof JsonNode) {
            try {
                value = JsonPathExpressionEngine.getJSONArray((JsonNode)((JsonNode)valueParam));
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        } else if (valueParam instanceof InputStream) {
            try {
                value = JsonPathExpressionEngine.getJSONArray((InputStream)((InputStream)valueParam));
            }
            catch (Exception e) {
                throw new MessageException(e.getMessage(), e);
            }
        } else {
            throw new MessageException("Unsupported type '" + valueParam.getClass().getName() + "'");
        }
        return value;
    }

    @Override
    public void removeElement(String name) throws MessageException, MessageNotSupportedException {
        this._processJsonField(true, null, name, null, false, true, false);
    }

    @Override
    public void removeElement(String jsonPath, String name) throws MessageException, MessageNotSupportedException {
        this._processJsonField(false, jsonPath, name, null, false, true, false);
    }

    @Override
    public void replaceValue(String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(true, null, name, value, false, false, true);
    }

    @Override
    public void replaceValue(String jsonPath, String name, Object value) throws MessageException, MessageNotSupportedException {
        this._processJsonField(false, jsonPath, name, value, false, false, true);
    }

    private void _processJsonField(boolean rootElement, String jsonPath, String name, Object value, boolean add, boolean remove, boolean replaceValue) throws MessageException {
        try {
            if (!this.hasContent()) {
                return;
            }
            JsonPathExpressionEngine engine = new JsonPathExpressionEngine();
            JSONObject rootObject = JsonPathExpressionEngine.getJSONObject((String)((String)this.getContent()));
            Object o = rootObject;
            if (!rootElement) {
                if (jsonPath == null) {
                    throw new Exception("JsonPath undefined");
                }
                o = engine.getMatchPattern(rootObject, jsonPath, JsonPathReturnType.JSON_PATH_OBJECT);
            }
            if (o instanceof JSONObject) {
                JSONObject oNode = o;
                if (add) {
                    oNode.appendField(name, value);
                } else if (replaceValue) {
                    oNode.remove((Object)name);
                    oNode.appendField(name, value);
                } else {
                    oNode.remove((Object)name);
                }
            } else if (o instanceof JSONArray) {
                JSONArray arrayNode = (JSONArray)o;
                if (arrayNode.size() > 0) {
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        Object oNodeArray = arrayNode.get(i);
                        if (oNodeArray instanceof JSONObject) {
                            JSONObject oNode = (JSONObject)oNodeArray;
                            if (add) {
                                oNode.appendField(name, value);
                                continue;
                            }
                            if (replaceValue) {
                                oNode.remove((Object)name);
                                oNode.appendField(name, value);
                                continue;
                            }
                            oNode.remove((Object)name);
                            continue;
                        }
                        throw new Exception("Tipo dell'oggetto individuato tramite jsonPath (posizione array '" + i + "') non consente l'operazione richiesta: " + oNodeArray.getClass().getName());
                    }
                }
            } else {
                throw new Exception("Tipo dell'oggetto individuato tramite jsonPath non consente l'operazione richiesta: " + o.getClass().getName());
            }
            this.updateContent(rootObject.toJSONString(JSONStyle.NO_COMPRESS));
        }
        catch (Exception e) {
            throw new MessageException("Operazione fallita (pattern: " + jsonPath + "): " + e.getMessage(), e);
        }
    }
}

