/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import jakarta.activation.DataHandler;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.openspcoop2.message.AbstractBaseOpenSPCoop2MessageDynamicContent;
import org.openspcoop2.message.ForwardConfig;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2MessageProperties;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.context.MessageContext;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_saaj_impl;
import org.openspcoop2.message.soap.OpenSPCoop2MessageMimeHeaderProperties;
import org.openspcoop2.message.soap.OpenSPCoop2SoapMessageCore;
import org.openspcoop2.message.soap.SOAPFaultCode;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.dynamic.DynamicSOAPHeader;
import org.openspcoop2.message.soap.dynamic.DynamicSOAPMessage;
import org.openspcoop2.message.soap.dynamic.DynamicSOAPPart;
import org.openspcoop2.message.soap.mtom.MTOMUtilities;
import org.openspcoop2.message.soap.mtom.MtomXomPackageInfo;
import org.openspcoop2.message.soap.mtom.MtomXomReference;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractOpenSPCoop2Message_soap_impl<T extends AbstractOpenSPCoop2Message_saaj_impl>
extends AbstractBaseOpenSPCoop2MessageDynamicContent<T>
implements OpenSPCoop2SoapMessage {
    protected long overhead;
    protected MimeHeaders mhs;
    protected OpenSPCoop2SoapMessageCore soapCore;
    private DynamicSOAPMessage<T> dynamicSOAPMessage = null;
    private DynamicSOAPPart<T> dynamicSOAPPart = null;
    private DynamicSOAPHeader<T> dynamicSOAPHeader = null;

    protected AbstractOpenSPCoop2Message_soap_impl(OpenSPCoop2MessageFactory messageFactory, MimeHeaders mhs, InputStream is, long overhead, OpenSPCoop2MessageSoapStreamReader soapStreamReader) throws MessageException {
        super(messageFactory, is, SoapUtils.getContentType(mhs), true, soapStreamReader);
        this.overhead = overhead;
        this.mhs = mhs;
        this.soapCore = new OpenSPCoop2SoapMessageCore();
    }

    @Override
    protected String buildContentAsString() throws MessageException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.serializeContent(bout, true);
            bout.flush();
            bout.close();
            return bout.toString(this.contentTypeCharsetName);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    protected byte[] buildContentAsByteArray() throws MessageException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.serializeContent(bout, true);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    protected void serializeContent(OutputStream os, boolean consume) throws MessageException {
        try {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).writeTo(os, consume);
            os.flush();
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    protected void addSoapHeaderModifiedIntoSoapReader(SOAPHeader hdr, SOAPEnvelope envelope) throws MessageException {
        try {
            if (this.contentUpdatable && this.getSoapReader() != null && this.getSoapReader().isSoapHeaderModified()) {
                SOAPHeader newHdr = this.getSoapReader().getHeader();
                if (hdr != null) {
                    NodeList list;
                    hdr.removeContents();
                    if (newHdr != null && (list = newHdr.getChildNodes()) != null && list.getLength() > 0) {
                        for (int i = 0; i < list.getLength(); ++i) {
                            Node n = list.item(i);
                            Node newNodeAdopted = envelope.getOwnerDocument().importNode(n, true);
                            hdr.appendChild(newNodeAdopted);
                        }
                    }
                } else if (newHdr != null) {
                    SOAPBody body;
                    Node newHdrAdopted = envelope.getOwnerDocument().importNode((Node)newHdr, true);
                    if (envelope.getPrefix() == null && newHdrAdopted.getPrefix() != null || !envelope.getPrefix().equals(newHdrAdopted.getPrefix())) {
                        newHdrAdopted.setPrefix(envelope.getPrefix());
                    }
                    if ((body = envelope.getBody()) != null) {
                        envelope.insertBefore(newHdrAdopted, (Node)body);
                    } else {
                        envelope.appendChild(newHdrAdopted);
                    }
                }
                this.getSoapReader().clearHeader();
                this.clearDynamicResources();
                this.releaseSoapReader();
            }
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    protected void setUpdatableContent() throws MessageException {
        try {
            if (this.getSoapReader() != null && this.getSoapReader().isSoapHeaderModified()) {
                SOAPHeader hdr = ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getSOAPHeader();
                SOAPEnvelope envelope = ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getSOAPPart().getEnvelope();
                this.addSoapHeaderModifiedIntoSoapReader(hdr, envelope);
            }
        }
        catch (Throwable t) {
            throw SoapUtils.buildMessageException("Unable to update envelope header: ", t);
        }
    }

    @Override
    public MessageContext serializeResourcesTo() throws MessageException {
        MessageContext messageContext = super.serializeResourcesTo();
        return this.soapCore.serializeResourcesTo(messageContext);
    }

    @Override
    public void readResourcesFrom(MessageContext messageContext) throws MessageException {
        super.readResourcesFrom(messageContext);
        this.soapCore.readResourcesFrom(messageContext);
    }

    @Override
    public String getSoapAction() {
        return this.soapCore.getSoapAction();
    }

    @Override
    public void setSoapAction(String soapAction) {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).setSoapAction(soapAction);
        }
        this.soapCore.setSoapAction(soapAction);
    }

    @Override
    public boolean isThrowExceptionIfFoundMoreSecurityHeader() {
        return this.soapCore.isThrowExceptionIfFoundMoreSecurityHeader();
    }

    @Override
    public void setThrowExceptionIfFoundMoreSecurityHeader(boolean throwExceptionIfFoundMoreSecurityHeader) {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).setThrowExceptionIfFoundMoreSecurityHeader(throwExceptionIfFoundMoreSecurityHeader);
        }
        this.soapCore.setThrowExceptionIfFoundMoreSecurityHeader(throwExceptionIfFoundMoreSecurityHeader);
    }

    @Override
    public OpenSPCoop2MessageProperties getForwardTransportHeader(ForwardConfig forwardConfig) throws MessageException {
        OpenSPCoop2MessageProperties msg = super.getForwardTransportHeader(forwardConfig);
        if (this.isContentBuilded()) {
            return new OpenSPCoop2MessageMimeHeaderProperties(((AbstractOpenSPCoop2Message_saaj_impl)this.content)._getSOAPMessage(), msg);
        }
        return msg;
    }

    @Override
    public void addContentTypeParameter(String name, String value) throws MessageException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).contentTypeParamaters.put(name, value);
            if (!this.contentUpdatable) {
                super.addContentTypeParameter(name, value);
            }
        } else {
            super.addContentTypeParameter(name, value);
        }
    }

    @Override
    public void removeContentTypeParameter(String name) throws MessageException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).removeContentTypeParameter(name);
            if (!this.contentUpdatable) {
                super.removeContentTypeParameter(name);
            }
        } else {
            super.removeContentTypeParameter(name);
        }
    }

    @Override
    public void updateContentType() throws MessageException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).updateContentType();
            if (!this.contentUpdatable) {
                super.updateContentType();
            }
        } else {
            super.updateContentType();
        }
    }

    @Override
    public void setContentType(String type) {
        if (this.isContentBuilded()) {
            try {
                ((AbstractOpenSPCoop2Message_saaj_impl)this.content).setContentType(type);
            }
            catch (Exception eInternal) {
                throw new UtilsRuntimeException(eInternal.getMessage(), (Throwable)eInternal);
            }
            if (!this.contentUpdatable) {
                super.setContentType(type);
            }
        } else {
            super.setContentType(type);
        }
    }

    @Override
    public String getContentType() {
        if (this.contentBuffer != null && !this.contentUpdatable) {
            return this._getContentType();
        }
        if (this.isContentBuilded()) {
            try {
                return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getContentType();
            }
            catch (Exception eInternal) {
                throw new UtilsRuntimeException(eInternal.getMessage(), (Throwable)eInternal);
            }
        }
        return this._getContentType();
    }

    protected String _getContentType() {
        return super.getContentType();
    }

    @Override
    public void saveChanges() throws MessageException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).saveChanges();
            if (!this.contentUpdatable) {
                super.saveChanges();
            }
        } else {
            super.saveChanges();
        }
    }

    @Override
    public boolean saveRequired() {
        if (this.contentBuffer != null && !this.contentUpdatable) {
            return super.saveRequired();
        }
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).saveRequired();
        }
        return super.saveRequired();
    }

    @Override
    public String createContentID(String ns) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).createContentID(ns);
        }
        return AbstractOpenSPCoop2Message_saaj_impl._createContentID(ns);
    }

    @Override
    public Element getFirstChildElement(SOAPElement element) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getFirstChildElement(element);
        }
        return AbstractOpenSPCoop2Message_saaj_impl._getFirstChildElement(element);
    }

    @Override
    public SOAPElement createSOAPElement(byte[] bytes) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).createSOAPElement(bytes);
        }
        return AbstractOpenSPCoop2Message_saaj_impl._createSOAPElement(bytes, this.getMessageType(), this.messageFactory);
    }

    @Override
    public SOAPHeaderElement newSOAPHeaderElement(SOAPHeader hdr, QName name) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).newSOAPHeaderElement(hdr, name);
        }
        return AbstractOpenSPCoop2Message_saaj_impl._newSOAPHeaderElement(hdr, name);
    }

    @Override
    public void addHeaderElement(SOAPHeader hdr, SOAPHeaderElement hdrElement) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).addHeaderElement(hdr, hdrElement);
        } else {
            AbstractOpenSPCoop2Message_saaj_impl._addHeaderElement(hdr, hdrElement);
        }
    }

    @Override
    public void removeHeaderElement(SOAPHeader hdr, SOAPHeaderElement hdrElement) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).removeHeaderElement(hdr, hdrElement);
        } else {
            AbstractOpenSPCoop2Message_saaj_impl._removeHeaderElement(hdr, hdrElement);
        }
    }

    @Override
    public void setFaultCode(SOAPFault fault, SOAPFaultCode code, QName eccezioneName) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).setFaultCode(fault, code, eccezioneName);
        } else {
            AbstractOpenSPCoop2Message_saaj_impl._setFaultCode(fault, code, eccezioneName);
        }
    }

    @Override
    public void setFaultString(SOAPFault fault, String message) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).setFaultString(fault, message);
        } else {
            AbstractOpenSPCoop2Message_saaj_impl._setFaultString(fault, message);
        }
    }

    @Override
    public void setFaultString(SOAPFault fault, String message, Locale locale) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            ((AbstractOpenSPCoop2Message_saaj_impl)this.content).setFaultString(fault, message, locale);
        } else {
            AbstractOpenSPCoop2Message_saaj_impl._setFaultString(fault, message, locale);
        }
    }

    public boolean isSoapHeaderOptimizable() {
        OpenSPCoop2MessageSoapStreamReader soapReader = this.getSoapReader();
        return (!this.isContentBuilded() || !this.contentUpdatable) && soapReader != null && soapReader.isParsingComplete() && soapReader.isSoapHeaderOptimizable();
    }

    @Override
    public SOAPMessage getSOAPMessage() throws MessageException, MessageNotSupportedException {
        if (this.dynamicSOAPMessage == null && this.isSoapHeaderOptimizable()) {
            this.dynamicSOAPMessage = new DynamicSOAPMessage(this);
        }
        if (this.dynamicSOAPMessage != null) {
            return this.dynamicSOAPMessage;
        }
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).getSOAPMessage();
    }

    @Override
    public SOAPPart getSOAPPart() throws MessageException, MessageNotSupportedException {
        if (this.dynamicSOAPPart == null && this.isSoapHeaderOptimizable()) {
            this.dynamicSOAPPart = new DynamicSOAPPart(this);
        }
        if (this.dynamicSOAPPart != null) {
            return this.dynamicSOAPPart;
        }
        AbstractOpenSPCoop2Message_saaj_impl c = (AbstractOpenSPCoop2Message_saaj_impl)this.getContent();
        return c != null ? c.getSOAPPart() : null;
    }

    @Override
    public SOAPHeader getSOAPHeader() throws MessageException, MessageNotSupportedException {
        if (this.dynamicSOAPHeader == null && this.isSoapHeaderOptimizable()) {
            this.dynamicSOAPHeader = new DynamicSOAPHeader(this);
        }
        if (this.dynamicSOAPHeader != null) {
            return this.dynamicSOAPHeader;
        }
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).getSOAPHeader();
    }

    public void clearDynamicResources() {
        this.dynamicSOAPHeader = null;
        if (this.dynamicSOAPPart != null) {
            this.dynamicSOAPPart.clearDynamicResources();
        }
        this.dynamicSOAPPart = null;
        if (this.dynamicSOAPMessage != null) {
            this.dynamicSOAPMessage.clearDynamicResources();
        }
        this.dynamicSOAPMessage = null;
    }

    @Override
    public SOAPBody getSOAPBody() throws MessageException, MessageNotSupportedException {
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).getSOAPBody();
    }

    @Override
    protected SOAPBody _getSOAPBody_internalAnalyze() throws MessageException, MessageNotSupportedException {
        SOAPBody body = null;
        body = this.content != null && this.contentBuffer != null ? ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getSOAPBody() : this.getSOAPBody();
        return body;
    }

    @Override
    public boolean hasSOAPFault() throws MessageException, MessageNotSupportedException {
        OpenSPCoop2MessageSoapStreamReader soapReader = this.getSoapReader();
        if (!this.isContentBuilded() && soapReader != null && soapReader.isParsingComplete()) {
            return soapReader.isFault();
        }
        SOAPBody body = null;
        body = this.content != null && this.contentBuffer != null ? ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getSOAPBody() : this.getSOAPBody();
        return body != null && body.hasFault();
    }

    @Override
    public boolean isSOAPBodyEmpty() throws MessageException, MessageNotSupportedException {
        boolean hasContent;
        OpenSPCoop2MessageSoapStreamReader soapReader = this.getSoapReader();
        if (!this.isContentBuilded() && soapReader != null && soapReader.isParsingComplete()) {
            return soapReader.isEmpty();
        }
        SOAPBody body = null;
        body = this.content != null && this.contentBuffer != null ? ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getSOAPBody() : this.getSOAPBody();
        boolean bl = hasContent = body != null;
        if (hasContent) {
            hasContent = SoapUtils.getFirstNotEmptyChildNode(this.messageFactory, (Node)body, false) != null;
        }
        return !hasContent;
    }

    @Override
    public void addAttachmentPart(AttachmentPart attachmentPart) throws MessageException, MessageNotSupportedException {
        ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).addAttachmentPart(attachmentPart);
    }

    @Override
    public AttachmentPart createAttachmentPart(DataHandler dataHandler) throws MessageException, MessageNotSupportedException {
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).createAttachmentPart(dataHandler);
    }

    @Override
    public AttachmentPart createAttachmentPart() throws MessageException, MessageNotSupportedException {
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).createAttachmentPart();
    }

    @Override
    public boolean hasAttachments() throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).countAttachments() > 0;
        }
        String ct = this.getContentType();
        try {
            return ct != null && ContentTypeUtilities.isMultipartRelated((String)ct);
        }
        catch (Exception e) {
            throw new MessageException(e.getMessage(), e);
        }
    }

    @Override
    public int countAttachments() throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).countAttachments();
        }
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).countAttachments();
    }

    @Override
    public Iterator<?> getAttachments() throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getAttachments();
        }
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).getAttachments();
    }

    @Override
    public Iterator<?> getAttachments(MimeHeaders headers) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getAttachments(headers);
        }
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).getAttachments(headers);
    }

    @Override
    public AttachmentPart getAttachment(SOAPElement element) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getAttachment(element);
        }
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).getAttachment(element);
    }

    @Override
    public void removeAllAttachments() throws MessageException, MessageNotSupportedException {
        ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).removeAllAttachments();
    }

    @Override
    public void removeAttachments(MimeHeaders mhs) throws MessageException, MessageNotSupportedException {
        ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).removeAttachments(mhs);
    }

    @Override
    public void updateAttachmentPart(AttachmentPart ap, byte[] content, String contentType) throws MessageException, MessageNotSupportedException {
        ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).updateAttachmentPart(ap, content, contentType);
    }

    @Override
    public void updateAttachmentPart(AttachmentPart ap, String content, String contentType) throws MessageException, MessageNotSupportedException {
        ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).updateAttachmentPart(ap, content, contentType);
    }

    @Override
    public void updateAttachmentPart(AttachmentPart ap, DataHandler dh) throws MessageException, MessageNotSupportedException {
        ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).updateAttachmentPart(ap, dh);
    }

    @Override
    public List<Reference> getWSSDirtyElements(String actor, boolean mustUnderstand) throws MessageException, MessageNotSupportedException {
        if (this.isContentBuilded()) {
            return ((AbstractOpenSPCoop2Message_saaj_impl)this.content).getWSSDirtyElements(actor, mustUnderstand);
        }
        return ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).getWSSDirtyElements(actor, mustUnderstand);
    }

    @Override
    public void cleanWSSDirtyElements(String actor, boolean mustUnderstand, List<Reference> elementsToClean, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws MessageException, MessageNotSupportedException {
        ((AbstractOpenSPCoop2Message_saaj_impl)this.getContent()).cleanWSSDirtyElements(actor, mustUnderstand, elementsToClean, detachHeaderWSSecurity, removeAllIdRef);
    }

    @Override
    public List<MtomXomReference> mtomUnpackaging() throws MessageException, MessageNotSupportedException {
        return MTOMUtilities.unpackaging((OpenSPCoop2Message)this.getContent(), false, true);
    }

    @Override
    public List<MtomXomReference> mtomPackaging(List<MtomXomPackageInfo> packageInfos) throws MessageException, MessageNotSupportedException {
        return MTOMUtilities.packaging((OpenSPCoop2Message)this.getContent(), packageInfos, true);
    }

    @Override
    public List<MtomXomReference> mtomVerify(List<MtomXomPackageInfo> packageInfos) throws MessageException, MessageNotSupportedException {
        return MTOMUtilities.verify(this.isContentBuilded() ? (OpenSPCoop2Message)this.content : (OpenSPCoop2Message)this.getContent(), packageInfos, true);
    }

    @Override
    public List<MtomXomReference> mtomFastUnpackagingForXSDConformance() throws MessageException, MessageNotSupportedException {
        return MTOMUtilities.unpackaging((OpenSPCoop2Message)this.getContent(), true, true);
    }

    @Override
    public void mtomRestoreAfterXSDConformance(List<MtomXomReference> references) throws MessageException, MessageNotSupportedException {
        MTOMUtilities.restoreAfterFastUnpackaging((OpenSPCoop2Message)this.getContent(), references, true);
    }
}

