/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap;

import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.ParseException;
import jakarta.xml.soap.Detail;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import jakarta.xml.soap.Text;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.exception.MessageNotSupportedException;
import org.openspcoop2.message.exception.ParseExceptionUtils;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_soap_impl;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.message.utils.MessageUtilities;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.NameValue;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.openspcoop2.utils.xml.PrettyPrintXMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SoapUtils {
    private static Locale soapFaultStringLocale = null;

    public static MessageException buildMessageException(String prefix, Throwable t) {
        Throwable tExists;
        Throwable tExists2;
        MessageException meSAXParser = null;
        String msgSAXParser = null;
        if (Utilities.existsInnerInstanceException((Throwable)t, SAXParseException.class) && (tExists2 = Utilities.getInnerInstanceException((Throwable)t, SAXParseException.class, (boolean)false)) != null) {
            msgSAXParser = tExists2.getMessage();
            meSAXParser = new MessageException(prefix + tExists2.getMessage(), t);
        }
        if (msgSAXParser != null && Utilities.existsInnerInstanceException((Throwable)t, TransformerException.class) && (tExists2 = Utilities.getInnerInstanceException((Throwable)t, TransformerException.class, (boolean)false)) != null && tExists2.getMessage() != null && tExists2.getMessage().contains(msgSAXParser)) {
            return new MessageException(prefix + tExists2.getMessage(), t);
        }
        if (meSAXParser != null) {
            return meSAXParser;
        }
        MessageException meSAXException = null;
        String msgSAXException = null;
        if (Utilities.existsInnerInstanceException((Throwable)t, SAXException.class) && (tExists = Utilities.getInnerInstanceException((Throwable)t, SAXException.class, (boolean)false)) != null) {
            msgSAXException = tExists.getMessage();
            meSAXException = new MessageException(prefix + tExists.getMessage(), t);
        }
        if (msgSAXException != null && Utilities.existsInnerInstanceException((Throwable)t, TransformerException.class) && (tExists = Utilities.getInnerInstanceException((Throwable)t, TransformerException.class, (boolean)false)) != null && tExists.getMessage() != null && tExists.getMessage().contains(msgSAXException)) {
            return new MessageException(prefix + tExists.getMessage(), t);
        }
        if (meSAXException != null) {
            return meSAXException;
        }
        return new MessageException(t.getMessage(), t);
    }

    public static SOAPFactory getSoapFactory(OpenSPCoop2MessageFactory messageFactory, MessageType messageType) throws MessageNotSupportedException {
        if (MessageType.SOAP_11.equals(messageType)) {
            return messageFactory.getSoapFactory11();
        }
        if (MessageType.SOAP_12.equals(messageType)) {
            return messageFactory.getSoapFactory12();
        }
        throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
    }

    public static MessageFactory getMessageFactory(OpenSPCoop2MessageFactory messageFactory) throws SOAPException {
        return messageFactory.getSoapMessageFactory();
    }

    public static void setSoapFaultStringLocale(Locale soapFaultStringLocale) {
        SoapUtils.soapFaultStringLocale = soapFaultStringLocale;
    }

    public static void setFaultString(SOAPFault fault, String faultString) throws SOAPException {
        SoapUtils.setFaultString(fault, faultString, null);
    }

    public static void setFaultString(SOAPFault fault, String faultString, Locale lParam) throws SOAPException {
        if (lParam != null) {
            fault.setFaultString(faultString, lParam);
        } else if (soapFaultStringLocale != null) {
            fault.setFaultString(faultString, soapFaultStringLocale);
        } else {
            fault.setFaultString(faultString);
        }
    }

    public static SOAPElement getFirstSOAPElement(SOAPElement element) {
        if (element != null) {
            Iterator it = element.getChildElements();
            while (it.hasNext()) {
                Node tmp = (Node)it.next();
                if (!(tmp instanceof SOAPElement)) continue;
                return (SOAPElement)tmp;
            }
        }
        return null;
    }

    public static String getContentType(SOAPMessage msg) {
        if (msg.getMimeHeaders() == null) {
            return null;
        }
        String[] values = msg.getMimeHeaders().getHeader("Content-Type");
        if (values == null || values.length <= 0) {
            return SoapUtils.getContentType(msg.getMimeHeaders());
        }
        return values[0];
    }

    public static String getContentType(MimeHeaders mhs) {
        Iterator itMhs;
        if (mhs != null && (itMhs = mhs.getAllHeaders()) != null) {
            while (itMhs.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)itMhs.next();
                if (mimeHeader == null || mimeHeader.getName() == null || !"Content-Type".toLowerCase().equals(mimeHeader.getName().toLowerCase())) continue;
                return mimeHeader.getValue();
            }
        }
        return null;
    }

    public static String getSoapAction(TransportRequestContext transportRequestContext, MessageType messageType, String contentType) throws MessageException, MessageNotSupportedException {
        if (MessageType.SOAP_11.equals(messageType)) {
            if (transportRequestContext.getHeaders() == null || transportRequestContext.getHeaders().size() <= 0) {
                throw new MessageException("Header http 'SOAPAction' non valorizzato (nessun header di trasporto trovato)");
            }
            for (String nomeProperty : transportRequestContext.getHeaders().keySet()) {
                if (!"SOAPAction".equalsIgnoreCase(nomeProperty)) continue;
                String soapAction = transportRequestContext.getHeaderFirstValue(nomeProperty);
                if (soapAction == null) {
                    throw new MessageException("Header http 'SOAPAction' non valorizzato (null)");
                }
                if ((soapAction = soapAction.trim()).startsWith("\"") && !soapAction.endsWith("\"")) {
                    throw new MessageException("Header http 'SOAPAction' non valorizzato correttamente (action quotata? Non \u00e8 stato trovato il carattere di chiusura \" ma \u00e8 presente quello di apertura)");
                }
                if (soapAction.endsWith("\"") && !soapAction.startsWith("\"")) {
                    throw new MessageException("Header http 'SOAPAction' non valorizzato correttamente (action quotata? Non \u00e8 stato trovato il carattere di apertura \" ma \u00e8 presente quello di chiusura)");
                }
                return soapAction;
            }
            throw new MessageException("Header http 'SOAPAction' non presente");
        }
        if (MessageType.SOAP_12.equals(messageType)) {
            ContentType ct = null;
            try {
                ct = new ContentType(contentType);
            }
            catch (Exception e) {
                throw new MessageException("Content-Type '" + contentType + "' non valorizzato correttamente: " + e.getMessage(), e);
            }
            if (ct.getParameterList() != null && ct.getParameterList().size() > 0) {
                Enumeration names = ct.getParameterList().getNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    if (!"action".equals(name)) continue;
                    return ct.getParameterList().get(name);
                }
            }
            return null;
        }
        throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
    }

    public static void checkSoapActionQuotedString(String soapAction, MessageType messageType) throws MessageException, MessageNotSupportedException {
        if (MessageType.SOAP_11.equals(messageType)) {
            if (!soapAction.startsWith("\"") || !soapAction.endsWith("\"")) {
                throw new MessageException("Header http 'SOAPAction' valorizzato tramite una stringa non quotata (WSI-BP-1.1 R1109)");
            }
        } else {
            throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
        }
    }

    public static String getSoapActor(SOAPHeaderElement headerElement, MessageType messageType) throws MessageNotSupportedException {
        if (MessageType.SOAP_11.equals(messageType)) {
            return headerElement.getActor();
        }
        if (MessageType.SOAP_12.equals(messageType)) {
            return headerElement.getRole();
        }
        throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
    }

    public static boolean checkMustUnderstandHeaderElement(MessageType messageType, SOAPHeader header, List<NameValue> filtri, StringBuilder bfErrorParam) throws MessageException {
        StringBuilder bfError = new StringBuilder();
        try {
            Iterator headers = header.getChildElements();
            while (headers.hasNext()) {
                SOAPHeaderElement elementHeader;
                String actor;
                Object element = headers.next();
                if (!(element instanceof SOAPHeaderElement) || (actor = SoapUtils.getSoapActor(elementHeader = (SOAPHeaderElement)element, messageType)) != null || !elementHeader.getMustUnderstand()) continue;
                boolean checked = false;
                if (filtri != null && filtri.size() > 0) {
                    for (NameValue nameValue : filtri) {
                        String localName = nameValue.getName();
                        String namespaceURI = nameValue.getValue();
                        if (!localName.equals(elementHeader.getLocalName()) || !namespaceURI.equals(elementHeader.getNamespaceURI())) continue;
                        checked = true;
                        break;
                    }
                }
                if (checked) continue;
                if (bfError.length() > 0) {
                    bfError.append(", ");
                }
                bfError.append("{").append(elementHeader.getNamespaceURI()).append("}").append(elementHeader.getLocalName());
            }
        }
        catch (Exception e) {
            Throwable t = ParseExceptionUtils.getParseException(e);
            if (t != null) {
                throw new MessageException(e);
            }
            throw new MessageException("Riscontrato errore durante l'applicazione del bypassMustUnderstandHeader: " + e.getMessage(), e);
        }
        if (bfError.length() > 0) {
            bfErrorParam.append(bfError.toString());
        }
        return bfError.length() <= 0;
    }

    public static void addSWAStartParameterIfNotPresent(OpenSPCoop2Message message) throws MessageException {
        SoapUtils.addSWAStartParameterIfNotPresent(message, false, false);
    }

    public static void addSWAStartParameterIfNotPresent(OpenSPCoop2Message message, boolean addOnlyIfExistsContentIdRootPart) throws MessageException {
        SoapUtils.addSWAStartParameterIfNotPresent(message, addOnlyIfExistsContentIdRootPart, false);
    }

    public static void addSWAStartParameterIfNotPresent(OpenSPCoop2Message message, boolean addOnlyIfExistsContentIdRootPart, boolean forceAddStartParameter) throws MessageException {
        if (message != null && ServiceBinding.SOAP.equals(message.getServiceBinding())) {
            try {
                OpenSPCoop2SoapMessage soapMsg = message.castAsSoap();
                if (!soapMsg.hasAttachments()) {
                    return;
                }
                SOAPPart part = soapMsg.getSOAPPart();
                if (part == null) {
                    throw new MessageException("SOAPPart is null?");
                }
                String[] idOld = part.getMimeHeader("Content-ID");
                String id = null;
                if (idOld != null && idOld.length > 0) {
                    id = idOld[0];
                }
                SoapUtils.addSWAStartParameterIfNotPresentEngine(soapMsg, part, addOnlyIfExistsContentIdRootPart, forceAddStartParameter, id);
            }
            catch (Exception t) {
                throw new MessageException(t.getMessage(), t);
            }
        }
    }

    private static void addSWAStartParameterIfNotPresentEngine(OpenSPCoop2SoapMessage soapMsg, SOAPPart part, boolean addOnlyIfExistsContentIdRootPart, boolean forceAddStartParameter, String id) throws MessageException, MessageNotSupportedException, ParseException {
        String cType;
        ContentType contentType;
        String startParam;
        if (id == null) {
            if (addOnlyIfExistsContentIdRootPart) {
                return;
            }
            id = soapMsg.createContentID("http://govway.org");
            part.addMimeHeader("Content-Id", id);
        }
        if ((startParam = (contentType = new ContentType(cType = soapMsg.getContentType())).getParameter("start")) == null || forceAddStartParameter) {
            soapMsg.addContentTypeParameter("start", id);
        }
    }

    public static List<Node> getNotEmptyChildNodes(OpenSPCoop2MessageFactory messageFactory, Node e) {
        return SoapUtils.getNotEmptyChildNodes(messageFactory, e, true);
    }

    public static List<Node> getNotEmptyChildNodes(OpenSPCoop2MessageFactory messageFactory, Node e, boolean consideraTextNotEmptyAsNode) {
        return MessageXMLUtils.getInstance(messageFactory).getNotEmptyChildNodes(e, consideraTextNotEmptyAsNode);
    }

    public static Node getFirstNotEmptyChildNode(OpenSPCoop2MessageFactory messageFactory, Node e) {
        return SoapUtils.getFirstNotEmptyChildNode(messageFactory, e, true);
    }

    public static Node getFirstNotEmptyChildNode(OpenSPCoop2MessageFactory messageFactory, Node e, boolean consideraTextNotEmptyAsNode) {
        return MessageXMLUtils.getInstance(messageFactory).getFirstNotEmptyChildNode(e, consideraTextNotEmptyAsNode);
    }

    public static List<SOAPElement> getNotEmptyChildSOAPElement(SOAPElement e) {
        ArrayList<SOAPElement> vec = new ArrayList<SOAPElement>();
        Iterator soapElements = e.getChildElements();
        while (soapElements.hasNext()) {
            Object soapElement = soapElements.next();
            if (!(soapElement instanceof SOAPElement)) continue;
            vec.add((SOAPElement)soapElement);
        }
        return vec;
    }

    public static SOAPElement getNotEmptyFirstChildSOAPElement(SOAPElement e) {
        Iterator soapElements = e.getChildElements();
        while (soapElements.hasNext()) {
            Object soapElement = soapElements.next();
            if (!(soapElement instanceof SOAPElement)) continue;
            return (SOAPElement)soapElement;
        }
        return null;
    }

    public static String getSoapEnvelopeNS(MessageType messageType) throws MessageNotSupportedException {
        if (MessageType.SOAP_11.equals(messageType)) {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if (MessageType.SOAP_12.equals(messageType)) {
            return "http://www.w3.org/2003/05/soap-envelope";
        }
        throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
    }

    public static String getSoapContentTypeForMessageWithoutAttachments(MessageType messageType) throws MessageNotSupportedException {
        if (MessageType.SOAP_11.equals(messageType) || MessageType.SOAP_12.equals(messageType)) {
            return MessageUtilities.getDefaultContentType(messageType);
        }
        throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
    }

    public static MessageType getSOAPVersion(Logger log, byte[] xml) {
        String s = new String(xml);
        if (s.contains("<Envelope") || s.contains(":Envelope")) {
            int indexOfSoap11 = s.indexOf("http://schemas.xmlsoap.org/soap/envelope/");
            int indexOfSoap12 = s.indexOf("http://www.w3.org/2003/05/soap-envelope");
            if (indexOfSoap11 > 0 && indexOfSoap12 > 0) {
                if (indexOfSoap11 < indexOfSoap12) {
                    return MessageType.SOAP_11;
                }
                return MessageType.SOAP_12;
            }
            if (indexOfSoap11 > 0) {
                return MessageType.SOAP_11;
            }
            if (indexOfSoap12 > 0) {
                return MessageType.SOAP_12;
            }
        }
        return null;
    }

    public static boolean checkSOAPEnvelopeNamespace(OpenSPCoop2SoapMessage message, MessageType messageType) throws MessageException, MessageNotSupportedException {
        try {
            boolean hasContent;
            SOAPEnvelope envelope;
            SOAPPart soapPart;
            OpenSPCoop2MessageSoapStreamReader reader = message.getSoapReader();
            String envelopeNamespace = null;
            if (reader != null) {
                envelopeNamespace = reader.getNamespace();
            }
            if (envelopeNamespace == null && (soapPart = message.getSOAPPart()) != null && (envelope = soapPart.getEnvelope()) != null) {
                envelopeNamespace = envelope.getNamespaceURI();
            }
            if (envelopeNamespace == null && message instanceof AbstractOpenSPCoop2Message_soap_impl && !(hasContent = ((AbstractOpenSPCoop2Message_soap_impl)message).hasContent())) {
                throw new MessageException("Invalid empty message");
            }
            if (messageType.equals(MessageType.SOAP_11) && "http://schemas.xmlsoap.org/soap/envelope/".equals(envelopeNamespace)) {
                return true;
            }
            return messageType.equals(MessageType.SOAP_12) && "http://www.w3.org/2003/05/soap-envelope".equals(envelopeNamespace);
        }
        catch (Exception ex) {
            Throwable t = ParseExceptionUtils.getParseException(ex);
            if (t != null) {
                throw new MessageException(ex);
            }
            throw new MessageException(ex.getMessage(), ex);
        }
    }

    public static boolean matchLocalName(OpenSPCoop2MessageFactory messageFactory, Node nodo, String nodeName, String prefix, String namespace) {
        return MessageXMLUtils.getInstance(messageFactory).matchLocalName(nodo, nodeName, prefix, namespace);
    }

    public static Node getAttributeNode(OpenSPCoop2MessageFactory messageFactory, Node node, String attributeName) {
        return MessageXMLUtils.getInstance(messageFactory).getAttributeNode(node, attributeName);
    }

    public static Node getQualifiedAttributeNode(OpenSPCoop2MessageFactory messageFactory, Node node, String attributeName, String namespace) {
        return MessageXMLUtils.getInstance(messageFactory).getQualifiedAttributeNode(node, attributeName, namespace);
    }

    public static void equalsSoapElements(SOAPElement element1, SOAPElement element2, boolean checkTextComment) throws MessageException {
        try {
            SoapUtils._equalsSoapElements(element1, element2, new ArrayList<String>(), checkTextComment);
        }
        catch (Exception e) {
            try {
                String soapReq = PrettyPrintXMLUtils.prettyPrintWithTrAX((Element)element1);
                String soapRes = PrettyPrintXMLUtils.prettyPrintWithTrAX((Element)element2);
                throw new MessageException("Element1 [" + soapReq + "] risulta differente da Element2 [" + soapRes + "] (motivo:" + e.getMessage() + ")", e);
            }
            catch (Exception eInternal) {
                throw new MessageException(eInternal.getMessage(), eInternal);
            }
        }
    }

    private static String _getQualifiedName(QName attr) {
        if (attr.getNamespaceURI() != null) {
            return "{" + attr.getNamespaceURI() + " }" + attr.getLocalPart();
        }
        return attr.getLocalPart();
    }

    private static void _equalsSoapElements(SOAPElement el1, SOAPElement el2, List<String> namespacePrefixEl1, boolean checkTextComment) throws MessageException {
        if (!el1.getNodeName().equals(el2.getNodeName())) {
            throw new MessageException("Node1 possiede un nome [" + el1.getNodeName() + "] differente dal nome del Node2 [" + el2.getNodeName() + "]");
        }
        Iterator it = el1.getAllAttributesAsQNames();
        Iterator it2 = el2.getAllAttributesAsQNames();
        ArrayList<String> vet = new ArrayList<String>();
        ArrayList<String> vet2 = new ArrayList<String>();
        while (it.hasNext()) {
            if (!it2.hasNext()) {
                throw new MessageException("Node1 [" + el1.getNodeName() + "] possiede degli attributi, mentre nel node2 [" + el2.getNodeName() + "] non ve ne sono");
            }
            QName attr1 = (QName)it.next();
            vet.add(SoapUtils._getQualifiedName(attr1));
            QName attr2 = (QName)it2.next();
            vet2.add(SoapUtils._getQualifiedName(attr2));
        }
        if (it2.hasNext()) {
            throw new MessageException("Node2 [" + el2.getNodeName() + "] possiede piu' attributi del Node1 [" + el1.getNodeName() + "]");
        }
        if (!vet.containsAll(vet2)) {
            StringBuilder bfNode1 = new StringBuilder();
            for (int i = 0; i < vet.size(); ++i) {
                if (i > 0) {
                    bfNode1.append(",");
                }
                bfNode1.append((String)vet.get(i));
            }
            StringBuilder bfNode2 = new StringBuilder();
            for (int i = 0; i < vet2.size(); ++i) {
                if (i > 0) {
                    bfNode2.append(",");
                }
                bfNode2.append((String)vet2.get(i));
            }
            throw new MessageException("Node1 [" + el1.getNodeName() + "] e Node2 [" + el2.getNodeName() + "] non hanno gli stessi attributi. Attributi(" + vet.size() + ") di Node1: " + String.valueOf(bfNode1) + " . Attributi(" + vet2.size() + ") di Node2: " + String.valueOf(bfNode2));
        }
        for (int i = 0; i < vet.size(); ++i) {
            String value = (String)vet.get(i);
            if (el1.getAttribute(value).equals(el2.getAttribute(value))) continue;
            throw new MessageException("L'attributo [" + value + "] di Node1 [" + el1.getNodeName() + "] possiede un valore (" + el1.getAttribute(value) + ") differente dal valore presente nello stesso attributo nel Node2 [" + el2.getNodeName() + "] (valore:" + el2.getAttribute(value) + ")");
        }
        String str1 = el1.getNamespaceURI();
        String str2 = el2.getNamespaceURI();
        boolean namespaceIdentico = false;
        if (str1 != null && str2 != null) {
            namespaceIdentico = str1.equals(str2);
        } else if (str1 == null && str2 == null) {
            namespaceIdentico = true;
        }
        if (!namespaceIdentico) {
            throw new MessageException("Node1 [" + el1.getNodeName() + "] possiede un namespace [" + str1 + "] differente dal namespace del Node2 [" + el2.getNodeName() + "] (namespace:" + str2 + ")");
        }
        Iterator nameSp1 = el1.getNamespacePrefixes();
        Iterator nameSp2 = el2.getNamespacePrefixes();
        ArrayList<CallSite> nameSpVet1 = new ArrayList<CallSite>();
        ArrayList<CallSite> nameSpVet2 = new ArrayList<CallSite>();
        while (nameSp1.hasNext() && nameSp2.hasNext()) {
            String urlPrefix2;
            String urlPrefix1;
            String prefix1 = (String)nameSp1.next();
            try {
                urlPrefix1 = el1.getNamespaceURI(prefix1);
            }
            catch (Exception e) {
                urlPrefix1 = el1.getNamespaceURI();
            }
            nameSpVet1.add((CallSite)((Object)(prefix1 + "=" + urlPrefix1)));
            if (!namespacePrefixEl1.contains(prefix1 + "=" + urlPrefix1)) {
                namespacePrefixEl1.add(prefix1 + "=" + urlPrefix1);
            }
            String prefix2 = (String)nameSp2.next();
            try {
                urlPrefix2 = el2.getNamespaceURI(prefix2);
            }
            catch (Exception e) {
                urlPrefix2 = el2.getNamespaceURI();
            }
            nameSpVet2.add((CallSite)((Object)(prefix2 + "=" + urlPrefix2)));
        }
        for (int i = 0; i < nameSpVet1.size(); ++i) {
            String n1 = (String)nameSpVet1.get(i);
            boolean trovato = false;
            for (int j = 0; j < nameSpVet2.size(); ++j) {
                String n2 = (String)nameSpVet2.get(j);
                if (!n1.equals(n2)) continue;
                trovato = true;
                break;
            }
            if (trovato || namespacePrefixEl1.contains(n1)) continue;
            throw new MessageException("Node1 [" + el1.getNodeName() + "] non contiene il prefix: " + n1);
        }
        if (nameSpVet1.size() != nameSpVet2.size()) {
            StringBuilder bfNode1 = new StringBuilder();
            for (int i = 0; i < nameSpVet1.size(); ++i) {
                if (i > 0) {
                    bfNode1.append(",");
                }
                bfNode1.append((String)nameSpVet1.get(i));
            }
            StringBuilder bfNode2 = new StringBuilder();
            for (int i = 0; i < nameSpVet2.size(); ++i) {
                if (i > 0) {
                    bfNode2.append(",");
                }
                bfNode2.append((String)nameSpVet2.get(i));
            }
            throw new MessageException("Node1 [" + el1.getNodeName() + "] e Node2 [" + el2.getNodeName() + "] non hanno gli stessi prefix. Attributi(" + nameSpVet1.size() + ") di Node1: " + String.valueOf(bfNode1) + " . Attributi(" + nameSpVet2.size() + ") di Node2: " + String.valueOf(bfNode2));
        }
        Iterator child = el1.getChildElements();
        Iterator child2 = el2.getChildElements();
        while (child.hasNext()) {
            if (checkTextComment && !child2.hasNext()) {
                throw new MessageException("Node2 [" + el2.getNodeName() + "] non ha child element, mentre il Node1 [" + el1.getNodeName() + "] ne possiede");
            }
            Object obj = null;
            if (child.hasNext()) {
                obj = child.next();
            }
            Object obj2 = null;
            if (child2.hasNext()) {
                obj2 = child2.next();
            }
            if (!checkTextComment) {
                while (obj != null && obj instanceof Text) {
                    if (child.hasNext()) {
                        obj = child.next();
                        continue;
                    }
                    obj = null;
                }
                while (obj2 != null && obj2 instanceof Text) {
                    if (child2.hasNext()) {
                        obj2 = child2.next();
                        continue;
                    }
                    obj2 = null;
                }
                if (obj == null) {
                    if (obj2 == null) break;
                    throw new MessageException("Node2 [" + el2.getNodeName() + "] possiede ulteriori child element (" + ((SOAPElement)obj2).getNodeName() + ") non presenti nel Node1 [" + el1.getNodeName() + "]");
                }
                if (obj2 == null) {
                    throw new MessageException("Node1 [" + el1.getNodeName() + "] possiede ulteriori child element (" + ((SOAPElement)obj).getNodeName() + ") non presenti nel Node2 [" + el2.getNodeName() + "]");
                }
            }
            if (obj instanceof Text) {
                Text text = obj;
                if (!(obj2 instanceof Text)) {
                    throw new MessageException("Node2 [" + el2.getNodeName() + "] non possiede l'element Text presente nel Node1 [" + el1.getNodeName() + "] (valore: " + text.toString() + ")");
                }
                Text text2 = obj2;
                boolean value = text.toString().equals(text2.toString());
                if (value) continue;
                throw new MessageException("Node2 [" + el2.getNodeName() + "] possiede un element Text con valore (" + text2.toString() + ") differente da quello presente nel Node1 [" + el1.getNodeName() + "] (valore:" + text.toString() + ")");
            }
            if (obj2 instanceof Text) {
                throw new MessageException("Node2 [" + el2.getNodeName() + "] possiede un element Text (" + ((Text)obj2).toString() + ") non presente nel Node1 [" + el1.getNodeName() + "]");
            }
            List namespacePrefixEl1Parent = (List)((ArrayList)namespacePrefixEl1).clone();
            SoapUtils._equalsSoapElements(obj, obj2, namespacePrefixEl1Parent, checkTextComment);
        }
    }

    public static String toString(OpenSPCoop2MessageFactory messageFactory, SOAPFault fault) throws MessageException {
        return SoapUtils.toString(messageFactory, fault, true);
    }

    public static String toString(OpenSPCoop2MessageFactory messageFactory, SOAPFault fault, boolean printDetails) throws MessageException {
        return SoapUtils._toString(messageFactory, fault, true, true, null);
    }

    public static String safe_toString(OpenSPCoop2MessageFactory messageFactory, SOAPFault fault, Logger log) throws MessageException {
        return SoapUtils.safe_toString(messageFactory, fault, false, log);
    }

    public static String safe_toString(OpenSPCoop2MessageFactory messageFactory, SOAPFault fault, boolean printDetails, Logger log) throws MessageException {
        return SoapUtils._toString(messageFactory, fault, true, false, log);
    }

    public static String _toString(OpenSPCoop2MessageFactory messageFactory, SOAPFault fault, boolean printDetails, boolean throwsException, Logger log) throws MessageException {
        try {
            if (printDetails) {
                if (fault != null) {
                    return OpenSPCoop2MessageFactory.getAsString(messageFactory, (Node)fault, true);
                }
                return "SOAPFault non presente";
            }
            StringBuilder bf = new StringBuilder();
            if (fault != null) {
                bf.append("SOAPFault");
                try {
                    if (fault.getFaultCode() != null && !"".equals(fault.getFaultCode())) {
                        bf.append(" faultCode[" + fault.getFaultCode() + "]");
                    }
                }
                catch (Throwable e) {
                    if (throwsException) {
                        throw e;
                    }
                    bf.append(" faultCode[unparsable: " + e.getMessage() + "]");
                }
                try {
                    if (fault.getFaultActor() != null && !"".equals(fault.getFaultActor())) {
                        bf.append(" faultActor[" + fault.getFaultActor() + "]");
                    }
                }
                catch (Throwable e) {
                    if (throwsException) {
                        throw e;
                    }
                    bf.append(" faultActor[unparsable: " + e.getMessage() + "]");
                }
                try {
                    if (fault.getFaultString() != null && !"".equals(fault.getFaultString())) {
                        bf.append(" faultString[" + fault.getFaultString() + "]");
                    }
                }
                catch (Throwable e) {
                    if (throwsException) {
                        throw e;
                    }
                    bf.append(" faultString[unparsable: " + e.getMessage() + "]");
                }
            } else {
                return "SOAPFault non presente";
            }
            return bf.toString();
        }
        catch (Throwable e) {
            if (throwsException) {
                throw new MessageException("toString SOAPFault: " + e.getMessage(), e);
            }
            if (log != null) {
                log.error("Unparsable SOAPFault: " + e.getMessage(), e);
            }
            return "Unparsable SOAPFault: " + e.getMessage();
        }
    }

    public static byte[] build_Soap_Fault(OpenSPCoop2MessageFactory messageFactory, MessageType messageType, String aFault, String aActor, QName aCode, Element dettaglioEccezione, boolean generaDetails) throws MessageException, MessageNotSupportedException {
        if (!MessageType.SOAP_11.equals(messageType) && !MessageType.SOAP_12.equals(messageType)) {
            throw MessageNotSupportedException.newMessageNotSupportedException(messageType);
        }
        ByteArrayOutputStream byteMessaggio = null;
        try {
            OpenSPCoop2Message msg = messageFactory.createEmptyMessage(messageType, MessageRole.FAULT);
            OpenSPCoop2SoapMessage soapMsg = msg.castAsSoap();
            SOAPEnvelope env = soapMsg.getSOAPPart().getEnvelope();
            SOAPBody bdy = env.getBody();
            bdy.addFault();
            SOAPFault fault = bdy.getFault();
            if (aFault != null) {
                fault.setFaultString(aFault);
            } else {
                fault.setFaultString("");
            }
            if (aCode != null) {
                fault.setFaultCode(aCode);
            }
            if (aActor != null) {
                fault.setFaultActor(aActor);
            }
            if (generaDetails && dettaglioEccezione != null) {
                fault.addDetail();
                Detail d = fault.getDetail();
                d.appendChild(d.getOwnerDocument().importNode(dettaglioEccezione, true));
            }
            byteMessaggio = new ByteArrayOutputStream();
            msg.writeTo(byteMessaggio, true);
            byte[] risultato = byteMessaggio.toByteArray();
            byteMessaggio.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (byteMessaggio != null) {
                    byteMessaggio.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MessageException("Creazione MsgSOAPFault non riuscito: " + e.getMessage(), e);
        }
    }
}

