/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap.reader;

import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.exception.MessageException;
import org.openspcoop2.message.soap.AbstractOpenSPCoop2Message_saaj_impl;
import org.openspcoop2.message.soap.OpenSPCoop2Message_saaj_11_impl;
import org.openspcoop2.message.soap.OpenSPCoop2Message_saaj_12_impl;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.soap.reader.RootElementSaxContentHandler;
import org.openspcoop2.message.soap.reader.SoapEnvelopeSaxContentHandler;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.transport.http.ContentTypeUtilities;
import org.openspcoop2.utils.xml.TransformerConfig;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class OpenSPCoop2MessageSoapStreamReader {
    public static boolean SOAP_HEADER_OPTIMIZATION_ENABLED = true;
    private OpenSPCoop2MessageFactory msgFactory;
    private InputStream is;
    private String contentType;
    private int bufferThresholdKb;
    private String envelope;
    private String prefixEnvelope = null;
    private String namespace;
    private String header;
    private String prefixHeader = null;
    private OpenSPCoop2Message _headerMsgCompleto;
    private boolean soapHeaderModified = false;
    private boolean soapHeaderOptimizable = false;
    private long startHeaderOffset;
    private long endHeaderOffset;
    private long startBodyOffset;
    private String isCharset;
    private String body;
    private boolean bodyEmpty;
    private String rootElementNamespace;
    private String rootElementLocalName;
    private String rootElementPrefix;
    private String fault;
    private int bufferSize;
    private boolean parsingComplete = false;
    private MessageException tBuffered = null;
    private InputStream bufferedInputStream = null;
    private MessageException parseErrorHeader = null;
    private static ThreadLocal<SAXParser> saxParserThreadLocal = new ThreadLocal<SAXParser>(){

        @Override
        protected SAXParser initialValue() {
            try {
                SAXParserFactory saxFactory = XMLUtils.getInstance().getSAXParserFactory();
                saxFactory.setNamespaceAware(true);
                SAXParser parser = saxFactory.newSAXParser();
                return parser;
            }
            catch (Throwable t) {
                throw new RuntimeException("Inizializzazione SAXParser fallita: " + t.getMessage(), t);
            }
        }
    };

    public OpenSPCoop2MessageSoapStreamReader(OpenSPCoop2MessageFactory msgFactory, String contentType, InputStream is, int bufferThresholdKb) {
        this.msgFactory = msgFactory;
        this.contentType = contentType;
        this.is = is;
        this.bufferThresholdKb = bufferThresholdKb;
    }

    public void checkException() throws MessageException {
        if (this.tBuffered != null) {
            throw this.tBuffered;
        }
    }

    public InputStream getBufferedInputStream() {
        return this.bufferedInputStream;
    }

    public void releaseBufferedInputStream() {
        this.bufferedInputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws MessageException {
        this.bufferedInputStream = this.is;
        if (this.tBuffered != null) {
            throw this.tBuffered;
        }
        if (this.contentType == null || StringUtils.isEmpty((CharSequence)this.contentType) || this.is == null) {
            return;
        }
        boolean multipart = false;
        try {
            multipart = ContentTypeUtilities.isMultipartType((String)this.contentType);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String charset = null;
        try {
            if (!multipart) {
                this.isCharset = charset = ContentTypeUtilities.readCharsetFromContentType((String)this.contentType);
                if (Charset.UTF_8.getValue().equalsIgnoreCase(charset)) {
                    charset = null;
                }
            } else {
                String internalCT = ContentTypeUtilities.getInternalMultipartContentType((String)this.contentType);
                this.isCharset = ContentTypeUtilities.readCharsetFromContentType((String)internalCT);
            }
        }
        catch (Throwable internalCT) {
            // empty catch block
        }
        try {
            ByteArrayOutputStream bufferReaded = new ByteArrayOutputStream();
            int lettiBuffer = 0;
            StringBuilder sbActual = null;
            long sbActualOffsetStart = -1L;
            byte[] bufferRaw = new byte[1024];
            long bLetti = 0L;
            int letturaPrecedente = 0;
            int kbLetti = 0;
            boolean envelopeFound = false;
            StringBuilder headerBuilder = null;
            Object headerClosure = null;
            boolean headerCompletato = false;
            boolean bodyFound = false;
            Object prefixBody = null;
            StringBuilder elementAfterBodyBuilder = null;
            boolean cdataFound = false;
            boolean commentFound = false;
            boolean analisiTerminata = false;
            while ((lettiBuffer = this.is.read(bufferRaw)) != -1) {
                bufferReaded.write(bufferRaw, 0, lettiBuffer);
                ++kbLetti;
                if (letturaPrecedente > 0) {
                    bLetti += (long)letturaPrecedente;
                }
                letturaPrecedente = lettiBuffer;
                String bufferString = null;
                if (charset != null) {
                    ByteArrayOutputStream bufferTmp = new ByteArrayOutputStream();
                    bufferTmp.write(bufferRaw, 0, lettiBuffer);
                    bufferTmp.flush();
                    bufferTmp.close();
                    bufferString = new String(bufferTmp.toByteArray(), charset);
                    lettiBuffer = bufferString.length();
                }
                for (int i = 0; i < lettiBuffer; ++i) {
                    String sPrefix;
                    char c;
                    char c2 = c = bufferString != null ? bufferString.charAt(i) : (char)bufferRaw[i];
                    if (headerCompletato && this.endHeaderOffset <= 0L) {
                        this.endHeaderOffset = sbActualOffsetStart;
                    }
                    if (!(c != '<' && !this.startsWithLessThan(sbActual) || cdataFound || commentFound)) {
                        if (sbActual != null) {
                            if (sbActual.length() > 0) {
                                String sPreClosure = sbActual.toString();
                                sbActual.setLength(0);
                                sbActualOffsetStart = (long)i + bLetti;
                                if (sPreClosure.startsWith("<![CDATA[")) {
                                    cdataFound = true;
                                } else if (sPreClosure.startsWith("<!--") && !sPreClosure.endsWith("-->")) {
                                    commentFound = true;
                                }
                                if (headerClosure != null) {
                                    headerBuilder.append(sPreClosure);
                                } else if (bodyFound && !sPreClosure.startsWith("<![CDATA[") && !sPreClosure.startsWith("<!--")) {
                                    if (elementAfterBodyBuilder != null) {
                                        elementAfterBodyBuilder.append(sPreClosure);
                                    } else {
                                        elementAfterBodyBuilder = new StringBuilder(sPreClosure);
                                    }
                                }
                            }
                        } else {
                            sbActual = new StringBuilder();
                            sbActualOffsetStart = (long)i + bLetti;
                        }
                    }
                    if (sbActual != null) {
                        sbActual.append(c);
                    }
                    if (c != '>' && !this.endsWithGreaterThan(sbActual)) continue;
                    if (sbActual == null) {
                        if (multipart) continue;
                        throw new Exception("Invalid content; found premature '>' character (" + bufferReaded.toString() + ")");
                    }
                    String s = sbActual.toString();
                    if (cdataFound) {
                        if (headerClosure != null) {
                            headerBuilder.append(sbActual.toString());
                        }
                        sbActual.setLength(0);
                        sbActualOffsetStart = (long)i + bLetti;
                        if (!s.endsWith("]]>")) continue;
                        cdataFound = false;
                        continue;
                    }
                    if (s.startsWith("<![CDATA[")) {
                        cdataFound = true;
                        continue;
                    }
                    if (commentFound) {
                        if (headerClosure != null) {
                            headerBuilder.append(sbActual.toString());
                        }
                        sbActual.setLength(0);
                        sbActualOffsetStart = (long)i + bLetti;
                        if (!s.endsWith("-->")) continue;
                        commentFound = false;
                        continue;
                    }
                    if (s.startsWith("<!--")) {
                        if (s.endsWith("-->")) {
                            if (headerClosure != null) {
                                headerBuilder.append(sbActual.toString());
                            }
                            sbActual.setLength(0);
                            sbActualOffsetStart = (long)i + bLetti;
                            continue;
                        }
                        commentFound = true;
                        continue;
                    }
                    if (s.startsWith("<?")) continue;
                    if (!envelopeFound && this.isOpenedElement(s, "<Envelope")) {
                        this.envelope = s;
                        if (!this.analizyEnvelopeNamespace(this.envelope)) {
                            analisiTerminata = true;
                            break;
                        }
                        envelopeFound = true;
                        this.prefixEnvelope = "";
                        continue;
                    }
                    if (!envelopeFound && this.isOpenedElement(s, ":Envelope")) {
                        sPrefix = s.substring(0, s.indexOf(":Envelope"));
                        if (sPrefix.startsWith("<") && !sPrefix.contains(" ") && sPrefix.length() > 1) {
                            this.envelope = s;
                            if (!this.analizyEnvelopeNamespace(this.envelope)) {
                                analisiTerminata = true;
                                break;
                            }
                            envelopeFound = true;
                            this.prefixEnvelope = sPrefix.substring(1) + ":";
                            continue;
                        }
                        analisiTerminata = true;
                        break;
                    }
                    if (!envelopeFound) continue;
                    if (headerClosure != null) {
                        headerBuilder.append(s);
                        sbActual.setLength(0);
                        sbActualOffsetStart = (long)i + bLetti;
                        if (!s.startsWith((String)headerClosure)) continue;
                        headerClosure = null;
                        headerCompletato = true;
                        continue;
                    }
                    if (headerBuilder == null && this.isOpenedElement(s, "<Header")) {
                        headerBuilder = new StringBuilder();
                        if (!s.endsWith("/>")) {
                            headerClosure = "</Header";
                        }
                        if (bodyFound) {
                            analisiTerminata = true;
                            break;
                        }
                        this.startHeaderOffset = sbActualOffsetStart;
                        this.prefixHeader = "";
                        continue;
                    }
                    if (headerBuilder == null && this.isOpenedElement(s, ":Header")) {
                        sPrefix = s.substring(0, s.indexOf(":Header"));
                        if (sPrefix.startsWith("<") && !sPrefix.contains(" ") && sPrefix.length() > 1) {
                            headerBuilder = new StringBuilder();
                            if (!s.endsWith("/>")) {
                                headerClosure = "</" + sPrefix.substring(1) + ":Header";
                            }
                            if (bodyFound) {
                                analisiTerminata = true;
                                break;
                            }
                            this.startHeaderOffset = sbActualOffsetStart;
                            this.prefixHeader = sPrefix.substring(1) + ":";
                            continue;
                        }
                        analisiTerminata = true;
                        break;
                    }
                    if (!bodyFound && this.isOpenedElement(s, "<Body")) {
                        this.body = s;
                        bodyFound = true;
                        prefixBody = "";
                        if (this.startHeaderOffset <= 0L) {
                            this.startHeaderOffset = sbActualOffsetStart;
                        }
                        this.startBodyOffset = sbActualOffsetStart;
                        sbActual.setLength(0);
                        sbActualOffsetStart = (long)i + bLetti;
                        continue;
                    }
                    if (!bodyFound && this.isOpenedElement(s, ":Body")) {
                        sPrefix = s.substring(0, s.indexOf(":Body"));
                        if (sPrefix.startsWith("<") && !sPrefix.contains(" ") && sPrefix.length() > 1) {
                            this.body = s;
                            bodyFound = true;
                            prefixBody = sPrefix.substring(1) + ":";
                            if (this.startHeaderOffset <= 0L) {
                                this.startHeaderOffset = sbActualOffsetStart;
                            }
                            this.startBodyOffset = sbActualOffsetStart;
                            sbActual.setLength(0);
                            sbActualOffsetStart = (long)i + bLetti;
                            continue;
                        }
                        analisiTerminata = true;
                        break;
                    }
                    if (!bodyFound) continue;
                    if (this.fault == null && this.isOpenedElement(s, "<Fault")) {
                        this.fault = s;
                        continue;
                    }
                    if (this.fault == null && this.isOpenedElement(s, ":Fault")) {
                        sPrefix = s.substring(0, s.indexOf(":Fault"));
                        if (!sPrefix.startsWith("<") || sPrefix.contains(" ")) continue;
                        this.fault = s;
                        continue;
                    }
                    String closeBody = "</" + (String)prefixBody + "Body";
                    String closeEnvelope = "</" + this.prefixEnvelope + "Envelope";
                    if (this.isClosedElement(s, closeBody) || this.isClosedElement(s, closeEnvelope)) {
                        this.parsingComplete = true;
                    } else if (!this.endsWithGreaterThan(s)) {
                        if (elementAfterBodyBuilder != null) {
                            elementAfterBodyBuilder.append(s);
                        } else {
                            elementAfterBodyBuilder = new StringBuilder(s);
                        }
                    }
                    analisiTerminata = true;
                    break;
                }
                if (!analisiTerminata && kbLetti != this.bufferThresholdKb) continue;
                break;
            }
            if (sbActual != null && sbActual.length() > 0) {
                sbActual.setLength(0);
            }
            bufferReaded.flush();
            bufferReaded.close();
            if (bufferReaded.size() > 0) {
                this.bufferSize = bufferReaded.size();
                ByteArrayInputStream bin = new ByteArrayInputStream(bufferReaded.toByteArray());
                this.bufferedInputStream = lettiBuffer != -1 ? new SequenceInputStream(bin, this.is) : bin;
            }
            boolean throwException = false;
            String elementAfterBody = null;
            if (elementAfterBodyBuilder != null && elementAfterBodyBuilder.length() > 0) {
                elementAfterBody = elementAfterBodyBuilder.toString();
            }
            if (elementAfterBody != null || this.fault != null) {
                throwException = true;
                this.parsingComplete = true;
            }
            if (headerBuilder != null && headerBuilder.length() > 0) {
                if (this.envelope.endsWith("/>")) {
                    if (throwException) {
                        throw new Exception("Invalid content; found 'Header' after envelope closure '/>': (" + String.valueOf(headerBuilder) + ")");
                    }
                    return;
                }
                if (headerCompletato) {
                    StringBuilder sbHeaderAnalizer = new StringBuilder();
                    sbHeaderAnalizer.append(this.envelope);
                    sbHeaderAnalizer.append(headerBuilder.toString());
                    sbHeaderAnalizer.append("<").append(this.prefixEnvelope).append("Body/>");
                    sbHeaderAnalizer.append("</").append(this.prefixEnvelope).append("Envelope>");
                    this.header = sbHeaderAnalizer.toString();
                }
            }
            if (this.body != null) {
                if (this.envelope.endsWith("/>")) {
                    if (throwException) {
                        throw new Exception("Invalid content; found 'Body' after envelope closure '/>': (" + this.body + ")");
                    }
                    return;
                }
                if (this.body.endsWith("/>")) {
                    this.bodyEmpty = true;
                }
            }
            if (this.fault != null) {
                if (this.body.endsWith("/>")) {
                    if (throwException) {
                        throw new Exception("Invalid content; found Fault after body closure '/>': (" + this.fault + ")");
                    }
                    return;
                }
                StringBuilder sbFaultAnalizer = new StringBuilder();
                sbFaultAnalizer.append(this.envelope);
                sbFaultAnalizer.append(this.body);
                sbFaultAnalizer.append(this.fault);
                if (this.fault.contains("<") && this.fault.contains(">") && !this.fault.trim().endsWith("/>")) {
                    char c;
                    int i;
                    for (i = 0; i < this.fault.length(); ++i) {
                        char c3 = this.fault.charAt(i);
                        if (c3 != '<') continue;
                        ++i;
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    while (i < this.fault.length() && (c = this.fault.charAt(i)) != ' ' && c != '>' && c != '\t' && c != '\r' && c != '\n') {
                        sb.append(c);
                        ++i;
                    }
                    sbFaultAnalizer.append("</").append(sb.toString()).append(">");
                }
                sbFaultAnalizer.append("</").append((String)prefixBody).append("Body>");
                sbFaultAnalizer.append("</").append(this.prefixEnvelope).append("Envelope>");
                String namespaceFaultTrovato = null;
                try {
                    OpenSPCoop2Message msg = OpenSPCoop2MessageSoapStreamReader.buildOp2Message(sbFaultAnalizer.toString().getBytes(), this.getMessageType());
                    SOAPBody soapBody = msg.castAsSoap().getSOAPBody();
                    if (soapBody != null && soapBody.hasFault()) {
                        namespaceFaultTrovato = soapBody.getFault().getNamespaceURI();
                    }
                }
                catch (Throwable t) {
                    if (throwException) {
                        throw new Exception("Invalid content (" + sbFaultAnalizer.toString() + "): " + t.getMessage(), t);
                    }
                    return;
                }
                if (!this.namespace.equals(namespaceFaultTrovato)) {
                    elementAfterBody = this.fault;
                    this.fault = null;
                }
            }
            if (this.fault == null && elementAfterBody != null) {
                StringBuilder sbElementAnalizer = new StringBuilder();
                sbElementAnalizer.append(this.envelope);
                sbElementAnalizer.append(this.body);
                sbElementAnalizer.append(elementAfterBody);
                if (elementAfterBody.contains("<") && elementAfterBody.contains(">") && !elementAfterBody.trim().endsWith("/>")) {
                    char c;
                    int i;
                    for (i = 0; i < elementAfterBody.length(); ++i) {
                        char c4 = elementAfterBody.charAt(i);
                        if (c4 != '<') continue;
                        ++i;
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    while (i < elementAfterBody.length() && (c = elementAfterBody.charAt(i)) != ' ' && c != '>' && c != '\t' && c != '\r' && c != '\n') {
                        sb.append(c);
                        ++i;
                    }
                    sbElementAnalizer.append("</").append(sb.toString()).append(">");
                } else {
                    boolean empty = true;
                    for (int i = 0; i < elementAfterBody.length(); ++i) {
                        char c = elementAfterBody.charAt(i);
                        if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
                        empty = false;
                        break;
                    }
                    if (empty) {
                        this.bodyEmpty = true;
                    }
                }
                if (this.body != null && this.body.endsWith("/>")) {
                    if (!this.bodyEmpty) {
                        if (throwException) {
                            throw new Exception("Invalid content; found element after body closure '/>': (" + elementAfterBody + ")");
                        }
                        return;
                    }
                } else {
                    sbElementAnalizer.append("</").append((String)prefixBody).append("Body>");
                    sbElementAnalizer.append("</").append(this.prefixEnvelope).append("Envelope>");
                    SAXParser saxParser = null;
                    try {
                        saxParser = OpenSPCoop2MessageSoapStreamReader.getParser();
                        XMLReader xmlReader = saxParser.getXMLReader();
                        RootElementSaxContentHandler saxHandler = new RootElementSaxContentHandler(this.namespace);
                        xmlReader.setContentHandler(saxHandler);
                        try (ByteArrayInputStream bin = new ByteArrayInputStream(sbElementAnalizer.toString().getBytes());){
                            InputSource inputSource = new InputSource(bin);
                            xmlReader.parse(inputSource);
                        }
                        this.rootElementLocalName = saxHandler.getLocalName();
                        this.rootElementNamespace = saxHandler.getNamespace();
                        this.rootElementPrefix = saxHandler.getPrefix();
                    }
                    catch (Throwable t) {
                        if (throwException) {
                            throw new Exception("Invalid content '" + elementAfterBody + "' (" + sbElementAnalizer.toString() + "): " + t.getMessage(), t);
                        }
                        return;
                    }
                    finally {
                        if (saxParser != null) {
                            OpenSPCoop2MessageSoapStreamReader.returnParser(saxParser);
                        }
                    }
                }
            }
            if (this.fault == null && elementAfterBody == null && this.parsingComplete) {
                this.bodyEmpty = true;
            }
            if (this.parsingComplete && (charset == null || !charset.startsWith("UTF-16")) && this.startHeaderOffset > 0L && this.startBodyOffset >= this.startHeaderOffset) {
                this.soapHeaderOptimizable = true;
                if (this.endHeaderOffset > 0L && (this.endHeaderOffset < this.startHeaderOffset || this.endHeaderOffset > this.startBodyOffset)) {
                    this.soapHeaderOptimizable = false;
                }
            }
        }
        catch (Throwable t) {
            this.tBuffered = new MessageException(t.getMessage(), t);
            throw this.tBuffered;
        }
    }

    private boolean endsWithGreaterThan(String s) {
        if (s == null || s.length() < 4) {
            return false;
        }
        int startIx = s.length() - 4;
        return s.charAt(startIx) == '&' && s.charAt(startIx + 1) == 'g' && s.charAt(startIx + 2) == 't' && s.charAt(startIx + 3) == ';';
    }

    private boolean endsWithGreaterThan(StringBuilder buffer) {
        if (buffer == null || buffer.length() < 4) {
            return false;
        }
        int startIx = buffer.length() - 4;
        return buffer.charAt(startIx) == '&' && buffer.charAt(startIx + 1) == 'g' && buffer.charAt(startIx + 2) == 't' && buffer.charAt(startIx + 3) == ';';
    }

    private boolean startsWithLessThan(StringBuilder buffer) {
        if (buffer == null || buffer.length() < 4) {
            return false;
        }
        return buffer.charAt(0) == '&' && buffer.charAt(1) == 'l' && buffer.charAt(2) == 't' && buffer.charAt(3) == ';';
    }

    private boolean isOpenedElement(String s, String prefix) {
        if (prefix.startsWith(":")) {
            return s.contains(prefix + " ") || s.contains(prefix + ">") || s.contains(prefix + "/") || s.contains(prefix + "\n") || s.contains(prefix + "\r") || s.contains(prefix + "\t");
        }
        return s.startsWith(prefix + " ") || s.startsWith(prefix + ">") || s.startsWith(prefix + "/") || s.startsWith(prefix + "\n") || s.startsWith(prefix + "\r") || s.startsWith(prefix + "\t");
    }

    private boolean isClosedElement(String s, String prefix) {
        return s.startsWith(prefix + " ") || s.startsWith(prefix + ">") || s.startsWith(prefix + "\n") || s.startsWith(prefix + "\r") || s.startsWith(prefix + "\t");
    }

    private boolean analizyEnvelopeNamespace(String envelope) throws Exception {
        if (envelope != null) {
            String s = null;
            s = envelope.endsWith("/>") ? envelope : envelope.replace(">", "/>");
            SAXParser saxParser = null;
            try {
                saxParser = OpenSPCoop2MessageSoapStreamReader.getParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                SoapEnvelopeSaxContentHandler saxHandler = new SoapEnvelopeSaxContentHandler();
                xmlReader.setContentHandler(saxHandler);
                try (ByteArrayInputStream bin = new ByteArrayInputStream(s.getBytes());){
                    InputSource inputSource = new InputSource(bin);
                    xmlReader.parse(inputSource);
                }
                this.namespace = saxHandler.getNamespace();
            }
            catch (Throwable t) {
                throw new Exception("Invalid content (" + s + "): " + t.getMessage(), t);
            }
            finally {
                if (saxParser != null) {
                    OpenSPCoop2MessageSoapStreamReader.returnParser(saxParser);
                }
            }
            return "http://schemas.xmlsoap.org/soap/envelope/".equals(this.namespace) || "http://www.w3.org/2003/05/soap-envelope".equals(this.namespace);
        }
        return false;
    }

    public String getEnvelope() {
        return this.envelope;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public MessageType getMessageType() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.namespace)) {
            return MessageType.SOAP_11;
        }
        return MessageType.SOAP_12;
    }

    public boolean isParsingComplete() {
        return this.parsingComplete;
    }

    public boolean isFault() {
        return this.fault != null;
    }

    public boolean isEmpty() {
        return this.bodyEmpty;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public OpenSPCoop2Message getHeader_OpenSPCoop2Message() throws MessageException {
        boolean checkIsEmpty = true;
        SOAPHeader s = this._getHeader(checkIsEmpty, false);
        if (s != null) {
            return this._headerMsgCompleto;
        }
        return null;
    }

    public SOAPHeader getHeader() throws MessageException {
        return this._getHeader(false, false);
    }

    public SOAPHeader getModifiableHeader() throws MessageException {
        this.soapHeaderModified = true;
        return this._getHeader(false, false);
    }

    public SOAPHeader addHeader() throws MessageException {
        return this._getHeader(false, true);
    }

    public boolean isSoapHeaderModified() {
        return this.soapHeaderModified;
    }

    public void setSoapHeaderModified(boolean soapHeaderModified) {
        this.soapHeaderModified = soapHeaderModified;
    }

    private SOAPHeader _getHeader(boolean checkIsEmpty, boolean buildIfEmpty) throws MessageException {
        Node n;
        if (this.parseErrorHeader != null) {
            throw this.parseErrorHeader;
        }
        SOAPHeader soapHeader = null;
        if (this._headerMsgCompleto != null) {
            try {
                soapHeader = this._headerMsgCompleto.castAsSoap().getSOAPHeader();
            }
            catch (Throwable t) {
                throw SoapUtils.buildMessageException("Error during access header: " + t.getMessage(), t);
            }
        }
        if (this._headerMsgCompleto == null && this.header != null) {
            try {
                this._headerMsgCompleto = OpenSPCoop2MessageSoapStreamReader.buildOp2Message(this.header.getBytes(), this.getMessageType());
                soapHeader = this._headerMsgCompleto.castAsSoap().getSOAPHeader();
                if (soapHeader != null) {
                    if ("".equals(this.prefixEnvelope)) {
                        this._headerMsgCompleto.castAsSoap().getSOAPPart().getEnvelope().setPrefix("");
                    }
                    if ("".equals(this.prefixHeader)) {
                        soapHeader.setPrefix("");
                    }
                }
                this.header = null;
            }
            catch (Throwable t) {
                this.parseErrorHeader = SoapUtils.buildMessageException("Invalid header (" + this.header + "): " + t.getMessage(), t);
                throw this.parseErrorHeader;
            }
        }
        if (this._headerMsgCompleto == null && buildIfEmpty) {
            try {
                Object xmlns = "";
                if (this.prefixEnvelope != null && !"".equals(this.prefixEnvelope) && ((String)(xmlns = ":" + this.prefixEnvelope)).endsWith(":") && ((String)xmlns).length() > 1) {
                    xmlns = ((String)xmlns).substring(0, ((String)xmlns).length() - 1);
                }
                String envelope = "<" + this.prefixEnvelope + "Envelope xmlns" + (String)xmlns + "=\"" + this.namespace + "\"><" + this.prefixEnvelope + "Header/></" + this.prefixEnvelope + "Envelope>";
                this._headerMsgCompleto = OpenSPCoop2MessageSoapStreamReader.buildOp2Message(envelope.getBytes(), this.getMessageType());
                soapHeader = this._headerMsgCompleto.castAsSoap().getSOAPHeader();
                if ("".equals(xmlns)) {
                    this._headerMsgCompleto.castAsSoap().getSOAPPart().getEnvelope().setPrefix("");
                    soapHeader.setPrefix("");
                }
                this.soapHeaderModified = true;
            }
            catch (Throwable t) {
                throw SoapUtils.buildMessageException("Build header failed: " + t.getMessage(), t);
            }
        }
        if (soapHeader != null && checkIsEmpty && (n = SoapUtils.getFirstNotEmptyChildNode(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (Node)soapHeader, false)) == null) {
            soapHeader = null;
        }
        return soapHeader;
    }

    public void clearHeader() {
        this._headerMsgCompleto = null;
        this.soapHeaderOptimizable = false;
    }

    public String getRootElementNamespace() {
        return this.rootElementNamespace;
    }

    public String getRootElementLocalName() {
        return this.rootElementLocalName;
    }

    public String getRootElementPrefix() {
        return this.rootElementPrefix;
    }

    private static SAXParser getParser() {
        return saxParserThreadLocal.get();
    }

    public static void removeParser() {
        saxParserThreadLocal.remove();
    }

    private static void returnParser(SAXParser saxParser) {
        saxParser.reset();
    }

    private static OpenSPCoop2Message buildOp2Message(byte[] bytes, MessageType messageType) throws Exception {
        MimeHeaders mhs = new MimeHeaders();
        mhs.addHeader("Content-Type", MessageType.SOAP_11.equals(messageType) ? "text/xml" : "application/soap+xml");
        AbstractOpenSPCoop2Message_saaj_impl msg = null;
        try (ByteArrayInputStream bin = new ByteArrayInputStream(bytes);){
            msg = MessageType.SOAP_11.equals(messageType) ? new OpenSPCoop2Message_saaj_11_impl(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), mhs, bin) : new OpenSPCoop2Message_saaj_12_impl(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), mhs, bin);
        }
        return msg;
    }

    public boolean isSoapHeaderOptimizable() {
        return SOAP_HEADER_OPTIMIZATION_ENABLED && this.soapHeaderOptimizable;
    }

    public void writeOptimizedHeaderTo(InputStream is, OutputStream osParam, boolean consumeHeader) throws Exception {
        if (!this.soapHeaderOptimizable) {
            throw new Exception("SOAPHeader not optimizable");
        }
        if (this._headerMsgCompleto == null) {
            throw new Exception("SOAPMessage Optimized undefined");
        }
        SOAPHeader soapHeader = this._headerMsgCompleto.castAsSoap().getSOAPHeader();
        if (soapHeader == null) {
            throw new Exception("SOAPHeader undefined");
        }
        TransformerConfig xmlConfig = new TransformerConfig();
        xmlConfig.setOmitXMLDeclaration(true);
        xmlConfig.setCharset(this.isCharset);
        long indexBody = this.startBodyOffset;
        if (this.endHeaderOffset > 0L) {
            indexBody = this.endHeaderOffset + 1L;
        }
        byte[] buffer = new byte[65536];
        int letti = 0;
        long index = 0L;
        boolean writeHeader = false;
        boolean debug = false;
        OutputStream os = null;
        os = debug ? new ByteArrayOutputStream() : osParam;
        while ((letti = is.read(buffer, 0, 65536)) != -1) {
            int i;
            if (index < this.startHeaderOffset) {
                for (i = 0; i < letti; ++i) {
                    if (!writeHeader || index >= indexBody) {
                        os.write(buffer[i]);
                    }
                    if (++index != this.startHeaderOffset) continue;
                    if (debug) {
                        os.flush();
                    }
                    os.write(MessageXMLUtils.getInstance(OpenSPCoop2MessageFactory.getDefaultMessageFactory()).toByteArray((Element)soapHeader, xmlConfig));
                    writeHeader = true;
                    if (!debug) continue;
                    os.flush();
                }
                continue;
            }
            if (!writeHeader) {
                os.write(MessageXMLUtils.getInstance(OpenSPCoop2MessageFactory.getDefaultMessageFactory()).toByteArray((Element)soapHeader, xmlConfig));
                writeHeader = true;
                if (debug) {
                    os.flush();
                }
            }
            if (index >= indexBody) {
                os.write(buffer, 0, letti);
                index += (long)letti;
            } else {
                for (i = 0; i < letti; ++i) {
                    if (index >= indexBody) {
                        os.write(buffer[i]);
                    }
                    ++index;
                }
            }
            if (!debug) continue;
            os.flush();
        }
        if (debug) {
            os.flush();
        }
        os.flush();
        if (consumeHeader) {
            this._headerMsgCompleto = null;
            this.soapHeaderOptimizable = false;
            this.bufferedInputStream = null;
        }
    }
}

