/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.message.xml;

import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XMLUtils;

public class MessageXMLUtils
extends XMLUtils {
    private static HashMap<String, MessageXMLUtils> xmlUtilsMap = new HashMap();
    public static MessageXMLUtils DEFAULT = MessageXMLUtils.getInstance(OpenSPCoop2MessageFactory.getDefaultMessageFactory());
    private OpenSPCoop2MessageFactory messageFactory;

    private static synchronized void init(OpenSPCoop2MessageFactory messageFactory) {
        String key = messageFactory.getClass().getName();
        if (!xmlUtilsMap.containsKey(key)) {
            MessageXMLUtils xmlUtils = new MessageXMLUtils(messageFactory);
            xmlUtilsMap.put(key, xmlUtils);
        }
    }

    public static MessageXMLUtils getInstance(OpenSPCoop2MessageFactory messageFactory) {
        String key = messageFactory.getClass().getName();
        if (!xmlUtilsMap.containsKey(key)) {
            MessageXMLUtils.init(messageFactory);
        }
        return xmlUtilsMap.get(key);
    }

    public MessageXMLUtils(OpenSPCoop2MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    protected DocumentBuilderFactory newDocumentBuilderFactory() throws XMLException {
        try {
            return (DocumentBuilderFactory)Loader.getInstance().newInstance(this.messageFactory.getDocumentBuilderFactoryClass());
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), (Throwable)e);
        }
    }

    protected SAXParserFactory newSAXParserFactory() throws XMLException {
        try {
            return (SAXParserFactory)Loader.getInstance().newInstance(this.messageFactory.getSAXParserFactoryClass());
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), (Throwable)e);
        }
    }
}

