/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.utils.id.IDUtilities;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceUtils;

public class ExternalResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXTERNAL_RESOURCE_PROTOCOL = "external_resource://";
    private String id;
    private byte[] resource;

    public ExternalResource(String resource, ExternalResourceConfig externalConfig) throws SecurityException {
        this(ExternalResource.generateId(), resource, externalConfig);
    }

    public ExternalResource(String id, String resource, ExternalResourceConfig externalConfig) throws SecurityException {
        this.id = id;
        try {
            this.resource = ExternalResourceUtils.readResource((String)resource, (ExternalResourceConfig)externalConfig);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private static String generateId() throws SecurityException {
        Object uniqueId = null;
        if (UniqueIdentifierManager.isInitialized()) {
            try {
                uniqueId = UniqueIdentifierManager.newUniqueIdentifier().getAsString();
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        if (uniqueId == null) {
            uniqueId = "" + IDUtilities.getUniqueSerialNumber();
        }
        return uniqueId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public byte[] getResource() {
        return this.resource;
    }

    public void setResource(byte[] resource) {
        this.resource = resource;
    }

    public String getPathId() {
        return EXTERNAL_RESOURCE_PROTOCOL + this.id;
    }
}

