/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;

public class RemoteStoreClientInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String remoteStoreName;
    private String keyId;
    private String clientId;
    private org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo clientInfo;

    public RemoteStoreClientInfo(String keyId, String clientId, RemoteStoreConfig remoteStoreConfig, IRemoteStoreProvider provider, Map<Object> context) throws SecurityException {
        try {
            this.keyId = keyId;
            if (keyId == null) {
                throw new SecurityException("KeyId undefined");
            }
            this.clientId = clientId;
            if (clientId == null) {
                throw new SecurityException("ClientId undefined");
            }
            if (remoteStoreConfig == null) {
                throw new SecurityException("RemoteStoreConfig undefined");
            }
            this.remoteStoreName = remoteStoreConfig.getStoreName();
            if (this.remoteStoreName == null) {
                throw new SecurityException("RemoteStoreConfig name undefined");
            }
            this.clientInfo = provider.readClientInfo(this.keyId, this.clientId, remoteStoreConfig, context);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public String getRemoteStoreName() {
        return this.remoteStoreName;
    }

    public void setRemoteStoreName(String remoteStoreName) {
        this.remoteStoreName = remoteStoreName;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public void setClientInfo(org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }
}

