/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;

public class SecretPasswordKeyDerivationConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String pwd = null;
    private String pwdEncryptionMode = null;
    private Integer pwdIteration = null;

    public SecretPasswordKeyDerivationConfig(String pwd, String pwdEncryptionMode) {
        this(pwd, pwdEncryptionMode, null);
    }

    public SecretPasswordKeyDerivationConfig(String pwd, String pwdEncryptionMode, Integer pwdIteration) {
        this.pwd = pwd;
        this.pwdEncryptionMode = pwdEncryptionMode;
        this.pwdIteration = pwdIteration;
    }

    public String toKey() {
        StringBuilder sb = new StringBuilder("PwdDerivationConfig_");
        sb.append("mode:").append(this.pwdEncryptionMode);
        sb.append("_");
        sb.append("iter:").append(this.pwdIteration != null ? this.pwdIteration : "-");
        sb.append("_");
        sb.append(this.pwd);
        return sb.toString();
    }

    public String getPassword() {
        return this.pwd;
    }

    public String getPasswordEncryptionMode() {
        return this.pwdEncryptionMode;
    }

    public Integer getPasswordIterator() {
        return this.pwdIteration;
    }
}

