/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.core.byok.BYOKUtilities;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKStore;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.byok.BYOKEncryptionMode;
import org.openspcoop2.utils.certificate.byok.BYOKInstance;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.slf4j.Logger;

public class StoreUtils {
    private StoreUtils() {
    }

    public static byte[] readContent(String pName, String path) throws SecurityException {
        byte[] array;
        block19: {
            if (path == null) {
                throw new SecurityException("Property " + pName + " non indicata");
            }
            File fStore = new File(path);
            boolean fExists = fStore.exists();
            array = null;
            try {
                try (InputStream isStore = fExists ? new FileInputStream(fStore) : StoreUtils.class.getResourceAsStream(path);){
                    if (isStore != null) {
                        array = Utilities.getAsByteArray((InputStream)isStore);
                    }
                }
                if (array != null || fExists) break block19;
                isStore = StoreUtils.class.getResourceAsStream("/" + path);
                try {
                    if (isStore != null) {
                        array = Utilities.getAsByteArray((InputStream)isStore);
                    }
                }
                finally {
                    if (isStore != null) {
                        isStore.close();
                    }
                }
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        if (array == null) {
            throw new SecurityException("Store [" + path + "] not found");
        }
        return array;
    }

    public static Properties readProperties(String pName, String path) throws SecurityException {
        Properties propStore;
        block19: {
            if (path == null) {
                throw new SecurityException("Property " + pName + " non indicata");
            }
            File fStore = new File(path);
            boolean fExists = fStore.exists();
            propStore = null;
            try {
                try (InputStream isStore = fExists ? new FileInputStream(fStore) : StoreUtils.class.getResourceAsStream(path);){
                    if (isStore != null) {
                        propStore = new Properties();
                        propStore.load(isStore);
                    }
                }
                if (propStore != null || fStore.exists()) break block19;
                isStore = StoreUtils.class.getResourceAsStream("/" + path);
                try {
                    if (isStore != null) {
                        propStore = new Properties();
                        propStore.load(isStore);
                    }
                }
                finally {
                    if (isStore != null) {
                        isStore.close();
                    }
                }
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
        if (propStore == null) {
            throw new SecurityException("Store [" + path + "] not found");
        }
        return propStore;
    }

    public static byte[] unwrapBYOK(byte[] archive, BYOKRequestParams requestParams) throws SecurityException {
        if (requestParams != null) {
            if (archive != null && BYOKUtilities.isWrappedValue((byte[])archive)) {
                archive = BYOKUtilities.deletePrefixWrappedValue((byte[])archive);
            }
            Logger log = LoggerWrapperFactory.getLogger(StoreUtils.class);
            BYOKInstance instance = null;
            try {
                instance = requestParams.getConfig() != null && BYOKEncryptionMode.LOCAL.equals((Object)requestParams.getConfig().getEncryptionMode()) ? BYOKInstance.newLocalInstance((Logger)log, (BYOKRequestParams)requestParams, (byte[])archive) : BYOKInstance.newRemoteInstance((Logger)log, (BYOKRequestParams)requestParams, (byte[])archive);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
            BYOKStore store = new BYOKStore(instance.getKeyCache(), instance);
            return store.getStoreBytes();
        }
        return archive;
    }
}

