/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import javax.crypto.spec.SecretKeySpec;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.FixTrustAnchorsNotEmpty;
import org.openspcoop2.security.keystore.StoreUtils;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;

public class SymmetricKeystore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SecretKeySpec key = null;
    private transient org.openspcoop2.utils.certificate.KeyStore keyStore = null;
    private String pwKey = null;
    private String alias = null;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("SymmetricKeystore (").append(this.alias).append(") ");
        return bf.toString();
    }

    public SymmetricKeystore(String alias, String key, String algoritmo) throws SecurityException {
        this(alias, key, algoritmo, null);
    }

    public SymmetricKeystore(String alias, String key, String algoritmo, BYOKRequestParams requestParams) throws SecurityException {
        try {
            String algorithm = null;
            algorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(algoritmo) ? "DESede" : "DES";
            byte[] keyBytes = key.getBytes();
            if (requestParams != null) {
                keyBytes = StoreUtils.unwrapBYOK(keyBytes, requestParams);
            }
            this.key = new SecretKeySpec(keyBytes, algorithm);
            this.alias = alias;
            this.pwKey = "PW_CUSTOM";
            this.initKS();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private void checkInit() throws SecurityException {
        if (this.keyStore == null) {
            this.initKS();
        }
    }

    private synchronized void initKS() throws SecurityException {
        if (this.keyStore == null) {
            try {
                KeyStore keyStoreJCEKS = KeyStore.getInstance("JCEKS");
                keyStoreJCEKS.load(null);
                keyStoreJCEKS.setKeyEntry(this.alias, this.key, this.pwKey.toCharArray(), null);
                this.keyStore = new org.openspcoop2.utils.certificate.KeyStore(keyStoreJCEKS);
                FixTrustAnchorsNotEmpty.addCertificate(this.keyStore.getKeystore());
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    public Key getKey() {
        return this.key;
    }

    public org.openspcoop2.utils.certificate.KeyStore getKeyStore() throws SecurityException {
        this.checkInit();
        return this.keyStore;
    }

    public String getPasswordKey() {
        return this.pwKey;
    }
}

