/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKStore;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.ExternalResource;
import org.openspcoop2.security.keystore.HttpStore;
import org.openspcoop2.security.keystore.JWKSetStore;
import org.openspcoop2.security.keystore.KeyPairStore;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.MultiKeystore;
import org.openspcoop2.security.keystore.OCSPResponse;
import org.openspcoop2.security.keystore.PublicKeyStore;
import org.openspcoop2.security.keystore.RemoteStore;
import org.openspcoop2.security.keystore.RemoteStoreClientInfo;
import org.openspcoop2.security.keystore.SSLConfigProps;
import org.openspcoop2.security.keystore.SSLSocketFactory;
import org.openspcoop2.security.keystore.SecretKeyStore;
import org.openspcoop2.security.keystore.SecretPasswordKeyDerivationConfig;
import org.openspcoop2.security.keystore.SymmetricKeystore;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.security.keystore.cache.BYOKStoreCache;
import org.openspcoop2.security.keystore.cache.CRLCertstoreCache;
import org.openspcoop2.security.keystore.cache.ExternalResourceCache;
import org.openspcoop2.security.keystore.cache.HttpStoreCache;
import org.openspcoop2.security.keystore.cache.JWKSetStoreCache;
import org.openspcoop2.security.keystore.cache.KeyPairStoreCache;
import org.openspcoop2.security.keystore.cache.MerlinKeystoreCache;
import org.openspcoop2.security.keystore.cache.MerlinTruststoreCache;
import org.openspcoop2.security.keystore.cache.MultiKeystoreCache;
import org.openspcoop2.security.keystore.cache.OCSPResponseCache;
import org.openspcoop2.security.keystore.cache.PublicKeyStoreCache;
import org.openspcoop2.security.keystore.cache.RemoteStoreCache;
import org.openspcoop2.security.keystore.cache.RemoteStoreClientInfoCache;
import org.openspcoop2.security.keystore.cache.SSLConfigPropsCache;
import org.openspcoop2.security.keystore.cache.SSLSocketFactoryCache;
import org.openspcoop2.security.keystore.cache.SecretKeyStoreCache;
import org.openspcoop2.security.keystore.cache.SymmetricKeystoreCache;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.byok.BYOKInstance;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.transport.http.ExternalResourceConfig;
import org.openspcoop2.utils.transport.http.HttpOptions;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.SSLConfig;

public class GestoreKeystoreCache {
    private static final MerlinTruststoreCache merlinTruststoreCache = new MerlinTruststoreCache();
    private static final MerlinKeystoreCache merlinKeystoreCache = new MerlinKeystoreCache();
    private static final SymmetricKeystoreCache symmetricKeystoreCache = new SymmetricKeystoreCache();
    private static final MultiKeystoreCache multiKeystoreCache = new MultiKeystoreCache();
    private static final JWKSetStoreCache jwkSetStoreCache = new JWKSetStoreCache();
    private static final KeyPairStoreCache keyPairStoreCache = new KeyPairStoreCache();
    private static final PublicKeyStoreCache publicKeyStoreCache = new PublicKeyStoreCache();
    private static final SecretKeyStoreCache secretKeyStoreCache = new SecretKeyStoreCache();
    private static final RemoteStoreCache remoteStoreCache = new RemoteStoreCache();
    private static final RemoteStoreClientInfoCache remoteStoreClientInfoCache = new RemoteStoreClientInfoCache();
    private static final HttpStoreCache httpStoreCache = new HttpStoreCache();
    private static final BYOKStoreCache byokStoreCache = new BYOKStoreCache();
    private static final CRLCertstoreCache crlCertstoreCache = new CRLCertstoreCache();
    private static final SSLSocketFactoryCache sslSocketFactoryCache = new SSLSocketFactoryCache();
    private static final SSLConfigPropsCache sslConfigPropsCache = new SSLConfigPropsCache();
    private static final ExternalResourceCache externalResourceCache = new ExternalResourceCache();
    private static final OCSPResponseCache ocspResponseCache = new OCSPResponseCache();
    private static boolean cacheEnabled = false;

    private GestoreKeystoreCache() {
    }

    public static void setKeystoreCacheParameters(boolean cacheEnabled, int cacheLifeSecond, int cacheSize) {
        GestoreKeystoreCache.cacheEnabled = cacheEnabled;
        merlinTruststoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        merlinKeystoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        symmetricKeystoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        multiKeystoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        jwkSetStoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        keyPairStoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        publicKeyStoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        secretKeyStoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        remoteStoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        remoteStoreClientInfoCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        httpStoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        byokStoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        crlCertstoreCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        sslSocketFactoryCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        sslConfigPropsCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        externalResourceCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
        ocspResponseCache.setKeystoreCacheParameters(cacheLifeSecond, cacheSize);
    }

    public static void setKeystoreCacheJCS(boolean cacheEnabled, int cacheLifeSecond, Cache cacheJCS) {
        GestoreKeystoreCache.cacheEnabled = cacheEnabled;
        merlinTruststoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        merlinKeystoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        symmetricKeystoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        multiKeystoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        jwkSetStoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        keyPairStoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        publicKeyStoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        secretKeyStoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        remoteStoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        remoteStoreClientInfoCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        httpStoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        byokStoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        crlCertstoreCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        sslSocketFactoryCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        sslConfigPropsCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        externalResourceCache.setCacheJCS(cacheLifeSecond, cacheJCS);
        ocspResponseCache.setCacheJCS(cacheLifeSecond, cacheJCS);
    }

    public static void setKeystoreCacheJCSCrlLifeSeconds(int cacheCrlLifeSecond) {
        crlCertstoreCache.updateCacheLifeSecond(cacheCrlLifeSecond);
        ocspResponseCache.updateCacheLifeSecond(cacheCrlLifeSecond);
        externalResourceCache.updateCacheLifeSecond(cacheCrlLifeSecond);
    }

    public static MerlinTruststore getMerlinTruststore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && propertyFilePath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getMerlinTruststore(propertyFilePath)) instanceof MerlinTruststore) {
            return (MerlinTruststore)o;
        }
        MerlinTruststore t = null;
        t = cacheEnabled ? (MerlinTruststore)merlinTruststoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, new Object[0]) : new MerlinTruststore(propertyFilePath);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinTruststore(propertyFilePath, (Serializable)t, requestInfo.getIdTransazione());
        }
        return t;
    }

    public static MerlinTruststore getMerlinTruststore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && pathStore != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getMerlinTruststore(pathStore)) instanceof MerlinTruststore) {
            return (MerlinTruststore)o;
        }
        MerlinTruststore t = null;
        t = cacheEnabled ? (MerlinTruststore)merlinTruststoreCache.getKeystoreAndCreateIfNotExists(pathStore, tipoStore, passwordStore) : new MerlinTruststore(pathStore, tipoStore, passwordStore);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinTruststore(pathStore, (Serializable)t, requestInfo.getIdTransazione());
        }
        return t;
    }

    public static MerlinTruststore getMerlinTruststore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && bytesStore != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(bytesStore);
            Serializable o = requestInfo.getRequestConfig().getMerlinTruststore(keyParam);
            if (o instanceof MerlinTruststore) {
                return (MerlinTruststore)o;
            }
        }
        MerlinTruststore t = null;
        t = cacheEnabled ? (MerlinTruststore)merlinTruststoreCache.getKeystoreAndCreateIfNotExists(bytesStore, tipoStore, passwordStore) : new MerlinTruststore(bytesStore, tipoStore, passwordStore);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinTruststore(keyParam, (Serializable)t, requestInfo.getIdTransazione());
        }
        return t;
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore(requestInfo, propertyFilePath, (BYOKRequestParams)null);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String propertyFilePath, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && propertyFilePath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getMerlinKeystore(propertyFilePath)) instanceof MerlinKeystore) {
            return (MerlinKeystore)o;
        }
        MerlinKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, requestParams) : new MerlinKeystore(propertyFilePath, requestParams)) : (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, new Object[0]) : new MerlinKeystore(propertyFilePath));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinKeystore(propertyFilePath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String propertyFilePath, String passwordPrivateKey) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore(requestInfo, propertyFilePath, passwordPrivateKey, (BYOKRequestParams)null);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String propertyFilePath, String passwordPrivateKey, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && propertyFilePath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getMerlinKeystore(propertyFilePath)) instanceof MerlinKeystore) {
            return (MerlinKeystore)o;
        }
        MerlinKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, passwordPrivateKey, requestParams) : new MerlinKeystore(propertyFilePath, passwordPrivateKey, requestParams)) : (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, passwordPrivateKey) : new MerlinKeystore(propertyFilePath, passwordPrivateKey));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinKeystore(propertyFilePath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore(requestInfo, pathStore, tipoStore, passwordStore, (BYOKRequestParams)null);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && pathStore != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getMerlinKeystore(pathStore)) instanceof MerlinKeystore) {
            return (MerlinKeystore)o;
        }
        MerlinKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(pathStore, tipoStore, passwordStore, requestParams) : new MerlinKeystore(pathStore, tipoStore, passwordStore, requestParams)) : (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(pathStore, tipoStore, passwordStore) : new MerlinKeystore(pathStore, tipoStore, passwordStore));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinKeystore(pathStore, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore(requestInfo, pathStore, tipoStore, passwordStore, passwordPrivateKey, (BYOKRequestParams)null);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && pathStore != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getMerlinKeystore(pathStore)) instanceof MerlinKeystore) {
            return (MerlinKeystore)o;
        }
        MerlinKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(pathStore, tipoStore, passwordStore, passwordPrivateKey, requestParams) : new MerlinKeystore(pathStore, tipoStore, passwordStore, passwordPrivateKey, requestParams)) : (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(pathStore, tipoStore, passwordStore, passwordPrivateKey) : new MerlinKeystore(pathStore, tipoStore, passwordStore, passwordPrivateKey));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinKeystore(pathStore, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore(requestInfo, bytesStore, tipoStore, passwordStore, (BYOKRequestParams)null);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore, BYOKRequestParams requestParams) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && bytesStore != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(bytesStore);
            Serializable o = requestInfo.getRequestConfig().getMerlinKeystore(keyParam);
            if (o instanceof MerlinKeystore) {
                return (MerlinKeystore)o;
            }
        }
        MerlinKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(bytesStore, tipoStore, passwordStore, requestParams) : new MerlinKeystore(bytesStore, tipoStore, passwordStore, requestParams)) : (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(bytesStore, tipoStore, passwordStore) : new MerlinKeystore(bytesStore, tipoStore, passwordStore));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinKeystore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        return GestoreKeystoreCache.getMerlinKeystore(requestInfo, bytesStore, tipoStore, passwordStore, passwordPrivateKey, (BYOKRequestParams)null);
    }

    public static MerlinKeystore getMerlinKeystore(RequestInfo requestInfo, byte[] bytesStore, String tipoStore, String passwordStore, String passwordPrivateKey, BYOKRequestParams requestParams) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && bytesStore != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(bytesStore);
            Serializable o = requestInfo.getRequestConfig().getMerlinKeystore(keyParam);
            if (o instanceof MerlinKeystore) {
                return (MerlinKeystore)o;
            }
        }
        MerlinKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(bytesStore, tipoStore, passwordStore, passwordPrivateKey, requestParams) : new MerlinKeystore(bytesStore, tipoStore, passwordStore, passwordPrivateKey, requestParams)) : (cacheEnabled ? (MerlinKeystore)merlinKeystoreCache.getKeystoreAndCreateIfNotExists(bytesStore, tipoStore, passwordStore, passwordPrivateKey) : new MerlinKeystore(bytesStore, tipoStore, passwordStore, passwordPrivateKey));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMerlinKeystore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static SymmetricKeystore getSymmetricKeystore(RequestInfo requestInfo, String alias, String key, String algoritmo) throws SecurityException {
        return GestoreKeystoreCache.getSymmetricKeystore(requestInfo, alias, key, algoritmo, null);
    }

    public static SymmetricKeystore getSymmetricKeystore(RequestInfo requestInfo, String alias, String key, String algoritmo, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && key != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getSymmetricKeystore(key)) instanceof SymmetricKeystore) {
            return (SymmetricKeystore)o;
        }
        SymmetricKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (SymmetricKeystore)symmetricKeystoreCache.getKeystoreAndCreateIfNotExists(key, alias, algoritmo, requestParams) : new SymmetricKeystore(alias, key, algoritmo, requestParams)) : (cacheEnabled ? (SymmetricKeystore)symmetricKeystoreCache.getKeystoreAndCreateIfNotExists(key, alias, algoritmo) : new SymmetricKeystore(alias, key, algoritmo));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addSymmetricKeystore(key, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static MultiKeystore getMultiKeystore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        return GestoreKeystoreCache.getMultiKeystore(requestInfo, propertyFilePath, null);
    }

    public static MultiKeystore getMultiKeystore(RequestInfo requestInfo, String propertyFilePath, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && propertyFilePath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getMultiKeystore(propertyFilePath)) instanceof MultiKeystore) {
            return (MultiKeystore)o;
        }
        MultiKeystore k = null;
        k = requestParams != null ? (cacheEnabled ? (MultiKeystore)multiKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, requestParams) : new MultiKeystore(propertyFilePath, requestParams)) : (cacheEnabled ? (MultiKeystore)multiKeystoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, new Object[0]) : new MultiKeystore(propertyFilePath));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addMultiKeystore(propertyFilePath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static JWKSetStore getJwkSetStore(RequestInfo requestInfo, String propertyFilePath) throws SecurityException {
        return GestoreKeystoreCache.getJwkSetStore(requestInfo, propertyFilePath, (BYOKRequestParams)null);
    }

    public static JWKSetStore getJwkSetStore(RequestInfo requestInfo, String propertyFilePath, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && propertyFilePath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getJWKSetStore(propertyFilePath)) instanceof JWKSetStore) {
            return (JWKSetStore)o;
        }
        JWKSetStore k = null;
        k = requestParams != null ? (cacheEnabled ? (JWKSetStore)jwkSetStoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, requestParams) : new JWKSetStore(propertyFilePath, requestParams)) : (cacheEnabled ? (JWKSetStore)jwkSetStoreCache.getKeystoreAndCreateIfNotExists(propertyFilePath, new Object[0]) : new JWKSetStore(propertyFilePath));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addJWKSetStore(propertyFilePath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static JWKSetStore getJwkSetStore(RequestInfo requestInfo, byte[] archive) throws SecurityException {
        return GestoreKeystoreCache.getJwkSetStore(requestInfo, archive, (BYOKRequestParams)null);
    }

    public static JWKSetStore getJwkSetStore(RequestInfo requestInfo, byte[] archive, BYOKRequestParams requestParams) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && archive != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(archive);
            Serializable o = requestInfo.getRequestConfig().getJWKSetStore(keyParam);
            if (o instanceof JWKSetStore) {
                return (JWKSetStore)o;
            }
        }
        JWKSetStore k = null;
        k = requestParams != null ? (cacheEnabled ? (JWKSetStore)jwkSetStoreCache.getKeystoreAndCreateIfNotExists(archive, requestParams) : new JWKSetStore(archive, requestParams)) : (cacheEnabled ? (JWKSetStore)jwkSetStoreCache.getKeystoreAndCreateIfNotExists(archive, new Object[0]) : new JWKSetStore(archive));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addJWKSetStore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, String privateKeyPath, String publicKeyPath, String privateKeyPassword, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getKeyPairStore(requestInfo, privateKeyPath, publicKeyPath, privateKeyPassword, algorithm, (BYOKRequestParams)null);
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, String privateKeyPath, String publicKeyPath, String privateKeyPassword, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && privateKeyPath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getKeyPairStore(privateKeyPath)) instanceof KeyPairStore) {
            return (KeyPairStore)o;
        }
        KeyPairStore k = null;
        k = requestParams != null ? (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKeyPath, publicKeyPath, privateKeyPassword, algorithm, requestParams) : new KeyPairStore(privateKeyPath, publicKeyPath, privateKeyPassword, algorithm, requestParams)) : (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKeyPath, publicKeyPath, privateKeyPassword, algorithm) : new KeyPairStore(privateKeyPath, publicKeyPath, privateKeyPassword, algorithm));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addKeyPairStore(privateKeyPath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, String privateKeyPath, byte[] publicKey, String privateKeyPassword, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getKeyPairStore(requestInfo, privateKeyPath, publicKey, privateKeyPassword, algorithm, (BYOKRequestParams)null);
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, String privateKeyPath, byte[] publicKey, String privateKeyPassword, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && privateKeyPath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getKeyPairStore(privateKeyPath)) instanceof KeyPairStore) {
            return (KeyPairStore)o;
        }
        KeyPairStore k = null;
        k = requestParams != null ? (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKeyPath, publicKey, privateKeyPassword, algorithm, requestParams) : new KeyPairStore(privateKeyPath, publicKey, privateKeyPassword, algorithm, requestParams)) : (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKeyPath, publicKey, privateKeyPassword, algorithm) : new KeyPairStore(privateKeyPath, publicKey, privateKeyPassword, algorithm));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addKeyPairStore(privateKeyPath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, byte[] privateKey, byte[] publicKey, String privateKeyPassword, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getKeyPairStore(requestInfo, privateKey, publicKey, privateKeyPassword, algorithm, (BYOKRequestParams)null);
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, byte[] privateKey, byte[] publicKey, String privateKeyPassword, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && privateKey != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(privateKey);
            Serializable o = requestInfo.getRequestConfig().getKeyPairStore(keyParam);
            if (o instanceof KeyPairStore) {
                return (KeyPairStore)o;
            }
        }
        KeyPairStore k = null;
        k = requestParams != null ? (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKey, publicKey, privateKeyPassword, algorithm, requestParams) : new KeyPairStore(privateKey, publicKey, privateKeyPassword, algorithm, requestParams)) : (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKey, publicKey, privateKeyPassword, algorithm) : new KeyPairStore(privateKey, publicKey, privateKeyPassword, algorithm));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addKeyPairStore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, byte[] privateKey, String publicKeyPath, String privateKeyPassword, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getKeyPairStore(requestInfo, privateKey, publicKeyPath, privateKeyPassword, algorithm, (BYOKRequestParams)null);
    }

    public static KeyPairStore getKeyPairStore(RequestInfo requestInfo, byte[] privateKey, String publicKeyPath, String privateKeyPassword, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && privateKey != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(privateKey);
            Serializable o = requestInfo.getRequestConfig().getKeyPairStore(keyParam);
            if (o instanceof KeyPairStore) {
                return (KeyPairStore)o;
            }
        }
        KeyPairStore k = null;
        k = requestParams != null ? (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKey, publicKeyPath, privateKeyPassword, algorithm, requestParams) : new KeyPairStore(privateKey, publicKeyPath, privateKeyPassword, algorithm, requestParams)) : (cacheEnabled ? (KeyPairStore)keyPairStoreCache.getKeystoreAndCreateIfNotExists(privateKey, publicKeyPath, privateKeyPassword, algorithm) : new KeyPairStore(privateKey, publicKeyPath, privateKeyPassword, algorithm));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addKeyPairStore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static PublicKeyStore getPublicKeyStore(RequestInfo requestInfo, String publicKeyPath, String algorithm) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && publicKeyPath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getPublicKeyStore(publicKeyPath)) instanceof PublicKeyStore) {
            return (PublicKeyStore)o;
        }
        PublicKeyStore k = null;
        k = cacheEnabled ? (PublicKeyStore)publicKeyStoreCache.getKeystoreAndCreateIfNotExists(publicKeyPath, algorithm) : new PublicKeyStore(publicKeyPath, algorithm);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addPublicKeyStore(publicKeyPath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static PublicKeyStore getPublicKeyStore(RequestInfo requestInfo, byte[] publicKey, String algorithm) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && publicKey != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(publicKey);
            Serializable o = requestInfo.getRequestConfig().getPublicKeyStore(keyParam);
            if (o instanceof PublicKeyStore) {
                return (PublicKeyStore)o;
            }
        }
        PublicKeyStore k = null;
        k = cacheEnabled ? (PublicKeyStore)publicKeyStoreCache.getKeystoreAndCreateIfNotExists(publicKey, algorithm) : new PublicKeyStore(publicKey, algorithm);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addPublicKeyStore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, String secretKeyPath, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getSecretKeyStore(requestInfo, secretKeyPath, algorithm, (BYOKRequestParams)null);
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, String secretKeyPath, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && secretKeyPath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getSecretKeyStore(secretKeyPath)) instanceof SecretKeyStore) {
            return (SecretKeyStore)o;
        }
        SecretKeyStore k = null;
        k = requestParams != null ? (cacheEnabled ? (SecretKeyStore)secretKeyStoreCache.getKeystoreAndCreateIfNotExists(secretKeyPath, algorithm, requestParams) : new SecretKeyStore(secretKeyPath, algorithm, requestParams)) : (cacheEnabled ? (SecretKeyStore)secretKeyStoreCache.getKeystoreAndCreateIfNotExists(secretKeyPath, algorithm) : new SecretKeyStore(secretKeyPath, algorithm));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addSecretKeyStore(secretKeyPath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, byte[] secretKey, String algorithm) throws SecurityException {
        return GestoreKeystoreCache.getSecretKeyStore(requestInfo, secretKey, algorithm, (BYOKRequestParams)null);
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, byte[] secretKey, String algorithm, BYOKRequestParams requestParams) throws SecurityException {
        boolean useRequestInfo;
        String keyParam = null;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && secretKey != null;
        if (useRequestInfo) {
            keyParam = AbstractKeystoreCache.buildKeyCacheFromBytes(secretKey);
            Serializable o = requestInfo.getRequestConfig().getSecretKeyStore(keyParam);
            if (o instanceof SecretKeyStore) {
                return (SecretKeyStore)o;
            }
        }
        SecretKeyStore k = null;
        k = requestParams != null ? (cacheEnabled ? (SecretKeyStore)secretKeyStoreCache.getKeystoreAndCreateIfNotExists(secretKey, algorithm, requestParams) : new SecretKeyStore(secretKey, algorithm, requestParams)) : (cacheEnabled ? (SecretKeyStore)secretKeyStoreCache.getKeystoreAndCreateIfNotExists(secretKey, algorithm) : new SecretKeyStore(secretKey, algorithm));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addSecretKeyStore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, SecretPasswordKeyDerivationConfig config) throws SecurityException {
        return GestoreKeystoreCache.getSecretKeyStore(requestInfo, config, (BYOKRequestParams)null);
    }

    public static SecretKeyStore getSecretKeyStore(RequestInfo requestInfo, SecretPasswordKeyDerivationConfig config, BYOKRequestParams requestParams) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        if (config == null) {
            throw new SecurityException("SecretPasswordKeyDerivationConfig param undefined");
        }
        String keyParam = config.toKey();
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && config != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getSecretKeyStore(keyParam)) instanceof SecretKeyStore) {
            return (SecretKeyStore)o;
        }
        SecretKeyStore k = null;
        k = requestParams != null ? (cacheEnabled ? (SecretKeyStore)secretKeyStoreCache.getKeystoreAndCreateIfNotExists(keyParam, config, requestParams) : new SecretKeyStore(config, requestParams)) : (cacheEnabled ? (SecretKeyStore)secretKeyStoreCache.getKeystoreAndCreateIfNotExists(keyParam, config) : new SecretKeyStore(config));
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addSecretKeyStore(keyParam, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static RemoteStore getRemoteStore(RequestInfo requestInfo, String keyId, RemoteKeyType keyType, RemoteStoreConfig remoteStoreConfig, IRemoteStoreProvider provider) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        String keyCache = RemoteStoreCache.getKeyCache(remoteStoreConfig, keyId, keyType);
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && keyCache != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getRemoteStore(keyCache)) instanceof RemoteStore) {
            return (RemoteStore)o;
        }
        RemoteStore k = null;
        k = cacheEnabled ? (RemoteStore)remoteStoreCache.getKeystoreAndCreateIfNotExists(keyCache, keyId, keyType, remoteStoreConfig, provider) : new RemoteStore(keyId, keyType, remoteStoreConfig, provider);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addRemoteStore(keyCache, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static void removeRemoteStore(RequestInfo requestInfo, String keyId, RemoteKeyType keyType, RemoteStoreConfig remoteStoreConfig) throws SecurityException {
        boolean useRequestInfo;
        String keyCache = RemoteStoreCache.getKeyCache(remoteStoreConfig, keyId, keyType);
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && keyCache != null;
        if (useRequestInfo) {
            requestInfo.getRequestConfig().removeRemoteStore(keyCache);
        }
        if (cacheEnabled) {
            remoteStoreCache.removeObjectFromCache(keyCache);
        }
    }

    public static List<String> keysRemoteStore() throws SecurityException {
        List<String> l = null;
        if (cacheEnabled) {
            return remoteStoreCache.keys();
        }
        return l;
    }

    public static org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo getRemoteStoreClientInfo(RequestInfo requestInfo, String keyId, String clientId, RemoteStoreConfig remoteStoreConfig, IRemoteStoreProvider provider, org.openspcoop2.utils.Map<Object> context) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        String keyCache = RemoteStoreClientInfoCache.getKeyCache(remoteStoreConfig, keyId);
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && keyCache != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getRemoteStoreClientInfo(keyCache)) instanceof org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo) {
            return (org.openspcoop2.utils.certificate.remote.RemoteStoreClientInfo)o;
        }
        RemoteStoreClientInfo k = null;
        k = cacheEnabled ? (RemoteStoreClientInfo)remoteStoreClientInfoCache.getKeystoreAndCreateIfNotExists(keyCache, keyId, clientId, remoteStoreConfig, provider, context) : new RemoteStoreClientInfo(keyId, clientId, remoteStoreConfig, provider, context);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addRemoteStoreClientInfo(keyCache, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k.getClientInfo();
    }

    public static void removeRemoteStoreClientInfo(RequestInfo requestInfo, String keyId, RemoteStoreConfig remoteStoreConfig) throws SecurityException {
        boolean useRequestInfo;
        String keyCache = RemoteStoreClientInfoCache.getKeyCache(remoteStoreConfig, keyId);
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && keyCache != null;
        if (useRequestInfo) {
            requestInfo.getRequestConfig().removeRemoteStoreClientInfo(keyCache);
        }
        if (cacheEnabled) {
            remoteStoreClientInfoCache.removeObjectFromCache(keyCache);
        }
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        if (cacheEnabled) {
            if (options != null && options.length > 0) {
                ArrayList<HttpOptions> list = new ArrayList<HttpOptions>();
                list.addAll(Arrays.asList(options));
                k = (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, list);
            } else {
                k = (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, new Object[0]);
            }
        } else {
            k = new HttpStore(endpoint, options);
        }
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Integer connectionTimeout, Integer readTimeout, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        k = cacheEnabled ? (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, connectionTimeout, readTimeout, options) : new HttpStore(endpoint, connectionTimeout, readTimeout, options);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, MerlinTruststore trustStoreSsl, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        k = cacheEnabled ? (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, trustStoreSsl, options) : new HttpStore(endpoint, trustStoreSsl, options);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, MerlinTruststore trustStoreSsl, CRLCertstore crlTrustStoreSsl, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        k = cacheEnabled ? (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, trustStoreSsl, crlTrustStoreSsl, options) : new HttpStore(endpoint, trustStoreSsl, crlTrustStoreSsl, options);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Integer connectionTimeout, Integer readTimeout, MerlinTruststore trustStoreSsl, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        k = cacheEnabled ? (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, connectionTimeout, readTimeout, trustStoreSsl, options) : new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, options);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Integer connectionTimeout, Integer readTimeout, MerlinTruststore trustStoreSsl, CRLCertstore crlTrustStoreSsl, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        k = cacheEnabled ? (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, connectionTimeout, readTimeout, trustStoreSsl, crlTrustStoreSsl, options) : new HttpStore(endpoint, connectionTimeout, readTimeout, trustStoreSsl, crlTrustStoreSsl, options);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Boolean trustAll, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        k = cacheEnabled ? (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, trustAll, options) : new HttpStore(endpoint, trustAll, options);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static HttpStore getHttpStore(RequestInfo requestInfo, String endpoint, Integer connectionTimeout, Integer readTimeout, Boolean trustAll, HttpOptions ... options) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && endpoint != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getHttpStore(endpoint)) instanceof HttpStore) {
            return (HttpStore)o;
        }
        HttpStore k = null;
        k = cacheEnabled ? (HttpStore)httpStoreCache.getKeystoreAndCreateIfNotExists(endpoint, connectionTimeout, readTimeout, trustAll, options) : new HttpStore(endpoint, connectionTimeout, readTimeout, trustAll, options);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addHttpStore(endpoint, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static BYOKStore getBYOKStore(RequestInfo requestInfo, BYOKInstance instance) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        if (instance == null) {
            throw new SecurityException("Instance is null");
        }
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && instance != null && instance.getKeyCache() != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getBYOKStore(instance.getKeyCache())) instanceof BYOKStore) {
            return (BYOKStore)o;
        }
        BYOKStore k = null;
        k = cacheEnabled ? (BYOKStore)byokStoreCache.getKeystoreAndCreateIfNotExists(instance.getKeyCache(), instance) : new BYOKStore(instance.getKeyCache(), instance);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addBYOKStore(instance.getKeyCache(), (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static CRLCertstore getCRLCertstore(RequestInfo requestInfo, String crlPath) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && crlPath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getCRLCertstore(crlPath)) instanceof CRLCertstore) {
            return (CRLCertstore)o;
        }
        CRLCertstore k = null;
        k = cacheEnabled ? (CRLCertstore)crlCertstoreCache.getKeystoreAndCreateIfNotExists(crlPath, new Object[0]) : new CRLCertstore(crlPath);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addCRLCertstore(crlPath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static CRLCertstore getCRLCertstore(RequestInfo requestInfo, String crlPath, Map<String, byte[]> localResources) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && crlPath != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getCRLCertstore(crlPath)) instanceof CRLCertstore) {
            return (CRLCertstore)o;
        }
        CRLCertstore k = null;
        k = cacheEnabled ? (CRLCertstore)crlCertstoreCache.getKeystoreAndCreateIfNotExists(crlPath, localResources) : new CRLCertstore(crlPath, localResources);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addCRLCertstore(crlPath, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static SSLSocketFactory getSSLSocketFactory(RequestInfo requestInfo, SSLConfig sslConfig) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        String sslConfigKey = sslConfig.toString();
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && sslConfigKey != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getSSLSocketFactory(sslConfigKey)) instanceof SSLSocketFactory) {
            return (SSLSocketFactory)o;
        }
        SSLSocketFactory k = null;
        k = cacheEnabled ? (SSLSocketFactory)sslSocketFactoryCache.getKeystoreAndCreateIfNotExists(sslConfigKey, requestInfo, sslConfig) : new SSLSocketFactory(requestInfo, sslConfig);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addSSLSocketFactory(sslConfigKey, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static ExternalResource getExternalResource(RequestInfo requestInfo, String resource, ExternalResourceConfig externalConfig) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && resource != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getExternalResource(resource)) instanceof ExternalResource) {
            return (ExternalResource)o;
        }
        ExternalResource k = null;
        k = cacheEnabled ? (ExternalResource)externalResourceCache.getKeystoreAndCreateIfNotExists(resource, externalConfig) : new ExternalResource(resource, resource, externalConfig);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addExternalResource(resource, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static SSLConfigProps getSSLConfigProps(RequestInfo requestInfo, String resource, boolean sslConfigRequired) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && resource != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getSSLConfigProps(resource)) instanceof SSLConfigProps) {
            return (SSLConfigProps)o;
        }
        SSLConfigProps k = null;
        k = cacheEnabled ? (SSLConfigProps)sslConfigPropsCache.getKeystoreAndCreateIfNotExists(resource, sslConfigRequired) : new SSLConfigProps(resource, sslConfigRequired);
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addSSLConfigProps(resource, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }

    public static OCSPResponse getOCSPResponse(RequestInfo requestInfo, IOCSPValidator ocspValidator, X509Certificate cert) throws SecurityException {
        if (cert == null) {
            throw new SecurityException("Certificate is null");
        }
        CertificateInfo certInfo = new CertificateInfo(cert, "cer");
        return GestoreKeystoreCache.getOCSPResponse(requestInfo, ocspValidator, certInfo);
    }

    public static OCSPResponse getOCSPResponse(RequestInfo requestInfo, IOCSPValidator ocspValidator, CertificateInfo cert) throws SecurityException {
        Serializable o;
        boolean useRequestInfo;
        if (cert == null) {
            throw new SecurityException("Certificate is null");
        }
        String pem = null;
        try {
            pem = cert.getPEMEncoded();
        }
        catch (Exception t) {
            throw new SecurityException(t.getMessage(), t);
        }
        if (pem == null) {
            throw new SecurityException("Certificate PEM Encoding is null");
        }
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null;
        if (useRequestInfo && (o = requestInfo.getRequestConfig().getOCSPResponse(pem)) instanceof OCSPResponse) {
            return (OCSPResponse)o;
        }
        OCSPResponse k = null;
        k = cacheEnabled ? (OCSPResponse)ocspResponseCache.getKeystoreAndCreateIfNotExists(pem, ocspValidator, cert.getCertificate()) : new OCSPResponse(ocspValidator, cert.getCertificate());
        if (useRequestInfo) {
            requestInfo.getRequestConfig().addOCSPResponse(pem, (Serializable)k, requestInfo.getIdTransazione());
        }
        return k;
    }
}

