/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import java.security.cert.X509Certificate;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.keystore.OCSPResponse;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.certificate.ocsp.OCSPValidatorImpl;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.OCSPResponseException;
import org.openspcoop2.utils.transport.http.OCSPTrustManager;

public class GestoreOCSPValidator
implements IOCSPValidator {
    private OCSPValidatorImpl validatorImpl;
    private RequestInfo requestInfo;

    public GestoreOCSPValidator(RequestInfo requestInfo, LoggerBuffer log, String crlInput, String configType, IOCSPResourceReader ocspResourceReader) throws UtilsException {
        this.validatorImpl = new OCSPValidatorImpl(log, crlInput, configType, ocspResourceReader);
        this.requestInfo = requestInfo;
    }

    public GestoreOCSPValidator(RequestInfo requestInfo, LoggerBuffer log, KeyStore trustStore, String crlInput, String configType, IOCSPResourceReader ocspResourceReader) throws UtilsException {
        this.validatorImpl = new OCSPValidatorImpl(log, trustStore, crlInput, configType, ocspResourceReader);
        this.requestInfo = requestInfo;
    }

    public void valid(X509Certificate cert) throws UtilsException {
        OCSPResponse response = null;
        try {
            response = GestoreKeystoreCache.getOCSPResponse(this.requestInfo, (IOCSPValidator)this.validatorImpl, cert);
            if (response == null) {
                throw new UtilsException("OCSPResponse unavailable");
            }
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), (Throwable)t);
        }
        if (!response.isValid()) {
            if (response.getException() == null) {
                throw new UtilsException("Invalid Certificate");
            }
            if (response.getException() instanceof OCSPResponseException) {
                throw (OCSPResponseException)response.getException();
            }
            if (response.getException() instanceof UtilsException) {
                throw (UtilsException)response.getException();
            }
            throw new UtilsException(response.getException().getMessage(), response.getException());
        }
    }

    public KeyStore getTrustStore() {
        return this.validatorImpl.getTrustStore();
    }

    public void setTrustStore(KeyStore keystore) {
        this.validatorImpl.setTrustStore(keystore);
    }

    public OCSPTrustManager getOCSPTrustManager() {
        return this.validatorImpl.getOCSPTrustManager();
    }

    public void setOCSPTrustManager(OCSPTrustManager trustManager) {
        this.validatorImpl.setOCSPTrustManager(trustManager);
    }

    public OCSPConfig getOcspConfig() {
        return this.validatorImpl.getOcspConfig();
    }
}

