/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;

public class MerlinTruststoreCache
extends AbstractKeystoreCache<MerlinTruststore> {
    @Override
    public MerlinTruststore createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 0) {
            String propertyFilePath = key;
            return new MerlinTruststore(propertyFilePath);
        }
        if (params.length == 2) {
            if (!(params[0] instanceof String)) {
                throw new SecurityException("Param[0] must be String (tipoStore)");
            }
            if (params[1] != null && !(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String (passwordStore)");
            }
            String pathStore = key;
            String tipoStore = (String)params[0];
            String passwordStore = (String)params[1];
            return new MerlinTruststore(pathStore, tipoStore, passwordStore);
        }
        if (params.length == 3) {
            if (!(params[0] instanceof byte[])) {
                throw new SecurityException("Param[0] must be byte[] (store)");
            }
            if (!(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String (tipoStore)");
            }
            if (params[2] != null && !(params[2] instanceof String)) {
                throw new SecurityException("Param[2] must be String (passwordStore)");
            }
            byte[] store = (byte[])params[0];
            String tipoStore = (String)params[1];
            String passwordStore = (String)params[2];
            return new MerlinTruststore(store, tipoStore, passwordStore);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    @Override
    public String getPrefixKey() {
        return "Truststore ";
    }
}

