/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore.cache;

import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.SecretKeyStore;
import org.openspcoop2.security.keystore.SecretPasswordKeyDerivationConfig;
import org.openspcoop2.security.keystore.cache.AbstractKeystoreCache;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;

public class SecretKeyStoreCache
extends AbstractKeystoreCache<SecretKeyStore> {
    @Override
    public SecretKeyStore createKeystore(String key, Object ... params) throws SecurityException {
        if (params == null) {
            throw new SecurityException("Params is null");
        }
        if (params.length == 1) {
            if (params[0] instanceof String) {
                return this.createFromPath(key, params);
            }
            return this.createFromPasswordKeyDerivation(params);
        }
        if (params.length == 2) {
            if (params[0] instanceof String) {
                return this.createFromPath(key, params);
            }
            if (params[0] instanceof SecretPasswordKeyDerivationConfig) {
                return this.createFromPasswordKeyDerivation(params);
            }
            return this.createFromByteArray(params);
        }
        if (params.length == 3) {
            return this.createFromByteArray(params);
        }
        throw new SecurityException("Params [lenght:" + params.length + "] not supported");
    }

    private SecretKeyStore createFromPath(String key, Object ... params) throws SecurityException {
        if (params[0] instanceof String) {
            String pathSecretKey = key;
            String algorithm = (String)params[0];
            if (params.length == 2) {
                if (!(params[1] instanceof BYOKRequestParams)) {
                    throw new SecurityException("Param[1] must be BYOKRequestParams");
                }
                BYOKRequestParams requestParams = (BYOKRequestParams)params[1];
                return new SecretKeyStore(pathSecretKey, algorithm, requestParams);
            }
            return new SecretKeyStore(pathSecretKey, algorithm);
        }
        throw new SecurityException("Param[0] must be String (algorithm)");
    }

    private SecretKeyStore createFromByteArray(Object ... params) throws SecurityException {
        if (params[0] instanceof byte[]) {
            if (!(params[1] instanceof String)) {
                throw new SecurityException("Param[1] must be String (algorithm)");
            }
            byte[] secretKey = (byte[])params[0];
            String algorithm = (String)params[1];
            if (params.length == 3) {
                if (!(params[2] instanceof BYOKRequestParams)) {
                    throw new SecurityException("Param[2] must be BYOKRequestParams");
                }
                BYOKRequestParams requestParams = (BYOKRequestParams)params[2];
                return new SecretKeyStore(secretKey, algorithm, requestParams);
            }
            return new SecretKeyStore(secretKey, algorithm);
        }
        throw new SecurityException("Param[0] must be byte[] (secretKey)");
    }

    private SecretKeyStore createFromPasswordKeyDerivation(Object ... params) throws SecurityException {
        if (params[0] instanceof SecretPasswordKeyDerivationConfig) {
            SecretPasswordKeyDerivationConfig secretPasswordKeyDerivationConfig = (SecretPasswordKeyDerivationConfig)params[0];
            if (params.length == 2) {
                if (!(params[1] instanceof BYOKRequestParams)) {
                    throw new SecurityException("Param[1] must be BYOKRequestParams");
                }
                BYOKRequestParams requestParams = (BYOKRequestParams)params[1];
                return new SecretKeyStore(secretPasswordKeyDerivationConfig, requestParams);
            }
            return new SecretKeyStore(secretPasswordKeyDerivationConfig);
        }
        throw new SecurityException("Param[0] must be SecretPasswordKeyDerivationConfig");
    }

    @Override
    public String getPrefixKey() {
        return "SecretKey ";
    }
}

