/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageRole;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.IMessageSecurityReceiver;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.utils.io.Base64Utilities;

public abstract class AbstractRESTMessageSecurityReceiver
implements IMessageSecurityReceiver {
    private String signatureDetachedHeader = null;
    private String signatureDetachedPropertyUrl = null;

    @Override
    public boolean checkExistsWSSecurityHeader() {
        return false;
    }

    @Override
    public List<Reference> getDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2SoapMessage message) throws SecurityException {
        return null;
    }

    @Override
    public Map<QName, QName> checkEncryptSignatureParts(MessageSecurityContext messageSecurityContext, List<Reference> elementsToClean, OpenSPCoop2SoapMessage message, List<SubErrorCodeSecurity> codiciErrore) throws SecurityException {
        return null;
    }

    @Override
    public void checkEncryptionPartElements(Map<QName, QName> notResolved, OpenSPCoop2SoapMessage message, List<SubErrorCodeSecurity> erroriRilevati) throws SecurityException {
    }

    @Override
    public void cleanDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2SoapMessage message, List<Reference> elementsToClean, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws SecurityException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String readDetachedSignatureFromMessage(Map<String, Object> map, OpenSPCoop2RestMessage<?> restMessage, String descriptionEngine) throws SecurityException {
        String detachedSignature = null;
        String mode = (String)map.get("signatureMode");
        this.signatureDetachedHeader = (String)map.get("signatureDetachedHeader");
        if (this.signatureDetachedHeader == null || "".equals(this.signatureDetachedHeader.trim())) {
            this.signatureDetachedHeader = null;
            if (!MessageRole.REQUEST.equals((Object)restMessage.getMessageRole())) throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") require 'signatureDetachedHeader' property");
            this.signatureDetachedPropertyUrl = (String)map.get("signatureDetachedPropertyURL");
            if (this.signatureDetachedPropertyUrl == null || "".equals(this.signatureDetachedPropertyUrl.trim())) {
                this.signatureDetachedPropertyUrl = null;
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") require 'signatureDetachedHeader'/'signatureDetachedPropertyURL' property");
            }
            if (restMessage.getTransportRequestContext() == null || restMessage.getTransportRequestContext().getParameters() == null || restMessage.getTransportRequestContext().getParameters().size() <= 0) {
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") property url '" + this.signatureDetachedPropertyUrl + "' not found (properties url not exists)");
            }
            detachedSignature = restMessage.getTransportRequestContext().getParameterFirstValue(this.signatureDetachedPropertyUrl);
            if (detachedSignature == null) {
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") property url '" + this.signatureDetachedPropertyUrl + "' not found");
            }
        } else {
            if (MessageRole.REQUEST.equals((Object)restMessage.getMessageRole())) {
                if (restMessage.getTransportRequestContext() == null || restMessage.getTransportRequestContext().getHeaders() == null || restMessage.getTransportRequestContext().getHeaders().size() <= 0) {
                    throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") header '" + this.signatureDetachedHeader + "' not found (header empty)");
                }
                detachedSignature = restMessage.getTransportRequestContext().getHeaderFirstValue(this.signatureDetachedHeader);
            } else {
                if (restMessage.getTransportResponseContext() == null || restMessage.getTransportResponseContext().getHeaders() == null || restMessage.getTransportResponseContext().getHeaders().size() <= 0) {
                    throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") header '" + this.signatureDetachedHeader + "' not found (header empty)");
                }
                detachedSignature = restMessage.getTransportResponseContext().getHeaderFirstValue(this.signatureDetachedHeader);
            }
            if (detachedSignature == null) {
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") header '" + this.signatureDetachedHeader + "' not found");
            }
        }
        boolean base64Detached = SecurityConstants.SIGNATURE_DETACHED_BASE64_DEFAULT;
        String tmpBase64 = (String)map.get("signatureDetachedBase64");
        if (tmpBase64 != null && !"".equals(tmpBase64)) {
            try {
                base64Detached = Boolean.parseBoolean(tmpBase64);
            }
            catch (Exception e) {
                throw new SecurityException(descriptionEngine + " (mode:" + mode + " message-role:" + String.valueOf(restMessage.getMessageRole()) + ") property 'signatureDetachedBase64' with wrong value (expected true/false): " + e.getMessage(), e);
            }
        }
        if (!base64Detached) return detachedSignature;
        return new String(Base64Utilities.decode((String)detachedSignature));
    }

    protected void deleteDetachedSignatureFromMessage(OpenSPCoop2RestMessage<?> restMessage, String descriptionEngine) throws SecurityException {
        if (this.signatureDetachedHeader != null) {
            if (MessageRole.REQUEST.equals((Object)restMessage.getMessageRole())) {
                if (restMessage.getTransportRequestContext() == null || restMessage.getTransportRequestContext().getHeaders() == null || restMessage.getTransportRequestContext().getHeaders().size() <= 0) {
                    return;
                }
                restMessage.getTransportRequestContext().removeHeader(this.signatureDetachedHeader);
            } else {
                if (restMessage.getTransportResponseContext() == null || restMessage.getTransportResponseContext().getHeaders() == null || restMessage.getTransportResponseContext().getHeaders().size() <= 0) {
                    return;
                }
                restMessage.getTransportResponseContext().removeHeader(this.signatureDetachedHeader);
            }
        } else if (this.signatureDetachedPropertyUrl != null) {
            if (restMessage.getTransportRequestContext() == null || restMessage.getTransportRequestContext().getParameters() == null || restMessage.getTransportRequestContext().getParameters().size() <= 0) {
                return;
            }
            restMessage.getTransportRequestContext().removeParameter(this.signatureDetachedPropertyUrl);
        } else {
            throw new SecurityException(descriptionEngine + "; this method required preProcess detached signature");
        }
    }
}

