/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.engine;

import java.lang.reflect.Constructor;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityContextParameters;
import org.openspcoop2.security.message.MessageSecurityDigestReader;
import org.openspcoop2.security.message.constants.SecurityType;
import org.openspcoop2.utils.digest.IDigestReader;
import org.slf4j.Logger;

public class MessageSecurityFactory {
    public static String messageSecurityContextImplClass = "org.openspcoop2.security.message.engine.MessageSecurityContext_impl";
    public static String messageSecurityDigestReaderImplClass = "org.openspcoop2.security.message.engine.MessageSecurityDigestReader_impl";

    public static void setMessageSecurityContextClassName(String messageSecurityContextImplClass) {
        if (messageSecurityContextImplClass != null) {
            MessageSecurityFactory.messageSecurityContextImplClass = messageSecurityContextImplClass;
        }
    }

    public static void setMessageSecurityDigestReaderClassName(String messageSecurityDigestReader) {
        if (messageSecurityDigestReader != null) {
            messageSecurityDigestReaderImplClass = messageSecurityDigestReader;
        }
    }

    public MessageSecurityContext getMessageSecurityContext(MessageSecurityContextParameters messageSecurityContextParameters) throws SecurityException {
        try {
            Constructor<?> constructor = Class.forName(messageSecurityContextImplClass).getConstructor(MessageSecurityContextParameters.class);
            return (MessageSecurityContext)constructor.newInstance(messageSecurityContextParameters);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public static IDigestReader getMessageSecurityDigestReader(OpenSPCoop2MessageFactory messageFactory, SecurityType securityType, Logger log) throws SecurityException {
        try {
            Constructor<?> constructor = Class.forName(messageSecurityDigestReaderImplClass).getConstructor(Logger.class);
            MessageSecurityDigestReader digestReader = (MessageSecurityDigestReader)constructor.newInstance(log);
            return digestReader.getDigestReader(messageFactory, securityType);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

