/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.jose;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.security.message.AbstractRESTMessageSecurityReceiver;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.jose.JOSEUtils;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.KeystoreUtils;
import org.openspcoop2.security.message.utils.PropertiesUtils;
import org.openspcoop2.security.message.utils.SignatureBean;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.remote.IRemoteStoreProvider;
import org.openspcoop2.utils.certificate.remote.RemoteKeyType;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.security.CertificateValidityCheck;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonDecrypt;
import org.openspcoop2.utils.security.JsonVerifySignature;
import org.openspcoop2.utils.transport.http.IOCSPValidator;

public class MessageSecurityReceiver_jose
extends AbstractRESTMessageSecurityReceiver {
    private JOSESerialization joseSerialization = null;
    private boolean detached = false;
    private JsonVerifySignature jsonVerifierSignature = null;
    private JsonDecrypt jsonDecrypt = null;

    @Override
    public void process(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message messageParam, Busta busta, org.openspcoop2.utils.Map<Object> ctx) throws SecurityException {
        this.process(messageSecurityContext, messageParam, busta, false, null, ctx);
    }

    public void process(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message messageParam, Busta busta, boolean bufferMessageReadOnly, String idTransazione, org.openspcoop2.utils.Map<Object> ctx) throws SecurityException {
        block109: {
            boolean signatureProcess = false;
            boolean encryptProcess = false;
            try {
                CertificateValidityCheck c;
                if (!ServiceBinding.REST.equals((Object)messageParam.getServiceBinding())) {
                    throw new SecurityException("JOSE Engine usable only with REST Binding");
                }
                if (!MessageType.JSON.equals((Object)messageParam.getMessageType())) {
                    throw new SecurityException("JOSE Engine usable only with REST Binding and a json message, found: " + String.valueOf(messageParam.getMessageType()));
                }
                OpenSPCoop2RestJsonMessage restJsonMessage = messageParam.castAsRestJson();
                RequestInfo requestInfo = null;
                if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
                }
                boolean encrypt = false;
                boolean signature = false;
                String[] actions = ((String)messageSecurityContext.getIncomingProperties().get("action")).split(" ");
                for (int i = 0; i < actions.length; ++i) {
                    if (SecurityConstants.isActionEncryption(actions[i].trim()) || SecurityConstants.isActionDecryption(actions[i].trim())) {
                        encrypt = true;
                        continue;
                    }
                    if ("Signature".equals(actions[i].trim())) {
                        signature = true;
                        continue;
                    }
                    throw new SecurityException("JOSE Engine; action '" + actions[i] + "' unsupported");
                }
                if (encrypt && signature) {
                    throw new SecurityException("JOSE Engine usable only with one function beetwen encrypt or signature");
                }
                if (!encrypt && !signature) {
                    throw new SecurityException("JOSE Engine require one function beetwen encrypt or signature");
                }
                if (signature) {
                    String signatureOCSP;
                    String signatureCRL;
                    CertificateValidityCheck c2;
                    String signatureValidityCheck;
                    String mode = (String)messageSecurityContext.getIncomingProperties().get("signatureMode");
                    if (mode == null || "".equals(mode.trim())) {
                        throw new SecurityException("JOSE SignatureVerifier Engine require 'signatureMode' property");
                    }
                    try {
                        this.joseSerialization = JOSEUtils.toJOSESerialization(mode);
                    }
                    catch (Exception e) {
                        throw new SecurityException("JOSE SignatureVerifier Engine, 'signatureMode' property error: " + e.getMessage(), e);
                    }
                    JWTOptions options = new JWTOptions(this.joseSerialization);
                    boolean useHeaders = JOSEUtils.useJwtHeadersMap(messageSecurityContext.getIncomingProperties(), options);
                    SignatureBean bean = null;
                    NotFoundException notFound = null;
                    try {
                        bean = PropertiesUtils.getReceiverSignatureBean(messageSecurityContext);
                    }
                    catch (NotFoundException e) {
                        notFound = e;
                    }
                    if (bean != null) {
                        Properties signatureProperties = bean.getProperties();
                        boolean throwError = true;
                        Map dynamicMap = Costanti.readDynamicMap(ctx);
                        JOSEUtils.injectKeystore(requestInfo, dynamicMap, signatureProperties, messageSecurityContext.getLog(), throwError);
                        this.jsonVerifierSignature = new JsonVerifySignature(signatureProperties, options);
                    } else if (useHeaders) {
                        if (JOSEUtils.isRemoteStore(messageSecurityContext.getIncomingProperties())) {
                            IRemoteStoreProvider provider = (IRemoteStoreProvider)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.remoteStoreProvider");
                            RemoteKeyType keyType = (RemoteKeyType)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.remoteStoreKeyType");
                            RemoteStoreConfig config = (RemoteStoreConfig)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.remoteStoreConfig");
                            this.jsonVerifierSignature = new JsonVerifySignature(provider, keyType, config, options);
                        } else if (JOSEUtils.isJWKSetTrustStore(messageSecurityContext.getIncomingProperties())) {
                            jsonWebKeys = null;
                            JWKSet jkwSet = JOSEUtils.readTrustStoreJwtJsonWebKeysCert(requestInfo, messageSecurityContext.getIncomingProperties());
                            if (jkwSet != null) {
                                jsonWebKeys = jkwSet.getJsonWebKeys();
                            }
                            this.jsonVerifierSignature = new JsonVerifySignature(jsonWebKeys, options);
                        } else if (JOSEUtils.isPublicKeyTrustStore(messageSecurityContext.getIncomingProperties())) {
                            jsonWebKeys = null;
                            JWKSet jkwSet = JOSEUtils.readTrustStorePublicKey(requestInfo, messageSecurityContext.getIncomingProperties());
                            if (jkwSet != null) {
                                jsonWebKeys = jkwSet.getJsonWebKeys();
                            }
                            this.jsonVerifierSignature = new JsonVerifySignature(jsonWebKeys, options);
                        } else {
                            KeyStore trustStore = JOSEUtils.readTrustStoreJwtX509Cert(requestInfo, messageSecurityContext.getIncomingProperties());
                            KeyStore trustStoreSsl = JOSEUtils.readTrustStoreSsl(requestInfo, messageSecurityContext.getIncomingProperties());
                            this.jsonVerifierSignature = new JsonVerifySignature(trustStoreSsl, trustStore, options);
                        }
                    } else {
                        KeyStore signatureKS = null;
                        KeyStore signatureTrustStoreKS = null;
                        JWKSet signatureJWKSet = null;
                        String aliasSignatureUser = null;
                        try {
                            bean = KeystoreUtils.getReceiverSignatureBean(messageSecurityContext, ctx);
                        }
                        catch (Exception e) {
                            if (notFound != null) {
                                messageSecurityContext.getLog().error(e.getMessage(), (Throwable)e);
                                throw notFound;
                            }
                            throw e;
                        }
                        signatureKS = bean.getKeystore();
                        signatureTrustStoreKS = bean.getTruststore();
                        signatureJWKSet = bean.getJwkSet();
                        aliasSignatureUser = bean.getUser();
                        if (signatureKS == null && signatureTrustStoreKS == null && signatureJWKSet == null) {
                            throw new SecurityException("JOSE SignatureVerifier Engine require truststore");
                        }
                        if (aliasSignatureUser == null) {
                            throw new SecurityException("JOSE SignatureVerifier Engine require alias certificate");
                        }
                        String signatureAlgorithm = (String)messageSecurityContext.getIncomingProperties().get("signatureAlgorithm");
                        if (signatureAlgorithm == null || "".equals(signatureAlgorithm.trim())) {
                            throw new SecurityException("JOSE SignatureVerifier Engine require 'signatureAlgorithm' property");
                        }
                        String symmetricKeyParam = (String)messageSecurityContext.getIncomingProperties().get("symmetricKey");
                        boolean symmetricKey = false;
                        if (symmetricKeyParam != null) {
                            symmetricKey = "true".equalsIgnoreCase(symmetricKeyParam);
                        }
                        this.jsonVerifierSignature = signatureTrustStoreKS != null ? new JsonVerifySignature(signatureTrustStoreKS, aliasSignatureUser, signatureAlgorithm, options) : (signatureKS != null ? new JsonVerifySignature(signatureKS, aliasSignatureUser, signatureAlgorithm, options) : new JsonVerifySignature(signatureJWKSet.getJsonWebKeys(), symmetricKey, aliasSignatureUser, signatureAlgorithm, options));
                    }
                    String signatureDetachedParam = (String)messageSecurityContext.getIncomingProperties().get("signatureDetached");
                    if (signatureDetachedParam != null) {
                        this.detached = "true".equalsIgnoreCase(signatureDetachedParam);
                    }
                    String detachedSignature = null;
                    if (this.detached) {
                        detachedSignature = this.readDetachedSignatureFromMessage(messageSecurityContext.getIncomingProperties(), (OpenSPCoop2RestMessage<?>)restJsonMessage, "JOSE SignatureVerifier Engine");
                    }
                    if ((signatureValidityCheck = (String)messageSecurityContext.getIncomingProperties().get("signatureValidityCheck")) != null && StringUtils.isNotEmpty((CharSequence)signatureValidityCheck) && (c2 = CertificateValidityCheck.parseCertificateValidityCheck((String)signatureValidityCheck)) != null) {
                        this.jsonVerifierSignature.setValidityCheck(c2);
                    }
                    if ((signatureCRL = (String)messageSecurityContext.getIncomingProperties().get("signatureCRL")) == null || "".equals(signatureCRL)) {
                        signatureCRL = (String)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.crl");
                    }
                    if ((signatureOCSP = (String)messageSecurityContext.getIncomingProperties().get("signatureOCSP")) == null || "".equals(signatureOCSP)) {
                        signatureOCSP = (String)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.ocsp");
                    }
                    boolean crlByOcsp = false;
                    if (this.jsonVerifierSignature.getTrustStoreCertificatiX509() != null && signatureOCSP != null && !"".equals(signatureOCSP)) {
                        LoggerBuffer lb = new LoggerBuffer();
                        lb.setLogDebug(messageSecurityContext.getLog());
                        lb.setLogError(messageSecurityContext.getLog());
                        GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                        GestoreOCSPValidator ocspValidator = null;
                        try {
                            ocspValidator = new GestoreOCSPValidator(requestInfo, lb, this.jsonVerifierSignature.getTrustStoreCertificatiX509(), signatureCRL, signatureOCSP, ocspResourceReader);
                        }
                        catch (Exception e) {
                            throw new SecurityException("JOSE SignatureVerifier Engine; ocsp initialization (policy:'" + signatureOCSP + "') failed: " + e.getMessage(), e);
                        }
                        if (ocspValidator != null) {
                            this.jsonVerifierSignature.setOcspValidatorX509((IOCSPValidator)ocspValidator);
                            GestoreOCSPValidator gOcspValidator = ocspValidator;
                            if (gOcspValidator.getOcspConfig() != null) {
                                crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                            }
                        }
                    }
                    if (signatureCRL != null && !"".equals(signatureCRL) && !crlByOcsp) {
                        CRLCertstore crlCertstore = GestoreKeystoreCache.getCRLCertstore(requestInfo, signatureCRL);
                        if (crlCertstore == null) {
                            throw new SecurityException("Process CRL '" + signatureCRL + "' failed");
                        }
                        this.jsonVerifierSignature.setCrlX509(crlCertstore.getCertStore());
                    }
                    String httpsCRL = (String)messageSecurityContext.getIncomingProperties().get("rs.security.keystore.ssl.crl");
                    String httpsOCSP = (String)messageSecurityContext.getIncomingProperties().get("rs.security.keystore.ssl.ocsp");
                    boolean httpsCrlByOcsp = false;
                    if (this.jsonVerifierSignature.getTrustStoreHttps() != null && httpsOCSP != null && !"".equals(httpsOCSP)) {
                        LoggerBuffer lb = new LoggerBuffer();
                        lb.setLogDebug(messageSecurityContext.getLog());
                        lb.setLogError(messageSecurityContext.getLog());
                        GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                        GestoreOCSPValidator ocspValidator = null;
                        try {
                            ocspValidator = new GestoreOCSPValidator(requestInfo, lb, this.jsonVerifierSignature.getTrustStoreHttps(), httpsCRL, httpsOCSP, ocspResourceReader);
                        }
                        catch (Exception e) {
                            throw new SecurityException("JOSE SignatureVerifier Engine; ocsp initialization for https (policy:'" + signatureOCSP + "') failed: " + e.getMessage(), e);
                        }
                        if (ocspValidator != null) {
                            this.jsonVerifierSignature.setOcspValidatorHttps((IOCSPValidator)ocspValidator);
                            GestoreOCSPValidator gOcspValidator = ocspValidator;
                            if (gOcspValidator.getOcspConfig() != null) {
                                httpsCrlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                            }
                        }
                    }
                    if (httpsCRL != null && !"".equals(httpsCRL) && !httpsCrlByOcsp) {
                        CRLCertstore crlCertstore = GestoreKeystoreCache.getCRLCertstore(requestInfo, httpsCRL);
                        if (crlCertstore == null) {
                            throw new SecurityException("Process CRL '" + httpsCRL + "' failed");
                        }
                        this.jsonVerifierSignature.setCrlHttps(crlCertstore.getCertStore());
                    }
                    signatureProcess = true;
                    boolean verify = false;
                    try {
                        verify = this.detached ? this.jsonVerifierSignature.verifyDetached(detachedSignature, (String)restJsonMessage.getContent(bufferMessageReadOnly, idTransazione)) : this.jsonVerifierSignature.verify((String)restJsonMessage.getContent(bufferMessageReadOnly, idTransazione));
                    }
                    catch (Exception e) {
                        throw new SecurityException("Signature verification failed: " + e.getMessage(), e);
                    }
                    if (!verify) {
                        throw new SecurityException("Signature verification failed");
                    }
                    break block109;
                }
                if (!encrypt) break block109;
                String mode = (String)messageSecurityContext.getIncomingProperties().get("decryptionMode");
                if (mode == null || "".equals(mode.trim())) {
                    throw new SecurityException("JOSE Decrypt Engine require 'decryptionMode' property");
                }
                try {
                    this.joseSerialization = JOSEUtils.toJOSESerialization(mode);
                }
                catch (Exception e) {
                    throw new SecurityException("JOSE Decrypt Engine, 'decryptionMode' property error: " + e.getMessage(), e);
                }
                JWTOptions options = new JWTOptions(this.joseSerialization);
                boolean useHeaders = JOSEUtils.useJwtHeadersMap(messageSecurityContext.getIncomingProperties(), options);
                EncryptionBean bean = null;
                NotFoundException notFound = null;
                try {
                    bean = PropertiesUtils.getReceiverEncryptionBean(messageSecurityContext);
                }
                catch (NotFoundException e) {
                    notFound = e;
                }
                if (bean != null) {
                    Properties encryptionProperties = bean.getProperties();
                    boolean throwError = true;
                    Map dynamicMap = Costanti.readDynamicMap(ctx);
                    JOSEUtils.injectKeystore(requestInfo, dynamicMap, encryptionProperties, messageSecurityContext.getLog(), throwError);
                    this.jsonDecrypt = new JsonDecrypt(encryptionProperties, options);
                } else if (useHeaders) {
                    KeyStore trustStoreSsl = JOSEUtils.readTrustStoreSsl(requestInfo, messageSecurityContext.getIncomingProperties());
                    if (JOSEUtils.isJWKSetKeyStore(messageSecurityContext.getIncomingProperties())) {
                        JsonWebKeys jsonWebKeys = null;
                        JWKSet jkwSet = JOSEUtils.readKeyStoreJwtJsonWebKeysCert(requestInfo, messageSecurityContext.getIncomingProperties());
                        if (jkwSet != null) {
                            jsonWebKeys = jkwSet.getJsonWebKeys();
                        }
                        this.jsonDecrypt = new JsonDecrypt(trustStoreSsl, jsonWebKeys, options);
                    } else {
                        KeyStore trustStore = JOSEUtils.readTrustStoreJwtX509Cert(requestInfo, messageSecurityContext.getIncomingProperties());
                        KeyStore keyStore = JOSEUtils.readKeyStoreJwtX509Cert(requestInfo, messageSecurityContext.getIncomingProperties());
                        Map<String, String> keystoreMapAliasPassword = JOSEUtils.covertToJwtX509CertMapAliasPassword(messageSecurityContext.getIncomingProperties());
                        this.jsonDecrypt = new JsonDecrypt(trustStoreSsl, trustStore, keyStore, keystoreMapAliasPassword, options);
                    }
                } else {
                    String encryptionKeyAlgorithm;
                    KeyStore encryptionKS = null;
                    boolean encryptionSymmetric = false;
                    JWKSet encryptionJWKSet = null;
                    String aliasEncryptUser = null;
                    String aliasEncryptPassword = null;
                    try {
                        bean = KeystoreUtils.getReceiverEncryptionBean(messageSecurityContext, ctx);
                    }
                    catch (Exception e) {
                        if (notFound != null) {
                            messageSecurityContext.getLog().error(e.getMessage(), (Throwable)e);
                            throw notFound;
                        }
                        throw e;
                    }
                    encryptionKS = bean.getKeystore();
                    encryptionSymmetric = bean.isEncryptionSimmetric();
                    encryptionJWKSet = bean.getJwkSet();
                    aliasEncryptUser = bean.getUser();
                    aliasEncryptPassword = bean.getPassword();
                    if (encryptionKS == null && encryptionJWKSet == null) {
                        throw new SecurityException("JOSE Decrypt Engine require keystore");
                    }
                    if (aliasEncryptUser == null) {
                        if (encryptionSymmetric) {
                            throw new SecurityException("JOSE Decrypt Engine require alias secret key");
                        }
                        throw new SecurityException("JOSE Decrypt Engine require alias private key");
                    }
                    if (encryptionKS != null && aliasEncryptPassword == null) {
                        if (encryptionSymmetric) {
                            throw new SecurityException("JOSE Decrypt Engine require password secret key");
                        }
                        boolean required = true;
                        if (KeystoreType.JKS.isType(encryptionKS.getKeystoreType())) {
                            required = DBUtils.isKeystoreJksKeyPasswordRequired();
                        } else if (KeystoreType.PKCS12.isType(encryptionKS.getKeystoreType())) {
                            required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
                        }
                        if (required) {
                            throw new SecurityException("JOSE Decrypt Engine require password private key");
                        }
                    }
                    if ((encryptionKeyAlgorithm = (String)messageSecurityContext.getIncomingProperties().get("encryptionKeyAlgorithm")) == null || "".equals(encryptionKeyAlgorithm.trim())) {
                        throw new SecurityException("JOSE Decrypt Engine require 'encryptionKeyAlgorithm' property");
                    }
                    String encryptionContentAlgorithm = (String)messageSecurityContext.getIncomingProperties().get("encryptionContentAlgorithm");
                    if (encryptionContentAlgorithm == null || "".equals(encryptionContentAlgorithm.trim())) {
                        throw new SecurityException("JOSE Decrypt Engine require 'encryptionContentAlgorithm' property");
                    }
                    this.jsonDecrypt = encryptionKS != null ? new JsonDecrypt(encryptionKS, encryptionSymmetric, aliasEncryptUser, aliasEncryptPassword, encryptionKeyAlgorithm, encryptionContentAlgorithm, options) : new JsonDecrypt(encryptionJWKSet.getJsonWebKeys(), encryptionSymmetric, aliasEncryptUser, encryptionKeyAlgorithm, encryptionContentAlgorithm, options);
                }
                String encryptionValidityCheck = (String)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.validityCheck");
                if (encryptionValidityCheck != null && StringUtils.isNotEmpty((CharSequence)encryptionValidityCheck) && (c = CertificateValidityCheck.parseCertificateValidityCheck((String)encryptionValidityCheck)) != null) {
                    this.jsonDecrypt.setValidityCheck(c);
                }
                String encryptionCRL = (String)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.crl");
                String encryptionOCSP = (String)messageSecurityContext.getIncomingProperties().get("joseUseHeaders.truststore.ocsp");
                boolean crlByOcsp = false;
                if (this.jsonDecrypt.getTrustStoreVerificaCertificatiX509() != null && encryptionOCSP != null && !"".equals(encryptionOCSP)) {
                    LoggerBuffer lb = new LoggerBuffer();
                    lb.setLogDebug(messageSecurityContext.getLog());
                    lb.setLogError(messageSecurityContext.getLog());
                    GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                    GestoreOCSPValidator ocspValidator = null;
                    try {
                        ocspValidator = new GestoreOCSPValidator(requestInfo, lb, this.jsonDecrypt.getTrustStoreVerificaCertificatiX509(), encryptionCRL, encryptionOCSP, ocspResourceReader);
                    }
                    catch (Exception e) {
                        throw new SecurityException("JOSE Decrypt Engine; ocsp initialization (policy:'" + encryptionOCSP + "') failed: " + e.getMessage(), e);
                    }
                    if (ocspValidator != null) {
                        this.jsonDecrypt.setOcspValidatorX509((IOCSPValidator)ocspValidator);
                        GestoreOCSPValidator gOcspValidator = ocspValidator;
                        if (gOcspValidator.getOcspConfig() != null) {
                            crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                        }
                    }
                }
                if (encryptionCRL != null && !"".equals(encryptionCRL) && !crlByOcsp) {
                    CRLCertstore crlCertstore = GestoreKeystoreCache.getCRLCertstore(requestInfo, encryptionCRL);
                    if (crlCertstore == null) {
                        throw new SecurityException("Process CRL '" + encryptionCRL + "' failed");
                    }
                    this.jsonDecrypt.setCrlX509(crlCertstore.getCertStore());
                }
                String httpsCRL = (String)messageSecurityContext.getIncomingProperties().get("rs.security.keystore.ssl.crl");
                String httpsOCSP = (String)messageSecurityContext.getIncomingProperties().get("rs.security.keystore.ssl.ocsp");
                boolean httpsCrlByOcsp = false;
                if (this.jsonDecrypt.getTrustStoreHttps() != null && httpsOCSP != null && !"".equals(httpsOCSP)) {
                    LoggerBuffer lb = new LoggerBuffer();
                    lb.setLogDebug(messageSecurityContext.getLog());
                    lb.setLogError(messageSecurityContext.getLog());
                    GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                    GestoreOCSPValidator ocspValidator = null;
                    try {
                        ocspValidator = new GestoreOCSPValidator(requestInfo, lb, this.jsonDecrypt.getTrustStoreHttps(), httpsCRL, httpsOCSP, ocspResourceReader);
                    }
                    catch (Exception e) {
                        throw new SecurityException("JOSE Decrypt Engine; ocsp initialization for https (policy:'" + httpsOCSP + "') failed: " + e.getMessage(), e);
                    }
                    if (ocspValidator != null) {
                        this.jsonDecrypt.setOcspValidatorHttps((IOCSPValidator)ocspValidator);
                        GestoreOCSPValidator gOcspValidator = ocspValidator;
                        if (gOcspValidator.getOcspConfig() != null) {
                            httpsCrlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                        }
                    }
                }
                if (httpsCRL != null && !"".equals(httpsCRL) && !httpsCrlByOcsp) {
                    CRLCertstore crlCertstore = GestoreKeystoreCache.getCRLCertstore(requestInfo, httpsCRL);
                    if (crlCertstore == null) {
                        throw new SecurityException("Process CRL '" + httpsCRL + "' failed");
                    }
                    this.jsonDecrypt.setCrlHttps(crlCertstore.getCertStore());
                }
                encryptProcess = true;
                try {
                    this.jsonDecrypt.decrypt((String)restJsonMessage.getContent(bufferMessageReadOnly, idTransazione));
                }
                catch (Exception e) {
                    throw new SecurityException("Decrypt failed: " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                SecurityException secException = new SecurityException(e.getMessage(), e);
                String msg = Utilities.getInnerNotEmptyMessageException((Throwable)e).getMessage();
                Throwable innerExc = Utilities.getLastInnerException((Throwable)e);
                String innerMsg = null;
                if (innerExc != null) {
                    innerMsg = innerExc.getMessage();
                }
                Object messaggio = null;
                if (msg != null) {
                    messaggio = msg;
                    if (innerMsg != null && !innerMsg.equals(msg)) {
                        messaggio = (String)messaggio + " ; " + innerMsg;
                    }
                } else if (innerMsg != null) {
                    messaggio = innerMsg;
                }
                secException.setMsgErrore((String)messaggio);
                if (signatureProcess) {
                    secException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
                } else if (encryptProcess) {
                    secException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_VALIDA);
                } else {
                    secException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA);
                }
                throw secException;
            }
        }
    }

    @Override
    public void detachSecurity(MessageSecurityContext messageSecurityContext, OpenSPCoop2RestMessage<?> messageParam) throws SecurityException {
        block8: {
            try {
                if (!ServiceBinding.REST.equals((Object)messageParam.getServiceBinding())) {
                    throw new SecurityException("JOSE Engine usable only with REST Binding");
                }
                if (!MessageType.JSON.equals((Object)messageParam.getMessageType())) {
                    throw new SecurityException("JOSE Engine usable only with REST Binding and a json message, found: " + String.valueOf(messageParam.getMessageType()));
                }
                OpenSPCoop2RestJsonMessage restJsonMessage = messageParam.castAsRestJson();
                if (this.jsonVerifierSignature != null) {
                    if (this.detached) {
                        this.deleteDetachedSignatureFromMessage((OpenSPCoop2RestMessage<?>)restJsonMessage, "JOSE SignatureVerifier Engine");
                    } else {
                        restJsonMessage.updateContent((Object)this.jsonVerifierSignature.getDecodedPayload());
                    }
                    break block8;
                }
                if (this.jsonDecrypt != null) {
                    restJsonMessage.updateContent((Object)this.jsonDecrypt.getDecodedPayload());
                    break block8;
                }
                throw new SecurityException("JOSE Engine (detach method) usable only after one function beetwen encrypt or signature");
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    public JOSESerialization getJoseSerialization() {
        return this.joseSerialization;
    }

    @Override
    public String getCertificate() throws SecurityException {
        if (this.jsonVerifierSignature != null && this.jsonVerifierSignature.getX509Certificate() != null) {
            return this.jsonVerifierSignature.getX509Certificate().getSubjectX500Principal().toString();
        }
        if (this.jsonDecrypt != null && this.jsonDecrypt.getX509Certificate() != null) {
            return this.jsonDecrypt.getX509Certificate().getSubjectX500Principal().toString();
        }
        return null;
    }

    @Override
    public X509Certificate getX509Certificate() throws SecurityException {
        if (this.jsonVerifierSignature != null) {
            return this.jsonVerifierSignature.getX509Certificate();
        }
        if (this.jsonDecrypt != null) {
            return this.jsonDecrypt.getX509Certificate();
        }
        return null;
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.jsonVerifierSignature != null) {
            return this.jsonVerifierSignature.getRsaPublicKey();
        }
        if (this.jsonDecrypt != null) {
            return this.jsonDecrypt.getRsaPublicKey();
        }
        return null;
    }

    @Override
    public String getCertificateId() {
        if (this.jsonVerifierSignature != null) {
            return this.jsonVerifierSignature.getKid();
        }
        if (this.jsonDecrypt != null) {
            return this.jsonDecrypt.getKid();
        }
        return null;
    }
}

