/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.MerlinKeystore;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.MultiKeystore;
import org.openspcoop2.security.keystore.SymmetricKeystore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.SignatureBean;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.byok.BYOKProvider;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;

public class KeystoreUtils {
    private static final String PREFIX_ALIAS = "Alias ";
    private static final String SUFFIX_NON_FORNITA = " non fornita";
    private static final String SUFFIX_NON_TROVATO_MULTIKEYSTORE = " non trovato nella configurazione MultiKeystore";

    private KeystoreUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptionBean getSenderEncryptionBean(MessageSecurityContext messageSecurityContext, Map<Object> ctx) throws UtilsException, SecurityException, FileNotFoundException, URISyntaxException {
        String storePassword;
        String storeType;
        String storePath;
        if (messageSecurityContext.getEncryptionBean() != null) {
            return messageSecurityContext.getEncryptionBean();
        }
        RequestInfo requestInfo = null;
        if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
        }
        MultiKeystore multiKeystore = null;
        JWKSet encryptionJWKSet = null;
        KeyStore encryptionKS = null;
        KeyStore encryptionTrustStoreKS = null;
        boolean encryptionSymmetric = false;
        String aliasEncryptUser = null;
        String aliasEncryptPassword = null;
        aliasEncryptUser = (String)messageSecurityContext.getOutgoingProperties().get("encryptionUser");
        if (aliasEncryptUser == null && (aliasEncryptUser = (String)messageSecurityContext.getOutgoingProperties().get("user")) == null) {
            throw new UtilsException("encryptionUser/user non fornita");
        }
        Object encryptionSymmetricObject = messageSecurityContext.getOutgoingProperties().get("encryptionSymmetricKey");
        if (encryptionSymmetricObject != null) {
            encryptionSymmetric = "true".equals(encryptionSymmetricObject);
        }
        String encryptionTrustStore = (String)messageSecurityContext.getOutgoingProperties().get("encryptionTrustStorePropFile");
        Object oEncryptionTrustStoreProperties = messageSecurityContext.getOutgoingProperties().get("encryptionTrustStorePropRefId");
        Properties encryptionTrustStoreProperties = null;
        if (oEncryptionTrustStoreProperties != null) {
            encryptionTrustStoreProperties = (Properties)oEncryptionTrustStoreProperties;
        }
        String encryptionStore = (String)messageSecurityContext.getOutgoingProperties().get("encryptionPropFile");
        Object oEncryptionStoreProperties = messageSecurityContext.getOutgoingProperties().get("encryptionPropRefId");
        Properties encryptionStoreProperties = null;
        if (oEncryptionStoreProperties != null) {
            encryptionStoreProperties = (Properties)oEncryptionStoreProperties;
        }
        String multiEncryptionStore = (String)messageSecurityContext.getOutgoingProperties().get("encryptionMultiPropFile");
        String encryptionSymmetricKeyValue = null;
        if (encryptionSymmetric) {
            encryptionSymmetricKeyValue = (String)messageSecurityContext.getOutgoingProperties().get("encryptionSymmetricKeyValue");
        }
        String encryptionJWKSetFile = (String)messageSecurityContext.getOutgoingProperties().get("encryptionJWKSetFile");
        if (encryptionTrustStore != null) {
            merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(requestInfo, encryptionTrustStore);
            encryptionTrustStoreKS = merlinTruststore.getTrustStore();
        } else if (encryptionTrustStoreProperties != null) {
            merlinTruststore = null;
            storePath = encryptionTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = encryptionTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = encryptionTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            merlinTruststore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinTruststore(requestInfo, storePath, storeType, storePassword) : new MerlinTruststore(encryptionTrustStoreProperties);
            encryptionTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if ((encryptionStore != null || encryptionStoreProperties != null) && (aliasEncryptPassword = (String)messageSecurityContext.getOutgoingProperties().get("encryptionPassword")) == null) {
            throw new UtilsException("encryptionPassword non fornita");
        }
        if (encryptionStore != null) {
            merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(requestInfo, encryptionStore, aliasEncryptPassword);
            encryptionKS = merlinKeystore.getKeyStore();
        } else if (encryptionStoreProperties != null) {
            merlinKeystore = null;
            storePath = encryptionStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = encryptionStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = encryptionStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            BYOKRequestParams byokParams = KeystoreUtils.getBYOKRequestParams(requestInfo, encryptionStoreProperties);
            merlinKeystore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinKeystore(requestInfo, storePath, storeType, storePassword, aliasEncryptPassword, byokParams) : new MerlinKeystore(encryptionStoreProperties, aliasEncryptPassword);
            encryptionKS = merlinKeystore.getKeyStore();
        } else if (multiEncryptionStore != null) {
            multiKeystore = GestoreKeystoreCache.getMultiKeystore(requestInfo, multiEncryptionStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                encryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasEncryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                encryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasEncryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFruitoreErogatore = fruitore + "-" + erogatore;
                String aliasErogatoreFruitore = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFruitoreErogatore)) {
                    encryptionKS = multiKeystore.getKeyStore(aliasFruitoreErogatore);
                    aliasEncryptUser = multiKeystore.getKeyAlias(aliasFruitoreErogatore);
                    aliasEncryptPassword = multiKeystore.getKeyPassword(aliasFruitoreErogatore);
                } else {
                    if (!multiKeystore.existsAlias(aliasErogatoreFruitore)) throw new UtilsException("Alias [" + aliasFruitoreErogatore + "] o [" + aliasErogatoreFruitore + "] non trovato nella configurazione MultiKeystore");
                    encryptionKS = multiKeystore.getKeyStore(aliasErogatoreFruitore);
                    aliasEncryptUser = multiKeystore.getKeyAlias(aliasErogatoreFruitore);
                    aliasEncryptPassword = multiKeystore.getKeyPassword(aliasErogatoreFruitore);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getPddFruitore() != null) {
                fruitore = messageSecurityContext.getPddFruitore();
                encryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasEncryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getPddErogatore() != null) {
                erogatore = messageSecurityContext.getPddErogatore();
                encryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasEncryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                encryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasEncryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasEncryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                encryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasEncryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasEncryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                encryptionKS = multiKeystore.getKeyStore(aliasEncryptUser);
                aliasEncryptPassword = multiKeystore.getKeyPassword(aliasEncryptUser);
                aliasEncryptUser = multiKeystore.getKeyAlias(aliasEncryptUser);
            }
        } else if (encryptionSymmetricKeyValue != null) {
            Object encryptionSymmetricAlgoritm = messageSecurityContext.getOutgoingProperties().get("encryptionSymAlgorithm");
            if (encryptionSymmetricAlgoritm == null) {
                throw new UtilsException("E' stata indicata una funzionalita' di encrypt con chiave simmetrica fornita direttamente nelle proprieta' [encryptionSymmetricKeyValue=" + encryptionSymmetricKeyValue + "], ma non e' stato indicato l'algoritmo associato tramite la proprieta' encryptionSymAlgorithm");
            }
            SymmetricKeystore symmetricKeystore = GestoreKeystoreCache.getSymmetricKeystore(requestInfo, aliasEncryptUser, encryptionSymmetricKeyValue, (String)encryptionSymmetricAlgoritm);
            encryptionKS = symmetricKeystore.getKeyStore();
            aliasEncryptPassword = symmetricKeystore.getPasswordKey();
        }
        if (encryptionJWKSetFile != null) {
            encryptionJWKSet = new JWKSet(new String(KeystoreUtils.readResources(encryptionJWKSetFile)));
        }
        if (encryptionKS == null && encryptionTrustStoreKS == null && encryptionJWKSet == null) {
            throw new UtilsException("Nessuna modalita' di recupero del Keystore per la funzionalita' di Encryption indicata");
        }
        EncryptionBean bean = new EncryptionBean();
        bean.setKeystore(encryptionKS);
        bean.setTruststore(encryptionTrustStoreKS);
        bean.setJwkSet(encryptionJWKSet);
        bean.setUser(aliasEncryptUser);
        bean.setPassword(aliasEncryptPassword);
        bean.setEncryptionSimmetric(encryptionSymmetric);
        bean.setMultiKeystore(multiKeystore);
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptionBean getReceiverEncryptionBean(MessageSecurityContext messageSecurityContext, Map<Object> ctx) throws UtilsException, SecurityException, FileNotFoundException, URISyntaxException {
        String storePassword;
        String storeType;
        String storePath;
        if (messageSecurityContext.getEncryptionBean() != null) {
            return messageSecurityContext.getEncryptionBean();
        }
        RequestInfo requestInfo = null;
        if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
        }
        MultiKeystore multiKeystore = null;
        JWKSet decryptionJWKSet = null;
        KeyStore decryptionKS = null;
        KeyStore decryptionTrustStoreKS = null;
        String aliasDecryptUser = null;
        String aliasDecryptPassword = null;
        boolean decryptionSymmetric = false;
        aliasDecryptUser = (String)messageSecurityContext.getIncomingProperties().get("decryptionUser");
        if (aliasDecryptUser == null && (aliasDecryptUser = (String)messageSecurityContext.getIncomingProperties().get("user")) == null) {
            throw new UtilsException("decryptionUser/user non fornita");
        }
        Object decryptionSymmetricObject = messageSecurityContext.getIncomingProperties().get("decryptionSymmetricKey");
        if (decryptionSymmetricObject != null) {
            decryptionSymmetric = "true".equals(decryptionSymmetricObject);
        }
        String decryptionTrustStore = (String)messageSecurityContext.getIncomingProperties().get("decryptionTrustStorePropFile");
        Object oDecryptionTrustStoreProperties = messageSecurityContext.getIncomingProperties().get("decryptionTrustStorePropRefId");
        Properties decryptionTrustStoreProperties = null;
        if (oDecryptionTrustStoreProperties != null) {
            decryptionTrustStoreProperties = (Properties)oDecryptionTrustStoreProperties;
        }
        String decryptionStore = (String)messageSecurityContext.getIncomingProperties().get("decryptionPropFile");
        Object oDecryptionStoreProperties = messageSecurityContext.getIncomingProperties().get("decryptionPropRefId");
        Properties decryptionStoreProperties = null;
        if (oDecryptionStoreProperties != null) {
            decryptionStoreProperties = (Properties)oDecryptionStoreProperties;
        }
        String multiDecryptionStore = (String)messageSecurityContext.getIncomingProperties().get("decryptionMultiPropFile");
        String decryptionSymmetricKeyValue = null;
        if (decryptionSymmetric) {
            decryptionSymmetricKeyValue = (String)messageSecurityContext.getIncomingProperties().get("decryptionSymmetricKeyValue");
        }
        String decryptionJWKSetFile = (String)messageSecurityContext.getOutgoingProperties().get("decryptionJWKSetFile");
        if (decryptionTrustStore != null) {
            merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(requestInfo, decryptionTrustStore);
            decryptionTrustStoreKS = merlinTruststore.getTrustStore();
        } else if (decryptionTrustStoreProperties != null) {
            merlinTruststore = null;
            storePath = decryptionTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = decryptionTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = decryptionTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            merlinTruststore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinTruststore(requestInfo, storePath, storeType, storePassword) : new MerlinTruststore(decryptionTrustStoreProperties);
            decryptionTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if ((decryptionStore != null || decryptionStoreProperties != null) && (aliasDecryptPassword = (String)messageSecurityContext.getIncomingProperties().get("decryptionPassword")) == null) {
            throw new UtilsException("decryptionPassword non fornita");
        }
        if (decryptionStore != null) {
            merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(requestInfo, decryptionStore, aliasDecryptPassword);
            decryptionKS = merlinKeystore.getKeyStore();
        } else if (decryptionStoreProperties != null) {
            merlinKeystore = null;
            storePath = decryptionStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = decryptionStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = decryptionStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            BYOKRequestParams byokParams = KeystoreUtils.getBYOKRequestParams(requestInfo, decryptionStoreProperties);
            merlinKeystore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinKeystore(requestInfo, storePath, storeType, storePassword, aliasDecryptPassword, byokParams) : new MerlinKeystore(decryptionStoreProperties, aliasDecryptPassword);
            decryptionKS = merlinKeystore.getKeyStore();
        } else if (multiDecryptionStore != null) {
            multiKeystore = GestoreKeystoreCache.getMultiKeystore(requestInfo, multiDecryptionStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                decryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasDecryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                decryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasDecryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFruitoreErogatore = fruitore + "-" + erogatore;
                String aliasErogatoreFruitore = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFruitoreErogatore)) {
                    decryptionKS = multiKeystore.getKeyStore(aliasFruitoreErogatore);
                    aliasDecryptUser = multiKeystore.getKeyAlias(aliasFruitoreErogatore);
                    aliasDecryptPassword = multiKeystore.getKeyPassword(aliasFruitoreErogatore);
                } else {
                    if (!multiKeystore.existsAlias(aliasErogatoreFruitore)) throw new UtilsException("Alias [" + aliasFruitoreErogatore + "] o [" + aliasErogatoreFruitore + "] non trovato nella configurazione MultiKeystore");
                    decryptionKS = multiKeystore.getKeyStore(aliasErogatoreFruitore);
                    aliasDecryptUser = multiKeystore.getKeyAlias(aliasErogatoreFruitore);
                    aliasDecryptPassword = multiKeystore.getKeyPassword(aliasErogatoreFruitore);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getPddFruitore() != null) {
                fruitore = messageSecurityContext.getPddFruitore();
                decryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasDecryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getPddErogatore() != null) {
                erogatore = messageSecurityContext.getPddErogatore();
                decryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasDecryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                decryptionKS = multiKeystore.getKeyStore(fruitore);
                aliasDecryptUser = multiKeystore.getKeyAlias(fruitore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasDecryptUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                decryptionKS = multiKeystore.getKeyStore(erogatore);
                aliasDecryptUser = multiKeystore.getKeyAlias(erogatore);
                aliasDecryptPassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                decryptionKS = multiKeystore.getKeyStore(aliasDecryptUser);
                aliasDecryptPassword = multiKeystore.getKeyPassword(aliasDecryptUser);
                aliasDecryptUser = multiKeystore.getKeyAlias(aliasDecryptUser);
            }
        } else if (decryptionSymmetricKeyValue != null) {
            Object decryptionSymmetricAlgoritm = messageSecurityContext.getIncomingProperties().get("decryptionSymAlgorithm");
            if (decryptionSymmetricAlgoritm == null) {
                throw new UtilsException("E' stata indicata una funzionalita' di encrypt con chiave simmetrica fornita direttamente nelle proprieta' [decryptionSymmetricKeyValue=" + decryptionSymmetricKeyValue + "], ma non e' stato indicato l'algoritmo associato tramite la proprieta' decryptionSymAlgorithm");
            }
            SymmetricKeystore symmetricKeystore = GestoreKeystoreCache.getSymmetricKeystore(requestInfo, aliasDecryptUser, decryptionSymmetricKeyValue, (String)decryptionSymmetricAlgoritm);
            decryptionKS = symmetricKeystore.getKeyStore();
            aliasDecryptPassword = symmetricKeystore.getPasswordKey();
        } else {
            if (decryptionJWKSetFile == null) throw new UtilsException("Nessuna modalita' di recupero del Keystore per la funzionalita' di Encryption indicata");
            decryptionJWKSet = new JWKSet(new String(KeystoreUtils.readResources(decryptionJWKSetFile)));
        }
        EncryptionBean bean = new EncryptionBean();
        bean.setKeystore(decryptionKS);
        bean.setTruststore(decryptionTrustStoreKS);
        bean.setJwkSet(decryptionJWKSet);
        bean.setUser(aliasDecryptUser);
        bean.setPassword(aliasDecryptPassword);
        bean.setEncryptionSimmetric(decryptionSymmetric);
        bean.setMultiKeystore(multiKeystore);
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SignatureBean getSenderSignatureBean(MessageSecurityContext messageSecurityContext, Map<Object> ctx) throws UtilsException, SecurityException, FileNotFoundException, URISyntaxException {
        String storePassword;
        String storeType;
        String storePath;
        if (messageSecurityContext.getSignatureBean() != null) {
            return messageSecurityContext.getSignatureBean();
        }
        RequestInfo requestInfo = null;
        if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
        }
        MultiKeystore multiKeystore = null;
        JWKSet signatureJWKSet = null;
        KeyStore signatureKS = null;
        KeyStore signatureTrustStoreKS = null;
        String aliasSignatureUser = null;
        String aliasSignaturePassword = null;
        aliasSignatureUser = (String)messageSecurityContext.getOutgoingProperties().get("signatureUser");
        if (aliasSignatureUser == null && (aliasSignatureUser = (String)messageSecurityContext.getOutgoingProperties().get("user")) == null) {
            throw new UtilsException("signatureUser/user non fornita");
        }
        String signatureTrustStore = (String)messageSecurityContext.getOutgoingProperties().get("signatureTrustStorePropFile");
        Object oSignatureTrustStoreProperties = messageSecurityContext.getOutgoingProperties().get("signatureTrustStorePropRefId");
        Properties signatureTrustStoreProperties = null;
        if (oSignatureTrustStoreProperties != null) {
            signatureTrustStoreProperties = (Properties)oSignatureTrustStoreProperties;
        }
        String signatureStore = (String)messageSecurityContext.getOutgoingProperties().get("signaturePropFile");
        Object oSignatureStoreProperties = messageSecurityContext.getOutgoingProperties().get("signaturePropRefId");
        Properties signatureStoreProperties = null;
        if (oSignatureStoreProperties != null) {
            signatureStoreProperties = (Properties)oSignatureStoreProperties;
        }
        String multiSignatureStore = (String)messageSecurityContext.getOutgoingProperties().get("signatureMultiPropFile");
        String signatureJWKSetFile = (String)messageSecurityContext.getOutgoingProperties().get("signatureJWKSetFile");
        if (signatureTrustStore != null) {
            merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(requestInfo, signatureTrustStore);
            signatureTrustStoreKS = merlinTruststore.getTrustStore();
        } else if (signatureTrustStoreProperties != null) {
            merlinTruststore = null;
            storePath = signatureTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = signatureTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = signatureTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            merlinTruststore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinTruststore(requestInfo, storePath, storeType, storePassword) : new MerlinTruststore(signatureTrustStoreProperties);
            signatureTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if ((signatureStore != null || signatureStoreProperties != null) && (aliasSignaturePassword = (String)messageSecurityContext.getOutgoingProperties().get("signaturePassword")) == null) {
            throw new UtilsException("signaturePassword non fornita");
        }
        if (signatureStore != null) {
            merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(requestInfo, signatureStore, aliasSignaturePassword);
            signatureKS = merlinKeystore.getKeyStore();
        } else if (signatureStoreProperties != null) {
            merlinKeystore = null;
            storePath = signatureStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = signatureStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = signatureStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            BYOKRequestParams byokParams = KeystoreUtils.getBYOKRequestParams(requestInfo, signatureStoreProperties);
            merlinKeystore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinKeystore(requestInfo, storePath, storeType, storePassword, aliasSignaturePassword, byokParams) : new MerlinKeystore(signatureStoreProperties, aliasSignaturePassword);
            signatureKS = merlinKeystore.getKeyStore();
        } else if (multiSignatureStore != null) {
            multiKeystore = GestoreKeystoreCache.getMultiKeystore(requestInfo, multiSignatureStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFruitoreErogatore = fruitore + "-" + erogatore;
                String aliasErogatoreFruitore = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFruitoreErogatore)) {
                    signatureKS = multiKeystore.getKeyStore(aliasFruitoreErogatore);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasFruitoreErogatore);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasFruitoreErogatore);
                } else {
                    if (!multiKeystore.existsAlias(aliasErogatoreFruitore)) throw new UtilsException("Alias [" + aliasFruitoreErogatore + "] o [" + aliasErogatoreFruitore + "] non trovato nella configurazione MultiKeystore");
                    signatureKS = multiKeystore.getKeyStore(aliasErogatoreFruitore);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasErogatoreFruitore);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasErogatoreFruitore);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddFruitore() != null) {
                fruitore = messageSecurityContext.getPddFruitore();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddErogatore() != null) {
                erogatore = messageSecurityContext.getPddErogatore();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                signatureKS = multiKeystore.getKeyStore(aliasSignatureUser);
                aliasSignaturePassword = multiKeystore.getKeyPassword(aliasSignatureUser);
                aliasSignatureUser = multiKeystore.getKeyAlias(aliasSignatureUser);
            }
        } else {
            if (signatureJWKSetFile == null) throw new UtilsException("Nessuna modalita' di recupero del Keystore per la funzionalita' di Signature indicata");
            signatureJWKSet = new JWKSet(new String(KeystoreUtils.readResources(signatureJWKSetFile)));
        }
        SignatureBean bean = new SignatureBean();
        bean.setKeystore(signatureKS);
        bean.setTruststore(signatureTrustStoreKS);
        bean.setJwkSet(signatureJWKSet);
        bean.setUser(aliasSignatureUser);
        bean.setPassword(aliasSignaturePassword);
        bean.setMultiKeystore(multiKeystore);
        return bean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SignatureBean getReceiverSignatureBean(MessageSecurityContext messageSecurityContext, Map<Object> ctx) throws UtilsException, SecurityException, FileNotFoundException, URISyntaxException {
        String storePassword;
        String storeType;
        String storePath;
        if (messageSecurityContext.getSignatureBean() != null) {
            return messageSecurityContext.getSignatureBean();
        }
        RequestInfo requestInfo = null;
        if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
            requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
        }
        MultiKeystore multiKeystore = null;
        JWKSet signatureJWKSet = null;
        KeyStore signatureKS = null;
        KeyStore signatureTrustStoreKS = null;
        String aliasSignatureUser = null;
        String aliasSignaturePassword = null;
        String crlPath = null;
        aliasSignatureUser = (String)messageSecurityContext.getIncomingProperties().get("signatureUser");
        if (aliasSignatureUser == null && (aliasSignatureUser = (String)messageSecurityContext.getIncomingProperties().get("user")) == null) {
            throw new UtilsException("signatureUser/user non fornita");
        }
        crlPath = (String)messageSecurityContext.getIncomingProperties().get("signatureCRL");
        String signatureTrustStore = (String)messageSecurityContext.getIncomingProperties().get("signatureTrustStorePropFile");
        Object oSignatureTrustStoreProperties = messageSecurityContext.getIncomingProperties().get("signatureTrustStorePropRefId");
        Properties signatureTrustStoreProperties = null;
        if (oSignatureTrustStoreProperties != null) {
            signatureTrustStoreProperties = (Properties)oSignatureTrustStoreProperties;
        }
        String signatureStore = (String)messageSecurityContext.getIncomingProperties().get("signaturePropFile");
        Object oSignatureStoreProperties = messageSecurityContext.getIncomingProperties().get("signaturePropRefId");
        Properties signatureStoreProperties = null;
        if (oSignatureStoreProperties != null) {
            signatureStoreProperties = (Properties)oSignatureStoreProperties;
        }
        String multiSignatureStore = (String)messageSecurityContext.getIncomingProperties().get("signatureMultiPropFile");
        String signatureJWKSetFile = (String)messageSecurityContext.getOutgoingProperties().get("signatureJWKSetFile");
        if (signatureTrustStore != null) {
            merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(requestInfo, signatureTrustStore);
            signatureTrustStoreKS = merlinTruststore.getTrustStore();
        } else if (signatureTrustStoreProperties != null) {
            merlinTruststore = null;
            storePath = signatureTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = signatureTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = signatureTrustStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            merlinTruststore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinTruststore(requestInfo, storePath, storeType, storePassword) : new MerlinTruststore(signatureTrustStoreProperties);
            signatureTrustStoreKS = merlinTruststore.getTrustStore();
        }
        if (signatureStore != null) {
            aliasSignaturePassword = (String)messageSecurityContext.getIncomingProperties().get("signaturePassword");
            if (aliasSignaturePassword == null) {
                throw new UtilsException("signaturePassword non fornita");
            }
            merlinKeystore = GestoreKeystoreCache.getMerlinKeystore(requestInfo, signatureStore, aliasSignaturePassword);
            signatureKS = merlinKeystore.getKeyStore();
        } else if (signatureStoreProperties != null) {
            merlinKeystore = null;
            storePath = signatureStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.file");
            storeType = signatureStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            storePassword = signatureStoreProperties.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            BYOKRequestParams byokParams = KeystoreUtils.getBYOKRequestParams(requestInfo, signatureStoreProperties);
            merlinKeystore = StringUtils.isNotEmpty((CharSequence)storePath) && StringUtils.isNotEmpty((CharSequence)storeType) && StringUtils.isNotEmpty((CharSequence)storePassword) ? GestoreKeystoreCache.getMerlinKeystore(requestInfo, storePath, storeType, storePassword, aliasSignaturePassword, byokParams) : new MerlinKeystore(signatureStoreProperties, aliasSignaturePassword);
            signatureKS = merlinKeystore.getKeyStore();
        } else if (multiSignatureStore != null) {
            multiKeystore = GestoreKeystoreCache.getMultiKeystore(requestInfo, multiSignatureStore);
            if ("#MultiPropUseFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseFruitoreErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getNome() != null && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getNome();
                String erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getNome();
                String aliasFruitoreErogatore = fruitore + "-" + erogatore;
                String aliasErogatoreFruitore = erogatore + "-" + fruitore;
                if (multiKeystore.existsAlias(aliasFruitoreErogatore)) {
                    signatureKS = multiKeystore.getKeyStore(aliasFruitoreErogatore);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasFruitoreErogatore);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasFruitoreErogatore);
                } else {
                    if (!multiKeystore.existsAlias(aliasErogatoreFruitore)) throw new UtilsException("Alias [" + aliasFruitoreErogatore + "] o [" + aliasErogatoreFruitore + "] non trovato nella configurazione MultiKeystore");
                    signatureKS = multiKeystore.getKeyStore(aliasErogatoreFruitore);
                    aliasSignatureUser = multiKeystore.getKeyAlias(aliasErogatoreFruitore);
                    aliasSignaturePassword = multiKeystore.getKeyPassword(aliasErogatoreFruitore);
                }
            } else if ("#MultiPropUsePddFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddFruitore() != null) {
                fruitore = messageSecurityContext.getPddFruitore();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUsePddErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getPddErogatore() != null) {
                erogatore = messageSecurityContext.getPddErogatore();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else if ("#MultiPropUseIdentificativoPortaFruitoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdFruitore() != null && messageSecurityContext.getIdFruitore().getCodicePorta() != null) {
                fruitore = messageSecurityContext.getIdFruitore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(fruitore);
                aliasSignatureUser = multiKeystore.getKeyAlias(fruitore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(fruitore);
            } else if ("#MultiPropUseIdentificativoPortaErogatoreAsAlias#".equals(aliasSignatureUser) && messageSecurityContext.getIdServizio() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore() != null && messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta() != null) {
                erogatore = messageSecurityContext.getIdServizio().getSoggettoErogatore().getCodicePorta();
                signatureKS = multiKeystore.getKeyStore(erogatore);
                aliasSignatureUser = multiKeystore.getKeyAlias(erogatore);
                aliasSignaturePassword = multiKeystore.getKeyPassword(erogatore);
            } else {
                signatureKS = multiKeystore.getKeyStore(aliasSignatureUser);
                aliasSignaturePassword = multiKeystore.getKeyPassword(aliasSignatureUser);
                aliasSignatureUser = multiKeystore.getKeyAlias(aliasSignatureUser);
            }
        }
        if (signatureJWKSetFile != null) {
            signatureJWKSet = new JWKSet(new String(KeystoreUtils.readResources(signatureJWKSetFile)));
        }
        if (signatureKS == null && signatureTrustStoreKS == null && signatureJWKSet == null) {
            throw new UtilsException("Nessuna modalita' di recupero del TrustStore per la funzionalita' di Signature indicata");
        }
        SignatureBean bean = new SignatureBean();
        bean.setKeystore(signatureKS);
        bean.setTruststore(signatureTrustStoreKS);
        bean.setJwkSet(signatureJWKSet);
        bean.setUser(aliasSignatureUser);
        bean.setPassword(aliasSignaturePassword);
        bean.setCrlPath(crlPath);
        bean.setMultiKeystore(multiKeystore);
        return bean;
    }

    private static byte[] readResources(String path) throws UtilsException, FileNotFoundException, URISyntaxException {
        byte[] b = null;
        if (path == null) {
            return b;
        }
        if (path.startsWith("http") || path.startsWith("https")) {
            HttpResponse httpResponse = HttpUtilities.getHTTPResponse((String)path, (int)60000, (int)10000);
            if (httpResponse == null || httpResponse.getContent() == null) {
                throw new UtilsException("Resource '" + path + "' unavailable");
            }
            if (httpResponse.getResultHTTPOperation() != 200) {
                throw new UtilsException("Retrieve resource '" + path + "' failed (returnCode:" + httpResponse.getResultHTTPOperation() + ")");
            }
            return httpResponse.getContent();
        }
        if (path.startsWith("file")) {
            File f = new File(new URI(path));
            return FileSystemUtilities.readBytesFromFile((File)f);
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new UtilsException("File '" + f.getAbsolutePath() + "' not exists");
        }
        return FileSystemUtilities.readBytesFromFile((File)f);
    }

    private static BYOKRequestParams getBYOKRequestParams(RequestInfo requestInfo, Properties properties) throws UtilsException {
        String keyStoreByokPolicy = properties.getProperty("org.apache.ws.security.crypto.merlin.file.byok");
        BYOKRequestParams byokParams = null;
        if (keyStoreByokPolicy != null && BYOKProvider.isPolicyDefined((String)(keyStoreByokPolicy = keyStoreByokPolicy.trim()))) {
            try {
                byokParams = BYOKProvider.getBYOKRequestParamsByUnwrapBYOKPolicy((String)keyStoreByokPolicy, requestInfo != null && requestInfo.getDynamicMap() != null ? requestInfo.getDynamicMap() : new HashMap());
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), (Throwable)e);
            }
        }
        return byokParams;
    }
}

