/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.SignatureBean;

public class PropertiesUtils {
    public static EncryptionBean getSenderEncryptionBean(MessageSecurityContext messageSecurityContext) throws NotFoundException, SecurityException {
        Properties p = PropertiesUtils._readProperties(messageSecurityContext.getOutgoingProperties(), "encryptionPropRefId");
        if (p == null) {
            p = PropertiesUtils._readProperties(messageSecurityContext.getOutgoingProperties(), "encryptionPropFile");
        }
        if (p == null) {
            throw new NotFoundException("encryptionPropRefId/encryptionPropFile non fornita");
        }
        EncryptionBean bean = new EncryptionBean();
        bean.setProperties(p);
        return bean;
    }

    public static EncryptionBean getReceiverEncryptionBean(MessageSecurityContext messageSecurityContext) throws NotFoundException, SecurityException {
        Properties p = PropertiesUtils._readProperties(messageSecurityContext.getIncomingProperties(), "decryptionPropRefId");
        if (p == null) {
            p = PropertiesUtils._readProperties(messageSecurityContext.getIncomingProperties(), "decryptionPropFile");
        }
        if (p == null) {
            throw new NotFoundException("decryptionPropRefId/decryptionPropFile non fornita");
        }
        EncryptionBean bean = new EncryptionBean();
        bean.setProperties(p);
        return bean;
    }

    public static SignatureBean getSenderSignatureBean(MessageSecurityContext messageSecurityContext) throws NotFoundException, SecurityException {
        Properties p = PropertiesUtils._readProperties(messageSecurityContext.getOutgoingProperties(), "signaturePropRefId");
        if (p == null) {
            p = PropertiesUtils._readProperties(messageSecurityContext.getOutgoingProperties(), "signaturePropFile");
        }
        if (p == null) {
            throw new NotFoundException("signaturePropRefId/signaturePropFile non fornita");
        }
        SignatureBean bean = new SignatureBean();
        bean.setProperties(p);
        return bean;
    }

    public static SignatureBean getReceiverSignatureBean(MessageSecurityContext messageSecurityContext) throws NotFoundException, SecurityException {
        Properties p = PropertiesUtils._readProperties(messageSecurityContext.getIncomingProperties(), "signatureVerificationPropRefId");
        if (p == null) {
            p = PropertiesUtils._readProperties(messageSecurityContext.getIncomingProperties(), "signatureVerificationPropFile");
        }
        if (p == null) {
            p = PropertiesUtils._readProperties(messageSecurityContext.getIncomingProperties(), "signaturePropRefId");
        }
        if (p == null) {
            p = PropertiesUtils._readProperties(messageSecurityContext.getIncomingProperties(), "signaturePropFile");
        }
        if (p == null) {
            throw new NotFoundException("signatureVerificationPropRefId/signatureVerificationPropFile/signaturePropRefId/signaturePropFile non fornita");
        }
        SignatureBean bean = new SignatureBean();
        bean.setProperties(p);
        return bean;
    }

    private static Properties _readProperties(Map<String, Object> map, String property) throws SecurityException {
        String path = null;
        File fPath = null;
        if (map.containsKey(property)) {
            Object o = map.get(property);
            if (o instanceof Properties) {
                return (Properties)o;
            }
            if (o instanceof File) {
                fPath = (File)o;
            } else if (o instanceof String) {
                path = (String)o;
            } else {
                throw new SecurityException("Found property [" + property + "] with wrong type");
            }
        }
        if (fPath != null) {
            try {
                return PropertiesUtils._readProperties(fPath);
            }
            catch (Exception e) {
                throw new SecurityException("Occurs error (property [" + property + "]): " + e.getMessage(), e);
            }
        }
        if (path != null) {
            File check = new File(path);
            if (check.exists()) {
                return PropertiesUtils._readProperties(check);
            }
            InputStream is = PropertiesUtils.class.getResourceAsStream(path);
            if (is == null && !path.startsWith("/")) {
                is = PropertiesUtils.class.getResourceAsStream("/" + path);
            }
            if (is == null) {
                throw new SecurityException("Occurs error (property [" + property + "]): resource [" + path + "] not found");
            }
        }
        return null;
    }

    private static Properties _readProperties(File file) throws SecurityException {
        if (!file.exists()) {
            throw new SecurityException("Cannot exists");
        }
        if (!file.canRead()) {
            throw new SecurityException("Cannot read");
        }
        if (!file.isFile()) {
            throw new SecurityException("Isn't file");
        }
        Properties p = new Properties();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            p.load(fin);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
        return p;
    }
}

