/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.wss4j;

import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.SAMLTokenPrincipalImpl;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.str.STRParser;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.CRLCertstore;
import org.openspcoop2.security.keystore.KeystoreConstants;
import org.openspcoop2.security.keystore.MerlinProvider;
import org.openspcoop2.security.keystore.MerlinTruststore;
import org.openspcoop2.security.keystore.cache.GestoreKeystoreCache;
import org.openspcoop2.security.keystore.cache.GestoreOCSPResource;
import org.openspcoop2.security.keystore.cache.GestoreOCSPValidator;
import org.openspcoop2.security.message.AbstractSOAPMessageSecurityReceiver;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.SubErrorCodeSecurity;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.engine.MessageUtilities;
import org.openspcoop2.security.message.utils.AttachmentProcessingPart;
import org.openspcoop2.security.message.utils.AttachmentsConfigReaderUtils;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.KeystoreUtils;
import org.openspcoop2.security.message.wss4j.WSSUtilities;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.id.IDUtilities;
import org.openspcoop2.utils.transport.http.IOCSPValidator;

public class MessageSecurityReceiver_wss4j
extends AbstractSOAPMessageSecurityReceiver {
    private Timestamp timestamp;
    private List<WSDataRef> signatureRefs;
    private List<WSDataRef> encryptionRefs;
    private String certificate;
    private STRParser.REFERENCE_TYPE x509ReferenceType;
    private X509Certificate x509Certificate;
    private X509Certificate[] x509Certificates;
    private PublicKey publicKey;
    private IOCSPValidator ocspValidator;
    private org.openspcoop2.utils.certificate.KeyStore trustStore = null;
    private CRLCertstore crlX509 = null;

    @Override
    public void process(MessageSecurityContext wssContext, OpenSPCoop2Message messageParam, Busta busta, org.openspcoop2.utils.Map<Object> ctx) throws SecurityException {
        this.process(wssContext, messageParam, busta, false, null, ctx);
    }

    public void process(MessageSecurityContext wssContext, OpenSPCoop2Message messageParam, Busta busta, boolean bufferMessage_readOnly, String idTransazione, org.openspcoop2.utils.Map<Object> ctx) throws SecurityException {
        block39: {
            boolean certError = false;
            boolean ocspError = false;
            try {
                if (!ServiceBinding.SOAP.equals((Object)messageParam.getServiceBinding())) {
                    throw new SecurityException("WSS4J Engine usable only with SOAP Binding");
                }
                OpenSPCoop2SoapMessage message = messageParam.castAsSoap();
                SOAPMessage soapMessage = MessageUtils.getSOAPMessage((OpenSPCoop2SoapMessage)message, (boolean)bufferMessage_readOnly, (String)idTransazione);
                RequestInfo requestInfo = null;
                if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
                    requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
                }
                WSS4JInInterceptor inHandler = new WSS4JInInterceptor();
                SoapMessage msgCtx = new SoapMessage((Message)new MessageImpl());
                msgCtx.setVersion((SoapVersion)(MessageType.SOAP_12.equals((Object)message.getMessageType()) ? Soap12.getInstance() : Soap11.getInstance()));
                ExchangeImpl ex = new ExchangeImpl();
                ex.setInMessage((Message)msgCtx);
                msgCtx.setContent(SOAPMessage.class, (Object)soapMessage);
                this.setIncomingProperties(wssContext, inHandler, msgCtx, requestInfo, ctx);
                AttachmentProcessingPart app = AttachmentsConfigReaderUtils.getSecurityOnAttachments(wssContext);
                List<Attachment> listAttachments = null;
                if (app != null) {
                    if (!app.isAllAttachments()) {
                        List<String> cidAttachmentsForSecurity = AttachmentsConfigReaderUtils.getListCIDAttachmentsForSecurity(wssContext);
                        listAttachments = WSSUtilities.readAttachments(cidAttachmentsForSecurity, message, msgCtx);
                    } else {
                        listAttachments = WSSUtilities.readAttachments(app, message, msgCtx);
                    }
                    if (listAttachments != null && listAttachments.size() > 0) {
                        msgCtx.setAttachments(listAttachments);
                    }
                }
                inHandler.handleMessage(msgCtx);
                List results = (List)msgCtx.getContextualProperty("RECV_RESULTS");
                wssContext.getLog().debug("Print wssRecever results...");
                WSSUtilities.printWSResult(wssContext.getLog(), results);
                WSSUtilities.updateAttachments(listAttachments, message, msgCtx);
                boolean validateX509 = this.examineResults(msgCtx, wssContext.getActor());
                if (validateX509 && this.x509Certificate != null && this.crlX509 != null) {
                    try {
                        CertificateInfo certificatoInfo = new CertificateInfo(this.x509Certificate, "x509");
                        certificatoInfo.checkValid(this.crlX509.getCertStore(), this.trustStore);
                    }
                    catch (Throwable e) {
                        certError = true;
                        throw new Exception(e.getMessage(), e);
                    }
                }
                if (this.ocspValidator == null) break block39;
                X509Certificate cert = this.x509Certificate;
                if (cert == null && this.x509Certificates != null && this.x509Certificates.length > 0) {
                    cert = this.x509Certificates[0];
                }
                if (cert == null) break block39;
                try {
                    this.ocspValidator.valid(cert);
                }
                catch (Throwable e) {
                    ocspError = true;
                    throw e;
                }
            }
            catch (Throwable e) {
                Throwable t;
                SecurityException wssException = null;
                String msg = Utilities.getInnerNotEmptyMessageException((Throwable)e).getMessage();
                Throwable innerExc = Utilities.getLastInnerException((Throwable)e);
                String innerMsg = null;
                if (innerExc != null) {
                    innerMsg = innerExc.getMessage();
                }
                Object messaggio = null;
                if (msg != null) {
                    messaggio = new String(msg);
                    if (innerMsg != null && !innerMsg.equals(msg)) {
                        messaggio = (String)messaggio + " ; " + innerMsg;
                    }
                } else if (innerMsg != null) {
                    messaggio = innerMsg;
                }
                if (Utilities.existsInnerException((Throwable)e, WSSecurityException.class) && (t = Utilities.getLastInnerException((Throwable)e)) instanceof WSSecurityException) {
                    messaggio = messaggio != null ? (String)messaggio + " ; " + t.getMessage() : t.getMessage();
                }
                wssException = new SecurityException((String)messaggio, e);
                wssException.setMsgErrore((String)messaggio);
                boolean signature = false;
                boolean encrypt = false;
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    PrintStream printStream = new PrintStream(bout);
                    e.printStackTrace(printStream);
                    bout.flush();
                    printStream.flush();
                    bout.close();
                    printStream.close();
                    if (certError) {
                        signature = true;
                    } else if (ocspError) {
                        signature = true;
                    } else if (bout.toString().contains(".processor.SignatureProcessor")) {
                        signature = true;
                    } else if (bout.toString().contains(".processor.SignatureConfirmationProcessor")) {
                        signature = true;
                    } else if (bout.toString().contains(".processor.EncryptedKeyProcessor")) {
                        encrypt = true;
                    } else if (bout.toString().contains(".processor.EncryptedDataProcessor")) {
                        encrypt = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (signature) {
                    wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
                } else if (encrypt) {
                    wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_VALIDA);
                } else if (Utilities.existsInnerMessageException((Throwable)e, (String)"The signature or decryption was invalid", (boolean)true)) {
                    wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
                } else {
                    wssException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA);
                }
                throw wssException;
            }
        }
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public List<WSDataRef> getSignatureRefs() {
        return this.signatureRefs;
    }

    public List<WSDataRef> getEncryptionRefs() {
        return this.encryptionRefs;
    }

    @Override
    public String getCertificate() throws SecurityException {
        return this.certificate;
    }

    public STRParser.REFERENCE_TYPE getX509ReferenceType() {
        return this.x509ReferenceType;
    }

    @Override
    public X509Certificate getX509Certificate() throws SecurityException {
        return this.x509Certificate;
    }

    public X509Certificate[] getX509Certificates() {
        return this.x509Certificates;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getCertificateId() throws SecurityException {
        return null;
    }

    private void setIncomingProperties(MessageSecurityContext wssContext, WSS4JInInterceptor interceptor, SoapMessage msgCtx, RequestInfo requestInfo, org.openspcoop2.utils.Map<Object> ctx) throws SecurityException {
        Map<String, Object> wssIncomingProperties = wssContext.getIncomingProperties();
        String ocspPolicy = null;
        String crls = null;
        Properties pTrustStore = null;
        boolean samlSigned = false;
        if (wssIncomingProperties != null && wssIncomingProperties.size() > 0) {
            try {
                this.preprocessMultipropFile(wssContext, msgCtx, wssIncomingProperties, requestInfo, ctx);
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
            for (String key : wssIncomingProperties.keySet()) {
                Object oValue = wssIncomingProperties.get(key);
                String value = null;
                if (oValue != null && oValue instanceof String) {
                    value = (String)oValue;
                }
                if ("action".equals(key)) {
                    msgCtx.put(key, (Object)value);
                    interceptor.setProperty(key, value);
                    if (value == null || !value.contains("SAMLTokenSigned")) continue;
                    samlSigned = true;
                    continue;
                }
                if ("passwordCallbackRef".equals(key)) {
                    msgCtx.put(key, oValue);
                    continue;
                }
                if ("signaturePropRefId".equals(key) || "signatureVerificationPropRefId".equals(key) || "signatureTrustStorePropRefId".equals(key) || "encryptionPropRefId".equals(key) || "decryptionPropRefId".equals(key)) {
                    if (value != null) {
                        msgCtx.put(key, (Object)value);
                        continue;
                    }
                    String id = key + "_" + IDUtilities.getUniqueSerialNumber((String)"wssSecurity.setIncomingProperties");
                    msgCtx.put(key, (Object)id);
                    msgCtx.put(id, oValue);
                    if (oValue == null || !(oValue instanceof Properties)) continue;
                    Properties p = (Properties)oValue;
                    p.put("requestInfo", requestInfo);
                    if (!"signaturePropRefId".equals(key) && !"signatureVerificationPropRefId".equals(key) && !"signatureTrustStorePropRefId".equals(key)) continue;
                    pTrustStore = p;
                    continue;
                }
                if ("Encrypt".equals(key)) {
                    msgCtx.put("Encryption", (Object)value);
                    interceptor.setProperty("Encryption", value);
                    continue;
                }
                if ("signatureOCSP".equals(key)) {
                    ocspPolicy = value;
                    continue;
                }
                if ("signatureCRL".equals(key)) {
                    crls = value;
                    continue;
                }
                msgCtx.put(key, (Object)value);
                interceptor.setProperty(key, value);
            }
        }
        if (wssContext.getActor() != null) {
            interceptor.setProperty("actor", wssContext.getActor());
            msgCtx.put("actor", (Object)wssContext.getActor());
        }
        String prefixTrustStore = null;
        if (pTrustStore != null && !pTrustStore.isEmpty()) {
            String trustStoreLocation = null;
            try {
                prefixTrustStore = MerlinProvider.readPrefix(pTrustStore);
                trustStoreLocation = pTrustStore.getProperty(prefixTrustStore + "truststore.file");
                String trustStorePassword = null;
                String trustStoreType = null;
                if (trustStoreLocation == null) {
                    trustStoreLocation = pTrustStore.getProperty(prefixTrustStore + "keystore.file");
                    if (trustStoreLocation == null) {
                        trustStoreLocation = pTrustStore.getProperty(prefixTrustStore + "file");
                    }
                    if (trustStoreLocation != null) {
                        trustStorePassword = pTrustStore.getProperty(prefixTrustStore + "keystore.password");
                        if (trustStorePassword != null) {
                            trustStorePassword = trustStorePassword.trim();
                        }
                        if ((trustStoreType = pTrustStore.getProperty(prefixTrustStore + "keystore.type", KeyStore.getDefaultType())) != null) {
                            trustStoreType = trustStoreType.trim();
                        }
                    }
                } else {
                    trustStorePassword = pTrustStore.getProperty(prefixTrustStore + "truststore.password");
                    if (trustStorePassword != null) {
                        trustStorePassword = trustStorePassword.trim();
                    }
                    if ((trustStoreType = pTrustStore.getProperty(prefixTrustStore + "truststore.type", KeyStore.getDefaultType())) != null) {
                        trustStoreType = trustStoreType.trim();
                    }
                }
                if (trustStoreLocation != null) {
                    MerlinTruststore merlinTs = GestoreKeystoreCache.getMerlinTruststore(requestInfo, trustStoreLocation = trustStoreLocation.trim(), trustStoreType, trustStorePassword);
                    if (merlinTs == null) {
                        throw new Exception("Accesso al truststore '" + trustStoreLocation + "' non riuscito");
                    }
                    if (merlinTs.getTrustStore() == null) {
                        throw new Exception("Accesso al truststore '" + trustStoreLocation + "' non riuscito");
                    }
                    this.trustStore = merlinTs.getTrustStore();
                }
            }
            catch (Exception e) {
                throw new SecurityException("[Truststore-File] '" + trustStoreLocation + "': " + e.getMessage(), e);
            }
        }
        boolean crlByOcsp = false;
        if (ocspPolicy != null && !"".equals(ocspPolicy)) {
            if (this.trustStore != null) {
                LoggerBuffer lb = new LoggerBuffer();
                lb.setLogDebug(wssContext.getLog());
                lb.setLogError(wssContext.getLog());
                GestoreOCSPResource ocspResourceReader = new GestoreOCSPResource(requestInfo);
                GestoreOCSPValidator ocspValidator = null;
                try {
                    ocspValidator = new GestoreOCSPValidator(requestInfo, lb, this.trustStore, crls, ocspPolicy, ocspResourceReader);
                }
                catch (Exception e) {
                    throw new SecurityException("SignatureVerifier; ocsp initialization (policy:'" + ocspPolicy + "') failed: " + e.getMessage(), e);
                }
                if (ocspValidator != null) {
                    this.ocspValidator = ocspValidator;
                    GestoreOCSPValidator gOcspValidator = ocspValidator;
                    if (gOcspValidator.getOcspConfig() != null) {
                        crlByOcsp = gOcspValidator.getOcspConfig().isCrl();
                    }
                }
            }
            if (crlByOcsp) {
                msgCtx.put("enableRevocation", (Object)"false");
                interceptor.setProperty("enableRevocation", "false");
            }
        }
        if (samlSigned && !crlByOcsp && this.trustStore != null && pTrustStore != null) {
            String trustStoreCRLs = null;
            try {
                trustStoreCRLs = pTrustStore.getProperty(prefixTrustStore + "x509crl.file");
                if (trustStoreCRLs != null) {
                    trustStoreCRLs = trustStoreCRLs.trim();
                    this.crlX509 = GestoreKeystoreCache.getCRLCertstore(requestInfo, trustStoreCRLs);
                }
            }
            catch (Exception e) {
                throw new SecurityException("[Truststore-CRLs] '" + trustStoreCRLs + "': " + e.getMessage(), e);
            }
        }
    }

    private void preprocessMultipropFile(MessageSecurityContext wssContext, SoapMessage msgCtx, Map<String, Object> wssIncomingProperties, RequestInfo requestInfo, org.openspcoop2.utils.Map<Object> ctx) throws FileNotFoundException, UtilsException, SecurityException, URISyntaxException {
        Properties pTrustStoreSignatureVerification = null;
        String signatureCrls = null;
        for (Map.Entry<String, Object> entry : wssIncomingProperties.entrySet()) {
            if (!"signatureCRL".equals(entry.getKey())) continue;
            signatureCrls = (String)entry.getValue();
            break;
        }
        String signatureCrlsValidateOnlyEndEntity = null;
        if (signatureCrls != null) {
            for (Map.Entry entry : wssIncomingProperties.entrySet()) {
                if (!"signatureCRLValidateOnlyEndEntity".equals(entry.getKey())) continue;
                signatureCrlsValidateOnlyEndEntity = (String)entry.getValue();
                break;
            }
        }
        String forceDecryptionUser = null;
        for (Map.Entry<String, Object> entry : wssIncomingProperties.entrySet()) {
            String key = entry.getKey();
            if ("signatureTrustStorePropFile".equals(key)) {
                Object o = wssIncomingProperties.get(key);
                if (!(o instanceof String)) continue;
                String path = (String)o;
                MerlinTruststore merlinTruststore = GestoreKeystoreCache.getMerlinTruststore(requestInfo, path);
                pTrustStoreSignatureVerification = new Properties();
                pTrustStoreSignatureVerification.put("org.apache.ws.security.crypto.merlin.truststore.file", merlinTruststore.getPathStore());
                pTrustStoreSignatureVerification.put("org.apache.ws.security.crypto.merlin.truststore.password", merlinTruststore.getPasswordStore());
                pTrustStoreSignatureVerification.put("org.apache.ws.security.crypto.merlin.truststore.type", merlinTruststore.getTipoStore());
                pTrustStoreSignatureVerification.put("org.apache.ws.security.crypto.provider", KeystoreConstants.PROVIDER_GOVWAY);
                if (signatureCrls == null) continue;
                pTrustStoreSignatureVerification.put("org.apache.ws.security.crypto.merlin.x509crl.file", signatureCrls);
                if (signatureCrlsValidateOnlyEndEntity == null) continue;
                pTrustStoreSignatureVerification.put("org.apache.ws.security.crypto.merlin.x509crl.file.validateOnlyEndEntity", signatureCrlsValidateOnlyEndEntity);
                continue;
            }
            if (!"decryptionMultiPropFile".equals(key)) continue;
            EncryptionBean bean = KeystoreUtils.getReceiverEncryptionBean(wssContext, ctx);
            if (bean.getMultiKeystore() == null) {
                throw new SecurityException("Multiproperty config not exists");
            }
            String keyAlias = bean.getUser();
            String internalAlias = bean.getMultiKeystore().getInternalConfigAlias(keyAlias);
            Properties p = new Properties();
            p.put("org.apache.ws.security.crypto.merlin.file", bean.getMultiKeystore().getKeystorePath(internalAlias));
            p.put("org.apache.ws.security.crypto.merlin.keystore.password", bean.getMultiKeystore().getKeystorePassword(internalAlias));
            p.put("org.apache.ws.security.crypto.merlin.keystore.type", bean.getMultiKeystore().getKeystoreType(internalAlias));
            p.put("org.apache.ws.security.crypto.provider", KeystoreConstants.PROVIDER_GOVWAY);
            p.put("requestInfo", requestInfo);
            String id = "decryptionPropRefId_" + IDUtilities.getUniqueSerialNumber((String)"wssSecurity.setOutgoingProperties");
            msgCtx.put("decryptionPropRefId", (Object)id);
            msgCtx.put(id, (Object)p);
            HashMap<String, String> mapAliasToPassword = new HashMap<String, String>();
            String password = bean.getPassword();
            msgCtx.put("decryptionPassword", (Object)bean.getPassword());
            mapAliasToPassword.put(keyAlias, password);
            CallbackHandler pwCallbackHandler = MessageSecurityContext.newCallbackHandler(mapAliasToPassword);
            msgCtx.put("passwordCallbackRef", (Object)pwCallbackHandler);
            forceDecryptionUser = keyAlias;
        }
        if (pTrustStoreSignatureVerification != null) {
            wssIncomingProperties.put("signatureVerificationPropRefId", pTrustStoreSignatureVerification);
            if (signatureCrls != null) {
                wssIncomingProperties.put("enableRevocation", "true");
            }
        }
        if (forceDecryptionUser != null) {
            wssIncomingProperties.remove("decryptionUser");
            wssIncomingProperties.put("decryptionUser", forceDecryptionUser);
        }
    }

    private boolean examineResults(SoapMessage msgCtx, String actor) {
        boolean validateX509 = false;
        List results = (List)msgCtx.get((Object)"RECV_RESULTS");
        for (int i = 0; results != null && i < results.size(); ++i) {
            WSHandlerResult hResult = (WSHandlerResult)results.get(i);
            boolean actorCompatibile = false;
            actorCompatibile = actor == null ? hResult.getActor() == null : actor.equals(hResult.getActor());
            if (!actorCompatibile) continue;
            List hResults = hResult.getResults();
            for (int j = 0; j < hResults.size(); ++j) {
                Object oTimestamp;
                Object oEncryptionRefs;
                WSSecurityEngineResult eResult = (WSSecurityEngineResult)hResults.get(j);
                int actionGet = (Integer)eResult.get((Object)"action");
                if (actionGet == 2 || actionGet == 1 || actionGet == 64 || actionGet == 16) {
                    Object oSignatureRefs;
                    Object oX509ReferenceType;
                    Object oListX509Certificates;
                    Object oX509Certificate;
                    Object oPrincipal = eResult.get((Object)"principal");
                    if (oPrincipal != null && oPrincipal instanceof Principal) {
                        SAMLTokenPrincipalImpl samlPrincipal;
                        Principal principal = (Principal)oPrincipal;
                        if (principal != null) {
                            this.certificate = principal.getName();
                        }
                        if (oPrincipal instanceof SAMLTokenPrincipalImpl && (samlPrincipal = (SAMLTokenPrincipalImpl)oPrincipal).getToken() != null && samlPrincipal.getToken().getSignatureKeyInfo() != null) {
                            if (samlPrincipal.getToken().getSignatureKeyInfo().getCerts() != null) {
                                if (this.x509Certificates == null) {
                                    this.x509Certificates = samlPrincipal.getToken().getSignatureKeyInfo().getCerts();
                                }
                            } else if (samlPrincipal.getToken().getSignatureKeyInfo().getPublicKey() != null && this.x509Certificate == null && this.trustStore != null) {
                                try {
                                    Certificate c = this.trustStore.getCertificateByPublicKey(samlPrincipal.getToken().getSignatureKeyInfo().getPublicKey());
                                    if (c != null && c instanceof X509Certificate) {
                                        this.x509Certificate = (X509Certificate)c;
                                        validateX509 = true;
                                    }
                                }
                                catch (Throwable c) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if ((oX509Certificate = eResult.get((Object)"x509-certificate")) != null && oX509Certificate instanceof X509Certificate) {
                        this.x509Certificate = (X509Certificate)oX509Certificate;
                        if (this.x509Certificate != null) {
                            this.publicKey = this.x509Certificate.getPublicKey();
                        }
                    }
                    if ((oListX509Certificates = eResult.get((Object)"x509-certificates")) != null && oListX509Certificates instanceof X509Certificate[]) {
                        this.x509Certificates = (X509Certificate[])oListX509Certificates;
                    }
                    if ((oX509ReferenceType = eResult.get((Object)"x509-reference-type")) != null && oX509ReferenceType instanceof STRParser.REFERENCE_TYPE) {
                        this.x509ReferenceType = (STRParser.REFERENCE_TYPE)oX509ReferenceType;
                    }
                    if ((oSignatureRefs = eResult.get((Object)"data-ref-uris")) != null && oSignatureRefs instanceof List) {
                        ArrayList<WSDataRef> l = new ArrayList<WSDataRef>();
                        List lRefs = (List)oSignatureRefs;
                        for (Object oRef : lRefs) {
                            if (oRef == null || !(oRef instanceof WSDataRef)) continue;
                            l.add((WSDataRef)oRef);
                        }
                        if (!l.isEmpty()) {
                            this.signatureRefs = l;
                        }
                    }
                }
                if (actionGet == 4 && (oEncryptionRefs = eResult.get((Object)"data-ref-uris")) != null && oEncryptionRefs instanceof List) {
                    ArrayList<WSDataRef> l = new ArrayList<WSDataRef>();
                    List lRefs = (List)oEncryptionRefs;
                    for (Object oRef : lRefs) {
                        if (oRef == null || !(oRef instanceof WSDataRef)) continue;
                        l.add((WSDataRef)oRef);
                    }
                    if (!l.isEmpty()) {
                        this.encryptionRefs = l;
                    }
                }
                if (actionGet == 32 && (oTimestamp = eResult.get((Object)"timestamp")) != null && oTimestamp instanceof Timestamp) {
                    this.timestamp = (Timestamp)oTimestamp;
                }
                if (actionGet != 16) continue;
            }
        }
        return validateX509;
    }

    @Override
    public List<Reference> getDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2SoapMessage message) throws SecurityException {
        return org.openspcoop2.security.message.engine.WSSUtilities.getDirtyElements(messageSecurityContext, message);
    }

    @Override
    public Map<QName, QName> checkEncryptSignatureParts(MessageSecurityContext messageSecurityContext, List<Reference> elementsToClean, OpenSPCoop2SoapMessage message, List<SubErrorCodeSecurity> codiciErrore) throws SecurityException {
        return MessageUtilities.checkEncryptSignatureParts(messageSecurityContext, elementsToClean, message, codiciErrore, SecurityConstants.QNAME_WSS_ELEMENT_SECURITY);
    }

    @Override
    public void checkEncryptionPartElements(Map<QName, QName> notResolved, OpenSPCoop2SoapMessage message, List<SubErrorCodeSecurity> erroriRilevati) throws SecurityException {
        MessageUtilities.checkEncryptionPartElements(notResolved, message, erroriRilevati);
    }

    @Override
    public void cleanDirtyElements(MessageSecurityContext messageSecurityContext, OpenSPCoop2SoapMessage message, List<Reference> elementsToClean, boolean detachHeaderWSSecurity, boolean removeAllIdRef) throws SecurityException {
        org.openspcoop2.security.message.engine.WSSUtilities.cleanDirtyElements(messageSecurityContext, message, elementsToClean, detachHeaderWSSecurity, removeAllIdRef);
    }
}

