/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.xml;

import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.AbstractRESTMessageSecuritySender;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.KeystoreUtils;
import org.openspcoop2.security.message.utils.SignatureBean;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.security.SymmetricKeyWrappedMode;
import org.openspcoop2.utils.security.XmlEncrypt;
import org.openspcoop2.utils.security.XmlSignature;
import org.w3c.dom.Element;

public class MessageSecuritySender_xml
extends AbstractRESTMessageSecuritySender {
    @Override
    public void process(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message messageParam, Map<Object> ctx) throws SecurityException {
        block57: {
            try {
                String encryptionCanonicalizationMethodAlgorithm;
                if (!ServiceBinding.REST.equals((Object)messageParam.getServiceBinding())) {
                    throw new SecurityException("XML Engine usable only with REST Binding");
                }
                if (!MessageType.XML.equals((Object)messageParam.getMessageType())) {
                    throw new SecurityException("XML Engine usable only with REST Binding and a xml message, found: " + String.valueOf(messageParam.getMessageType()));
                }
                OpenSPCoop2RestXmlMessage restXmlMessage = messageParam.castAsRestXml();
                boolean encrypt = false;
                boolean signature = false;
                String[] actions = ((String)messageSecurityContext.getOutgoingProperties().get("action")).split(" ");
                for (int i = 0; i < actions.length; ++i) {
                    if (SecurityConstants.isActionEncryption(actions[i].trim())) {
                        encrypt = true;
                        continue;
                    }
                    if ("Signature".equals(actions[i].trim())) {
                        signature = true;
                        continue;
                    }
                    throw new SecurityException("XML Engine; action '" + actions[i] + "' unsupported");
                }
                if (encrypt && signature) {
                    throw new SecurityException("XML Engine usable only with one function beetwen encrypt or signature");
                }
                if (!encrypt && !signature) {
                    throw new SecurityException("XML Engine require one function beetwen encrypt or signature");
                }
                if (signature) {
                    SignatureBean bean = null;
                    bean = KeystoreUtils.getSenderSignatureBean(messageSecurityContext, ctx);
                    KeyStore signatureKS = bean.getKeystore();
                    String aliasSignatureUser = bean.getUser();
                    String aliasSignaturePassword = bean.getPassword();
                    if (signatureKS == null) {
                        throw new SecurityException("XML Signature Engine require keystore");
                    }
                    if (aliasSignatureUser == null) {
                        throw new SecurityException("XML Signature Engine require alias private key");
                    }
                    if (aliasSignaturePassword == null) {
                        throw new SecurityException("XML Signature Engine require password private key");
                    }
                    String signatureAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("signatureAlgorithm");
                    if (signatureAlgorithm == null || "".equals(signatureAlgorithm.trim())) {
                        throw new SecurityException("XML Signature Engine require 'signatureAlgorithm' property");
                    }
                    String digestMethodAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("signatureDigestAlgorithm");
                    if (digestMethodAlgorithm == null || "".equals(digestMethodAlgorithm.trim())) {
                        throw new SecurityException("XML Signature Engine require 'signatureDigestAlgorithm' property");
                    }
                    String signatureCanonicalizationMethod = (String)messageSecurityContext.getOutgoingProperties().get("signatureC14nAlgorithm");
                    if (signatureCanonicalizationMethod == null || "".equals(signatureCanonicalizationMethod.trim())) {
                        throw new SecurityException("XML Signature Engine require 'signatureC14nAlgorithm' property");
                    }
                    XmlSignature xmlSignature = new XmlSignature(signatureKS, aliasSignatureUser, aliasSignaturePassword);
                    String signatureKeyInfo = (String)messageSecurityContext.getOutgoingProperties().get("keyInfo");
                    String signatureKeyInfoAlias = (String)messageSecurityContext.getOutgoingProperties().get("keyInfoAlias");
                    if (signatureKeyInfo != null && !"".equals(signatureKeyInfo.trim())) {
                        if ("x509".equals(signatureKeyInfo)) {
                            if (signatureKeyInfoAlias != null && !"".equals(signatureKeyInfoAlias.trim())) {
                                xmlSignature.addX509KeyInfo(signatureKeyInfoAlias);
                            } else {
                                xmlSignature.addX509KeyInfo();
                            }
                        } else if ("RSA".equals(signatureKeyInfo)) {
                            if (signatureKeyInfoAlias != null && !"".equals(signatureKeyInfoAlias.trim())) {
                                xmlSignature.addRSAKeyInfo(signatureKeyInfoAlias);
                            } else {
                                xmlSignature.addRSAKeyInfo();
                            }
                        } else {
                            throw new Exception("keyInfo not supported [" + signatureKeyInfo + "]");
                        }
                    }
                    xmlSignature.sign((Element)restXmlMessage.getContent(), signatureAlgorithm, digestMethodAlgorithm, signatureCanonicalizationMethod);
                    break block57;
                }
                if (!encrypt) break block57;
                XmlEncrypt xmlEncrypt = null;
                EncryptionBean bean = null;
                bean = KeystoreUtils.getSenderEncryptionBean(messageSecurityContext, ctx);
                KeyStore encryptionKS = bean.getKeystore();
                KeyStore encryptionTrustStoreKS = bean.getTruststore();
                boolean encryptionSymmetric = bean.isEncryptionSimmetric();
                SymmetricKeyWrappedMode encryptionSymmetricWrappedMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY;
                String aliasEncryptUser = bean.getUser();
                String aliasEncryptPassword = bean.getPassword();
                if (encryptionSymmetric) {
                    String encryptionSymmetricWrapped = (String)messageSecurityContext.getOutgoingProperties().get("encryptionSymmetricKeyWrapped");
                    if (encryptionSymmetricWrapped != null) {
                        if ("true".equalsIgnoreCase(encryptionSymmetricWrapped)) {
                            encryptionSymmetricWrappedMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY;
                        } else if ("false".equalsIgnoreCase(encryptionSymmetricWrapped)) {
                            encryptionSymmetricWrappedMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_NO_WRAPPED;
                        }
                    }
                    if (encryptionKS == null) {
                        throw new SecurityException("XML Encrypt Engine require keystore");
                    }
                    if (aliasEncryptUser == null) {
                        throw new SecurityException("XML Encrypt Engine require alias secret key");
                    }
                    if (aliasEncryptPassword == null) {
                        throw new SecurityException("XML Encrypt Engine require password secret key");
                    }
                } else {
                    if (encryptionTrustStoreKS == null) {
                        throw new SecurityException("XML Encrypt Engine require truststore");
                    }
                    if (aliasEncryptUser == null) {
                        throw new SecurityException("XML Encrypt Engine require alias public key");
                    }
                    encryptionSymmetricWrappedMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY;
                }
                String wrappedKeyAlgorithm = null;
                if (encryptionSymmetric) {
                    if (SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY.equals((Object)encryptionSymmetricWrappedMode) && ((wrappedKeyAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionSymAlgorithm")) == null || "".equals(wrappedKeyAlgorithm.trim()))) {
                        throw new SecurityException("XML Encrypt Engine require 'encryptionSymAlgorithm' property");
                    }
                    xmlEncrypt = new XmlEncrypt(encryptionKS, true, encryptionSymmetricWrappedMode, aliasEncryptUser, aliasEncryptPassword);
                } else {
                    wrappedKeyAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionKeyTransportAlgorithm");
                    if (wrappedKeyAlgorithm == null || "".equals(wrappedKeyAlgorithm.trim())) {
                        throw new SecurityException("XML Encrypt Engine require 'encryptionKeyTransportAlgorithm' property");
                    }
                    xmlEncrypt = new XmlEncrypt(encryptionTrustStoreKS, aliasEncryptUser);
                }
                String encryptionKeyAlgorithm = null;
                if ((SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY.equals((Object)encryptionSymmetricWrappedMode) || SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY.equals((Object)encryptionSymmetricWrappedMode)) && ((encryptionKeyAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionKeyAlgorithm")) == null || "".equals(encryptionKeyAlgorithm.trim()))) {
                    throw new SecurityException("XML Encrypt Engine require 'encryptionKeyAlgorithm' property");
                }
                String encryptionAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionAlgorithm");
                if (encryptionAlgorithm == null || "".equals(encryptionAlgorithm.trim())) {
                    throw new SecurityException("XML Encrypt Engine require 'encryptionAlgorithm' property");
                }
                String encryptionDigestAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionDigestAlgorithm");
                if (encryptionDigestAlgorithm != null && "".equals(encryptionDigestAlgorithm.trim())) {
                    encryptionDigestAlgorithm = null;
                }
                if ((encryptionCanonicalizationMethodAlgorithm = (String)messageSecurityContext.getOutgoingProperties().get("encryptionC14nAlgorithm")) != null && "".equals(encryptionCanonicalizationMethodAlgorithm.trim())) {
                    encryptionCanonicalizationMethodAlgorithm = null;
                }
                if (encryptionSymmetric) {
                    if (SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY.equals((Object)encryptionSymmetricWrappedMode)) {
                        xmlEncrypt.encrypt((Element)restXmlMessage.getContent(), encryptionAlgorithm, encryptionCanonicalizationMethodAlgorithm, encryptionDigestAlgorithm, encryptionKeyAlgorithm, wrappedKeyAlgorithm);
                    } else {
                        xmlEncrypt.encryptSymmetric((Element)restXmlMessage.getContent(), encryptionAlgorithm, encryptionCanonicalizationMethodAlgorithm, encryptionDigestAlgorithm);
                    }
                } else {
                    xmlEncrypt.encrypt((Element)restXmlMessage.getContent(), encryptionAlgorithm, encryptionCanonicalizationMethodAlgorithm, encryptionDigestAlgorithm, encryptionKeyAlgorithm, wrappedKeyAlgorithm);
                }
            }
            catch (Exception e) {
                String msg = Utilities.getInnerNotEmptyMessageException((Throwable)e).getMessage();
                Throwable innerExc = Utilities.getLastInnerException((Throwable)e);
                String innerMsg = null;
                if (innerExc != null) {
                    innerMsg = innerExc.getMessage();
                }
                Object messaggio = null;
                if (msg != null) {
                    messaggio = new String(msg);
                    if (innerMsg != null && !innerMsg.equals(msg)) {
                        messaggio = (String)messaggio + " ; " + innerMsg;
                    }
                } else if (innerMsg != null) {
                    messaggio = innerMsg;
                }
                SecurityException wssException = new SecurityException(e.getMessage(), e);
                wssException.setMsgErrore((String)messaggio);
                throw wssException;
            }
        }
    }
}

