/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.context.ViewIdHolder;
import org.ajax4jsf.resource.util.URLToStreamHelper;

public abstract class AjaxContext {
    private boolean limitToList;
    public static final String RESPONSE_DATA_KEY = "_ajax:data";
    static final String SERVICE_RESOURCE = "META-INF/services/" + AjaxContext.class.getName();
    private static final String DEFAULT_CONTEXT_CLASS = "org.ajax4jsf.context.AjaxContextImpl";
    public static final String HEAD_EVENTS_PARAMETER = "org.ajax4jsf.framework.HEAD_EVENTS_LIST";
    public static final String AJAX_CONTEXT_KEY = "ajaxContext";
    private static Map<ClassLoader, Class<? extends AjaxContext>> ajaxContextClasses = new HashMap<ClassLoader, Class<? extends AjaxContext>>();

    public abstract Map<String, Object> getCommonAjaxParameters();

    public abstract String getAjaxActionURL(FacesContext var1);

    public abstract void setResponseData(Object var1);

    public abstract Object getResponseData();

    public abstract void setOncomplete(Object var1);

    public abstract Object getOncomplete();

    public abstract void setViewIdHolder(ViewIdHolder var1);

    public abstract ViewIdHolder getViewIdHolder();

    public abstract boolean removeRenderedArea(String var1);

    public abstract void addRenderedArea(String var1);

    public abstract Set<String> getAjaxRenderedAreas();

    public abstract void addComponentToAjaxRender(UIComponent var1, String var2);

    public abstract void addComponentToAjaxRender(UIComponent var1);

    public abstract void addRegionsFromComponent(UIComponent var1);

    public abstract void addAreasToProcessFromComponent(FacesContext var1, UIComponent var2);

    public abstract Set<String> getAjaxAreasToRender();

    public abstract Set<String> getAjaxAreasToProcess();

    public boolean isAjaxRequest(FacesContext facesContext) {
        return this.isAjaxRequest();
    }

    public abstract boolean isAjaxRequest();

    public abstract void encodeAjaxEnd(FacesContext var1) throws IOException;

    public abstract void encodeAjaxBegin(FacesContext var1) throws IOException;

    public abstract void renderAjax(FacesContext var1);

    public abstract void decode(FacesContext var1);

    public abstract void release();

    public abstract Map<String, Object> getResponseDataMap();

    public abstract void setAjaxRequest(boolean var1);

    public abstract boolean isSelfRender();

    public abstract void setSelfRender(boolean var1);

    public abstract String getSubmittedRegionClientId();

    public abstract void saveViewState(FacesContext var1) throws IOException;

    public abstract void setAjaxSingleClientId(String var1);

    public abstract String getAjaxSingleClientId();

    public abstract void setAjaxAreasToProcess(Set<String> var1);

    public abstract void setSubmittedRegionClientId(String var1);

    public boolean isLimitToList() {
        return this.limitToList;
    }

    public void setLimitToList(boolean limitToList) {
        this.limitToList = limitToList;
    }

    public static AjaxContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return AjaxContext.getCurrentInstance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AjaxContext getCurrentInstance(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("FacesContext is null");
        }
        Map requestMap = context.getExternalContext().getRequestMap();
        AjaxContext ajaxContext = (AjaxContext)requestMap.get(AJAX_CONTEXT_KEY);
        if (null == ajaxContext) {
            Class<? extends AjaxContext> clazz;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (null == contextClassLoader) {
                contextClassLoader = AjaxContext.class.getClassLoader();
            }
            Map<ClassLoader, Class<? extends AjaxContext>> map = ajaxContextClasses;
            synchronized (map) {
                clazz = ajaxContextClasses.get(contextClassLoader);
                if (null == clazz) {
                    String factoryClassName = DEFAULT_CONTEXT_CLASS;
                    InputStream input = null;
                    input = URLToStreamHelper.urlToStreamSafe(contextClassLoader.getResource(SERVICE_RESOURCE));
                    if (input != null) {
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                            factoryClassName = reader.readLine();
                        }
                        catch (Exception e) {
                            throw new FacesException("Error to create AjaxContext Instance", (Throwable)e);
                        }
                        finally {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    try {
                        clazz = Class.forName(factoryClassName, false, contextClassLoader).asSubclass(AjaxContext.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new FacesException("AjaxContext implementation class " + factoryClassName + " not found ", (Throwable)e);
                    }
                    ajaxContextClasses.put(contextClassLoader, clazz);
                }
            }
            try {
                ajaxContext = clazz.newInstance();
                ajaxContext.decode(context);
            }
            catch (InstantiationException e) {
                throw new FacesException("Error to create AjaxContext Instance", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new FacesException("No access to AjaxContext constructor", (Throwable)e);
            }
            requestMap.put(AJAX_CONTEXT_KEY, ajaxContext);
        }
        return ajaxContext;
    }
}

