/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import java.beans.BeanInfo;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.util.LRUMap;
import org.richfaces.util.ReferenceMap;

class GenericsIntrospectionCache {
    private static final String INSTANCE_ATTRIBUTE_NAME = GenericsIntrospectionCache.class.getName();
    private static final String CACHE_SIZE_PARAMETER = "org.richfaces.GenericsIntrospectionCacheSize";
    private static final int DEFAULT_CACHE_SIZE = 256;
    private Map<Class<?>, GenericsCacheEntry> genericsCache;

    private static int getSize(ExternalContext externalContext) {
        int cacheSize = 256;
        String cacheSizeParameter = externalContext.getInitParameter(CACHE_SIZE_PARAMETER);
        if (cacheSizeParameter != null && cacheSizeParameter.length() != 0) {
            try {
                cacheSize = Integer.valueOf(cacheSizeParameter);
            }
            catch (NumberFormatException e) {
                externalContext.log("Error converting org.richfaces.GenericsIntrospectionCacheSize init parameter to int: " + e.getMessage(), (Throwable)e);
            }
        }
        return cacheSize;
    }

    private GenericsIntrospectionCache(int cacheSize) {
        this.genericsCache = new ReferenceMap(new LRUMap(cacheSize));
    }

    public GenericsCacheEntry getGenericCacheEntry(Class<?> beanClass) {
        GenericsCacheEntry cacheEntry = this.genericsCache.get(beanClass);
        if (cacheEntry == null) {
            cacheEntry = new GenericsCacheEntry();
            this.genericsCache.put(beanClass, cacheEntry);
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GenericsIntrospectionCache getInstance(FacesContext facesContext) {
        GenericsIntrospectionCache instance;
        Map applicationMap;
        ExternalContext externalContext = facesContext.getExternalContext();
        Map map = applicationMap = externalContext.getApplicationMap();
        synchronized (map) {
            instance = (GenericsIntrospectionCache)applicationMap.get(INSTANCE_ATTRIBUTE_NAME);
            if (instance == null) {
                instance = new GenericsIntrospectionCache(GenericsIntrospectionCache.getSize(externalContext));
                applicationMap.put(INSTANCE_ATTRIBUTE_NAME, instance);
            }
        }
        return instance;
    }

    static final class GenericsCacheEntry {
        SoftReference<BeanInfo> beanInfoReference;
        Map<String, Class<?>> genericPropertiesClasses;

        GenericsCacheEntry() {
        }
    }
}

