/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util;

import jakarta.el.ValueExpression;
import java.io.Serializable;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.ajax4jsf.Messages;

public class InputUtils {
    public static final String EMPTY_STRING = new String();
    public static final Object NOTHING = new Serializable(){};

    public static boolean isTrue(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static boolean isDisabled(UIComponent component) {
        return InputUtils.isTrue(component.getAttributes().get("disabled"));
    }

    public static boolean isReadOnly(UIComponent component) {
        return InputUtils.isTrue(component.getAttributes().get("readonly"));
    }

    public static Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String newValue = (String)submittedValue;
        ValueExpression valueExpression = component.getValueExpression("value");
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && valueExpression != null) {
            Class converterType = valueExpression.getType(context.getELContext());
            if (converterType == null || converterType == Object.class || converterType == String.class) {
                return newValue;
            }
            converter = context.getApplication().createConverter(converterType);
            if (converter == null) {
                throw new ConverterException(Messages.getMessage("NO_CONVERTER_FOUND_ERROR", converterType.getName()));
            }
        } else if (converter == null) {
            return newValue;
        }
        return converter.getAsObject(context, component, newValue);
    }

    public static String getConvertedStringValue(FacesContext context, UIComponent component, Object value) {
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            if (value == null) {
                return "";
            }
            if (value instanceof String) {
                return (String)value;
            }
            Class<?> converterType = value.getClass();
            if (converterType != null) {
                converter = context.getApplication().createConverter(converterType);
            }
            if (converter == null) {
                return value.toString();
            }
        }
        return converter.getAsString(context, component, value);
    }
}

