/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EmptyStackException;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import org.ajax4jsf.Messages;
import org.ajax4jsf.io.parser.FastHtmlParser;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.webapp.BaseXMLFilter;
import org.ajax4jsf.webapp.HtmlParser;
import org.ajax4jsf.webapp.ParserConfig;
import org.ajax4jsf.webapp.nekko.NekkoParser;
import org.ajax4jsf.webapp.tidy.TidyParser;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurableXMLFilter
extends BaseXMLFilter {
    public static final String NONE = "NONE";
    public static final String NEKO = "NEKO";
    public static final String TIDY = "TIDY";
    private static final Log log = LogFactory.getLog(ConfigurableXMLFilter.class);
    private static final String PARSERS_LIST_PARAMETER = "org.ajax4jsf.xmlparser.ORDER";
    private static final String VIEW_ID_PATTERN_PARAMETER = "org.ajax4jsf.xmlparser.";
    private ParserConfig parsers = new TidyParserConfig();
    private static final int STACK_SIZE = 100;
    private ArrayStack _xhtmlParsersPool = new ArrayStack(100);
    private Properties _tidyProperties;

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        ServletContext servletContext = config.getServletContext();
        String parsersParameter = servletContext.getInitParameter(PARSERS_LIST_PARAMETER);
        if (null != parsersParameter) {
            this.configureParsers(servletContext, parsersParameter);
        }
    }

    public void configureParsers(ServletContext servletContext, String parsersParameter) throws ServletException {
        String[] parsersNames = parsersParameter.split("\\s*,\\s*");
        for (int i = parsersNames.length - 1; i >= 0; --i) {
            ParserConfig parserConfig;
            String parserName = parsersNames[i];
            if (TIDY.equals(parserName)) {
                parserConfig = new TidyParserConfig();
            } else if (NEKO.equals(parserName)) {
                parserConfig = new NekoParserConfig();
            } else if (NONE.equals(parserName)) {
                parserConfig = new PassParserConfig();
            } else {
                throw new ServletException("Unknown XML parser type in config parameter " + parserName);
            }
            parserConfig.setNext(this.parsers);
            if (null != servletContext) {
                try {
                    String parserViewPattern = servletContext.getInitParameter(VIEW_ID_PATTERN_PARAMETER + parserName);
                    parserConfig.setPatterns(parserViewPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new ServletException("Invalid pattern for a parser " + parserName + " :" + e.getMessage());
                }
            }
            this.parsers = parserConfig;
        }
    }

    @Override
    protected HtmlParser getParser(String mimetype, boolean isAjax, String viewId) {
        HtmlParser parser = null;
        if (isAjax || mimetype.startsWith("text/html") || mimetype.startsWith("application/xhtml+xml")) {
            parser = isAjax || this.isForcexml() ? this.parsers.getParser(viewId, mimetype) : new FastHtmlParser();
        }
        return parser;
    }

    @Override
    protected void reuseParser(HtmlParser parser) {
        this.parsers.reuseParser(parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getTidyProperties() {
        if (null == this._tidyProperties) {
            this._tidyProperties = new Properties();
            InputStream defaultprops = null;
            InputStream props = null;
            try {
                defaultprops = URLToStreamHelper.urlToStreamSafe(TidyParser.class.getResource("tidy.properties"));
                if (null != defaultprops) {
                    this._tidyProperties.load(defaultprops);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"default tidy parser properties loaded");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"No default tidy parser properties found");
                }
                if (null != (props = URLToStreamHelper.urlToStreamSafe(Thread.currentThread().getContextClassLoader().getResource("tidy.properties")))) {
                    this._tidyProperties.load(props);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"application-specific tidy parser properties loaded");
                    }
                }
            }
            catch (IOException e) {
                log.warn((Object)Messages.getMessage("READING_TIDY_PROPERTIES_ERROR"), (Throwable)e);
            }
            finally {
                if (null != props) {
                    try {
                        props.close();
                    }
                    catch (IOException iOException) {}
                }
                if (null != defaultprops) {
                    try {
                        defaultprops.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this._tidyProperties;
    }

    public ParserConfig getParsers() {
        return this.parsers;
    }

    private class TidyParserConfig
    extends ParserConfig {
        private TidyParserConfig() {
        }

        @Override
        protected HtmlParser createParser(String mime) {
            TidyParser tidyParser = new TidyParser(ConfigurableXMLFilter.this.getTidyProperties());
            tidyParser.setMoveElements(ConfigurableXMLFilter.this.isForcexml());
            tidyParser.setMime(mime);
            return tidyParser;
        }
    }

    private class NekoParserConfig
    extends ParserConfig {
        private NekoParserConfig() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HtmlParser createParser(String mime) {
            NekkoParser parser;
            try {
                ArrayStack arrayStack = ConfigurableXMLFilter.this._xhtmlParsersPool;
                synchronized (arrayStack) {
                    parser = (NekkoParser)ConfigurableXMLFilter.this._xhtmlParsersPool.pop();
                }
            }
            catch (EmptyStackException e) {
                parser = new NekkoParser();
                parser.setPublicId(ConfigurableXMLFilter.this.getPublicid());
                parser.setSystemid(ConfigurableXMLFilter.this.getSystemid());
                parser.setNamespace(ConfigurableXMLFilter.this.getNamespace());
                parser.init();
            }
            parser.setMime(mime);
            return parser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean storeParser(HtmlParser parser) {
            if (null != parser && parser instanceof NekkoParser) {
                ArrayStack arrayStack = ConfigurableXMLFilter.this._xhtmlParsersPool;
                synchronized (arrayStack) {
                    if (ConfigurableXMLFilter.this._xhtmlParsersPool.size() < 100) {
                        ((NekkoParser)parser).reset();
                        ConfigurableXMLFilter.this._xhtmlParsersPool.push((Object)parser);
                    }
                }
                return true;
            }
            return false;
        }
    }

    private class PassParserConfig
    extends ParserConfig {
        private PassParserConfig() {
        }

        @Override
        protected HtmlParser createParser(String mime) {
            return new FastHtmlParser();
        }
    }
}

