/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModelListener;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SerializableDataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.model.ScrollableTableDataModel;
import org.richfaces.model.SortOrder;

public class DataModelCache
extends ScrollableTableDataModel {
    private static Log log = LogFactory.getLog(DataModelCache.class);
    private Map secondaryMapping = new HashMap();
    private DataRange dataRange;
    private ScrollableTableDataModel scrollableTableDataModel;
    private int rowCount = Integer.MIN_VALUE;

    public DataModelCache(ScrollableTableDataModel scrollableTableDataModel) {
        this.scrollableTableDataModel = scrollableTableDataModel;
        if (log.isTraceEnabled()) {
            log.trace((Object)("initializing with " + (Object)((Object)scrollableTableDataModel)));
        }
    }

    public void addDataModelListener(DataModelListener listener) {
        this.scrollableTableDataModel.addDataModelListener(listener);
    }

    public DataModelListener[] getDataModelListeners() {
        return this.scrollableTableDataModel.getDataModelListeners();
    }

    public Object getObjectById(Object id) {
        Object cached;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get object by id" + id));
        }
        if ((cached = this.secondaryMapping.get(id)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache miss " + id + " falling back to original model"));
            }
            cached = this.scrollableTableDataModel.getObjectById(id);
            this.secondaryMapping.put(id, cached);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("At last found element " + cached));
        }
        return cached;
    }

    public int getRowCount() {
        if (this.rowCount == Integer.MIN_VALUE) {
            this.rowCount = this.scrollableTableDataModel.getRowCount();
        }
        return this.rowCount;
    }

    @Override
    public Object getRowData() {
        Object secondaryMapped = this.secondaryMapping.get(this.getRowKey());
        if (secondaryMapped == null) {
            secondaryMapped = super.getRowData();
        }
        return secondaryMapped;
    }

    @Override
    public int getRowIndex() {
        return this.scrollableTableDataModel.getRowIndex();
    }

    @Override
    public Object getRowKey() {
        return this.scrollableTableDataModel.getRowKey();
    }

    @Override
    public SerializableDataModel getSerializableModel(Range range) {
        return this.scrollableTableDataModel.getSerializableModel(range);
    }

    public Object getWrappedData() {
        return this.scrollableTableDataModel.getWrappedData();
    }

    @Override
    public boolean isRowAvailable() {
        return this.secondaryMapping.containsKey(this.getRowKey()) || super.isRowAvailable();
    }

    public List loadData(int startRow, int endRow, SortOrder sortOrder) {
        if (this.dataRange == null || !this.dataRange.match(startRow, endRow, sortOrder)) {
            List data = this.scrollableTableDataModel.loadData(startRow, endRow, sortOrder);
            this.dataRange = new DataRange(startRow, endRow, sortOrder, data);
        }
        return this.dataRange.loadedData;
    }

    public void removeDataModelListener(DataModelListener listener) {
        this.scrollableTableDataModel.removeDataModelListener(listener);
    }

    @Override
    public void setRowIndex(int arg0) {
        this.scrollableTableDataModel.setRowIndex(arg0);
    }

    @Override
    public void setRowKey(Object key) {
        this.scrollableTableDataModel.setRowKey(key);
        super.setRowKey(key);
    }

    public void setWrappedData(Object arg0) {
        this.scrollableTableDataModel.setWrappedData(arg0);
    }

    public Object getId(Object o) {
        return this.scrollableTableDataModel.getId(o);
    }

    @Override
    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        super.walk(context, visitor, range, argument);
    }

    private static class DataRange {
        private int startRow;
        private int endRow;
        private SortOrder sortOrder;
        private List loadedData;

        public DataRange(int startRow, int endRow, SortOrder sortOrder, List loadedData) {
            this.startRow = startRow;
            this.endRow = endRow;
            this.sortOrder = sortOrder;
            this.loadedData = loadedData;
        }

        public boolean match(int s, int e, SortOrder sortOrder) {
            return s == this.startRow && e == this.endRow && this.sortOrdersMatch(sortOrder, this.sortOrder);
        }

        private boolean sortOrdersMatch(SortOrder sortOrder1, SortOrder sortOrder2) {
            boolean result;
            boolean bl = result = sortOrder1 == sortOrder2;
            if (sortOrder1 != null && sortOrder2 != null) {
                result = sortOrder1.equals(sortOrder2);
            }
            return result;
        }
    }
}

