/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.model.DataProvider;

public class ExtendedTableDataModel<T>
extends ExtendedDataModel
implements Serializable {
    private static final long serialVersionUID = 7374505108088114161L;
    private static final Log log = LogFactory.getLog(ExtendedTableDataModel.class);
    private DataProvider<T> dataProvider;
    private Object rowKey;
    private List<Object> wrappedKeys = null;
    private Map<Object, T> wrappedData = new HashMap<Object, T>();
    private Integer rowCount;
    private Integer rowIndex;

    public ExtendedTableDataModel(DataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public Object getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(Object key) {
        this.rowKey = key;
    }

    @Override
    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) throws IOException {
        int rowC = this.getRowCount();
        int firstRow = ((SequenceRange)range).getFirstRow();
        int numberOfRows = ((SequenceRange)range).getRows();
        if (numberOfRows <= 0) {
            numberOfRows = rowC;
        }
        if (this.wrappedKeys != null) {
            for (Object key : this.wrappedKeys) {
                this.setRowKey(key);
                visitor.process(context, key, argument);
            }
        } else {
            this.wrappedKeys = new ArrayList<Object>();
            int endRow = firstRow + numberOfRows;
            if (endRow > rowC) {
                endRow = rowC;
            }
            for (T item : this.loadData(firstRow, endRow)) {
                Object key = this.getKey(item);
                this.wrappedKeys.add(key);
                this.wrappedData.put(key, item);
                visitor.process(context, key, argument);
            }
        }
    }

    protected List<T> loadData(int startRow, int endRow) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("load data from range: " + startRow + " - " + endRow));
        }
        if (startRow < 0) {
            startRow = 0;
            throw new IllegalArgumentException("Illegal start index value: " + startRow);
        }
        int rowCount = this.getRowCount();
        if (endRow > rowCount) {
            endRow = rowCount;
            throw new IllegalArgumentException("Illegal end index value: " + endRow);
        }
        return this.dataProvider.getItemsByRange(startRow, endRow);
    }

    public int getRowCount() {
        if (this.rowCount != null) {
            return this.rowCount;
        }
        this.rowCount = new Integer(this.dataProvider.getRowCount());
        return this.rowCount;
    }

    public T getRowData() {
        if (this.rowKey == null) {
            return null;
        }
        return this.getObjectByKey(this.rowKey);
    }

    public Object getKey(T o) {
        return this.dataProvider.getKey(o);
    }

    public T getObjectByKey(Object key) {
        T t = this.wrappedData.get(key);
        if (t == null) {
            t = this.dataProvider.getItemByKey(key);
            this.wrappedData.put(key, t);
        }
        return t;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    public Object getWrappedData() {
        throw new UnsupportedOperationException();
    }

    public void setWrappedData(Object data) {
        throw new UnsupportedOperationException();
    }

    public boolean isRowAvailable() {
        return this.getRowData() != null;
    }

    public void reset() {
        this.wrappedKeys = null;
        this.wrappedData.clear();
        this.rowCount = null;
        this.rowIndex = -1;
        this.rowKey = null;
    }

    public DataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
    }
}

