/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.selection;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.richfaces.model.selection.Selection;

public class SimpleSelection
implements Selection {
    private static final long serialVersionUID = 1L;
    private Set<Object> keys = new LinkedHashSet<Object>();
    private boolean selectAll = false;

    public boolean addKey(Object rowKey) {
        return this.keys.add(rowKey);
    }

    public boolean removeKey(Object rowKey) {
        this.selectAll = false;
        return this.keys.remove(rowKey);
    }

    @Override
    public Iterator<Object> getKeys() {
        Iterator<Object> result = Collections.emptyList().iterator();
        if (!this.selectAll) {
            result = this.keys.iterator();
        }
        return result;
    }

    @Override
    public int size() {
        int result = -1;
        if (!this.selectAll) {
            result = this.keys.size();
        }
        return result;
    }

    @Override
    public boolean isSelected(Object rowKey) {
        return this.selectAll || this.keys.contains(rowKey);
    }

    public void clear() {
        this.selectAll = false;
        this.keys.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        result = 31 * result + (this.selectAll ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleSelection other = (SimpleSelection)obj;
        if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
            return false;
        }
        return this.selectAll == other.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }
}

