/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.jdbc.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCParameterUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCSqlLogger;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.IKeyGenerator;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.KeyGeneratorException;
import org.openspcoop2.utils.jdbc.KeyGeneratorFactory;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class JDBCPreparedStatementUtilities {
    private Logger log;
    private Connection connection;
    private JDBCSqlLogger sqlLogger;
    private TipiDatabase tipoDatabase = null;
    private GenericJDBCParameterUtilities jdbcParameterUtilities = null;
    private Integer queryTimeout = null;

    public JDBCPreparedStatementUtilities(TipiDatabase tipoDatabase, Logger log, Connection connection) throws SQLQueryObjectException, JDBCAdapterException {
        this(tipoDatabase, log, connection, null);
    }

    public JDBCPreparedStatementUtilities(TipiDatabase tipoDatabase, Logger log, Connection connection, Integer queryTimeout) throws SQLQueryObjectException, JDBCAdapterException {
        this.log = log;
        this.connection = connection;
        this.sqlLogger = new JDBCSqlLogger(this.log);
        this.tipoDatabase = tipoDatabase;
        this.jdbcParameterUtilities = new GenericJDBCParameterUtilities(this.tipoDatabase);
        this.queryTimeout = queryTimeout;
    }

    private PreparedStatement _createPreparedStatement(String sql) throws SQLException {
        return this._createPreparedStatement(sql, null);
    }

    private PreparedStatement _createPreparedStatement(String sql, Integer params) throws SQLException {
        PreparedStatement p = null;
        p = params != null ? this.connection.prepareStatement(sql, params) : this.connection.prepareStatement(sql);
        if (this.queryTimeout != null && this.queryTimeout > 0) {
            p.setQueryTimeout(this.queryTimeout);
        }
        return p;
    }

    public long insertAndReturnGeneratedKey(ISQLQueryObject sqlQueryObject, IKeyGeneratorObject object, boolean showSql, JDBCObject ... params) throws KeyGeneratorException {
        Statement pstmt = null;
        try {
            IKeyGenerator keyGenerator = KeyGeneratorFactory.createKeyGeneratorFactory((String)this.tipoDatabase.getNome(), (Connection)this.connection, (IKeyGeneratorObject)object);
            ArrayList<JDBCObject> p = new ArrayList<JDBCObject>();
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    p.add(params[i]);
                }
            }
            if (!keyGenerator.isReturnGeneratedKeySupported()) {
                JDBCObject jdbcObject = new JDBCObject(keyGenerator.generateKey(), Long.class);
                p.add(jdbcObject);
            }
            JDBCObject[] paramsWithId = null;
            if (p.size() > 0) {
                paramsWithId = p.toArray(new JDBCObject[1]);
            }
            sqlQueryObject.addInsertTable(object.getTable());
            if (!keyGenerator.isReturnGeneratedKeySupported()) {
                sqlQueryObject.addInsertField(keyGenerator.getColunmKeyName(), "?");
            }
            String insertString = sqlQueryObject.createSQLInsert();
            if (showSql) {
                this.sqlLogger.infoSql(insertString, paramsWithId);
            }
            pstmt = keyGenerator.isReturnGeneratedKeySupported() ? this._createPreparedStatement(insertString, 1) : this._createPreparedStatement(insertString);
            this.jdbcParameterUtilities.setParameters((PreparedStatement)pstmt, paramsWithId);
            pstmt.executeUpdate();
            long l = keyGenerator.getReturnGeneratedKey((PreparedStatement)pstmt);
            return l;
        }
        catch (Exception e) {
            throw new KeyGeneratorException("insertAndReturnGeneratedKey failed: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean execute(String sql, boolean showSql, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        try {
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            boolean bl = pstmt.execute();
            return bl;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int executeUpdate(String sql, boolean showSql, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        try {
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            int n = pstmt.executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Object executeQuerySingleResult(String sql, boolean showSql, IModel<?> model, IJDBCFetch fetch, JDBCObject ... params) throws ServiceException, MultipleResultException, NotFoundException {
        List<Object> list = this.executeQuery(sql, showSql, model, fetch, params);
        if (list.size() == 1) {
            Object o = list.get(0);
            if (o != null) {
                return o;
            }
            throw new NotFoundException("Not found");
        }
        if (list.size() <= 0) {
            throw new NotFoundException("Not found");
        }
        throw new MultipleResultException("More than one result found (result: " + list.size() + ")");
    }

    public List<Object> executeQuery(String sql, boolean showSql, IModel<?> model, IJDBCFetch fetch, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Object> lista = new ArrayList<Object>();
        try {
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                lista.add(fetch.fetch(this.tipoDatabase, model, rs));
            }
            ArrayList<Object> arrayList = lista;
            return arrayList;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Object executeQuerySingleResult(String sql, boolean showSql, Class<?> returnType, JDBCObject ... params) throws NotFoundException, ServiceException, MultipleResultException {
        List<Object> list = this.executeQuery(sql, showSql, returnType, params);
        if (list.size() == 1) {
            Object o = list.get(0);
            if (o != null) {
                return o;
            }
            throw new NotFoundException("Not found");
        }
        if (list.size() <= 0) {
            throw new NotFoundException("Not found");
        }
        throw new MultipleResultException("More than one result found (result: " + list.size() + ")");
    }

    public List<Object> executeQuery(String sql, boolean showSql, Class<?> returnType, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Object> lista = new ArrayList<Object>();
        try {
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                lista.add(this.jdbcParameterUtilities.readParameter(rs, 1, returnType));
            }
            ArrayList<Object> arrayList = lista;
            return arrayList;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public List<Object> executeQuerySingleResult(String sql, boolean showSql, List<Class<?>> returnType, JDBCObject ... params) throws ServiceException, MultipleResultException {
        List<List<Object>> list = this.executeQuery(sql, showSql, returnType, params);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() <= 0) {
            return new ArrayList<Object>();
        }
        throw new MultipleResultException("More than one result found (result: " + list.size() + ")");
    }

    public List<List<Object>> executeQuery(String sql, boolean showSql, List<Class<?>> returnType, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<List<Object>> lista = new ArrayList<List<Object>>();
        try {
            ArrayList<List<Object>> result;
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                result = new ArrayList();
                for (int i = 0; i < returnType.size(); ++i) {
                    result.add((List<Object>)this.jdbcParameterUtilities.readParameter(rs, i + 1, returnType.get(i)));
                }
                lista.add(result);
            }
            result = lista;
            return result;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean exists(String sql, boolean showSql, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            rs = pstmt.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean deleteById(String sql, boolean showSql, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            rs = pstmt.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public long count(String sql, boolean showSql, JDBCObject ... params) throws ServiceException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (showSql) {
                this.sqlLogger.infoSql(sql, params);
            }
            pstmt = this._createPreparedStatement(sql);
            this.jdbcParameterUtilities.setParameters(pstmt, params);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

