/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.impl.AbstractBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;

public abstract class AbstractCommonFieldBaseExpressionImpl
extends AbstractBaseExpressionImpl {
    protected IField field;

    protected AbstractCommonFieldBaseExpressionImpl(IObjectFormatter objectFormatter, IField field) {
        super(objectFormatter);
        this.field = field;
    }

    public IField getField() {
        return this.field;
    }

    public void setField(IField field) {
        this.field = field;
    }

    @Override
    public boolean inUseField(IField field) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        return this.field.equals(field);
    }

    @Override
    public boolean inUseModel(IModel<?> model) throws ExpressionNotImplementedException, ExpressionException {
        if (this.field == null) {
            return false;
        }
        if (model.getBaseField() != null) {
            if (this.field instanceof ComplexField) {
                ComplexField c = (ComplexField)this.field;
                return c.getFather().equals(model.getBaseField());
            }
            String modeClassName = model.getModeledClass().getName();
            return modeClassName.equals(this.field.getClassType().getName());
        }
        String modeClassName = model.getModeledClass().getName();
        return modeClassName.equals(this.field.getClassType().getName());
    }

    @Override
    public List<IField> getFields() throws ExpressionNotImplementedException, ExpressionException {
        ArrayList<IField> lista = null;
        if (this.field == null) {
            return lista;
        }
        lista = new ArrayList<IField>();
        lista.add(this.field);
        return lista;
    }
}

