/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.impl.AbstractCommonFieldBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;

public class BetweenExpressionImpl
extends AbstractCommonFieldBaseExpressionImpl {
    private Object lower;
    private Object high;

    public BetweenExpressionImpl(IObjectFormatter objectFormatter, IField field, Object lower, Object high) {
        super(objectFormatter, field);
        this.lower = lower;
        this.high = high;
    }

    public Object getLower() {
        return this.lower;
    }

    public void setLower(Object lower) {
        this.lower = lower;
    }

    public Object getHigh() {
        return this.high;
    }

    public void setHigh(Object high) {
        this.high = high;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.field instanceof ComplexField) {
            ComplexField cf = (ComplexField)this.field;
            if (cf.getFather() != null) {
                bf.append(cf.getFather().getFieldName());
            } else {
                bf.append(this.field.getClassName());
            }
        } else {
            bf.append(this.field.getClassName());
        }
        bf.append(".");
        bf.append(this.field.getFieldName());
        bf.append(" BETWEEN ");
        bf.append(" ");
        try {
            bf.append(super.getObjectFormatter().toString(this.lower));
        }
        catch (Exception e) {
            return "ERROR-LOWER: " + e.getMessage();
        }
        bf.append(" AND ");
        try {
            bf.append(super.getObjectFormatter().toString(this.high));
        }
        catch (Exception e) {
            return "ERROR-HIGH: " + e.getMessage();
        }
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    @Override
    public List<Object> getFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionException {
        ArrayList<Object> lista = null;
        if (this.field == null) {
            return lista;
        }
        if (this.field.equals(field)) {
            lista = new ArrayList<Object>();
            lista.add(this.lower);
            lista.add(this.high);
        }
        return lista;
    }
}

