/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.impl.AbstractCommonFieldValueBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.EscapeSQLPattern;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class LikeExpressionImpl
extends AbstractCommonFieldValueBaseExpressionImpl {
    private LikeMode mode;
    private boolean caseInsensitive;

    public LikeExpressionImpl(IObjectFormatter objectFormatter, IField field, String value, LikeMode mode, boolean caseInsensitive) {
        super(objectFormatter, field, value);
        this.mode = mode;
        this.caseInsensitive = caseInsensitive;
    }

    public LikeMode getMode() {
        return this.mode;
    }

    public void setMode(LikeMode mode) {
        this.mode = mode;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.caseInsensitive) {
            bf.append("lower(");
        }
        if (this.field instanceof ComplexField) {
            ComplexField cf = (ComplexField)this.field;
            if (cf.getFather() != null) {
                bf.append(cf.getFather().getFieldName());
            } else {
                bf.append(this.field.getClassName());
            }
        } else {
            bf.append(this.field.getClassName());
        }
        bf.append(".");
        bf.append(this.field.getFieldName());
        if (this.caseInsensitive) {
            bf.append(")");
        }
        bf.append(" like '");
        String likeValue = this.value;
        Object escapeClausole = "";
        try {
            ISQLQueryObject sqlQueryObjectForEscape = SQLObjectFactory.createSQLQueryObject((TipiDatabase)TipiDatabase.POSTGRESQL);
            EscapeSQLPattern escapePattern = sqlQueryObjectForEscape.escapePatternValue(likeValue);
            if (escapePattern.isUseEscapeClausole()) {
                escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
            }
            likeValue = escapePattern.getEscapeValue();
        }
        catch (Exception e) {
            LoggerWrapperFactory.getLogger(LikeExpressionImpl.class).error(e.getMessage(), (Throwable)e);
        }
        String likeParam = this.getLikeParam(likeValue);
        bf.append(likeParam);
        bf.append("'");
        bf.append((String)escapeClausole);
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    private String getLikeParam(String likeValue) {
        Object likeParam = null;
        switch (this.mode) {
            case EXACT: {
                if (this.caseInsensitive) {
                    likeParam = likeValue.toLowerCase();
                    break;
                }
                likeParam = likeValue;
                break;
            }
            case ANYWHERE: {
                if (this.caseInsensitive) {
                    likeParam = "%" + likeValue.toLowerCase() + "%";
                    break;
                }
                likeParam = "%" + likeValue + "%";
                break;
            }
            case END: {
                if (this.caseInsensitive) {
                    likeParam = "%" + likeValue.toLowerCase();
                    break;
                }
                likeParam = "%" + likeValue;
                break;
            }
            case START: {
                if (this.caseInsensitive) {
                    likeParam = likeValue.toLowerCase() + "%";
                    break;
                }
                likeParam = likeValue + "%";
                break;
            }
        }
        return likeParam;
    }
}

