/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.sql;

import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.impl.DateTimePartExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.expression.impl.sql.SQLMode;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.DateTimePartEnum;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;

public class DateTimePartExpressionSQL
extends DateTimePartExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public DateTimePartExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter, IField field, String value, DateTimePartEnum dateTimePartEnum) {
        super(objectFormatter, field, value, dateTimePartEnum);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    private SQLQueryObjectCore getSQLQueryObjectCore(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        if (sqlQueryObject == null) {
            try {
                sqlQueryObject = this.sqlFieldConverter != null && this.sqlFieldConverter.getDatabaseType() != null ? SQLObjectFactory.createSQLQueryObject((TipiDatabase)this.sqlFieldConverter.getDatabaseType()) : SQLObjectFactory.createSQLQueryObject((TipiDatabase)TipiDatabase.POSTGRESQL);
            }
            catch (Exception e) {
                throw new ExpressionException(e.getMessage(), e);
            }
        }
        return (SQLQueryObjectCore)sqlQueryObject;
    }

    private String toSqlEngine(SQLMode mode, ISQLQueryObject sqlQueryObject, List<?> oggettiPreparedStatement, Map<String, ?> oggettiJPA) throws ExpressionException {
        if (mode != null) {
            // empty if block
        }
        if (oggettiPreparedStatement != null) {
            // empty if block
        }
        if (oggettiJPA != null) {
            // empty if block
        }
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        SQLQueryObjectCore sqlObjectCore = this.getSQLQueryObjectCore(sqlQueryObject);
        try {
            String prefix = sqlObjectCore.getExtractDateTimePartFromTimestampFieldPrefix(this.dateTimePartEnum);
            bf.append(prefix);
        }
        catch (Exception e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        if (this.sqlFieldConverter != null) {
            bf.append(this.sqlFieldConverter.toColumn(this.getField(), true));
        } else {
            bf.append(this.getField().getFieldName());
        }
        try {
            String suffix = sqlObjectCore.getExtractDateTimePartFromTimestampFieldSuffix(this.dateTimePartEnum);
            bf.append(" ");
            bf.append(suffix);
        }
        catch (Exception e) {
            throw new ExpressionException(e.getMessage(), e);
        }
        bf.append(" = '");
        String sqlValue = null;
        try {
            sqlValue = super.getObjectFormatter().toString(this.getValue());
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
        bf.append(sqlValue);
        bf.append("'");
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    private void toSqlEngine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Map<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSqlEngine(mode, sqlQueryObject, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSqlEngine(SQLMode.STANDARD, null, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.PREPARED_STATEMENT, null, oggetti, null);
    }

    @Override
    public String toSqlJPA(Map<String, Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.JPA, null, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Map<String, Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

