/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl.sql;

import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.impl.LikeExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.expression.impl.sql.SQLMode;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.EscapeSQLPattern;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class LikeExpressionSQL
extends LikeExpressionImpl
implements ISQLExpression {
    private ISQLFieldConverter sqlFieldConverter;

    public LikeExpressionSQL(ISQLFieldConverter sqlFieldConverter, IObjectFormatter objectFormatter, IField field, String value, LikeMode mode, boolean caseInsensitive) {
        super(objectFormatter, field, value, mode, caseInsensitive);
        this.sqlFieldConverter = sqlFieldConverter;
    }

    private String toSqlEngine(SQLMode mode, ISQLQueryObject sqlQueryObject, List<?> oggettiPreparedStatement, Map<String, ?> oggettiJPA) throws ExpressionException {
        if (mode != null) {
            // empty if block
        }
        if (oggettiPreparedStatement != null) {
            // empty if block
        }
        if (oggettiJPA != null) {
            // empty if block
        }
        StringBuilder bf = new StringBuilder();
        if (this.isNot()) {
            bf.append("( NOT ");
        }
        bf.append("( ");
        if (this.isCaseInsensitive()) {
            bf.append("lower(");
        }
        bf.append(this.sqlFieldConverter.toColumn(this.getField(), true));
        if (this.isCaseInsensitive()) {
            bf.append(")");
        }
        bf.append(" like '");
        String sqlValue = null;
        try {
            sqlValue = super.getObjectFormatter().toString(this.getValue());
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
        Object escapeClausole = "";
        try {
            ISQLQueryObject sqlQueryObjectForEscape = null;
            sqlQueryObjectForEscape = sqlQueryObject != null ? sqlQueryObject.newSQLQueryObject() : SQLObjectFactory.createSQLQueryObject((TipiDatabase)TipiDatabase.POSTGRESQL);
            EscapeSQLPattern escapePattern = sqlQueryObjectForEscape.escapePatternValue(sqlValue);
            if (escapePattern.isUseEscapeClausole()) {
                escapeClausole = " ESCAPE '" + escapePattern.getEscapeClausole() + "'";
            }
            sqlValue = escapePattern.getEscapeValue();
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
        String likeParam = this.getLikeParamSql(sqlValue);
        bf.append(likeParam);
        bf.append("'");
        bf.append((String)escapeClausole);
        bf.append(" )");
        if (this.isNot()) {
            bf.append(" )");
        }
        return bf.toString();
    }

    private String getLikeParamSql(String sqlValue) {
        Object likeParam = null;
        switch (this.getMode()) {
            case EXACT: {
                if (this.isCaseInsensitive()) {
                    likeParam = sqlValue.toLowerCase();
                    break;
                }
                likeParam = sqlValue;
                break;
            }
            case ANYWHERE: {
                if (this.isCaseInsensitive()) {
                    likeParam = "%" + sqlValue.toLowerCase() + "%";
                    break;
                }
                likeParam = "%" + sqlValue + "%";
                break;
            }
            case END: {
                if (this.isCaseInsensitive()) {
                    likeParam = "%" + sqlValue.toLowerCase();
                    break;
                }
                likeParam = "%" + sqlValue;
                break;
            }
            case START: {
                if (this.isCaseInsensitive()) {
                    likeParam = sqlValue.toLowerCase() + "%";
                    break;
                }
                likeParam = sqlValue + "%";
                break;
            }
        }
        return likeParam;
    }

    private void toSqlEngine(ISQLQueryObject sqlQueryObject, SQLMode mode, List<Object> oggettiPreparedStatement, Map<String, Object> oggettiJPA) throws ExpressionException {
        try {
            String s = this.toSqlEngine(mode, sqlQueryObject, oggettiPreparedStatement, oggettiJPA);
            s = s.substring(1, s.length() - 2);
            sqlQueryObject.addWhereCondition(s);
        }
        catch (Exception e) {
            throw new ExpressionException(e);
        }
    }

    @Override
    public String toSql() throws ExpressionException {
        return this.toSqlEngine(SQLMode.STANDARD, null, null, null);
    }

    @Override
    public String toSqlPreparedStatement(List<Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.PREPARED_STATEMENT, null, oggetti, null);
    }

    @Override
    public String toSqlJPA(Map<String, Object> oggetti) throws ExpressionException {
        return this.toSqlEngine(SQLMode.JPA, null, null, oggetti);
    }

    @Override
    public void toSql(ISQLQueryObject sqlQueryObject) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.STANDARD, null, null);
    }

    @Override
    public void toSqlPreparedStatement(ISQLQueryObject sqlQueryObject, List<Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.PREPARED_STATEMENT, oggetti, null);
    }

    @Override
    public void toSqlJPA(ISQLQueryObject sqlQueryObject, Map<String, Object> oggetti) throws ExpressionException {
        this.toSqlEngine(sqlQueryObject, SQLMode.JPA, null, oggetti);
    }
}

