/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.utils;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.utils.DatabaseInstanceProperties;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class DatabaseProperties {
    private static DatabaseProperties databaseProperties = null;
    private DatabaseInstanceProperties reader;
    private static final String PROP_TIPO_DATABASE = "db.tipoDatabase";
    private static final String PROP_SHOW_SQL = "db.showSql";
    private static final String PROP_GENERATE_DDL = "db.generateDDL";
    private static final String PROP_AUTO_COMMIT = "db.autoCommit";
    private static final String PROP_SECONDS_TO_REFRESH_CONNECTION = "db.secondsToRefreshConnection";
    private static final String PROP_TIPO = "db.tipo";
    private static final String PROP_TIPO_VALUE_DATASOURCE = "datasource";
    private static final String PROP_TIPO_VALUE_CONNECTION = "connection";
    private static final String PROP_DATASOURCE_JNDI_NAME = "db.datasource.jndiName";
    private static final String PROP_DATASOURCE_JNDI_CONTEXT = "db.datasource.jndiContext";
    private static final String PROP_CONNECTION_URL = "db.connection.url";
    private static final String PROP_CONNECTION_DRIVER = "db.connection.driver";
    private static final String PROP_CONNECTION_AUTH_USER = "db.connection.user";
    private static final String PROP_CONNECTION_AUTH_PASSWORD = "db.connection.password";

    public static synchronized void initialize(String propertiesLocalPath, String propertiesName, String nomeFileProperties, Logger log) throws ServiceException {
        if (databaseProperties == null) {
            databaseProperties = new DatabaseProperties(propertiesLocalPath, propertiesName, nomeFileProperties, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseProperties getInstance(Logger log) throws ServiceException {
        if (log != null) {
            // empty if block
        }
        if (databaseProperties != null) return databaseProperties;
        Class<DatabaseProperties> clazz = DatabaseProperties.class;
        synchronized (DatabaseProperties.class) {
            if (databaseProperties != null) return databaseProperties;
            throw new ServiceException("DatabaseProperties not initialized, use initialize method");
        }
    }

    private DatabaseProperties(String propertiesLocalPath, String propertiesName, String nomeFileProperties, Logger log) throws ServiceException {
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = DatabaseProperties.class.getResourceAsStream("/" + nomeFileProperties);
            if (properties == null) {
                throw new ServiceException("Properties " + nomeFileProperties + " not found");
            }
            propertiesReader.load(properties);
            properties.close();
        }
        catch (Exception e) {
            this.doError(log, nomeFileProperties, properties, e);
        }
        try {
            this.reader = new DatabaseInstanceProperties(propertiesLocalPath, propertiesName, propertiesReader, log);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), e);
        }
    }

    private void doError(Logger log, String nomeFileProperties, InputStream properties, Exception e) throws ServiceException {
        String msg = "Riscontrato errore durante la lettura del file '" + nomeFileProperties + "': " + e.getMessage();
        log.error(msg, (Throwable)e);
        try {
            if (properties != null) {
                properties.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ServiceException(e.getMessage(), e);
    }

    private String getProperty(String name, boolean required, boolean convertEnvProperty) throws UtilsException {
        String tmp = null;
        tmp = convertEnvProperty ? this.reader.getValueConvertEnvProperties(name) : this.reader.getValue(name);
        if (tmp == null && required) {
            throw new UtilsException("Property [" + name + "] not found");
        }
        if (tmp != null) {
            return tmp.trim();
        }
        return null;
    }

    public String getTipoDatabase() throws UtilsException {
        return this.getProperty(PROP_TIPO_DATABASE, true, false);
    }

    public TipiDatabase getTipoDatabaseEnum() throws UtilsException {
        return TipiDatabase.toEnumConstant((String)this.getTipoDatabase());
    }

    public boolean isShowSql() throws UtilsException {
        return Boolean.parseBoolean(this.getProperty(PROP_SHOW_SQL, true, false));
    }

    public boolean isGenerateDDL() throws UtilsException {
        return Boolean.parseBoolean(this.getProperty(PROP_GENERATE_DDL, true, false));
    }

    public boolean isAutoCommit() throws UtilsException {
        return Boolean.parseBoolean(this.getProperty(PROP_AUTO_COMMIT, true, false));
    }

    public int getSecondsToRefreshConnection() throws UtilsException {
        return Integer.parseInt(this.getProperty(PROP_SECONDS_TO_REFRESH_CONNECTION, true, false));
    }

    public ServiceManagerProperties getServiceManagerProperties() throws UtilsException {
        ServiceManagerProperties sm = new ServiceManagerProperties();
        sm.setDatabaseType(this.getTipoDatabase());
        sm.setShowSql(this.isShowSql());
        sm.setGenerateDdl(this.isGenerateDDL());
        sm.setAutomaticTransactionManagement(this.isAutoCommit());
        sm.setSecondsToRefreshConnection(this.getSecondsToRefreshConnection());
        return sm;
    }

    private String getTipoAccessoDatabase() throws UtilsException {
        String v = this.getProperty(PROP_TIPO, true, true);
        if (!PROP_TIPO_VALUE_DATASOURCE.equals(v) && !PROP_TIPO_VALUE_CONNECTION.equals(v)) {
            throw new UtilsException("Tipo di accesso al database fornito [" + v + "] non valido (supportati datasource,connection)");
        }
        return v;
    }

    public boolean isTipoAccessoTramiteDatasource() throws UtilsException {
        return PROP_TIPO_VALUE_DATASOURCE.equals(this.getTipoAccessoDatabase());
    }

    public boolean isTipoAccessoTramiteConnection() throws UtilsException {
        return PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase());
    }

    public String getDatasourceJNDIName() throws UtilsException {
        return this.getProperty(PROP_DATASOURCE_JNDI_NAME, PROP_TIPO_VALUE_DATASOURCE.equals(this.getTipoAccessoDatabase()), true);
    }

    public Properties getDatasourceJNDIContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties(PROP_DATASOURCE_JNDI_CONTEXT);
    }

    public String getConnectionUrl() throws UtilsException {
        return this.getProperty(PROP_CONNECTION_URL, PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase()), true);
    }

    public String getConnectionDriverJDBC() throws UtilsException {
        return this.getProperty(PROP_CONNECTION_DRIVER, PROP_TIPO_VALUE_CONNECTION.equals(this.getTipoAccessoDatabase()), true);
    }

    public String getConnectionAuthUsername() throws UtilsException {
        return this.getProperty(PROP_CONNECTION_AUTH_USER, false, true);
    }

    public String getConnectionAuthPassword() throws UtilsException {
        return this.getProperty(PROP_CONNECTION_AUTH_PASSWORD, false, true);
    }
}

